/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoOrderbook;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * CryptoLatestOrderbooksResp
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CryptoLatestOrderbooksResp {
  public static final String SERIALIZED_NAME_ORDERBOOKS = "orderbooks";
  @SerializedName(SERIALIZED_NAME_ORDERBOOKS)
  private Map<String, CryptoOrderbook> orderbooks = new HashMap<>();

  public CryptoLatestOrderbooksResp() {
  }

  public CryptoLatestOrderbooksResp orderbooks(Map<String, CryptoOrderbook> orderbooks) {
    this.orderbooks = orderbooks;
    return this;
  }

  public CryptoLatestOrderbooksResp putOrderbooksItem(String key, CryptoOrderbook orderbooksItem) {
    if (this.orderbooks == null) {
      this.orderbooks = new HashMap<>();
    }
    this.orderbooks.put(key, orderbooksItem);
    return this;
  }

   /**
   * Get orderbooks
   * @return orderbooks
  **/
  @javax.annotation.Nonnull
  public Map<String, CryptoOrderbook> getOrderbooks() {
    return orderbooks;
  }

  public void setOrderbooks(Map<String, CryptoOrderbook> orderbooks) {
    this.orderbooks = orderbooks;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoLatestOrderbooksResp cryptoLatestOrderbooksResp = (CryptoLatestOrderbooksResp) o;
    return Objects.equals(this.orderbooks, cryptoLatestOrderbooksResp.orderbooks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderbooks);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoLatestOrderbooksResp {\n");
    sb.append("    orderbooks: ").append(toIndentedString(orderbooks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("orderbooks");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("orderbooks");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CryptoLatestOrderbooksResp.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CryptoLatestOrderbooksResp is not found in the empty JSON string", CryptoLatestOrderbooksResp.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CryptoLatestOrderbooksResp.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CryptoLatestOrderbooksResp` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CryptoLatestOrderbooksResp.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CryptoLatestOrderbooksResp.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CryptoLatestOrderbooksResp' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CryptoLatestOrderbooksResp> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CryptoLatestOrderbooksResp.class));

       return (TypeAdapter<T>) new TypeAdapter<CryptoLatestOrderbooksResp>() {
           @Override
           public void write(JsonWriter out, CryptoLatestOrderbooksResp value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CryptoLatestOrderbooksResp read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CryptoLatestOrderbooksResp given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CryptoLatestOrderbooksResp
  * @throws IOException if the JSON string is invalid with respect to CryptoLatestOrderbooksResp
  */
  public static CryptoLatestOrderbooksResp fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CryptoLatestOrderbooksResp.class);
  }

 /**
  * Convert an instance of CryptoLatestOrderbooksResp to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

