/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * OHLC aggregate of all the trades in a given interval. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CryptoBar {
  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public static final String SERIALIZED_NAME_O = "o";
  @SerializedName(SERIALIZED_NAME_O)
  private Double o;

  public static final String SERIALIZED_NAME_H = "h";
  @SerializedName(SERIALIZED_NAME_H)
  private Double h;

  public static final String SERIALIZED_NAME_L = "l";
  @SerializedName(SERIALIZED_NAME_L)
  private Double l;

  public static final String SERIALIZED_NAME_C = "c";
  @SerializedName(SERIALIZED_NAME_C)
  private Double c;

  public static final String SERIALIZED_NAME_V = "v";
  @SerializedName(SERIALIZED_NAME_V)
  private Double v;

  public static final String SERIALIZED_NAME_N = "n";
  @SerializedName(SERIALIZED_NAME_N)
  private Long n;

  public static final String SERIALIZED_NAME_VW = "vw";
  @SerializedName(SERIALIZED_NAME_VW)
  private Double vw;

  public CryptoBar() {
  }

  public CryptoBar t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp in RFC-3339 format with nanosecond precision
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }


  public CryptoBar o(Double o) {
    this.o = o;
    return this;
  }

   /**
   * Opening price
   * @return o
  **/
  @javax.annotation.Nonnull
  public Double getO() {
    return o;
  }

  public void setO(Double o) {
    this.o = o;
  }


  public CryptoBar h(Double h) {
    this.h = h;
    return this;
  }

   /**
   * High price
   * @return h
  **/
  @javax.annotation.Nonnull
  public Double getH() {
    return h;
  }

  public void setH(Double h) {
    this.h = h;
  }


  public CryptoBar l(Double l) {
    this.l = l;
    return this;
  }

   /**
   * Low price
   * @return l
  **/
  @javax.annotation.Nonnull
  public Double getL() {
    return l;
  }

  public void setL(Double l) {
    this.l = l;
  }


  public CryptoBar c(Double c) {
    this.c = c;
    return this;
  }

   /**
   * Closing price
   * @return c
  **/
  @javax.annotation.Nonnull
  public Double getC() {
    return c;
  }

  public void setC(Double c) {
    this.c = c;
  }


  public CryptoBar v(Double v) {
    this.v = v;
    return this;
  }

   /**
   * Bar volume
   * @return v
  **/
  @javax.annotation.Nonnull
  public Double getV() {
    return v;
  }

  public void setV(Double v) {
    this.v = v;
  }


  public CryptoBar n(Long n) {
    this.n = n;
    return this;
  }

   /**
   * Trade count in the bar
   * @return n
  **/
  @javax.annotation.Nonnull
  public Long getN() {
    return n;
  }

  public void setN(Long n) {
    this.n = n;
  }


  public CryptoBar vw(Double vw) {
    this.vw = vw;
    return this;
  }

   /**
   * Volume weighted average price
   * @return vw
  **/
  @javax.annotation.Nonnull
  public Double getVw() {
    return vw;
  }

  public void setVw(Double vw) {
    this.vw = vw;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoBar cryptoBar = (CryptoBar) o;
    return Objects.equals(this.t, cryptoBar.t) &&
        Objects.equals(this.o, cryptoBar.o) &&
        Objects.equals(this.h, cryptoBar.h) &&
        Objects.equals(this.l, cryptoBar.l) &&
        Objects.equals(this.c, cryptoBar.c) &&
        Objects.equals(this.v, cryptoBar.v) &&
        Objects.equals(this.n, cryptoBar.n) &&
        Objects.equals(this.vw, cryptoBar.vw);
  }

  @Override
  public int hashCode() {
    return Objects.hash(t, o, h, l, c, v, n, vw);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoBar {\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("    o: ").append(toIndentedString(o)).append("\n");
    sb.append("    h: ").append(toIndentedString(h)).append("\n");
    sb.append("    l: ").append(toIndentedString(l)).append("\n");
    sb.append("    c: ").append(toIndentedString(c)).append("\n");
    sb.append("    v: ").append(toIndentedString(v)).append("\n");
    sb.append("    n: ").append(toIndentedString(n)).append("\n");
    sb.append("    vw: ").append(toIndentedString(vw)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("t");
    openapiFields.add("o");
    openapiFields.add("h");
    openapiFields.add("l");
    openapiFields.add("c");
    openapiFields.add("v");
    openapiFields.add("n");
    openapiFields.add("vw");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("t");
    openapiRequiredFields.add("o");
    openapiRequiredFields.add("h");
    openapiRequiredFields.add("l");
    openapiRequiredFields.add("c");
    openapiRequiredFields.add("v");
    openapiRequiredFields.add("n");
    openapiRequiredFields.add("vw");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CryptoBar.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CryptoBar is not found in the empty JSON string", CryptoBar.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CryptoBar.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CryptoBar` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CryptoBar.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CryptoBar.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CryptoBar' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CryptoBar> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CryptoBar.class));

       return (TypeAdapter<T>) new TypeAdapter<CryptoBar>() {
           @Override
           public void write(JsonWriter out, CryptoBar value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CryptoBar read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CryptoBar given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CryptoBar
  * @throws IOException if the JSON string is invalid with respect to CryptoBar
  */
  public static CryptoBar fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CryptoBar.class);
  }

 /**
  * Convert an instance of CryptoBar to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

