/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Unit split. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CAUnitSplit {
  public static final String SERIALIZED_NAME_OLD_SYMBOL = "old_symbol";
  @SerializedName(SERIALIZED_NAME_OLD_SYMBOL)
  private String oldSymbol;

  public static final String SERIALIZED_NAME_OLD_RATE = "old_rate";
  @SerializedName(SERIALIZED_NAME_OLD_RATE)
  private Double oldRate;

  public static final String SERIALIZED_NAME_NEW_SYMBOL = "new_symbol";
  @SerializedName(SERIALIZED_NAME_NEW_SYMBOL)
  private String newSymbol;

  public static final String SERIALIZED_NAME_NEW_RATE = "new_rate";
  @SerializedName(SERIALIZED_NAME_NEW_RATE)
  private Double newRate;

  public static final String SERIALIZED_NAME_ALTERNATE_SYMBOL = "alternate_symbol";
  @SerializedName(SERIALIZED_NAME_ALTERNATE_SYMBOL)
  private String alternateSymbol;

  public static final String SERIALIZED_NAME_ALTERNATE_RATE = "alternate_rate";
  @SerializedName(SERIALIZED_NAME_ALTERNATE_RATE)
  private Double alternateRate;

  public static final String SERIALIZED_NAME_PROCESS_DATE = "process_date";
  @SerializedName(SERIALIZED_NAME_PROCESS_DATE)
  private LocalDate processDate;

  public static final String SERIALIZED_NAME_EFFECTIVE_DATE = "effective_date";
  @SerializedName(SERIALIZED_NAME_EFFECTIVE_DATE)
  private LocalDate effectiveDate;

  public static final String SERIALIZED_NAME_PAYABLE_DATE = "payable_date";
  @SerializedName(SERIALIZED_NAME_PAYABLE_DATE)
  private LocalDate payableDate;

  public CAUnitSplit() {
  }

  public CAUnitSplit oldSymbol(String oldSymbol) {
    this.oldSymbol = oldSymbol;
    return this;
  }

   /**
   * Get oldSymbol
   * @return oldSymbol
  **/
  @javax.annotation.Nonnull
  public String getOldSymbol() {
    return oldSymbol;
  }

  public void setOldSymbol(String oldSymbol) {
    this.oldSymbol = oldSymbol;
  }


  public CAUnitSplit oldRate(Double oldRate) {
    this.oldRate = oldRate;
    return this;
  }

   /**
   * Get oldRate
   * @return oldRate
  **/
  @javax.annotation.Nonnull
  public Double getOldRate() {
    return oldRate;
  }

  public void setOldRate(Double oldRate) {
    this.oldRate = oldRate;
  }


  public CAUnitSplit newSymbol(String newSymbol) {
    this.newSymbol = newSymbol;
    return this;
  }

   /**
   * Get newSymbol
   * @return newSymbol
  **/
  @javax.annotation.Nonnull
  public String getNewSymbol() {
    return newSymbol;
  }

  public void setNewSymbol(String newSymbol) {
    this.newSymbol = newSymbol;
  }


  public CAUnitSplit newRate(Double newRate) {
    this.newRate = newRate;
    return this;
  }

   /**
   * Get newRate
   * @return newRate
  **/
  @javax.annotation.Nonnull
  public Double getNewRate() {
    return newRate;
  }

  public void setNewRate(Double newRate) {
    this.newRate = newRate;
  }


  public CAUnitSplit alternateSymbol(String alternateSymbol) {
    this.alternateSymbol = alternateSymbol;
    return this;
  }

   /**
   * Get alternateSymbol
   * @return alternateSymbol
  **/
  @javax.annotation.Nonnull
  public String getAlternateSymbol() {
    return alternateSymbol;
  }

  public void setAlternateSymbol(String alternateSymbol) {
    this.alternateSymbol = alternateSymbol;
  }


  public CAUnitSplit alternateRate(Double alternateRate) {
    this.alternateRate = alternateRate;
    return this;
  }

   /**
   * Get alternateRate
   * @return alternateRate
  **/
  @javax.annotation.Nonnull
  public Double getAlternateRate() {
    return alternateRate;
  }

  public void setAlternateRate(Double alternateRate) {
    this.alternateRate = alternateRate;
  }


  public CAUnitSplit processDate(LocalDate processDate) {
    this.processDate = processDate;
    return this;
  }

   /**
   * The date when the corporate action is processed by Alpaca.
   * @return processDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getProcessDate() {
    return processDate;
  }

  public void setProcessDate(LocalDate processDate) {
    this.processDate = processDate;
  }


  public CAUnitSplit effectiveDate(LocalDate effectiveDate) {
    this.effectiveDate = effectiveDate;
    return this;
  }

   /**
   * The ex-date marks the cutoff point for shareholders to be credited.
   * @return effectiveDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getEffectiveDate() {
    return effectiveDate;
  }

  public void setEffectiveDate(LocalDate effectiveDate) {
    this.effectiveDate = effectiveDate;
  }


  public CAUnitSplit payableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
    return this;
  }

   /**
   * Get payableDate
   * @return payableDate
  **/
  @javax.annotation.Nullable
  public LocalDate getPayableDate() {
    return payableDate;
  }

  public void setPayableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CAUnitSplit caUnitSplit = (CAUnitSplit) o;
    return Objects.equals(this.oldSymbol, caUnitSplit.oldSymbol) &&
        Objects.equals(this.oldRate, caUnitSplit.oldRate) &&
        Objects.equals(this.newSymbol, caUnitSplit.newSymbol) &&
        Objects.equals(this.newRate, caUnitSplit.newRate) &&
        Objects.equals(this.alternateSymbol, caUnitSplit.alternateSymbol) &&
        Objects.equals(this.alternateRate, caUnitSplit.alternateRate) &&
        Objects.equals(this.processDate, caUnitSplit.processDate) &&
        Objects.equals(this.effectiveDate, caUnitSplit.effectiveDate) &&
        Objects.equals(this.payableDate, caUnitSplit.payableDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldSymbol, oldRate, newSymbol, newRate, alternateSymbol, alternateRate, processDate, effectiveDate, payableDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CAUnitSplit {\n");
    sb.append("    oldSymbol: ").append(toIndentedString(oldSymbol)).append("\n");
    sb.append("    oldRate: ").append(toIndentedString(oldRate)).append("\n");
    sb.append("    newSymbol: ").append(toIndentedString(newSymbol)).append("\n");
    sb.append("    newRate: ").append(toIndentedString(newRate)).append("\n");
    sb.append("    alternateSymbol: ").append(toIndentedString(alternateSymbol)).append("\n");
    sb.append("    alternateRate: ").append(toIndentedString(alternateRate)).append("\n");
    sb.append("    processDate: ").append(toIndentedString(processDate)).append("\n");
    sb.append("    effectiveDate: ").append(toIndentedString(effectiveDate)).append("\n");
    sb.append("    payableDate: ").append(toIndentedString(payableDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("old_symbol");
    openapiFields.add("old_rate");
    openapiFields.add("new_symbol");
    openapiFields.add("new_rate");
    openapiFields.add("alternate_symbol");
    openapiFields.add("alternate_rate");
    openapiFields.add("process_date");
    openapiFields.add("effective_date");
    openapiFields.add("payable_date");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("old_symbol");
    openapiRequiredFields.add("old_rate");
    openapiRequiredFields.add("new_symbol");
    openapiRequiredFields.add("new_rate");
    openapiRequiredFields.add("alternate_symbol");
    openapiRequiredFields.add("alternate_rate");
    openapiRequiredFields.add("process_date");
    openapiRequiredFields.add("effective_date");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CAUnitSplit.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CAUnitSplit is not found in the empty JSON string", CAUnitSplit.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CAUnitSplit.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CAUnitSplit` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CAUnitSplit.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("old_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `old_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("old_symbol").toString()));
      }
      if (!jsonObj.get("new_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `new_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("new_symbol").toString()));
      }
      if (!jsonObj.get("alternate_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `alternate_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("alternate_symbol").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CAUnitSplit.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CAUnitSplit' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CAUnitSplit> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CAUnitSplit.class));

       return (TypeAdapter<T>) new TypeAdapter<CAUnitSplit>() {
           @Override
           public void write(JsonWriter out, CAUnitSplit value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CAUnitSplit read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CAUnitSplit given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CAUnitSplit
  * @throws IOException if the JSON string is invalid with respect to CAUnitSplit
  */
  public static CAUnitSplit fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CAUnitSplit.class);
  }

 /**
  * Convert an instance of CAUnitSplit to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

