/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Spin-off. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CASpinOff {
  public static final String SERIALIZED_NAME_SOURCE_SYMBOL = "source_symbol";
  @SerializedName(SERIALIZED_NAME_SOURCE_SYMBOL)
  private String sourceSymbol;

  public static final String SERIALIZED_NAME_SOURCE_RATE = "source_rate";
  @SerializedName(SERIALIZED_NAME_SOURCE_RATE)
  private Double sourceRate;

  public static final String SERIALIZED_NAME_NEW_SYMBOL = "new_symbol";
  @SerializedName(SERIALIZED_NAME_NEW_SYMBOL)
  private String newSymbol;

  public static final String SERIALIZED_NAME_NEW_RATE = "new_rate";
  @SerializedName(SERIALIZED_NAME_NEW_RATE)
  private Double newRate;

  public static final String SERIALIZED_NAME_PROCESS_DATE = "process_date";
  @SerializedName(SERIALIZED_NAME_PROCESS_DATE)
  private LocalDate processDate;

  public static final String SERIALIZED_NAME_EX_DATE = "ex_date";
  @SerializedName(SERIALIZED_NAME_EX_DATE)
  private LocalDate exDate;

  public static final String SERIALIZED_NAME_RECORD_DATE = "record_date";
  @SerializedName(SERIALIZED_NAME_RECORD_DATE)
  private LocalDate recordDate;

  public static final String SERIALIZED_NAME_PAYABLE_DATE = "payable_date";
  @SerializedName(SERIALIZED_NAME_PAYABLE_DATE)
  private LocalDate payableDate;

  public static final String SERIALIZED_NAME_DUE_BILL_REDEMPTION_DATE = "due_bill_redemption_date";
  @SerializedName(SERIALIZED_NAME_DUE_BILL_REDEMPTION_DATE)
  private LocalDate dueBillRedemptionDate;

  public CASpinOff() {
  }

  public CASpinOff sourceSymbol(String sourceSymbol) {
    this.sourceSymbol = sourceSymbol;
    return this;
  }

   /**
   * Get sourceSymbol
   * @return sourceSymbol
  **/
  @javax.annotation.Nonnull
  public String getSourceSymbol() {
    return sourceSymbol;
  }

  public void setSourceSymbol(String sourceSymbol) {
    this.sourceSymbol = sourceSymbol;
  }


  public CASpinOff sourceRate(Double sourceRate) {
    this.sourceRate = sourceRate;
    return this;
  }

   /**
   * Get sourceRate
   * @return sourceRate
  **/
  @javax.annotation.Nonnull
  public Double getSourceRate() {
    return sourceRate;
  }

  public void setSourceRate(Double sourceRate) {
    this.sourceRate = sourceRate;
  }


  public CASpinOff newSymbol(String newSymbol) {
    this.newSymbol = newSymbol;
    return this;
  }

   /**
   * Get newSymbol
   * @return newSymbol
  **/
  @javax.annotation.Nonnull
  public String getNewSymbol() {
    return newSymbol;
  }

  public void setNewSymbol(String newSymbol) {
    this.newSymbol = newSymbol;
  }


  public CASpinOff newRate(Double newRate) {
    this.newRate = newRate;
    return this;
  }

   /**
   * Get newRate
   * @return newRate
  **/
  @javax.annotation.Nonnull
  public Double getNewRate() {
    return newRate;
  }

  public void setNewRate(Double newRate) {
    this.newRate = newRate;
  }


  public CASpinOff processDate(LocalDate processDate) {
    this.processDate = processDate;
    return this;
  }

   /**
   * The date when the corporate action is processed by Alpaca.
   * @return processDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getProcessDate() {
    return processDate;
  }

  public void setProcessDate(LocalDate processDate) {
    this.processDate = processDate;
  }


  public CASpinOff exDate(LocalDate exDate) {
    this.exDate = exDate;
    return this;
  }

   /**
   * The ex-date marks the cutoff point for shareholders to be credited.
   * @return exDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getExDate() {
    return exDate;
  }

  public void setExDate(LocalDate exDate) {
    this.exDate = exDate;
  }


  public CASpinOff recordDate(LocalDate recordDate) {
    this.recordDate = recordDate;
    return this;
  }

   /**
   * Get recordDate
   * @return recordDate
  **/
  @javax.annotation.Nullable
  public LocalDate getRecordDate() {
    return recordDate;
  }

  public void setRecordDate(LocalDate recordDate) {
    this.recordDate = recordDate;
  }


  public CASpinOff payableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
    return this;
  }

   /**
   * Get payableDate
   * @return payableDate
  **/
  @javax.annotation.Nullable
  public LocalDate getPayableDate() {
    return payableDate;
  }

  public void setPayableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
  }


  public CASpinOff dueBillRedemptionDate(LocalDate dueBillRedemptionDate) {
    this.dueBillRedemptionDate = dueBillRedemptionDate;
    return this;
  }

   /**
   * Get dueBillRedemptionDate
   * @return dueBillRedemptionDate
  **/
  @javax.annotation.Nullable
  public LocalDate getDueBillRedemptionDate() {
    return dueBillRedemptionDate;
  }

  public void setDueBillRedemptionDate(LocalDate dueBillRedemptionDate) {
    this.dueBillRedemptionDate = dueBillRedemptionDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CASpinOff caSpinOff = (CASpinOff) o;
    return Objects.equals(this.sourceSymbol, caSpinOff.sourceSymbol) &&
        Objects.equals(this.sourceRate, caSpinOff.sourceRate) &&
        Objects.equals(this.newSymbol, caSpinOff.newSymbol) &&
        Objects.equals(this.newRate, caSpinOff.newRate) &&
        Objects.equals(this.processDate, caSpinOff.processDate) &&
        Objects.equals(this.exDate, caSpinOff.exDate) &&
        Objects.equals(this.recordDate, caSpinOff.recordDate) &&
        Objects.equals(this.payableDate, caSpinOff.payableDate) &&
        Objects.equals(this.dueBillRedemptionDate, caSpinOff.dueBillRedemptionDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceSymbol, sourceRate, newSymbol, newRate, processDate, exDate, recordDate, payableDate, dueBillRedemptionDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CASpinOff {\n");
    sb.append("    sourceSymbol: ").append(toIndentedString(sourceSymbol)).append("\n");
    sb.append("    sourceRate: ").append(toIndentedString(sourceRate)).append("\n");
    sb.append("    newSymbol: ").append(toIndentedString(newSymbol)).append("\n");
    sb.append("    newRate: ").append(toIndentedString(newRate)).append("\n");
    sb.append("    processDate: ").append(toIndentedString(processDate)).append("\n");
    sb.append("    exDate: ").append(toIndentedString(exDate)).append("\n");
    sb.append("    recordDate: ").append(toIndentedString(recordDate)).append("\n");
    sb.append("    payableDate: ").append(toIndentedString(payableDate)).append("\n");
    sb.append("    dueBillRedemptionDate: ").append(toIndentedString(dueBillRedemptionDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("source_symbol");
    openapiFields.add("source_rate");
    openapiFields.add("new_symbol");
    openapiFields.add("new_rate");
    openapiFields.add("process_date");
    openapiFields.add("ex_date");
    openapiFields.add("record_date");
    openapiFields.add("payable_date");
    openapiFields.add("due_bill_redemption_date");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("source_symbol");
    openapiRequiredFields.add("source_rate");
    openapiRequiredFields.add("new_symbol");
    openapiRequiredFields.add("new_rate");
    openapiRequiredFields.add("process_date");
    openapiRequiredFields.add("ex_date");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CASpinOff.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CASpinOff is not found in the empty JSON string", CASpinOff.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CASpinOff.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CASpinOff` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CASpinOff.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("source_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `source_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("source_symbol").toString()));
      }
      if (!jsonObj.get("new_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `new_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("new_symbol").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CASpinOff.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CASpinOff' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CASpinOff> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CASpinOff.class));

       return (TypeAdapter<T>) new TypeAdapter<CASpinOff>() {
           @Override
           public void write(JsonWriter out, CASpinOff value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CASpinOff read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CASpinOff given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CASpinOff
  * @throws IOException if the JSON string is invalid with respect to CASpinOff
  */
  public static CASpinOff fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CASpinOff.class);
  }

 /**
  * Convert an instance of CASpinOff to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

