/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Forward split. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CANameChange {
  public static final String SERIALIZED_NAME_OLD_SYMBOL = "old_symbol";
  @SerializedName(SERIALIZED_NAME_OLD_SYMBOL)
  private String oldSymbol;

  public static final String SERIALIZED_NAME_NEW_SYMBOL = "new_symbol";
  @SerializedName(SERIALIZED_NAME_NEW_SYMBOL)
  private String newSymbol;

  public static final String SERIALIZED_NAME_PROCESS_DATE = "process_date";
  @SerializedName(SERIALIZED_NAME_PROCESS_DATE)
  private LocalDate processDate;

  public CANameChange() {
  }

  public CANameChange oldSymbol(String oldSymbol) {
    this.oldSymbol = oldSymbol;
    return this;
  }

   /**
   * Get oldSymbol
   * @return oldSymbol
  **/
  @javax.annotation.Nonnull
  public String getOldSymbol() {
    return oldSymbol;
  }

  public void setOldSymbol(String oldSymbol) {
    this.oldSymbol = oldSymbol;
  }


  public CANameChange newSymbol(String newSymbol) {
    this.newSymbol = newSymbol;
    return this;
  }

   /**
   * Get newSymbol
   * @return newSymbol
  **/
  @javax.annotation.Nonnull
  public String getNewSymbol() {
    return newSymbol;
  }

  public void setNewSymbol(String newSymbol) {
    this.newSymbol = newSymbol;
  }


  public CANameChange processDate(LocalDate processDate) {
    this.processDate = processDate;
    return this;
  }

   /**
   * The date when the corporate action is processed by Alpaca.
   * @return processDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getProcessDate() {
    return processDate;
  }

  public void setProcessDate(LocalDate processDate) {
    this.processDate = processDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CANameChange caNameChange = (CANameChange) o;
    return Objects.equals(this.oldSymbol, caNameChange.oldSymbol) &&
        Objects.equals(this.newSymbol, caNameChange.newSymbol) &&
        Objects.equals(this.processDate, caNameChange.processDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldSymbol, newSymbol, processDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CANameChange {\n");
    sb.append("    oldSymbol: ").append(toIndentedString(oldSymbol)).append("\n");
    sb.append("    newSymbol: ").append(toIndentedString(newSymbol)).append("\n");
    sb.append("    processDate: ").append(toIndentedString(processDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("old_symbol");
    openapiFields.add("new_symbol");
    openapiFields.add("process_date");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("old_symbol");
    openapiRequiredFields.add("new_symbol");
    openapiRequiredFields.add("process_date");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CANameChange.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CANameChange is not found in the empty JSON string", CANameChange.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CANameChange.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CANameChange` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CANameChange.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("old_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `old_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("old_symbol").toString()));
      }
      if (!jsonObj.get("new_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `new_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("new_symbol").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CANameChange.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CANameChange' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CANameChange> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CANameChange.class));

       return (TypeAdapter<T>) new TypeAdapter<CANameChange>() {
           @Override
           public void write(JsonWriter out, CANameChange value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CANameChange read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CANameChange given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CANameChange
  * @throws IOException if the JSON string is invalid with respect to CANameChange
  */
  public static CANameChange fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CANameChange.class);
  }

 /**
  * Convert an instance of CANameChange to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

