/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CACashDividend;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CACashMerger;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAForwardSplit;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CANameChange;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CARedemption;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAReverseSplit;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CASpinOff;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockAndCashMerger;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockDividend;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockMerger;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAUnitSplit;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CAWorthlessRemoval;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * CACorporateActions
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CACorporateActions {
  public static final String SERIALIZED_NAME_REVERSE_SPLITS = "reverse_splits";
  @SerializedName(SERIALIZED_NAME_REVERSE_SPLITS)
  private List<CAReverseSplit> reverseSplits;

  public static final String SERIALIZED_NAME_FORWARD_SPLITS = "forward_splits";
  @SerializedName(SERIALIZED_NAME_FORWARD_SPLITS)
  private List<CAForwardSplit> forwardSplits;

  public static final String SERIALIZED_NAME_UNIT_SPLITS = "unit_splits";
  @SerializedName(SERIALIZED_NAME_UNIT_SPLITS)
  private List<CAUnitSplit> unitSplits;

  public static final String SERIALIZED_NAME_STOCK_DIVIDENDS = "stock_dividends";
  @SerializedName(SERIALIZED_NAME_STOCK_DIVIDENDS)
  private List<CAStockDividend> stockDividends;

  public static final String SERIALIZED_NAME_CASH_DIVIDENDS = "cash_dividends";
  @SerializedName(SERIALIZED_NAME_CASH_DIVIDENDS)
  private List<CACashDividend> cashDividends;

  public static final String SERIALIZED_NAME_SPIN_OFFS = "spin_offs";
  @SerializedName(SERIALIZED_NAME_SPIN_OFFS)
  private List<CASpinOff> spinOffs;

  public static final String SERIALIZED_NAME_CASH_MERGERS = "cash_mergers";
  @SerializedName(SERIALIZED_NAME_CASH_MERGERS)
  private List<CACashMerger> cashMergers;

  public static final String SERIALIZED_NAME_STOCK_MERGERS = "stock_mergers";
  @SerializedName(SERIALIZED_NAME_STOCK_MERGERS)
  private List<CAStockMerger> stockMergers;

  public static final String SERIALIZED_NAME_STOCK_AND_CASH_MERGERS = "stock_and_cash_mergers";
  @SerializedName(SERIALIZED_NAME_STOCK_AND_CASH_MERGERS)
  private List<CAStockAndCashMerger> stockAndCashMergers;

  public static final String SERIALIZED_NAME_REDEMPTIONS = "redemptions";
  @SerializedName(SERIALIZED_NAME_REDEMPTIONS)
  private List<CARedemption> redemptions;

  public static final String SERIALIZED_NAME_NAME_CHANGES = "name_changes";
  @SerializedName(SERIALIZED_NAME_NAME_CHANGES)
  private List<CANameChange> nameChanges;

  public static final String SERIALIZED_NAME_WORTHLESS_REMOVALS = "worthless_removals";
  @SerializedName(SERIALIZED_NAME_WORTHLESS_REMOVALS)
  private List<CAWorthlessRemoval> worthlessRemovals;

  public CACorporateActions() {
  }

  public CACorporateActions reverseSplits(List<CAReverseSplit> reverseSplits) {
    this.reverseSplits = reverseSplits;
    return this;
  }

  public CACorporateActions addReverseSplitsItem(CAReverseSplit reverseSplitsItem) {
    if (this.reverseSplits == null) {
      this.reverseSplits = new ArrayList<>();
    }
    this.reverseSplits.add(reverseSplitsItem);
    return this;
  }

   /**
   * Get reverseSplits
   * @return reverseSplits
  **/
  @javax.annotation.Nullable
  public List<CAReverseSplit> getReverseSplits() {
    return reverseSplits;
  }

  public void setReverseSplits(List<CAReverseSplit> reverseSplits) {
    this.reverseSplits = reverseSplits;
  }


  public CACorporateActions forwardSplits(List<CAForwardSplit> forwardSplits) {
    this.forwardSplits = forwardSplits;
    return this;
  }

  public CACorporateActions addForwardSplitsItem(CAForwardSplit forwardSplitsItem) {
    if (this.forwardSplits == null) {
      this.forwardSplits = new ArrayList<>();
    }
    this.forwardSplits.add(forwardSplitsItem);
    return this;
  }

   /**
   * Get forwardSplits
   * @return forwardSplits
  **/
  @javax.annotation.Nullable
  public List<CAForwardSplit> getForwardSplits() {
    return forwardSplits;
  }

  public void setForwardSplits(List<CAForwardSplit> forwardSplits) {
    this.forwardSplits = forwardSplits;
  }


  public CACorporateActions unitSplits(List<CAUnitSplit> unitSplits) {
    this.unitSplits = unitSplits;
    return this;
  }

  public CACorporateActions addUnitSplitsItem(CAUnitSplit unitSplitsItem) {
    if (this.unitSplits == null) {
      this.unitSplits = new ArrayList<>();
    }
    this.unitSplits.add(unitSplitsItem);
    return this;
  }

   /**
   * Get unitSplits
   * @return unitSplits
  **/
  @javax.annotation.Nullable
  public List<CAUnitSplit> getUnitSplits() {
    return unitSplits;
  }

  public void setUnitSplits(List<CAUnitSplit> unitSplits) {
    this.unitSplits = unitSplits;
  }


  public CACorporateActions stockDividends(List<CAStockDividend> stockDividends) {
    this.stockDividends = stockDividends;
    return this;
  }

  public CACorporateActions addStockDividendsItem(CAStockDividend stockDividendsItem) {
    if (this.stockDividends == null) {
      this.stockDividends = new ArrayList<>();
    }
    this.stockDividends.add(stockDividendsItem);
    return this;
  }

   /**
   * Get stockDividends
   * @return stockDividends
  **/
  @javax.annotation.Nullable
  public List<CAStockDividend> getStockDividends() {
    return stockDividends;
  }

  public void setStockDividends(List<CAStockDividend> stockDividends) {
    this.stockDividends = stockDividends;
  }


  public CACorporateActions cashDividends(List<CACashDividend> cashDividends) {
    this.cashDividends = cashDividends;
    return this;
  }

  public CACorporateActions addCashDividendsItem(CACashDividend cashDividendsItem) {
    if (this.cashDividends == null) {
      this.cashDividends = new ArrayList<>();
    }
    this.cashDividends.add(cashDividendsItem);
    return this;
  }

   /**
   * Get cashDividends
   * @return cashDividends
  **/
  @javax.annotation.Nullable
  public List<CACashDividend> getCashDividends() {
    return cashDividends;
  }

  public void setCashDividends(List<CACashDividend> cashDividends) {
    this.cashDividends = cashDividends;
  }


  public CACorporateActions spinOffs(List<CASpinOff> spinOffs) {
    this.spinOffs = spinOffs;
    return this;
  }

  public CACorporateActions addSpinOffsItem(CASpinOff spinOffsItem) {
    if (this.spinOffs == null) {
      this.spinOffs = new ArrayList<>();
    }
    this.spinOffs.add(spinOffsItem);
    return this;
  }

   /**
   * Get spinOffs
   * @return spinOffs
  **/
  @javax.annotation.Nullable
  public List<CASpinOff> getSpinOffs() {
    return spinOffs;
  }

  public void setSpinOffs(List<CASpinOff> spinOffs) {
    this.spinOffs = spinOffs;
  }


  public CACorporateActions cashMergers(List<CACashMerger> cashMergers) {
    this.cashMergers = cashMergers;
    return this;
  }

  public CACorporateActions addCashMergersItem(CACashMerger cashMergersItem) {
    if (this.cashMergers == null) {
      this.cashMergers = new ArrayList<>();
    }
    this.cashMergers.add(cashMergersItem);
    return this;
  }

   /**
   * Get cashMergers
   * @return cashMergers
  **/
  @javax.annotation.Nullable
  public List<CACashMerger> getCashMergers() {
    return cashMergers;
  }

  public void setCashMergers(List<CACashMerger> cashMergers) {
    this.cashMergers = cashMergers;
  }


  public CACorporateActions stockMergers(List<CAStockMerger> stockMergers) {
    this.stockMergers = stockMergers;
    return this;
  }

  public CACorporateActions addStockMergersItem(CAStockMerger stockMergersItem) {
    if (this.stockMergers == null) {
      this.stockMergers = new ArrayList<>();
    }
    this.stockMergers.add(stockMergersItem);
    return this;
  }

   /**
   * Get stockMergers
   * @return stockMergers
  **/
  @javax.annotation.Nullable
  public List<CAStockMerger> getStockMergers() {
    return stockMergers;
  }

  public void setStockMergers(List<CAStockMerger> stockMergers) {
    this.stockMergers = stockMergers;
  }


  public CACorporateActions stockAndCashMergers(List<CAStockAndCashMerger> stockAndCashMergers) {
    this.stockAndCashMergers = stockAndCashMergers;
    return this;
  }

  public CACorporateActions addStockAndCashMergersItem(CAStockAndCashMerger stockAndCashMergersItem) {
    if (this.stockAndCashMergers == null) {
      this.stockAndCashMergers = new ArrayList<>();
    }
    this.stockAndCashMergers.add(stockAndCashMergersItem);
    return this;
  }

   /**
   * Get stockAndCashMergers
   * @return stockAndCashMergers
  **/
  @javax.annotation.Nullable
  public List<CAStockAndCashMerger> getStockAndCashMergers() {
    return stockAndCashMergers;
  }

  public void setStockAndCashMergers(List<CAStockAndCashMerger> stockAndCashMergers) {
    this.stockAndCashMergers = stockAndCashMergers;
  }


  public CACorporateActions redemptions(List<CARedemption> redemptions) {
    this.redemptions = redemptions;
    return this;
  }

  public CACorporateActions addRedemptionsItem(CARedemption redemptionsItem) {
    if (this.redemptions == null) {
      this.redemptions = new ArrayList<>();
    }
    this.redemptions.add(redemptionsItem);
    return this;
  }

   /**
   * Get redemptions
   * @return redemptions
  **/
  @javax.annotation.Nullable
  public List<CARedemption> getRedemptions() {
    return redemptions;
  }

  public void setRedemptions(List<CARedemption> redemptions) {
    this.redemptions = redemptions;
  }


  public CACorporateActions nameChanges(List<CANameChange> nameChanges) {
    this.nameChanges = nameChanges;
    return this;
  }

  public CACorporateActions addNameChangesItem(CANameChange nameChangesItem) {
    if (this.nameChanges == null) {
      this.nameChanges = new ArrayList<>();
    }
    this.nameChanges.add(nameChangesItem);
    return this;
  }

   /**
   * Get nameChanges
   * @return nameChanges
  **/
  @javax.annotation.Nullable
  public List<CANameChange> getNameChanges() {
    return nameChanges;
  }

  public void setNameChanges(List<CANameChange> nameChanges) {
    this.nameChanges = nameChanges;
  }


  public CACorporateActions worthlessRemovals(List<CAWorthlessRemoval> worthlessRemovals) {
    this.worthlessRemovals = worthlessRemovals;
    return this;
  }

  public CACorporateActions addWorthlessRemovalsItem(CAWorthlessRemoval worthlessRemovalsItem) {
    if (this.worthlessRemovals == null) {
      this.worthlessRemovals = new ArrayList<>();
    }
    this.worthlessRemovals.add(worthlessRemovalsItem);
    return this;
  }

   /**
   * Get worthlessRemovals
   * @return worthlessRemovals
  **/
  @javax.annotation.Nullable
  public List<CAWorthlessRemoval> getWorthlessRemovals() {
    return worthlessRemovals;
  }

  public void setWorthlessRemovals(List<CAWorthlessRemoval> worthlessRemovals) {
    this.worthlessRemovals = worthlessRemovals;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CACorporateActions caCorporateActions = (CACorporateActions) o;
    return Objects.equals(this.reverseSplits, caCorporateActions.reverseSplits) &&
        Objects.equals(this.forwardSplits, caCorporateActions.forwardSplits) &&
        Objects.equals(this.unitSplits, caCorporateActions.unitSplits) &&
        Objects.equals(this.stockDividends, caCorporateActions.stockDividends) &&
        Objects.equals(this.cashDividends, caCorporateActions.cashDividends) &&
        Objects.equals(this.spinOffs, caCorporateActions.spinOffs) &&
        Objects.equals(this.cashMergers, caCorporateActions.cashMergers) &&
        Objects.equals(this.stockMergers, caCorporateActions.stockMergers) &&
        Objects.equals(this.stockAndCashMergers, caCorporateActions.stockAndCashMergers) &&
        Objects.equals(this.redemptions, caCorporateActions.redemptions) &&
        Objects.equals(this.nameChanges, caCorporateActions.nameChanges) &&
        Objects.equals(this.worthlessRemovals, caCorporateActions.worthlessRemovals);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reverseSplits, forwardSplits, unitSplits, stockDividends, cashDividends, spinOffs, cashMergers, stockMergers, stockAndCashMergers, redemptions, nameChanges, worthlessRemovals);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CACorporateActions {\n");
    sb.append("    reverseSplits: ").append(toIndentedString(reverseSplits)).append("\n");
    sb.append("    forwardSplits: ").append(toIndentedString(forwardSplits)).append("\n");
    sb.append("    unitSplits: ").append(toIndentedString(unitSplits)).append("\n");
    sb.append("    stockDividends: ").append(toIndentedString(stockDividends)).append("\n");
    sb.append("    cashDividends: ").append(toIndentedString(cashDividends)).append("\n");
    sb.append("    spinOffs: ").append(toIndentedString(spinOffs)).append("\n");
    sb.append("    cashMergers: ").append(toIndentedString(cashMergers)).append("\n");
    sb.append("    stockMergers: ").append(toIndentedString(stockMergers)).append("\n");
    sb.append("    stockAndCashMergers: ").append(toIndentedString(stockAndCashMergers)).append("\n");
    sb.append("    redemptions: ").append(toIndentedString(redemptions)).append("\n");
    sb.append("    nameChanges: ").append(toIndentedString(nameChanges)).append("\n");
    sb.append("    worthlessRemovals: ").append(toIndentedString(worthlessRemovals)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("reverse_splits");
    openapiFields.add("forward_splits");
    openapiFields.add("unit_splits");
    openapiFields.add("stock_dividends");
    openapiFields.add("cash_dividends");
    openapiFields.add("spin_offs");
    openapiFields.add("cash_mergers");
    openapiFields.add("stock_mergers");
    openapiFields.add("stock_and_cash_mergers");
    openapiFields.add("redemptions");
    openapiFields.add("name_changes");
    openapiFields.add("worthless_removals");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CACorporateActions.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CACorporateActions is not found in the empty JSON string", CACorporateActions.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CACorporateActions.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CACorporateActions` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (jsonObj.get("reverse_splits") != null && !jsonObj.get("reverse_splits").isJsonNull()) {
        JsonArray jsonArrayreverseSplits = jsonObj.getAsJsonArray("reverse_splits");
        if (jsonArrayreverseSplits != null) {
          // ensure the json data is an array
          if (!jsonObj.get("reverse_splits").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `reverse_splits` to be an array in the JSON string but got `%s`", jsonObj.get("reverse_splits").toString()));
          }

          // validate the optional field `reverse_splits` (array)
          for (int i = 0; i < jsonArrayreverseSplits.size(); i++) {
            CAReverseSplit.validateJsonElement(jsonArrayreverseSplits.get(i));
          };
        }
      }
      if (jsonObj.get("forward_splits") != null && !jsonObj.get("forward_splits").isJsonNull()) {
        JsonArray jsonArrayforwardSplits = jsonObj.getAsJsonArray("forward_splits");
        if (jsonArrayforwardSplits != null) {
          // ensure the json data is an array
          if (!jsonObj.get("forward_splits").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `forward_splits` to be an array in the JSON string but got `%s`", jsonObj.get("forward_splits").toString()));
          }

          // validate the optional field `forward_splits` (array)
          for (int i = 0; i < jsonArrayforwardSplits.size(); i++) {
            CAForwardSplit.validateJsonElement(jsonArrayforwardSplits.get(i));
          };
        }
      }
      if (jsonObj.get("unit_splits") != null && !jsonObj.get("unit_splits").isJsonNull()) {
        JsonArray jsonArrayunitSplits = jsonObj.getAsJsonArray("unit_splits");
        if (jsonArrayunitSplits != null) {
          // ensure the json data is an array
          if (!jsonObj.get("unit_splits").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit_splits` to be an array in the JSON string but got `%s`", jsonObj.get("unit_splits").toString()));
          }

          // validate the optional field `unit_splits` (array)
          for (int i = 0; i < jsonArrayunitSplits.size(); i++) {
            CAUnitSplit.validateJsonElement(jsonArrayunitSplits.get(i));
          };
        }
      }
      if (jsonObj.get("stock_dividends") != null && !jsonObj.get("stock_dividends").isJsonNull()) {
        JsonArray jsonArraystockDividends = jsonObj.getAsJsonArray("stock_dividends");
        if (jsonArraystockDividends != null) {
          // ensure the json data is an array
          if (!jsonObj.get("stock_dividends").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `stock_dividends` to be an array in the JSON string but got `%s`", jsonObj.get("stock_dividends").toString()));
          }

          // validate the optional field `stock_dividends` (array)
          for (int i = 0; i < jsonArraystockDividends.size(); i++) {
            CAStockDividend.validateJsonElement(jsonArraystockDividends.get(i));
          };
        }
      }
      if (jsonObj.get("cash_dividends") != null && !jsonObj.get("cash_dividends").isJsonNull()) {
        JsonArray jsonArraycashDividends = jsonObj.getAsJsonArray("cash_dividends");
        if (jsonArraycashDividends != null) {
          // ensure the json data is an array
          if (!jsonObj.get("cash_dividends").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cash_dividends` to be an array in the JSON string but got `%s`", jsonObj.get("cash_dividends").toString()));
          }

          // validate the optional field `cash_dividends` (array)
          for (int i = 0; i < jsonArraycashDividends.size(); i++) {
            CACashDividend.validateJsonElement(jsonArraycashDividends.get(i));
          };
        }
      }
      if (jsonObj.get("spin_offs") != null && !jsonObj.get("spin_offs").isJsonNull()) {
        JsonArray jsonArrayspinOffs = jsonObj.getAsJsonArray("spin_offs");
        if (jsonArrayspinOffs != null) {
          // ensure the json data is an array
          if (!jsonObj.get("spin_offs").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `spin_offs` to be an array in the JSON string but got `%s`", jsonObj.get("spin_offs").toString()));
          }

          // validate the optional field `spin_offs` (array)
          for (int i = 0; i < jsonArrayspinOffs.size(); i++) {
            CASpinOff.validateJsonElement(jsonArrayspinOffs.get(i));
          };
        }
      }
      if (jsonObj.get("cash_mergers") != null && !jsonObj.get("cash_mergers").isJsonNull()) {
        JsonArray jsonArraycashMergers = jsonObj.getAsJsonArray("cash_mergers");
        if (jsonArraycashMergers != null) {
          // ensure the json data is an array
          if (!jsonObj.get("cash_mergers").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cash_mergers` to be an array in the JSON string but got `%s`", jsonObj.get("cash_mergers").toString()));
          }

          // validate the optional field `cash_mergers` (array)
          for (int i = 0; i < jsonArraycashMergers.size(); i++) {
            CACashMerger.validateJsonElement(jsonArraycashMergers.get(i));
          };
        }
      }
      if (jsonObj.get("stock_mergers") != null && !jsonObj.get("stock_mergers").isJsonNull()) {
        JsonArray jsonArraystockMergers = jsonObj.getAsJsonArray("stock_mergers");
        if (jsonArraystockMergers != null) {
          // ensure the json data is an array
          if (!jsonObj.get("stock_mergers").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `stock_mergers` to be an array in the JSON string but got `%s`", jsonObj.get("stock_mergers").toString()));
          }

          // validate the optional field `stock_mergers` (array)
          for (int i = 0; i < jsonArraystockMergers.size(); i++) {
            CAStockMerger.validateJsonElement(jsonArraystockMergers.get(i));
          };
        }
      }
      if (jsonObj.get("stock_and_cash_mergers") != null && !jsonObj.get("stock_and_cash_mergers").isJsonNull()) {
        JsonArray jsonArraystockAndCashMergers = jsonObj.getAsJsonArray("stock_and_cash_mergers");
        if (jsonArraystockAndCashMergers != null) {
          // ensure the json data is an array
          if (!jsonObj.get("stock_and_cash_mergers").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `stock_and_cash_mergers` to be an array in the JSON string but got `%s`", jsonObj.get("stock_and_cash_mergers").toString()));
          }

          // validate the optional field `stock_and_cash_mergers` (array)
          for (int i = 0; i < jsonArraystockAndCashMergers.size(); i++) {
            CAStockAndCashMerger.validateJsonElement(jsonArraystockAndCashMergers.get(i));
          };
        }
      }
      if (jsonObj.get("redemptions") != null && !jsonObj.get("redemptions").isJsonNull()) {
        JsonArray jsonArrayredemptions = jsonObj.getAsJsonArray("redemptions");
        if (jsonArrayredemptions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("redemptions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `redemptions` to be an array in the JSON string but got `%s`", jsonObj.get("redemptions").toString()));
          }

          // validate the optional field `redemptions` (array)
          for (int i = 0; i < jsonArrayredemptions.size(); i++) {
            CARedemption.validateJsonElement(jsonArrayredemptions.get(i));
          };
        }
      }
      if (jsonObj.get("name_changes") != null && !jsonObj.get("name_changes").isJsonNull()) {
        JsonArray jsonArraynameChanges = jsonObj.getAsJsonArray("name_changes");
        if (jsonArraynameChanges != null) {
          // ensure the json data is an array
          if (!jsonObj.get("name_changes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `name_changes` to be an array in the JSON string but got `%s`", jsonObj.get("name_changes").toString()));
          }

          // validate the optional field `name_changes` (array)
          for (int i = 0; i < jsonArraynameChanges.size(); i++) {
            CANameChange.validateJsonElement(jsonArraynameChanges.get(i));
          };
        }
      }
      if (jsonObj.get("worthless_removals") != null && !jsonObj.get("worthless_removals").isJsonNull()) {
        JsonArray jsonArrayworthlessRemovals = jsonObj.getAsJsonArray("worthless_removals");
        if (jsonArrayworthlessRemovals != null) {
          // ensure the json data is an array
          if (!jsonObj.get("worthless_removals").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `worthless_removals` to be an array in the JSON string but got `%s`", jsonObj.get("worthless_removals").toString()));
          }

          // validate the optional field `worthless_removals` (array)
          for (int i = 0; i < jsonArrayworthlessRemovals.size(); i++) {
            CAWorthlessRemoval.validateJsonElement(jsonArrayworthlessRemovals.get(i));
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CACorporateActions.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CACorporateActions' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CACorporateActions> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CACorporateActions.class));

       return (TypeAdapter<T>) new TypeAdapter<CACorporateActions>() {
           @Override
           public void write(JsonWriter out, CACorporateActions value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CACorporateActions read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CACorporateActions given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CACorporateActions
  * @throws IOException if the JSON string is invalid with respect to CACorporateActions
  */
  public static CACorporateActions fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CACorporateActions.class);
  }

 /**
  * Convert an instance of CACorporateActions to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

