/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Cash merger. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CACashMerger {
  public static final String SERIALIZED_NAME_ACQUIRER_SYMBOL = "acquirer_symbol";
  @SerializedName(SERIALIZED_NAME_ACQUIRER_SYMBOL)
  private String acquirerSymbol;

  public static final String SERIALIZED_NAME_ACQUIREE_SYMBOL = "acquiree_symbol";
  @SerializedName(SERIALIZED_NAME_ACQUIREE_SYMBOL)
  private String acquireeSymbol;

  public static final String SERIALIZED_NAME_RATE = "rate";
  @SerializedName(SERIALIZED_NAME_RATE)
  private Double rate;

  public static final String SERIALIZED_NAME_PROCESS_DATE = "process_date";
  @SerializedName(SERIALIZED_NAME_PROCESS_DATE)
  private LocalDate processDate;

  public static final String SERIALIZED_NAME_EFFECTIVE_DATE = "effective_date";
  @SerializedName(SERIALIZED_NAME_EFFECTIVE_DATE)
  private LocalDate effectiveDate;

  public static final String SERIALIZED_NAME_PAYABLE_DATE = "payable_date";
  @SerializedName(SERIALIZED_NAME_PAYABLE_DATE)
  private LocalDate payableDate;

  public CACashMerger() {
  }

  public CACashMerger acquirerSymbol(String acquirerSymbol) {
    this.acquirerSymbol = acquirerSymbol;
    return this;
  }

   /**
   * Get acquirerSymbol
   * @return acquirerSymbol
  **/
  @javax.annotation.Nullable
  public String getAcquirerSymbol() {
    return acquirerSymbol;
  }

  public void setAcquirerSymbol(String acquirerSymbol) {
    this.acquirerSymbol = acquirerSymbol;
  }


  public CACashMerger acquireeSymbol(String acquireeSymbol) {
    this.acquireeSymbol = acquireeSymbol;
    return this;
  }

   /**
   * Get acquireeSymbol
   * @return acquireeSymbol
  **/
  @javax.annotation.Nonnull
  public String getAcquireeSymbol() {
    return acquireeSymbol;
  }

  public void setAcquireeSymbol(String acquireeSymbol) {
    this.acquireeSymbol = acquireeSymbol;
  }


  public CACashMerger rate(Double rate) {
    this.rate = rate;
    return this;
  }

   /**
   * Get rate
   * @return rate
  **/
  @javax.annotation.Nonnull
  public Double getRate() {
    return rate;
  }

  public void setRate(Double rate) {
    this.rate = rate;
  }


  public CACashMerger processDate(LocalDate processDate) {
    this.processDate = processDate;
    return this;
  }

   /**
   * The date when the corporate action is processed by Alpaca.
   * @return processDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getProcessDate() {
    return processDate;
  }

  public void setProcessDate(LocalDate processDate) {
    this.processDate = processDate;
  }


  public CACashMerger effectiveDate(LocalDate effectiveDate) {
    this.effectiveDate = effectiveDate;
    return this;
  }

   /**
   * The ex-date marks the cutoff point for shareholders to be credited.
   * @return effectiveDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getEffectiveDate() {
    return effectiveDate;
  }

  public void setEffectiveDate(LocalDate effectiveDate) {
    this.effectiveDate = effectiveDate;
  }


  public CACashMerger payableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
    return this;
  }

   /**
   * Get payableDate
   * @return payableDate
  **/
  @javax.annotation.Nullable
  public LocalDate getPayableDate() {
    return payableDate;
  }

  public void setPayableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CACashMerger caCashMerger = (CACashMerger) o;
    return Objects.equals(this.acquirerSymbol, caCashMerger.acquirerSymbol) &&
        Objects.equals(this.acquireeSymbol, caCashMerger.acquireeSymbol) &&
        Objects.equals(this.rate, caCashMerger.rate) &&
        Objects.equals(this.processDate, caCashMerger.processDate) &&
        Objects.equals(this.effectiveDate, caCashMerger.effectiveDate) &&
        Objects.equals(this.payableDate, caCashMerger.payableDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerSymbol, acquireeSymbol, rate, processDate, effectiveDate, payableDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CACashMerger {\n");
    sb.append("    acquirerSymbol: ").append(toIndentedString(acquirerSymbol)).append("\n");
    sb.append("    acquireeSymbol: ").append(toIndentedString(acquireeSymbol)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    processDate: ").append(toIndentedString(processDate)).append("\n");
    sb.append("    effectiveDate: ").append(toIndentedString(effectiveDate)).append("\n");
    sb.append("    payableDate: ").append(toIndentedString(payableDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("acquirer_symbol");
    openapiFields.add("acquiree_symbol");
    openapiFields.add("rate");
    openapiFields.add("process_date");
    openapiFields.add("effective_date");
    openapiFields.add("payable_date");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("acquiree_symbol");
    openapiRequiredFields.add("rate");
    openapiRequiredFields.add("process_date");
    openapiRequiredFields.add("effective_date");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CACashMerger.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CACashMerger is not found in the empty JSON string", CACashMerger.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CACashMerger.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CACashMerger` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CACashMerger.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("acquirer_symbol") != null && !jsonObj.get("acquirer_symbol").isJsonNull()) && !jsonObj.get("acquirer_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `acquirer_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acquirer_symbol").toString()));
      }
      if (!jsonObj.get("acquiree_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `acquiree_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acquiree_symbol").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CACashMerger.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CACashMerger' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CACashMerger> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CACashMerger.class));

       return (TypeAdapter<T>) new TypeAdapter<CACashMerger>() {
           @Override
           public void write(JsonWriter out, CACashMerger value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CACashMerger read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CACashMerger given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CACashMerger
  * @throws IOException if the JSON string is invalid with respect to CACashMerger
  */
  public static CACashMerger fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CACashMerger.class);
  }

 /**
  * Convert an instance of CACashMerger to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

