/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Cash dividend. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CACashDividend {
  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_RATE = "rate";
  @SerializedName(SERIALIZED_NAME_RATE)
  private Double rate;

  public static final String SERIALIZED_NAME_SPECIAL = "special";
  @SerializedName(SERIALIZED_NAME_SPECIAL)
  private Boolean special;

  public static final String SERIALIZED_NAME_FOREIGN = "foreign";
  @SerializedName(SERIALIZED_NAME_FOREIGN)
  private Boolean foreign;

  public static final String SERIALIZED_NAME_PROCESS_DATE = "process_date";
  @SerializedName(SERIALIZED_NAME_PROCESS_DATE)
  private LocalDate processDate;

  public static final String SERIALIZED_NAME_EX_DATE = "ex_date";
  @SerializedName(SERIALIZED_NAME_EX_DATE)
  private LocalDate exDate;

  public static final String SERIALIZED_NAME_RECORD_DATE = "record_date";
  @SerializedName(SERIALIZED_NAME_RECORD_DATE)
  private LocalDate recordDate;

  public static final String SERIALIZED_NAME_PAYABLE_DATE = "payable_date";
  @SerializedName(SERIALIZED_NAME_PAYABLE_DATE)
  private LocalDate payableDate;

  public static final String SERIALIZED_NAME_DUE_BILL_ON_DATE = "due_bill_on_date";
  @SerializedName(SERIALIZED_NAME_DUE_BILL_ON_DATE)
  private LocalDate dueBillOnDate;

  public static final String SERIALIZED_NAME_DUE_BILL_OFF_DATE = "due_bill_off_date";
  @SerializedName(SERIALIZED_NAME_DUE_BILL_OFF_DATE)
  private LocalDate dueBillOffDate;

  public CACashDividend() {
  }

  public CACashDividend symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Get symbol
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public CACashDividend rate(Double rate) {
    this.rate = rate;
    return this;
  }

   /**
   * Get rate
   * @return rate
  **/
  @javax.annotation.Nonnull
  public Double getRate() {
    return rate;
  }

  public void setRate(Double rate) {
    this.rate = rate;
  }


  public CACashDividend special(Boolean special) {
    this.special = special;
    return this;
  }

   /**
   * Get special
   * @return special
  **/
  @javax.annotation.Nonnull
  public Boolean getSpecial() {
    return special;
  }

  public void setSpecial(Boolean special) {
    this.special = special;
  }


  public CACashDividend foreign(Boolean foreign) {
    this.foreign = foreign;
    return this;
  }

   /**
   * Get foreign
   * @return foreign
  **/
  @javax.annotation.Nonnull
  public Boolean getForeign() {
    return foreign;
  }

  public void setForeign(Boolean foreign) {
    this.foreign = foreign;
  }


  public CACashDividend processDate(LocalDate processDate) {
    this.processDate = processDate;
    return this;
  }

   /**
   * The date when the corporate action is processed by Alpaca.
   * @return processDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getProcessDate() {
    return processDate;
  }

  public void setProcessDate(LocalDate processDate) {
    this.processDate = processDate;
  }


  public CACashDividend exDate(LocalDate exDate) {
    this.exDate = exDate;
    return this;
  }

   /**
   * The ex-date marks the cutoff point for shareholders to be credited.
   * @return exDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getExDate() {
    return exDate;
  }

  public void setExDate(LocalDate exDate) {
    this.exDate = exDate;
  }


  public CACashDividend recordDate(LocalDate recordDate) {
    this.recordDate = recordDate;
    return this;
  }

   /**
   * Get recordDate
   * @return recordDate
  **/
  @javax.annotation.Nullable
  public LocalDate getRecordDate() {
    return recordDate;
  }

  public void setRecordDate(LocalDate recordDate) {
    this.recordDate = recordDate;
  }


  public CACashDividend payableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
    return this;
  }

   /**
   * Get payableDate
   * @return payableDate
  **/
  @javax.annotation.Nullable
  public LocalDate getPayableDate() {
    return payableDate;
  }

  public void setPayableDate(LocalDate payableDate) {
    this.payableDate = payableDate;
  }


  public CACashDividend dueBillOnDate(LocalDate dueBillOnDate) {
    this.dueBillOnDate = dueBillOnDate;
    return this;
  }

   /**
   * Get dueBillOnDate
   * @return dueBillOnDate
  **/
  @javax.annotation.Nullable
  public LocalDate getDueBillOnDate() {
    return dueBillOnDate;
  }

  public void setDueBillOnDate(LocalDate dueBillOnDate) {
    this.dueBillOnDate = dueBillOnDate;
  }


  public CACashDividend dueBillOffDate(LocalDate dueBillOffDate) {
    this.dueBillOffDate = dueBillOffDate;
    return this;
  }

   /**
   * Get dueBillOffDate
   * @return dueBillOffDate
  **/
  @javax.annotation.Nullable
  public LocalDate getDueBillOffDate() {
    return dueBillOffDate;
  }

  public void setDueBillOffDate(LocalDate dueBillOffDate) {
    this.dueBillOffDate = dueBillOffDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CACashDividend caCashDividend = (CACashDividend) o;
    return Objects.equals(this.symbol, caCashDividend.symbol) &&
        Objects.equals(this.rate, caCashDividend.rate) &&
        Objects.equals(this.special, caCashDividend.special) &&
        Objects.equals(this.foreign, caCashDividend.foreign) &&
        Objects.equals(this.processDate, caCashDividend.processDate) &&
        Objects.equals(this.exDate, caCashDividend.exDate) &&
        Objects.equals(this.recordDate, caCashDividend.recordDate) &&
        Objects.equals(this.payableDate, caCashDividend.payableDate) &&
        Objects.equals(this.dueBillOnDate, caCashDividend.dueBillOnDate) &&
        Objects.equals(this.dueBillOffDate, caCashDividend.dueBillOffDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(symbol, rate, special, foreign, processDate, exDate, recordDate, payableDate, dueBillOnDate, dueBillOffDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CACashDividend {\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    special: ").append(toIndentedString(special)).append("\n");
    sb.append("    foreign: ").append(toIndentedString(foreign)).append("\n");
    sb.append("    processDate: ").append(toIndentedString(processDate)).append("\n");
    sb.append("    exDate: ").append(toIndentedString(exDate)).append("\n");
    sb.append("    recordDate: ").append(toIndentedString(recordDate)).append("\n");
    sb.append("    payableDate: ").append(toIndentedString(payableDate)).append("\n");
    sb.append("    dueBillOnDate: ").append(toIndentedString(dueBillOnDate)).append("\n");
    sb.append("    dueBillOffDate: ").append(toIndentedString(dueBillOffDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("symbol");
    openapiFields.add("rate");
    openapiFields.add("special");
    openapiFields.add("foreign");
    openapiFields.add("process_date");
    openapiFields.add("ex_date");
    openapiFields.add("record_date");
    openapiFields.add("payable_date");
    openapiFields.add("due_bill_on_date");
    openapiFields.add("due_bill_off_date");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("rate");
    openapiRequiredFields.add("special");
    openapiRequiredFields.add("foreign");
    openapiRequiredFields.add("process_date");
    openapiRequiredFields.add("ex_date");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CACashDividend.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CACashDividend is not found in the empty JSON string", CACashDividend.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CACashDividend.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CACashDividend` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CACashDividend.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CACashDividend.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CACashDividend' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CACashDividend> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CACashDividend.class));

       return (TypeAdapter<T>) new TypeAdapter<CACashDividend>() {
           @Override
           public void write(JsonWriter out, CACashDividend value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CACashDividend read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CACashDividend given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CACashDividend
  * @throws IOException if the JSON string is invalid with respect to CACashDividend
  */
  public static CACashDividend fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CACashDividend.class);
  }

 /**
  * Convert an instance of CACashDividend to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

