/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.api;

import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAdjustment;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockFeed;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshot;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshotsRespSingle;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesRespSingle;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StockApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public StockApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StockApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for stockAuctionSingle
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockAuctionSingleCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/auctions"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockAuctionSingleValidateBeforeCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockAuctionSingle(Async)");
        }

        return stockAuctionSingleCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical auctions (single)
     * The historical auctions endpoint provides auction prices for a list of stock symbols between the specified dates. 
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockAuctionsRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockAuctionsRespSingle stockAuctionSingle(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockAuctionsRespSingle> localVarResp = stockAuctionSingleWithHttpInfo(symbol, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical auctions (single)
     * The historical auctions endpoint provides auction prices for a list of stock symbols between the specified dates. 
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockAuctionsRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockAuctionsRespSingle> stockAuctionSingleWithHttpInfo(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockAuctionSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockAuctionsRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical auctions (single) (asynchronously)
     * The historical auctions endpoint provides auction prices for a list of stock symbols between the specified dates. 
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockAuctionSingleAsync(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockAuctionsRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockAuctionSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockAuctionsRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockAuctions
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockAuctionsCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/auctions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockAuctionsValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockAuctions(Async)");
        }

        return stockAuctionsCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical auctions
     * The historical auctions endpoint provides auction prices for the stock symbol between the specified dates. 
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockAuctionsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockAuctionsResp stockAuctions(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockAuctionsResp> localVarResp = stockAuctionsWithHttpInfo(symbols, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical auctions
     * The historical auctions endpoint provides auction prices for the stock symbol between the specified dates. 
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockAuctionsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockAuctionsResp> stockAuctionsWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockAuctionsValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockAuctionsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical auctions (asynchronously)
     * The historical auctions endpoint provides auction prices for the stock symbol between the specified dates. 
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockAuctionsAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockAuctionsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockAuctionsValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockAuctionsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockBarSingle
     * @param symbol The symbol to query for. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockBarSingleCall(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/bars"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (timeframe != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeframe", timeframe));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (adjustment != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("adjustment", adjustment));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockBarSingleValidateBeforeCall(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockBarSingle(Async)");
        }

        // verify the required parameter 'timeframe' is set
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling stockBarSingle(Async)");
        }

        return stockBarSingleCall(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical bars (single symbol)
     * The historical stock bars API provides aggregates for the stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockBarsRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockBarsRespSingle stockBarSingle(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockBarsRespSingle> localVarResp = stockBarSingleWithHttpInfo(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical bars (single symbol)
     * The historical stock bars API provides aggregates for the stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockBarsRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockBarsRespSingle> stockBarSingleWithHttpInfo(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockBarSingleValidateBeforeCall(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockBarsRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical bars (single symbol) (asynchronously)
     * The historical stock bars API provides aggregates for the stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockBarSingleAsync(String symbol, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockBarsRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockBarSingleValidateBeforeCall(symbol, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockBarsRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockBars
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockBarsCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/bars";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (timeframe != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeframe", timeframe));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (adjustment != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("adjustment", adjustment));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockBarsValidateBeforeCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockBars(Async)");
        }

        // verify the required parameter 'timeframe' is set
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling stockBars(Async)");
        }

        return stockBarsCall(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical bars
     * The historical stock bars API provides aggregates for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by bar timestamp. This means that you are likely to see only one symbol in your first response if there are enough bars for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any bars were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockBarsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockBarsResp stockBars(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockBarsResp> localVarResp = stockBarsWithHttpInfo(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical bars
     * The historical stock bars API provides aggregates for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by bar timestamp. This means that you are likely to see only one symbol in your first response if there are enough bars for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any bars were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockBarsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockBarsResp> stockBarsWithHttpInfo(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockBarsValidateBeforeCall(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockBarsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical bars (asynchronously)
     * The historical stock bars API provides aggregates for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by bar timestamp. This means that you are likely to see only one symbol in your first response if there are enough bars for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any bars were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param adjustment Specifies the corporate action adjustment for the stocks. (optional, default to raw)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockBarsAsync(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, StockAdjustment adjustment, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockBarsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockBarsValidateBeforeCall(symbols, timeframe, start, end, limit, adjustment, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockBarsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockLatestBarSingle
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestBarSingleCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/bars/latest"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockLatestBarSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockLatestBarSingle(Async)");
        }

        return stockLatestBarSingleCall(symbol, feed, currency, _callback);

    }

    /**
     * Latest bar (single symbol)
     * The latest stock bars endpoint returns the latest minute-aggregated historical bar for the requested security. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return StockLatestBarsRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockLatestBarsRespSingle stockLatestBarSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestBarsRespSingle> localVarResp = stockLatestBarSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Latest bar (single symbol)
     * The latest stock bars endpoint returns the latest minute-aggregated historical bar for the requested security. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;StockLatestBarsRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockLatestBarsRespSingle> stockLatestBarSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockLatestBarSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestBarsRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest bar (single symbol) (asynchronously)
     * The latest stock bars endpoint returns the latest minute-aggregated historical bar for the requested security. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestBarSingleAsync(String symbol, StockFeed feed, String currency, final ApiCallback<StockLatestBarsRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockLatestBarSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestBarsRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockLatestBars
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestBarsCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/bars/latest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockLatestBarsValidateBeforeCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockLatestBars(Async)");
        }

        return stockLatestBarsCall(symbols, feed, currency, _callback);

    }

    /**
     * Latest bars
     * The latest multi bars endpoint returns the latest minute-aggregated historical bar data for the ticker symbols provided. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return StockLatestBarsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockLatestBarsResp stockLatestBars(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestBarsResp> localVarResp = stockLatestBarsWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Latest bars
     * The latest multi bars endpoint returns the latest minute-aggregated historical bar data for the ticker symbols provided. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;StockLatestBarsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockLatestBarsResp> stockLatestBarsWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockLatestBarsValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestBarsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest bars (asynchronously)
     * The latest multi bars endpoint returns the latest minute-aggregated historical bar data for the ticker symbols provided. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestBarsAsync(String symbols, StockFeed feed, String currency, final ApiCallback<StockLatestBarsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockLatestBarsValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestBarsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockLatestQuoteSingle
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestQuoteSingleCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/quotes/latest"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockLatestQuoteSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockLatestQuoteSingle(Async)");
        }

        return stockLatestQuoteSingleCall(symbol, feed, currency, _callback);

    }

    /**
     * Latest quote (single symbol)
     * The latest quotes endpoint provides the latest bid and ask prices for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return StockLatestQuotesRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockLatestQuotesRespSingle stockLatestQuoteSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestQuotesRespSingle> localVarResp = stockLatestQuoteSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Latest quote (single symbol)
     * The latest quotes endpoint provides the latest bid and ask prices for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;StockLatestQuotesRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockLatestQuotesRespSingle> stockLatestQuoteSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockLatestQuoteSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestQuotesRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest quote (single symbol) (asynchronously)
     * The latest quotes endpoint provides the latest bid and ask prices for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestQuoteSingleAsync(String symbol, StockFeed feed, String currency, final ApiCallback<StockLatestQuotesRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockLatestQuoteSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestQuotesRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockLatestQuotes
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestQuotesCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/quotes/latest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockLatestQuotesValidateBeforeCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockLatestQuotes(Async)");
        }

        return stockLatestQuotesCall(symbols, feed, currency, _callback);

    }

    /**
     * Latest quotes
     * The latest multi quotes endpoint provides the latest bid and ask prices for each given ticker symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return StockLatestQuotesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockLatestQuotesResp stockLatestQuotes(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestQuotesResp> localVarResp = stockLatestQuotesWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Latest quotes
     * The latest multi quotes endpoint provides the latest bid and ask prices for each given ticker symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;StockLatestQuotesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockLatestQuotesResp> stockLatestQuotesWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockLatestQuotesValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestQuotesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest quotes (asynchronously)
     * The latest multi quotes endpoint provides the latest bid and ask prices for each given ticker symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestQuotesAsync(String symbols, StockFeed feed, String currency, final ApiCallback<StockLatestQuotesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockLatestQuotesValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestQuotesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockLatestTradeSingle
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestTradeSingleCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/trades/latest"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockLatestTradeSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockLatestTradeSingle(Async)");
        }

        return stockLatestTradeSingleCall(symbol, feed, currency, _callback);

    }

    /**
     * Latest trade (single symbol)
     * The latest trades endpoint provides the latest trade data for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return StockLatestTradesRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockLatestTradesRespSingle stockLatestTradeSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestTradesRespSingle> localVarResp = stockLatestTradeSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Latest trade (single symbol)
     * The latest trades endpoint provides the latest trade data for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;StockLatestTradesRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockLatestTradesRespSingle> stockLatestTradeSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockLatestTradeSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestTradesRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest trade (single symbol) (asynchronously)
     * The latest trades endpoint provides the latest trade data for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestTradeSingleAsync(String symbol, StockFeed feed, String currency, final ApiCallback<StockLatestTradesRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockLatestTradeSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestTradesRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockLatestTrades
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestTradesCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/trades/latest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockLatestTradesValidateBeforeCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockLatestTrades(Async)");
        }

        return stockLatestTradesCall(symbols, feed, currency, _callback);

    }

    /**
     * Latest trades
     * The latest multi trades endpoint provides the latest historical trade data for multiple given ticker symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return StockLatestTradesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockLatestTradesResp stockLatestTrades(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockLatestTradesResp> localVarResp = stockLatestTradesWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Latest trades
     * The latest multi trades endpoint provides the latest historical trade data for multiple given ticker symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;StockLatestTradesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockLatestTradesResp> stockLatestTradesWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockLatestTradesValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockLatestTradesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest trades (asynchronously)
     * The latest multi trades endpoint provides the latest historical trade data for multiple given ticker symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockLatestTradesAsync(String symbols, StockFeed feed, String currency, final ApiCallback<StockLatestTradesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockLatestTradesValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockLatestTradesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockMetaConditions
     * @param ticktype The type of ticks (required)
     * @param tape The one character name of the tape (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockMetaConditionsCall(String ticktype, String tape, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/meta/conditions/{ticktype}"
            .replace("{" + "ticktype" + "}", localVarApiClient.escapeString(ticktype.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (tape != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tape", tape));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockMetaConditionsValidateBeforeCall(String ticktype, String tape, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'ticktype' is set
        if (ticktype == null) {
            throw new ApiException("Missing the required parameter 'ticktype' when calling stockMetaConditions(Async)");
        }

        // verify the required parameter 'tape' is set
        if (tape == null) {
            throw new ApiException("Missing the required parameter 'tape' when calling stockMetaConditions(Async)");
        }

        return stockMetaConditionsCall(ticktype, tape, _callback);

    }

    /**
     * Condition codes
     * Returns the mapping between the condition codes and names. 
     * @param ticktype The type of ticks (required)
     * @param tape The one character name of the tape (required)
     * @return Map&lt;String, String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public Map<String, String> stockMetaConditions(String ticktype, String tape) throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = stockMetaConditionsWithHttpInfo(ticktype, tape);
        return localVarResp.getData();
    }

    /**
     * Condition codes
     * Returns the mapping between the condition codes and names. 
     * @param ticktype The type of ticks (required)
     * @param tape The one character name of the tape (required)
     * @return ApiResponse&lt;Map&lt;String, String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<Map<String, String>> stockMetaConditionsWithHttpInfo(String ticktype, String tape) throws ApiException {
        okhttp3.Call localVarCall = stockMetaConditionsValidateBeforeCall(ticktype, tape, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Condition codes (asynchronously)
     * Returns the mapping between the condition codes and names. 
     * @param ticktype The type of ticks (required)
     * @param tape The one character name of the tape (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockMetaConditionsAsync(String ticktype, String tape, final ApiCallback<Map<String, String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockMetaConditionsValidateBeforeCall(ticktype, tape, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockMetaExchanges
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockMetaExchangesCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/meta/exchanges";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockMetaExchangesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return stockMetaExchangesCall(_callback);

    }

    /**
     * Exchange codes
     * Returns the mapping between the stock exchange codes and the corresponding exchanges names. 
     * @return Map&lt;String, String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public Map<String, String> stockMetaExchanges() throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = stockMetaExchangesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Exchange codes
     * Returns the mapping between the stock exchange codes and the corresponding exchanges names. 
     * @return ApiResponse&lt;Map&lt;String, String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<Map<String, String>> stockMetaExchangesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = stockMetaExchangesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Exchange codes (asynchronously)
     * Returns the mapping between the stock exchange codes and the corresponding exchanges names. 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockMetaExchangesAsync(final ApiCallback<Map<String, String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockMetaExchangesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockQuoteSingle
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockQuoteSingleCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/quotes"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockQuoteSingleValidateBeforeCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockQuoteSingle(Async)");
        }

        return stockQuoteSingleCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical quotes (single symbol)
     * The historical stock quotes API provides quote data for a stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockQuotesRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockQuotesRespSingle stockQuoteSingle(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockQuotesRespSingle> localVarResp = stockQuoteSingleWithHttpInfo(symbol, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical quotes (single symbol)
     * The historical stock quotes API provides quote data for a stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockQuotesRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockQuotesRespSingle> stockQuoteSingleWithHttpInfo(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockQuoteSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockQuotesRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical quotes (single symbol) (asynchronously)
     * The historical stock quotes API provides quote data for a stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockQuoteSingleAsync(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockQuotesRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockQuoteSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockQuotesRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockQuotes
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockQuotesCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/quotes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockQuotesValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockQuotes(Async)");
        }

        return stockQuotesCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical quotes
     * The historical stock quotes API provides quote data for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by quote timestamp. This means that you are likely to see only one symbol in your first response if there are enough quotes for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any quotes were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockQuotesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockQuotesResp stockQuotes(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockQuotesResp> localVarResp = stockQuotesWithHttpInfo(symbols, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical quotes
     * The historical stock quotes API provides quote data for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by quote timestamp. This means that you are likely to see only one symbol in your first response if there are enough quotes for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any quotes were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockQuotesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockQuotesResp> stockQuotesWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockQuotesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockQuotesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical quotes (asynchronously)
     * The historical stock quotes API provides quote data for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by quote timestamp. This means that you are likely to see only one symbol in your first response if there are enough quotes for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any quotes were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockQuotesAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockQuotesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockQuotesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockQuotesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockSnapshotSingle
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockSnapshotSingleCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/snapshot"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockSnapshotSingleValidateBeforeCall(String symbol, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockSnapshotSingle(Async)");
        }

        return stockSnapshotSingleCall(symbol, feed, currency, _callback);

    }

    /**
     * Snapshot (single symbol)
     * The snapshot endpoint provides the latest trade, latest quote, minute bar daily bar, and previous daily bar data for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return StockSnapshotsRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockSnapshotsRespSingle stockSnapshotSingle(String symbol, StockFeed feed, String currency) throws ApiException {
        ApiResponse<StockSnapshotsRespSingle> localVarResp = stockSnapshotSingleWithHttpInfo(symbol, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Snapshot (single symbol)
     * The snapshot endpoint provides the latest trade, latest quote, minute bar daily bar, and previous daily bar data for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;StockSnapshotsRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockSnapshotsRespSingle> stockSnapshotSingleWithHttpInfo(String symbol, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockSnapshotSingleValidateBeforeCall(symbol, feed, currency, null);
        Type localVarReturnType = new TypeToken<StockSnapshotsRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Snapshot (single symbol) (asynchronously)
     * The snapshot endpoint provides the latest trade, latest quote, minute bar daily bar, and previous daily bar data for a given ticker symbol. 
     * @param symbol The symbol to query for. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockSnapshotSingleAsync(String symbol, StockFeed feed, String currency, final ApiCallback<StockSnapshotsRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockSnapshotSingleValidateBeforeCall(symbol, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<StockSnapshotsRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockSnapshots
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockSnapshotsCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/snapshots";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockSnapshotsValidateBeforeCall(String symbols, StockFeed feed, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockSnapshots(Async)");
        }

        return stockSnapshotsCall(symbols, feed, currency, _callback);

    }

    /**
     * Snapshots
     * The snapshot endpoint for multiple tickers provides the latest trade, latest quote, minute bar daily bar, and previous daily bar data for each given ticker symbol. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return Map&lt;String, StockSnapshot&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public Map<String, StockSnapshot> stockSnapshots(String symbols, StockFeed feed, String currency) throws ApiException {
        ApiResponse<Map<String, StockSnapshot>> localVarResp = stockSnapshotsWithHttpInfo(symbols, feed, currency);
        return localVarResp.getData();
    }

    /**
     * Snapshots
     * The snapshot endpoint for multiple tickers provides the latest trade, latest quote, minute bar daily bar, and previous daily bar data for each given ticker symbol. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @return ApiResponse&lt;Map&lt;String, StockSnapshot&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<Map<String, StockSnapshot>> stockSnapshotsWithHttpInfo(String symbols, StockFeed feed, String currency) throws ApiException {
        okhttp3.Call localVarCall = stockSnapshotsValidateBeforeCall(symbols, feed, currency, null);
        Type localVarReturnType = new TypeToken<Map<String, StockSnapshot>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Snapshots (asynchronously)
     * The snapshot endpoint for multiple tickers provides the latest trade, latest quote, minute bar daily bar, and previous daily bar data for each given ticker symbol. 
     * @param symbols Comma separated list of symbols. (required)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockSnapshotsAsync(String symbols, StockFeed feed, String currency, final ApiCallback<Map<String, StockSnapshot>> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockSnapshotsValidateBeforeCall(symbols, feed, currency, _callback);
        Type localVarReturnType = new TypeToken<Map<String, StockSnapshot>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockTradeSingle
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockTradeSingleCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/{symbol}/trades"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockTradeSingleValidateBeforeCall(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling stockTradeSingle(Async)");
        }

        return stockTradeSingleCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical trades (single symbol)
     * The historical stock trades API provides trade data for a stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockTradesRespSingle
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockTradesRespSingle stockTradeSingle(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockTradesRespSingle> localVarResp = stockTradeSingleWithHttpInfo(symbol, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical trades (single symbol)
     * The historical stock trades API provides trade data for a stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockTradesRespSingle&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockTradesRespSingle> stockTradeSingleWithHttpInfo(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockTradeSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockTradesRespSingle>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical trades (single symbol) (asynchronously)
     * The historical stock trades API provides trade data for a stock symbol between the specified dates.
     * @param symbol The symbol to query for. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockTradeSingleAsync(String symbol, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockTradesRespSingle> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockTradeSingleValidateBeforeCall(symbol, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockTradesRespSingle>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stockTrades
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockTradesCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/stocks/trades";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (asof != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asof", asof));
        }

        if (feed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("feed", feed));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stockTradesValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling stockTrades(Async)");
        }

        return stockTradesCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);

    }

    /**
     * Historical trades
     * The historical stock trades API provides trade data for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by trade timestamp. This means that you are likely to see only one symbol in your first response if there are enough trades for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any trades were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return StockTradesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public StockTradesResp stockTrades(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        ApiResponse<StockTradesResp> localVarResp = stockTradesWithHttpInfo(symbols, start, end, limit, asof, feed, currency, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical trades
     * The historical stock trades API provides trade data for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by trade timestamp. This means that you are likely to see only one symbol in your first response if there are enough trades for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any trades were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;StockTradesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<StockTradesResp> stockTradesWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = stockTradesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<StockTradesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical trades (asynchronously)
     * The historical stock trades API provides trade data for a list of stock symbols between the specified dates.  The returned results are sorted by symbol first then by trade timestamp. This means that you are likely to see only one symbol in your first response if there are enough trades for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any trades were found for them.
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param asof The asof date of the queried stock symbol(s) in YYYY-MM-DD format. Default is the current day.  This date is used to identify the underlying entity of the provided symbol(s) so that name changes for this entity can be found. Data for past symbol(s) is returned if the query date range spans the name change.  The special value of \&quot;-\&quot; means symbol mapping is skipped. Data is returned based on the symbol alone without looking up previous names. The same happens if the queried symbol is not found on the given asof date.  Example: FB was renamed to META in 2022-06-09. Querying META with an asof date after 2022-06-09 will also yield FB data. The data for the FB ticker will be labeled as META because they are considered the same underlying entity as of 2022-06-09. Querying FB with an asof date after 2022-06-09 will only return data with the FB ticker, not with META. But with an asof date before 2022-06-09, META will also be returned (as FB).  (optional)
     * @param feed The source feed of the data. &#x60;sip&#x60; contains all US exchanges, &#x60;iex&#x60; contains only the Investors Exchange. &#x60;otc&#x60; contains over the counter exchanges. Default: &#x60;sip&#x60; for the non-latest endpoints or if the user has the unlimited subscription, &#x60;iex&#x60; otherwise.  (optional, default to sip)
     * @param currency The currency of all prices in ISO 4217 format. Default is USD.  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call stockTradesAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String asof, StockFeed feed, String currency, String pageToken, Sort sort, final ApiCallback<StockTradesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = stockTradesValidateBeforeCall(symbols, start, end, limit, asof, feed, currency, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<StockTradesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
