/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.api;

import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionSnapshotsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OptionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OptionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for optionBars
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionBarsCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/options/bars";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (timeframe != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeframe", timeframe));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionBarsValidateBeforeCall(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionBars(Async)");
        }

        // verify the required parameter 'timeframe' is set
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling optionBars(Async)");
        }

        return optionBarsCall(symbols, timeframe, start, end, limit, pageToken, sort, _callback);

    }

    /**
     * Historical bars (BETA)
     * The historical option bars API provides aggregates for a list of option symbols between the specified dates.  The returned results are sorted by symbol first then by bar timestamp. This means that you are likely to see only one symbol in your first response if there are enough bars for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any bars were found for them.
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return OptionBarsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public OptionBarsResp optionBars(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<OptionBarsResp> localVarResp = optionBarsWithHttpInfo(symbols, timeframe, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical bars (BETA)
     * The historical option bars API provides aggregates for a list of option symbols between the specified dates.  The returned results are sorted by symbol first then by bar timestamp. This means that you are likely to see only one symbol in your first response if there are enough bars for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any bars were found for them.
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;OptionBarsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<OptionBarsResp> optionBarsWithHttpInfo(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = optionBarsValidateBeforeCall(symbols, timeframe, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<OptionBarsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical bars (BETA) (asynchronously)
     * The historical option bars API provides aggregates for a list of option symbols between the specified dates.  The returned results are sorted by symbol first then by bar timestamp. This means that you are likely to see only one symbol in your first response if there are enough bars for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any bars were found for them.
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionBarsAsync(String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback<OptionBarsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionBarsValidateBeforeCall(symbols, timeframe, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<OptionBarsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionChain
     * @param underlyingSymbol The financial instrument on which an option contract is based or derived. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionChainCall(String underlyingSymbol, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/options/snapshots/{underlying_symbol}"
            .replace("{" + "underlying_symbol" + "}", localVarApiClient.escapeString(underlyingSymbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionChainValidateBeforeCall(String underlyingSymbol, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlyingSymbol' is set
        if (underlyingSymbol == null) {
            throw new ApiException("Missing the required parameter 'underlyingSymbol' when calling optionChain(Async)");
        }

        return optionChainCall(underlyingSymbol, _callback);

    }

    /**
     * Option chain (BETA)
     * The option chain endpoint for underlying symbol provides the latest trade, latest quote for each contract symbol of the underlying symbol. 
     * @param underlyingSymbol The financial instrument on which an option contract is based or derived. (required)
     * @return OptionSnapshotsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public OptionSnapshotsResp optionChain(String underlyingSymbol) throws ApiException {
        ApiResponse<OptionSnapshotsResp> localVarResp = optionChainWithHttpInfo(underlyingSymbol);
        return localVarResp.getData();
    }

    /**
     * Option chain (BETA)
     * The option chain endpoint for underlying symbol provides the latest trade, latest quote for each contract symbol of the underlying symbol. 
     * @param underlyingSymbol The financial instrument on which an option contract is based or derived. (required)
     * @return ApiResponse&lt;OptionSnapshotsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<OptionSnapshotsResp> optionChainWithHttpInfo(String underlyingSymbol) throws ApiException {
        okhttp3.Call localVarCall = optionChainValidateBeforeCall(underlyingSymbol, null);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Option chain (BETA) (asynchronously)
     * The option chain endpoint for underlying symbol provides the latest trade, latest quote for each contract symbol of the underlying symbol. 
     * @param underlyingSymbol The financial instrument on which an option contract is based or derived. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionChainAsync(String underlyingSymbol, final ApiCallback<OptionSnapshotsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionChainValidateBeforeCall(underlyingSymbol, _callback);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionLatestQuotes
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionLatestQuotesCall(String symbols, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/options/quotes/latest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionLatestQuotesValidateBeforeCall(String symbols, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionLatestQuotes(Async)");
        }

        return optionLatestQuotesCall(symbols, _callback);

    }

    /**
     * Latest quotes (BETA)
     * The latest multi quotes endpoint provides the latest bid and ask prices for each given contract symbol. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @return OptionLatestQuotesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public OptionLatestQuotesResp optionLatestQuotes(String symbols) throws ApiException {
        ApiResponse<OptionLatestQuotesResp> localVarResp = optionLatestQuotesWithHttpInfo(symbols);
        return localVarResp.getData();
    }

    /**
     * Latest quotes (BETA)
     * The latest multi quotes endpoint provides the latest bid and ask prices for each given contract symbol. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @return ApiResponse&lt;OptionLatestQuotesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<OptionLatestQuotesResp> optionLatestQuotesWithHttpInfo(String symbols) throws ApiException {
        okhttp3.Call localVarCall = optionLatestQuotesValidateBeforeCall(symbols, null);
        Type localVarReturnType = new TypeToken<OptionLatestQuotesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest quotes (BETA) (asynchronously)
     * The latest multi quotes endpoint provides the latest bid and ask prices for each given contract symbol. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionLatestQuotesAsync(String symbols, final ApiCallback<OptionLatestQuotesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionLatestQuotesValidateBeforeCall(symbols, _callback);
        Type localVarReturnType = new TypeToken<OptionLatestQuotesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionLatestTrades
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionLatestTradesCall(String symbols, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/options/trades/latest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionLatestTradesValidateBeforeCall(String symbols, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionLatestTrades(Async)");
        }

        return optionLatestTradesCall(symbols, _callback);

    }

    /**
     * Latest trades (BETA)
     * The latest multi trades endpoint provides the latest historical trade data for multiple given contract symbols. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @return OptionLatestTradesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public OptionLatestTradesResp optionLatestTrades(String symbols) throws ApiException {
        ApiResponse<OptionLatestTradesResp> localVarResp = optionLatestTradesWithHttpInfo(symbols);
        return localVarResp.getData();
    }

    /**
     * Latest trades (BETA)
     * The latest multi trades endpoint provides the latest historical trade data for multiple given contract symbols. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @return ApiResponse&lt;OptionLatestTradesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<OptionLatestTradesResp> optionLatestTradesWithHttpInfo(String symbols) throws ApiException {
        okhttp3.Call localVarCall = optionLatestTradesValidateBeforeCall(symbols, null);
        Type localVarReturnType = new TypeToken<OptionLatestTradesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest trades (BETA) (asynchronously)
     * The latest multi trades endpoint provides the latest historical trade data for multiple given contract symbols. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionLatestTradesAsync(String symbols, final ApiCallback<OptionLatestTradesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionLatestTradesValidateBeforeCall(symbols, _callback);
        Type localVarReturnType = new TypeToken<OptionLatestTradesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionMetaExchanges
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionMetaExchangesCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/options/meta/exchanges";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionMetaExchangesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return optionMetaExchangesCall(_callback);

    }

    /**
     * Exchange codes (BETA)
     * Returns the mapping between the option exchange codes and the corresponding exchanges names. 
     * @return Map&lt;String, String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public Map<String, String> optionMetaExchanges() throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = optionMetaExchangesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Exchange codes (BETA)
     * Returns the mapping between the option exchange codes and the corresponding exchanges names. 
     * @return ApiResponse&lt;Map&lt;String, String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<Map<String, String>> optionMetaExchangesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = optionMetaExchangesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Exchange codes (BETA) (asynchronously)
     * Returns the mapping between the option exchange codes and the corresponding exchanges names. 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionMetaExchangesAsync(final ApiCallback<Map<String, String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionMetaExchangesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionSnapshots
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionSnapshotsCall(String symbols, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/options/snapshots";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionSnapshotsValidateBeforeCall(String symbols, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionSnapshots(Async)");
        }

        return optionSnapshotsCall(symbols, _callback);

    }

    /**
     * Snapshots (BETA)
     * The snapshot endpoint for multiple contract symbol provides the latest trade, latest quote for each given symbol. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @return OptionSnapshotsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public OptionSnapshotsResp optionSnapshots(String symbols) throws ApiException {
        ApiResponse<OptionSnapshotsResp> localVarResp = optionSnapshotsWithHttpInfo(symbols);
        return localVarResp.getData();
    }

    /**
     * Snapshots (BETA)
     * The snapshot endpoint for multiple contract symbol provides the latest trade, latest quote for each given symbol. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @return ApiResponse&lt;OptionSnapshotsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<OptionSnapshotsResp> optionSnapshotsWithHttpInfo(String symbols) throws ApiException {
        okhttp3.Call localVarCall = optionSnapshotsValidateBeforeCall(symbols, null);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Snapshots (BETA) (asynchronously)
     * The snapshot endpoint for multiple contract symbol provides the latest trade, latest quote for each given symbol. 
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionSnapshotsAsync(String symbols, final ApiCallback<OptionSnapshotsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionSnapshotsValidateBeforeCall(symbols, _callback);
        Type localVarReturnType = new TypeToken<OptionSnapshotsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionTrades
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionTradesCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/options/trades";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionTradesValidateBeforeCall(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling optionTrades(Async)");
        }

        return optionTradesCall(symbols, start, end, limit, pageToken, sort, _callback);

    }

    /**
     * Historical trades (BETA)
     * The historical option trades API provides trade data for a list of contract symbols between the specified dates up to 7 days ago.  The returned results are sorted by symbol first then by trade timestamp. This means that you are likely to see only one symbol in your first response if there are enough trades for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any trades were found for them.
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return OptionTradesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public OptionTradesResp optionTrades(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<OptionTradesResp> localVarResp = optionTradesWithHttpInfo(symbols, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical trades (BETA)
     * The historical option trades API provides trade data for a list of contract symbols between the specified dates up to 7 days ago.  The returned results are sorted by symbol first then by trade timestamp. This means that you are likely to see only one symbol in your first response if there are enough trades for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any trades were found for them.
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;OptionTradesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<OptionTradesResp> optionTradesWithHttpInfo(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = optionTradesValidateBeforeCall(symbols, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<OptionTradesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical trades (BETA) (asynchronously)
     * The historical option trades API provides trade data for a list of contract symbols between the specified dates up to 7 days ago.  The returned results are sorted by symbol first then by trade timestamp. This means that you are likely to see only one symbol in your first response if there are enough trades for that symbol to hit the limit you requested on that request.  In these situations if you keep requesting again with the &#x60;next_page_token&#x60; you will eventually reach the next symbols if any trades were found for them.
     * @param symbols Comma separated list of contract symbols with a limit of 100. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call optionTradesAsync(String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback<OptionTradesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionTradesValidateBeforeCall(symbols, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<OptionTradesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
