/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.api;

import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.marketdata.model.NewsResp;
import java.time.OffsetDateTime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NewsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NewsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NewsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for news
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param sort Sort articles by updated date.  (optional, default to desc)
     * @param symbols The comma-separated list of symbols to query news for. (optional)
     * @param limit Limit of news items to be returned for given page. (optional)
     * @param includeContent Boolean indicator to include content for news articles (if available) (optional)
     * @param excludeContentless Boolean indicator to exclude news articles that do not contain content  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call newsCall(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/news";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (includeContent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("include_content", includeContent));
        }

        if (excludeContentless != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("exclude_contentless", excludeContentless));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call newsValidateBeforeCall(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken, final ApiCallback _callback) throws ApiException {
        return newsCall(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken, _callback);

    }

    /**
     * News articles
     * Returns latest news articles across stocks and crypto. By default returns latest 10 news articles.
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param sort Sort articles by updated date.  (optional, default to desc)
     * @param symbols The comma-separated list of symbols to query news for. (optional)
     * @param limit Limit of news items to be returned for given page. (optional)
     * @param includeContent Boolean indicator to include content for news articles (if available) (optional)
     * @param excludeContentless Boolean indicator to exclude news articles that do not contain content  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @return NewsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public NewsResp news(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken) throws ApiException {
        ApiResponse<NewsResp> localVarResp = newsWithHttpInfo(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken);
        return localVarResp.getData();
    }

    /**
     * News articles
     * Returns latest news articles across stocks and crypto. By default returns latest 10 news articles.
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param sort Sort articles by updated date.  (optional, default to desc)
     * @param symbols The comma-separated list of symbols to query news for. (optional)
     * @param limit Limit of news items to be returned for given page. (optional)
     * @param includeContent Boolean indicator to include content for news articles (if available) (optional)
     * @param excludeContentless Boolean indicator to exclude news articles that do not contain content  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @return ApiResponse&lt;NewsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<NewsResp> newsWithHttpInfo(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken) throws ApiException {
        okhttp3.Call localVarCall = newsValidateBeforeCall(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken, null);
        Type localVarReturnType = new TypeToken<NewsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * News articles (asynchronously)
     * Returns latest news articles across stocks and crypto. By default returns latest 10 news articles.
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param sort Sort articles by updated date.  (optional, default to desc)
     * @param symbols The comma-separated list of symbols to query news for. (optional)
     * @param limit Limit of news items to be returned for given page. (optional)
     * @param includeContent Boolean indicator to include content for news articles (if available) (optional)
     * @param excludeContentless Boolean indicator to exclude news articles that do not contain content  (optional)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call newsAsync(OffsetDateTime start, OffsetDateTime end, String sort, String symbols, Integer limit, Boolean includeContent, Boolean excludeContentless, String pageToken, final ApiCallback<NewsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = newsValidateBeforeCall(start, end, sort, symbols, limit, includeContent, excludeContentless, pageToken, _callback);
        Type localVarReturnType = new TypeToken<NewsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
