/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.api;

import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.marketdata.model.ForexLatestRatesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ForexRatesResp;
import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ForexApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ForexApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ForexApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for latestRates
     * @param currencyPairs  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call latestRatesCall(String currencyPairs, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/forex/latest/rates";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (currencyPairs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pairs", currencyPairs));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call latestRatesValidateBeforeCall(String currencyPairs, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currencyPairs' is set
        if (currencyPairs == null) {
            throw new ApiException("Missing the required parameter 'currencyPairs' when calling latestRates(Async)");
        }

        return latestRatesCall(currencyPairs, _callback);

    }

    /**
     * Latest rates for currency pairs
     * Get the latest forex rates for the given currency pairs. 
     * @param currencyPairs  (required)
     * @return ForexLatestRatesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public ForexLatestRatesResp latestRates(String currencyPairs) throws ApiException {
        ApiResponse<ForexLatestRatesResp> localVarResp = latestRatesWithHttpInfo(currencyPairs);
        return localVarResp.getData();
    }

    /**
     * Latest rates for currency pairs
     * Get the latest forex rates for the given currency pairs. 
     * @param currencyPairs  (required)
     * @return ApiResponse&lt;ForexLatestRatesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<ForexLatestRatesResp> latestRatesWithHttpInfo(String currencyPairs) throws ApiException {
        okhttp3.Call localVarCall = latestRatesValidateBeforeCall(currencyPairs, null);
        Type localVarReturnType = new TypeToken<ForexLatestRatesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest rates for currency pairs (asynchronously)
     * Get the latest forex rates for the given currency pairs. 
     * @param currencyPairs  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call latestRatesAsync(String currencyPairs, final ApiCallback<ForexLatestRatesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = latestRatesValidateBeforeCall(currencyPairs, _callback);
        Type localVarReturnType = new TypeToken<ForexLatestRatesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for rates
     * @param currencyPairs  (required)
     * @param timeframe  (optional, default to 1Min)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call ratesCall(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/forex/rates";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (currencyPairs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pairs", currencyPairs));
        }

        if (timeframe != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeframe", timeframe));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call ratesValidateBeforeCall(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currencyPairs' is set
        if (currencyPairs == null) {
            throw new ApiException("Missing the required parameter 'currencyPairs' when calling rates(Async)");
        }

        return ratesCall(currencyPairs, timeframe, start, end, limit, sort, pageToken, _callback);

    }

    /**
     * Historical rates for currency pairs
     * Get historical forex rates for the given currency pairs in the given time interval, and at the given timeframe (snapshot frequency). 
     * @param currencyPairs  (required)
     * @param timeframe  (optional, default to 1Min)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @return ForexRatesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public ForexRatesResp rates(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken) throws ApiException {
        ApiResponse<ForexRatesResp> localVarResp = ratesWithHttpInfo(currencyPairs, timeframe, start, end, limit, sort, pageToken);
        return localVarResp.getData();
    }

    /**
     * Historical rates for currency pairs
     * Get historical forex rates for the given currency pairs in the given time interval, and at the given timeframe (snapshot frequency). 
     * @param currencyPairs  (required)
     * @param timeframe  (optional, default to 1Min)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @return ApiResponse&lt;ForexRatesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<ForexRatesResp> ratesWithHttpInfo(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken) throws ApiException {
        okhttp3.Call localVarCall = ratesValidateBeforeCall(currencyPairs, timeframe, start, end, limit, sort, pageToken, null);
        Type localVarReturnType = new TypeToken<ForexRatesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical rates for currency pairs (asynchronously)
     * Get historical forex rates for the given currency pairs in the given time interval, and at the given timeframe (snapshot frequency). 
     * @param currencyPairs  (required)
     * @param timeframe  (optional, default to 1Min)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call ratesAsync(String currencyPairs, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, Sort sort, String pageToken, final ApiCallback<ForexRatesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = ratesValidateBeforeCall(currencyPairs, timeframe, start, end, limit, sort, pageToken, _callback);
        Type localVarReturnType = new TypeToken<ForexRatesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
