/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.api;

import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestBarsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestOrderbooksResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestTradesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLoc;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoQuotesResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoSnapshotsResp;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoTradesResp;
import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CryptoApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CryptoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CryptoApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for cryptoBars
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoBarsCall(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/bars"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (timeframe != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeframe", timeframe));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoBarsValidateBeforeCall(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoBars(Async)");
        }

        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoBars(Async)");
        }

        // verify the required parameter 'timeframe' is set
        if (timeframe == null) {
            throw new ApiException("Missing the required parameter 'timeframe' when calling cryptoBars(Async)");
        }

        return cryptoBarsCall(loc, symbols, timeframe, start, end, limit, pageToken, sort, _callback);

    }

    /**
     * Historical bars
     * The crypto bars API provides historical aggregates for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return CryptoBarsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CryptoBarsResp cryptoBars(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<CryptoBarsResp> localVarResp = cryptoBarsWithHttpInfo(loc, symbols, timeframe, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical bars
     * The crypto bars API provides historical aggregates for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;CryptoBarsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoBarsResp> cryptoBarsWithHttpInfo(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = cryptoBarsValidateBeforeCall(loc, symbols, timeframe, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<CryptoBarsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical bars (asynchronously)
     * The crypto bars API provides historical aggregates for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param timeframe The timeframe of the bar aggregation. 5Min for example creates 5 minute aggregates. You can use the following values:  - [1-59]Min / T  - [1-23]Hour / H  - 1Day / D  - 1Week / W  - [1,2,3,4,6,12]Month / M  (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoBarsAsync(CryptoLoc loc, String symbols, String timeframe, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback<CryptoBarsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoBarsValidateBeforeCall(loc, symbols, timeframe, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<CryptoBarsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cryptoLatestBars
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestBarsCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/latest/bars"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoLatestBarsValidateBeforeCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestBars(Async)");
        }

        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestBars(Async)");
        }

        return cryptoLatestBarsCall(loc, symbols, _callback);

    }

    /**
     * Latest bars
     * The latest multi bars endpoint returns the latest minute-aggregated historical bar data for each of the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return CryptoLatestBarsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CryptoLatestBarsResp cryptoLatestBars(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestBarsResp> localVarResp = cryptoLatestBarsWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    /**
     * Latest bars
     * The latest multi bars endpoint returns the latest minute-aggregated historical bar data for each of the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return ApiResponse&lt;CryptoLatestBarsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoLatestBarsResp> cryptoLatestBarsWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        okhttp3.Call localVarCall = cryptoLatestBarsValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestBarsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest bars (asynchronously)
     * The latest multi bars endpoint returns the latest minute-aggregated historical bar data for each of the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestBarsAsync(CryptoLoc loc, String symbols, final ApiCallback<CryptoLatestBarsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoLatestBarsValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestBarsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cryptoLatestOrderbooks
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestOrderbooksCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/latest/orderbooks"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoLatestOrderbooksValidateBeforeCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestOrderbooks(Async)");
        }

        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestOrderbooks(Async)");
        }

        return cryptoLatestOrderbooksCall(loc, symbols, _callback);

    }

    /**
     * Latest orderbook
     * The latest orderbook endpoint returns the latest bid and ask orderbook for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return CryptoLatestOrderbooksResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CryptoLatestOrderbooksResp cryptoLatestOrderbooks(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestOrderbooksResp> localVarResp = cryptoLatestOrderbooksWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    /**
     * Latest orderbook
     * The latest orderbook endpoint returns the latest bid and ask orderbook for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return ApiResponse&lt;CryptoLatestOrderbooksResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoLatestOrderbooksResp> cryptoLatestOrderbooksWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        okhttp3.Call localVarCall = cryptoLatestOrderbooksValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestOrderbooksResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest orderbook (asynchronously)
     * The latest orderbook endpoint returns the latest bid and ask orderbook for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestOrderbooksAsync(CryptoLoc loc, String symbols, final ApiCallback<CryptoLatestOrderbooksResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoLatestOrderbooksValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestOrderbooksResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cryptoLatestQuotes
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestQuotesCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/latest/quotes"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoLatestQuotesValidateBeforeCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestQuotes(Async)");
        }

        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestQuotes(Async)");
        }

        return cryptoLatestQuotesCall(loc, symbols, _callback);

    }

    /**
     * Latest quotes
     * The latest quotes endpoint returns the latest bid and ask prices for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return CryptoLatestQuotesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CryptoLatestQuotesResp cryptoLatestQuotes(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestQuotesResp> localVarResp = cryptoLatestQuotesWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    /**
     * Latest quotes
     * The latest quotes endpoint returns the latest bid and ask prices for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return ApiResponse&lt;CryptoLatestQuotesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoLatestQuotesResp> cryptoLatestQuotesWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        okhttp3.Call localVarCall = cryptoLatestQuotesValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestQuotesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest quotes (asynchronously)
     * The latest quotes endpoint returns the latest bid and ask prices for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestQuotesAsync(CryptoLoc loc, String symbols, final ApiCallback<CryptoLatestQuotesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoLatestQuotesValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestQuotesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cryptoLatestTrades
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestTradesCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/latest/trades"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoLatestTradesValidateBeforeCall(CryptoLoc loc, String symbols, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoLatestTrades(Async)");
        }

        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoLatestTrades(Async)");
        }

        return cryptoLatestTradesCall(loc, symbols, _callback);

    }

    /**
     * Latest trades
     * The latest trades endpoint returns the latest trade data for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return CryptoLatestTradesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CryptoLatestTradesResp cryptoLatestTrades(CryptoLoc loc, String symbols) throws ApiException {
        ApiResponse<CryptoLatestTradesResp> localVarResp = cryptoLatestTradesWithHttpInfo(loc, symbols);
        return localVarResp.getData();
    }

    /**
     * Latest trades
     * The latest trades endpoint returns the latest trade data for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @return ApiResponse&lt;CryptoLatestTradesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoLatestTradesResp> cryptoLatestTradesWithHttpInfo(CryptoLoc loc, String symbols) throws ApiException {
        okhttp3.Call localVarCall = cryptoLatestTradesValidateBeforeCall(loc, symbols, null);
        Type localVarReturnType = new TypeToken<CryptoLatestTradesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Latest trades (asynchronously)
     * The latest trades endpoint returns the latest trade data for the crypto symbols provided. 
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoLatestTradesAsync(CryptoLoc loc, String symbols, final ApiCallback<CryptoLatestTradesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoLatestTradesValidateBeforeCall(loc, symbols, _callback);
        Type localVarReturnType = new TypeToken<CryptoLatestTradesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cryptoQuotes
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoQuotesCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/quotes"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoQuotesValidateBeforeCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoQuotes(Async)");
        }

        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoQuotes(Async)");
        }

        return cryptoQuotesCall(loc, symbols, start, end, limit, pageToken, sort, _callback);

    }

    /**
     * Historical quotes
     * The crypto quotes API provides historical quote data for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return CryptoQuotesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CryptoQuotesResp cryptoQuotes(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<CryptoQuotesResp> localVarResp = cryptoQuotesWithHttpInfo(loc, symbols, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical quotes
     * The crypto quotes API provides historical quote data for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;CryptoQuotesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoQuotesResp> cryptoQuotesWithHttpInfo(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = cryptoQuotesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<CryptoQuotesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical quotes (asynchronously)
     * The crypto quotes API provides historical quote data for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoQuotesAsync(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback<CryptoQuotesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoQuotesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<CryptoQuotesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cryptoSnapshots
     * @param symbols Comma separated list of symbols. (required)
     * @param loc Crypto location (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoSnapshotsCall(String symbols, CryptoLoc loc, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/snapshots"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoSnapshotsValidateBeforeCall(String symbols, CryptoLoc loc, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoSnapshots(Async)");
        }

        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoSnapshots(Async)");
        }

        return cryptoSnapshotsCall(symbols, loc, _callback);

    }

    /**
     * Snapshots
     * The latest orderbook endpoint returns the latest trade, latest quote, latest minute bar, latest daily bar, and previous daily bar data for crypto symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param loc Crypto location (required)
     * @return CryptoSnapshotsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CryptoSnapshotsResp cryptoSnapshots(String symbols, CryptoLoc loc) throws ApiException {
        ApiResponse<CryptoSnapshotsResp> localVarResp = cryptoSnapshotsWithHttpInfo(symbols, loc);
        return localVarResp.getData();
    }

    /**
     * Snapshots
     * The latest orderbook endpoint returns the latest trade, latest quote, latest minute bar, latest daily bar, and previous daily bar data for crypto symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param loc Crypto location (required)
     * @return ApiResponse&lt;CryptoSnapshotsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoSnapshotsResp> cryptoSnapshotsWithHttpInfo(String symbols, CryptoLoc loc) throws ApiException {
        okhttp3.Call localVarCall = cryptoSnapshotsValidateBeforeCall(symbols, loc, null);
        Type localVarReturnType = new TypeToken<CryptoSnapshotsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Snapshots (asynchronously)
     * The latest orderbook endpoint returns the latest trade, latest quote, latest minute bar, latest daily bar, and previous daily bar data for crypto symbols. 
     * @param symbols Comma separated list of symbols. (required)
     * @param loc Crypto location (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoSnapshotsAsync(String symbols, CryptoLoc loc, final ApiCallback<CryptoSnapshotsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoSnapshotsValidateBeforeCall(symbols, loc, _callback);
        Type localVarReturnType = new TypeToken<CryptoSnapshotsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cryptoTrades
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoTradesCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta3/crypto/{loc}/trades"
            .replace("{" + "loc" + "}", localVarApiClient.escapeString(loc.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cryptoTradesValidateBeforeCall(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loc' is set
        if (loc == null) {
            throw new ApiException("Missing the required parameter 'loc' when calling cryptoTrades(Async)");
        }

        // verify the required parameter 'symbols' is set
        if (symbols == null) {
            throw new ApiException("Missing the required parameter 'symbols' when calling cryptoTrades(Async)");
        }

        return cryptoTradesCall(loc, symbols, start, end, limit, pageToken, sort, _callback);

    }

    /**
     * Historical trades
     * The crypto trades API provides historical trade data for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return CryptoTradesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CryptoTradesResp cryptoTrades(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<CryptoTradesResp> localVarResp = cryptoTradesWithHttpInfo(loc, symbols, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Historical trades
     * The crypto trades API provides historical trade data for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;CryptoTradesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CryptoTradesResp> cryptoTradesWithHttpInfo(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = cryptoTradesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<CryptoTradesResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Historical trades (asynchronously)
     * The crypto trades API provides historical trade data for a list of crypto symbols between the specified dates.
     * @param loc Crypto location (required)
     * @param symbols Comma separated list of symbols. (required)
     * @param start The inclusive start of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the beginning of the current day.  (optional)
     * @param end The inclusive end of the interval. Format: RFC-3339 or YYYY-MM-DD. If missing, the default value is the current time.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call cryptoTradesAsync(CryptoLoc loc, String symbols, OffsetDateTime start, OffsetDateTime end, Long limit, String pageToken, Sort sort, final ApiCallback<CryptoTradesResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = cryptoTradesValidateBeforeCall(loc, symbols, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<CryptoTradesResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
