/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.api;

import net.jacobpeterson.alpaca.openapi.marketdata.ApiCallback;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiException;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiResponse;
import net.jacobpeterson.alpaca.openapi.marketdata.Configuration;
import net.jacobpeterson.alpaca.openapi.marketdata.Pair;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.marketdata.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.marketdata.model.CACorporateActionsResp;
import java.time.LocalDate;
import net.jacobpeterson.alpaca.openapi.marketdata.model.Sort;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorporateActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CorporateActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporateActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for corporateActions
     * @param symbols Comma separated list of symbols. (optional)
     * @param types Comma separated list of types. If not provided, all  The following types are supported:   - reverse_split   - forward_split   - unit_split   - cash_dividend   - stock_dividend   - spin_off   - cash_merger   - stock_merger   - stock_and_cash_merger   - redemption   - name_change   - worthless_removal  (optional)
     * @param start The inclusive start of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param end The inclusive end of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call corporateActionsCall(String symbols, String types, LocalDate start, LocalDate end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/corporate-actions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (types != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("types", types));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "apiKey", "apiSecret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call corporateActionsValidateBeforeCall(String symbols, String types, LocalDate start, LocalDate end, Long limit, String pageToken, Sort sort, final ApiCallback _callback) throws ApiException {
        return corporateActionsCall(symbols, types, start, end, limit, pageToken, sort, _callback);

    }

    /**
     * Corporate actions
     * This endpoint provides data about the corporate actions for each given symbol over a specified time period. 
     * @param symbols Comma separated list of symbols. (optional)
     * @param types Comma separated list of types. If not provided, all  The following types are supported:   - reverse_split   - forward_split   - unit_split   - cash_dividend   - stock_dividend   - spin_off   - cash_merger   - stock_merger   - stock_and_cash_merger   - redemption   - name_change   - worthless_removal  (optional)
     * @param start The inclusive start of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param end The inclusive end of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return CACorporateActionsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    public CACorporateActionsResp corporateActions(String symbols, String types, LocalDate start, LocalDate end, Long limit, String pageToken, Sort sort) throws ApiException {
        ApiResponse<CACorporateActionsResp> localVarResp = corporateActionsWithHttpInfo(symbols, types, start, end, limit, pageToken, sort);
        return localVarResp.getData();
    }

    /**
     * Corporate actions
     * This endpoint provides data about the corporate actions for each given symbol over a specified time period. 
     * @param symbols Comma separated list of symbols. (optional)
     * @param types Comma separated list of types. If not provided, all  The following types are supported:   - reverse_split   - forward_split   - unit_split   - cash_dividend   - stock_dividend   - spin_off   - cash_merger   - stock_merger   - stock_and_cash_merger   - redemption   - name_change   - worthless_removal  (optional)
     * @param start The inclusive start of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param end The inclusive end of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @return ApiResponse&lt;CACorporateActionsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected ApiResponse<CACorporateActionsResp> corporateActionsWithHttpInfo(String symbols, String types, LocalDate start, LocalDate end, Long limit, String pageToken, Sort sort) throws ApiException {
        okhttp3.Call localVarCall = corporateActionsValidateBeforeCall(symbols, types, start, end, limit, pageToken, sort, null);
        Type localVarReturnType = new TypeToken<CACorporateActionsResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Corporate actions (asynchronously)
     * This endpoint provides data about the corporate actions for each given symbol over a specified time period. 
     * @param symbols Comma separated list of symbols. (optional)
     * @param types Comma separated list of types. If not provided, all  The following types are supported:   - reverse_split   - forward_split   - unit_split   - cash_dividend   - stock_dividend   - spin_off   - cash_merger   - stock_merger   - stock_and_cash_merger   - redemption   - name_change   - worthless_removal  (optional)
     * @param start The inclusive start of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param end The inclusive end of the interval. Format: YYYY-MM-DD. If missing, the default value is the current day.  (optional)
     * @param limit Number of maximum data points to return in a response. The limit applies to the total number of data points, not per symbol! You can use the &#x60;next_page_token&#x60; to fetch the next at most &#x60;limit&#x60; responses.  (optional, default to 1000)
     * @param pageToken Pagination token to continue from. The value to pass here is returned in specific requests when more data is available than the request limit allows. (optional)
     * @param sort Sort data in ascending or descending order. (optional, default to asc)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * X-RateLimit-Limit -  <br>  * X-RateLimit-Remaining -  <br>  * X-RateLimit-Reset -  <br>  </td></tr>
     </table>
     */
    protected okhttp3.Call corporateActionsAsync(String symbols, String types, LocalDate start, LocalDate end, Long limit, String pageToken, Sort sort, final ApiCallback<CACorporateActionsResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = corporateActionsValidateBeforeCall(symbols, types, start, end, limit, pageToken, sort, _callback);
        Type localVarReturnType = new TypeToken<CACorporateActionsResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
