/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonElement;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;

import okio.ByteString;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.HashMap;
import java.util.TimeZone;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private static LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    private static final StdDateFormat sdf = new StdDateFormat()
        .withTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()))
        .withColonInTimeZone(true);
    private static final DateTimeFormatter dtf = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    static {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CACashDividend.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CACashMerger.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CACorporateActions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CACorporateActionsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CAForwardSplit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CANameChange.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CARedemption.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CAReverseSplit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CASpinOff.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockAndCashMerger.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockDividend.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CAStockMerger.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CAUnitSplit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CAWorthlessRemoval.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoBar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestOrderbooksResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoLatestTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoOrderbook.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoOrderbookEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoQuote.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoSnapshot.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoSnapshotsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoTrade.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.ForexLatestRatesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.ForexRate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.ForexRatesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.News.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.NewsImage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.NewsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionBar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionLatestTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionQuote.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionSnapshot.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionSnapshotsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionTrade.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.OptionTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMostActive.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMostActivesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMover.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMoversResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuctionsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockBar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockBarsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockDailyAuctions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestBarsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestQuotesRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockLatestTradesRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuote.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuotesRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshot.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockSnapshotsRespSingle.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockTrade.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesResp.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.marketdata.model.StockTradesRespSingle.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
                    return byteString.toByteArray();
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length()-5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public static class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(sdf.parse(date).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, DateTimeFormatter will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toInstant().atOffset(ZoneOffset.UTC).format(dtf);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return sdf.parse(date);
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
