/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * W-8BEN documents model.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class W8benDocument {
  public static final String SERIALIZED_NAME_ADDITIONAL_CONDITIONS = "additional_conditions";
  @SerializedName(SERIALIZED_NAME_ADDITIONAL_CONDITIONS)
  private String additionalConditions;

  public static final String SERIALIZED_NAME_COUNTRY_CITIZEN = "country_citizen";
  @SerializedName(SERIALIZED_NAME_COUNTRY_CITIZEN)
  private String countryCitizen;

  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
  @SerializedName(SERIALIZED_NAME_DATE_OF_BIRTH)
  private LocalDate dateOfBirth;

  public static final String SERIALIZED_NAME_FOREIGN_TAX_ID = "foreign_tax_id";
  @SerializedName(SERIALIZED_NAME_FOREIGN_TAX_ID)
  private String foreignTaxId;

  public static final String SERIALIZED_NAME_FTIN_NOT_REQUIRED = "ftin_not_required";
  @SerializedName(SERIALIZED_NAME_FTIN_NOT_REQUIRED)
  private Boolean ftinNotRequired;

  public static final String SERIALIZED_NAME_FULL_NAME = "full_name";
  @SerializedName(SERIALIZED_NAME_FULL_NAME)
  private String fullName;

  public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
  @SerializedName(SERIALIZED_NAME_IP_ADDRESS)
  private String ipAddress;

  public static final String SERIALIZED_NAME_MAILING_ADDRESS_CITY_STATE = "mailing_address_city_state";
  @SerializedName(SERIALIZED_NAME_MAILING_ADDRESS_CITY_STATE)
  private String mailingAddressCityState;

  public static final String SERIALIZED_NAME_MAILING_ADDRESS_COUNTRY = "mailing_address_country";
  @SerializedName(SERIALIZED_NAME_MAILING_ADDRESS_COUNTRY)
  private String mailingAddressCountry;

  public static final String SERIALIZED_NAME_MAILING_ADDRESS_STREET = "mailing_address_street";
  @SerializedName(SERIALIZED_NAME_MAILING_ADDRESS_STREET)
  private String mailingAddressStreet;

  public static final String SERIALIZED_NAME_PARAGRAPH_NUMBER = "paragraph_number";
  @SerializedName(SERIALIZED_NAME_PARAGRAPH_NUMBER)
  private String paragraphNumber;

  public static final String SERIALIZED_NAME_PERCENT_RATE_WITHHOLDING = "percent_rate_withholding";
  @SerializedName(SERIALIZED_NAME_PERCENT_RATE_WITHHOLDING)
  private Integer percentRateWithholding;

  public static final String SERIALIZED_NAME_PERMANENT_ADDRESS_CITY_STATE = "permanent_address_city_state";
  @SerializedName(SERIALIZED_NAME_PERMANENT_ADDRESS_CITY_STATE)
  private String permanentAddressCityState;

  public static final String SERIALIZED_NAME_PERMANENT_ADDRESS_COUNTRY = "permanent_address_country";
  @SerializedName(SERIALIZED_NAME_PERMANENT_ADDRESS_COUNTRY)
  private String permanentAddressCountry;

  public static final String SERIALIZED_NAME_PERMANENT_ADDRESS_STREET = "permanent_address_street";
  @SerializedName(SERIALIZED_NAME_PERMANENT_ADDRESS_STREET)
  private String permanentAddressStreet;

  public static final String SERIALIZED_NAME_REFERENCE_NUMBER = "reference_number";
  @SerializedName(SERIALIZED_NAME_REFERENCE_NUMBER)
  private String referenceNumber;

  public static final String SERIALIZED_NAME_RESIDENCY = "residency";
  @SerializedName(SERIALIZED_NAME_RESIDENCY)
  private String residency;

  public static final String SERIALIZED_NAME_REVISION = "revision";
  @SerializedName(SERIALIZED_NAME_REVISION)
  private String revision;

  public static final String SERIALIZED_NAME_TAX_ID_SSN = "tax_id_ssn";
  @SerializedName(SERIALIZED_NAME_TAX_ID_SSN)
  private String taxIdSsn;

  public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
  @SerializedName(SERIALIZED_NAME_TIMESTAMP)
  private String timestamp;

  public static final String SERIALIZED_NAME_INCOME_TYPE = "income_type";
  @SerializedName(SERIALIZED_NAME_INCOME_TYPE)
  private String incomeType;

  public static final String SERIALIZED_NAME_SIGNER_FULL_NAME = "signer_full_name";
  @SerializedName(SERIALIZED_NAME_SIGNER_FULL_NAME)
  private String signerFullName;

  public W8benDocument() {
  }

  public W8benDocument additionalConditions(String additionalConditions) {
    this.additionalConditions = additionalConditions;
    return this;
  }

   /**
   * Any additional conditions to specify
   * @return additionalConditions
  **/
  @javax.annotation.Nullable
  public String getAdditionalConditions() {
    return additionalConditions;
  }

  public void setAdditionalConditions(String additionalConditions) {
    this.additionalConditions = additionalConditions;
  }


  public W8benDocument countryCitizen(String countryCitizen) {
    this.countryCitizen = countryCitizen;
    return this;
  }

   /**
   * The country that the applicant is a citizen of
   * @return countryCitizen
  **/
  @javax.annotation.Nonnull
  public String getCountryCitizen() {
    return countryCitizen;
  }

  public void setCountryCitizen(String countryCitizen) {
    this.countryCitizen = countryCitizen;
  }


  public W8benDocument date(LocalDate date) {
    this.date = date;
    return this;
  }

   /**
   * date signed
   * @return date
  **/
  @javax.annotation.Nonnull
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }


  public W8benDocument dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * date of birth of applicant
   * @return dateOfBirth
  **/
  @javax.annotation.Nonnull
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public W8benDocument foreignTaxId(String foreignTaxId) {
    this.foreignTaxId = foreignTaxId;
    return this;
  }

   /**
   * Applicant&#39;s tax id in their home country
   * @return foreignTaxId
  **/
  @javax.annotation.Nullable
  public String getForeignTaxId() {
    return foreignTaxId;
  }

  public void setForeignTaxId(String foreignTaxId) {
    this.foreignTaxId = foreignTaxId;
  }


  public W8benDocument ftinNotRequired(Boolean ftinNotRequired) {
    this.ftinNotRequired = ftinNotRequired;
    return this;
  }

   /**
   * Required if foreign_tax_id and tax_id_ssn are empty.
   * @return ftinNotRequired
  **/
  @javax.annotation.Nullable
  public Boolean getFtinNotRequired() {
    return ftinNotRequired;
  }

  public void setFtinNotRequired(Boolean ftinNotRequired) {
    this.ftinNotRequired = ftinNotRequired;
  }


  public W8benDocument fullName(String fullName) {
    this.fullName = fullName;
    return this;
  }

   /**
   * Full name of applicant
   * @return fullName
  **/
  @javax.annotation.Nonnull
  public String getFullName() {
    return fullName;
  }

  public void setFullName(String fullName) {
    this.fullName = fullName;
  }


  public W8benDocument ipAddress(String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * IP address of applicant when signed
   * @return ipAddress
  **/
  @javax.annotation.Nonnull
  public String getIpAddress() {
    return ipAddress;
  }

  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public W8benDocument mailingAddressCityState(String mailingAddressCityState) {
    this.mailingAddressCityState = mailingAddressCityState;
    return this;
  }

   /**
   * Mailing city/state of applicant
   * @return mailingAddressCityState
  **/
  @javax.annotation.Nullable
  public String getMailingAddressCityState() {
    return mailingAddressCityState;
  }

  public void setMailingAddressCityState(String mailingAddressCityState) {
    this.mailingAddressCityState = mailingAddressCityState;
  }


  public W8benDocument mailingAddressCountry(String mailingAddressCountry) {
    this.mailingAddressCountry = mailingAddressCountry;
    return this;
  }

   /**
   * Mailing country for applicant
   * @return mailingAddressCountry
  **/
  @javax.annotation.Nullable
  public String getMailingAddressCountry() {
    return mailingAddressCountry;
  }

  public void setMailingAddressCountry(String mailingAddressCountry) {
    this.mailingAddressCountry = mailingAddressCountry;
  }


  public W8benDocument mailingAddressStreet(String mailingAddressStreet) {
    this.mailingAddressStreet = mailingAddressStreet;
    return this;
  }

   /**
   * Mailing street address for applicant
   * @return mailingAddressStreet
  **/
  @javax.annotation.Nullable
  public String getMailingAddressStreet() {
    return mailingAddressStreet;
  }

  public void setMailingAddressStreet(String mailingAddressStreet) {
    this.mailingAddressStreet = mailingAddressStreet;
  }


  public W8benDocument paragraphNumber(String paragraphNumber) {
    this.paragraphNumber = paragraphNumber;
    return this;
  }

   /**
   * Get paragraphNumber
   * @return paragraphNumber
  **/
  @javax.annotation.Nullable
  public String getParagraphNumber() {
    return paragraphNumber;
  }

  public void setParagraphNumber(String paragraphNumber) {
    this.paragraphNumber = paragraphNumber;
  }


  public W8benDocument percentRateWithholding(Integer percentRateWithholding) {
    this.percentRateWithholding = percentRateWithholding;
    return this;
  }

   /**
   * Get percentRateWithholding
   * @return percentRateWithholding
  **/
  @javax.annotation.Nullable
  public Integer getPercentRateWithholding() {
    return percentRateWithholding;
  }

  public void setPercentRateWithholding(Integer percentRateWithholding) {
    this.percentRateWithholding = percentRateWithholding;
  }


  public W8benDocument permanentAddressCityState(String permanentAddressCityState) {
    this.permanentAddressCityState = permanentAddressCityState;
    return this;
  }

   /**
   * Permanent city/state of applicant
   * @return permanentAddressCityState
  **/
  @javax.annotation.Nonnull
  public String getPermanentAddressCityState() {
    return permanentAddressCityState;
  }

  public void setPermanentAddressCityState(String permanentAddressCityState) {
    this.permanentAddressCityState = permanentAddressCityState;
  }


  public W8benDocument permanentAddressCountry(String permanentAddressCountry) {
    this.permanentAddressCountry = permanentAddressCountry;
    return this;
  }

   /**
   * Permanent country of residence of applicant
   * @return permanentAddressCountry
  **/
  @javax.annotation.Nonnull
  public String getPermanentAddressCountry() {
    return permanentAddressCountry;
  }

  public void setPermanentAddressCountry(String permanentAddressCountry) {
    this.permanentAddressCountry = permanentAddressCountry;
  }


  public W8benDocument permanentAddressStreet(String permanentAddressStreet) {
    this.permanentAddressStreet = permanentAddressStreet;
    return this;
  }

   /**
   * Permanent street address of applicant
   * @return permanentAddressStreet
  **/
  @javax.annotation.Nonnull
  public String getPermanentAddressStreet() {
    return permanentAddressStreet;
  }

  public void setPermanentAddressStreet(String permanentAddressStreet) {
    this.permanentAddressStreet = permanentAddressStreet;
  }


  public W8benDocument referenceNumber(String referenceNumber) {
    this.referenceNumber = referenceNumber;
    return this;
  }

   /**
   * Get referenceNumber
   * @return referenceNumber
  **/
  @javax.annotation.Nullable
  public String getReferenceNumber() {
    return referenceNumber;
  }

  public void setReferenceNumber(String referenceNumber) {
    this.referenceNumber = referenceNumber;
  }


  public W8benDocument residency(String residency) {
    this.residency = residency;
    return this;
  }

   /**
   * Country of residency of applicant
   * @return residency
  **/
  @javax.annotation.Nullable
  public String getResidency() {
    return residency;
  }

  public void setResidency(String residency) {
    this.residency = residency;
  }


  public W8benDocument revision(String revision) {
    this.revision = revision;
    return this;
  }

   /**
   * Revision of the W8BEN form
   * @return revision
  **/
  @javax.annotation.Nonnull
  public String getRevision() {
    return revision;
  }

  public void setRevision(String revision) {
    this.revision = revision;
  }


  public W8benDocument taxIdSsn(String taxIdSsn) {
    this.taxIdSsn = taxIdSsn;
    return this;
  }

   /**
   * TaxID/SSN of applicant
   * @return taxIdSsn
  **/
  @javax.annotation.Nullable
  public String getTaxIdSsn() {
    return taxIdSsn;
  }

  public void setTaxIdSsn(String taxIdSsn) {
    this.taxIdSsn = taxIdSsn;
  }


  public W8benDocument timestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Timestamp when form data was gathered
   * @return timestamp
  **/
  @javax.annotation.Nonnull
  public String getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(String timestamp) {
    this.timestamp = timestamp;
  }


  public W8benDocument incomeType(String incomeType) {
    this.incomeType = incomeType;
    return this;
  }

   /**
   * Income type of applicant
   * @return incomeType
  **/
  @javax.annotation.Nullable
  public String getIncomeType() {
    return incomeType;
  }

  public void setIncomeType(String incomeType) {
    this.incomeType = incomeType;
  }


  public W8benDocument signerFullName(String signerFullName) {
    this.signerFullName = signerFullName;
    return this;
  }

   /**
   * Full name of signing user
   * @return signerFullName
  **/
  @javax.annotation.Nonnull
  public String getSignerFullName() {
    return signerFullName;
  }

  public void setSignerFullName(String signerFullName) {
    this.signerFullName = signerFullName;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    W8benDocument w8benDocument = (W8benDocument) o;
    return Objects.equals(this.additionalConditions, w8benDocument.additionalConditions) &&
        Objects.equals(this.countryCitizen, w8benDocument.countryCitizen) &&
        Objects.equals(this.date, w8benDocument.date) &&
        Objects.equals(this.dateOfBirth, w8benDocument.dateOfBirth) &&
        Objects.equals(this.foreignTaxId, w8benDocument.foreignTaxId) &&
        Objects.equals(this.ftinNotRequired, w8benDocument.ftinNotRequired) &&
        Objects.equals(this.fullName, w8benDocument.fullName) &&
        Objects.equals(this.ipAddress, w8benDocument.ipAddress) &&
        Objects.equals(this.mailingAddressCityState, w8benDocument.mailingAddressCityState) &&
        Objects.equals(this.mailingAddressCountry, w8benDocument.mailingAddressCountry) &&
        Objects.equals(this.mailingAddressStreet, w8benDocument.mailingAddressStreet) &&
        Objects.equals(this.paragraphNumber, w8benDocument.paragraphNumber) &&
        Objects.equals(this.percentRateWithholding, w8benDocument.percentRateWithholding) &&
        Objects.equals(this.permanentAddressCityState, w8benDocument.permanentAddressCityState) &&
        Objects.equals(this.permanentAddressCountry, w8benDocument.permanentAddressCountry) &&
        Objects.equals(this.permanentAddressStreet, w8benDocument.permanentAddressStreet) &&
        Objects.equals(this.referenceNumber, w8benDocument.referenceNumber) &&
        Objects.equals(this.residency, w8benDocument.residency) &&
        Objects.equals(this.revision, w8benDocument.revision) &&
        Objects.equals(this.taxIdSsn, w8benDocument.taxIdSsn) &&
        Objects.equals(this.timestamp, w8benDocument.timestamp) &&
        Objects.equals(this.incomeType, w8benDocument.incomeType) &&
        Objects.equals(this.signerFullName, w8benDocument.signerFullName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalConditions, countryCitizen, date, dateOfBirth, foreignTaxId, ftinNotRequired, fullName, ipAddress, mailingAddressCityState, mailingAddressCountry, mailingAddressStreet, paragraphNumber, percentRateWithholding, permanentAddressCityState, permanentAddressCountry, permanentAddressStreet, referenceNumber, residency, revision, taxIdSsn, timestamp, incomeType, signerFullName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class W8benDocument {\n");
    sb.append("    additionalConditions: ").append(toIndentedString(additionalConditions)).append("\n");
    sb.append("    countryCitizen: ").append(toIndentedString(countryCitizen)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    foreignTaxId: ").append(toIndentedString(foreignTaxId)).append("\n");
    sb.append("    ftinNotRequired: ").append(toIndentedString(ftinNotRequired)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    mailingAddressCityState: ").append(toIndentedString(mailingAddressCityState)).append("\n");
    sb.append("    mailingAddressCountry: ").append(toIndentedString(mailingAddressCountry)).append("\n");
    sb.append("    mailingAddressStreet: ").append(toIndentedString(mailingAddressStreet)).append("\n");
    sb.append("    paragraphNumber: ").append(toIndentedString(paragraphNumber)).append("\n");
    sb.append("    percentRateWithholding: ").append(toIndentedString(percentRateWithholding)).append("\n");
    sb.append("    permanentAddressCityState: ").append(toIndentedString(permanentAddressCityState)).append("\n");
    sb.append("    permanentAddressCountry: ").append(toIndentedString(permanentAddressCountry)).append("\n");
    sb.append("    permanentAddressStreet: ").append(toIndentedString(permanentAddressStreet)).append("\n");
    sb.append("    referenceNumber: ").append(toIndentedString(referenceNumber)).append("\n");
    sb.append("    residency: ").append(toIndentedString(residency)).append("\n");
    sb.append("    revision: ").append(toIndentedString(revision)).append("\n");
    sb.append("    taxIdSsn: ").append(toIndentedString(taxIdSsn)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    incomeType: ").append(toIndentedString(incomeType)).append("\n");
    sb.append("    signerFullName: ").append(toIndentedString(signerFullName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("additional_conditions");
    openapiFields.add("country_citizen");
    openapiFields.add("date");
    openapiFields.add("date_of_birth");
    openapiFields.add("foreign_tax_id");
    openapiFields.add("ftin_not_required");
    openapiFields.add("full_name");
    openapiFields.add("ip_address");
    openapiFields.add("mailing_address_city_state");
    openapiFields.add("mailing_address_country");
    openapiFields.add("mailing_address_street");
    openapiFields.add("paragraph_number");
    openapiFields.add("percent_rate_withholding");
    openapiFields.add("permanent_address_city_state");
    openapiFields.add("permanent_address_country");
    openapiFields.add("permanent_address_street");
    openapiFields.add("reference_number");
    openapiFields.add("residency");
    openapiFields.add("revision");
    openapiFields.add("tax_id_ssn");
    openapiFields.add("timestamp");
    openapiFields.add("income_type");
    openapiFields.add("signer_full_name");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("country_citizen");
    openapiRequiredFields.add("date");
    openapiRequiredFields.add("date_of_birth");
    openapiRequiredFields.add("full_name");
    openapiRequiredFields.add("ip_address");
    openapiRequiredFields.add("permanent_address_city_state");
    openapiRequiredFields.add("permanent_address_country");
    openapiRequiredFields.add("permanent_address_street");
    openapiRequiredFields.add("revision");
    openapiRequiredFields.add("timestamp");
    openapiRequiredFields.add("signer_full_name");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!W8benDocument.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in W8benDocument is not found in the empty JSON string", W8benDocument.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!W8benDocument.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `W8benDocument` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : W8benDocument.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("additional_conditions") != null && !jsonObj.get("additional_conditions").isJsonNull()) && !jsonObj.get("additional_conditions").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `additional_conditions` to be a primitive type in the JSON string but got `%s`", jsonObj.get("additional_conditions").toString()));
      }
      if (!jsonObj.get("country_citizen").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country_citizen` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country_citizen").toString()));
      }
      if ((jsonObj.get("foreign_tax_id") != null && !jsonObj.get("foreign_tax_id").isJsonNull()) && !jsonObj.get("foreign_tax_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `foreign_tax_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("foreign_tax_id").toString()));
      }
      if (!jsonObj.get("full_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `full_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("full_name").toString()));
      }
      if (!jsonObj.get("ip_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ip_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ip_address").toString()));
      }
      if ((jsonObj.get("mailing_address_city_state") != null && !jsonObj.get("mailing_address_city_state").isJsonNull()) && !jsonObj.get("mailing_address_city_state").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `mailing_address_city_state` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mailing_address_city_state").toString()));
      }
      if ((jsonObj.get("mailing_address_country") != null && !jsonObj.get("mailing_address_country").isJsonNull()) && !jsonObj.get("mailing_address_country").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `mailing_address_country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mailing_address_country").toString()));
      }
      if ((jsonObj.get("mailing_address_street") != null && !jsonObj.get("mailing_address_street").isJsonNull()) && !jsonObj.get("mailing_address_street").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `mailing_address_street` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mailing_address_street").toString()));
      }
      if ((jsonObj.get("paragraph_number") != null && !jsonObj.get("paragraph_number").isJsonNull()) && !jsonObj.get("paragraph_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `paragraph_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paragraph_number").toString()));
      }
      if (!jsonObj.get("permanent_address_city_state").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `permanent_address_city_state` to be a primitive type in the JSON string but got `%s`", jsonObj.get("permanent_address_city_state").toString()));
      }
      if (!jsonObj.get("permanent_address_country").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `permanent_address_country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("permanent_address_country").toString()));
      }
      if (!jsonObj.get("permanent_address_street").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `permanent_address_street` to be a primitive type in the JSON string but got `%s`", jsonObj.get("permanent_address_street").toString()));
      }
      if ((jsonObj.get("reference_number") != null && !jsonObj.get("reference_number").isJsonNull()) && !jsonObj.get("reference_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reference_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference_number").toString()));
      }
      if ((jsonObj.get("residency") != null && !jsonObj.get("residency").isJsonNull()) && !jsonObj.get("residency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `residency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("residency").toString()));
      }
      if (!jsonObj.get("revision").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `revision` to be a primitive type in the JSON string but got `%s`", jsonObj.get("revision").toString()));
      }
      if ((jsonObj.get("tax_id_ssn") != null && !jsonObj.get("tax_id_ssn").isJsonNull()) && !jsonObj.get("tax_id_ssn").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `tax_id_ssn` to be a primitive type in the JSON string but got `%s`", jsonObj.get("tax_id_ssn").toString()));
      }
      if (!jsonObj.get("timestamp").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `timestamp` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timestamp").toString()));
      }
      if ((jsonObj.get("income_type") != null && !jsonObj.get("income_type").isJsonNull()) && !jsonObj.get("income_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `income_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("income_type").toString()));
      }
      if (!jsonObj.get("signer_full_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `signer_full_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("signer_full_name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!W8benDocument.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'W8benDocument' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<W8benDocument> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(W8benDocument.class));

       return (TypeAdapter<T>) new TypeAdapter<W8benDocument>() {
           @Override
           public void write(JsonWriter out, W8benDocument value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public W8benDocument read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of W8benDocument given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of W8benDocument
  * @throws IOException if the JSON string is invalid with respect to W8benDocument
  */
  public static W8benDocument fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, W8benDocument.class);
  }

 /**
  * Convert an instance of W8benDocument to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

