/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.TimeInForce;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents the fields that are editable in an order replace/update call.  Note: client_order_id is currently not editable on its own, one of the other fields must be changed at the same time to effectively replace the order
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class UpdateOrderRequest {
  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private BigDecimal qty;

  public static final String SERIALIZED_NAME_TIME_IN_FORCE = "time_in_force";
  @SerializedName(SERIALIZED_NAME_TIME_IN_FORCE)
  private TimeInForce timeInForce;

  public static final String SERIALIZED_NAME_LIMIT_PRICE = "limit_price";
  @SerializedName(SERIALIZED_NAME_LIMIT_PRICE)
  private BigDecimal limitPrice;

  public static final String SERIALIZED_NAME_STOP_PRICE = "stop_price";
  @SerializedName(SERIALIZED_NAME_STOP_PRICE)
  private BigDecimal stopPrice;

  public static final String SERIALIZED_NAME_TRAIL = "trail";
  @SerializedName(SERIALIZED_NAME_TRAIL)
  private BigDecimal trail;

  public static final String SERIALIZED_NAME_CLIENT_ORDER_ID = "client_order_id";
  @SerializedName(SERIALIZED_NAME_CLIENT_ORDER_ID)
  private String clientOrderId;

  public UpdateOrderRequest() {
  }

  public UpdateOrderRequest qty(BigDecimal qty) {
    this.qty = qty;
    return this;
  }

   /**
   * You can only patch full shares for now
   * @return qty
  **/
  @javax.annotation.Nullable
  public BigDecimal getQty() {
    return qty;
  }

  public void setQty(BigDecimal qty) {
    this.qty = qty;
  }


  public UpdateOrderRequest timeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
    return this;
  }

   /**
   * Get timeInForce
   * @return timeInForce
  **/
  @javax.annotation.Nullable
  public TimeInForce getTimeInForce() {
    return timeInForce;
  }

  public void setTimeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
  }


  public UpdateOrderRequest limitPrice(BigDecimal limitPrice) {
    this.limitPrice = limitPrice;
    return this;
  }

   /**
   * Required if original order&#39;s &#x60;type&#x60; field was limit or stop_limit
   * @return limitPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getLimitPrice() {
    return limitPrice;
  }

  public void setLimitPrice(BigDecimal limitPrice) {
    this.limitPrice = limitPrice;
  }


  public UpdateOrderRequest stopPrice(BigDecimal stopPrice) {
    this.stopPrice = stopPrice;
    return this;
  }

   /**
   * Required if original order&#39;s &#x60;type&#x60; field was stop or stop_limit
   * @return stopPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getStopPrice() {
    return stopPrice;
  }

  public void setStopPrice(BigDecimal stopPrice) {
    this.stopPrice = stopPrice;
  }


  public UpdateOrderRequest trail(BigDecimal trail) {
    this.trail = trail;
    return this;
  }

   /**
   * The new value of the trail_price or trail_percent
   * @return trail
  **/
  @javax.annotation.Nullable
  public BigDecimal getTrail() {
    return trail;
  }

  public void setTrail(BigDecimal trail) {
    this.trail = trail;
  }


  public UpdateOrderRequest clientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
    return this;
  }

   /**
   * Get clientOrderId
   * @return clientOrderId
  **/
  @javax.annotation.Nullable
  public String getClientOrderId() {
    return clientOrderId;
  }

  public void setClientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateOrderRequest updateOrderRequest = (UpdateOrderRequest) o;
    return Objects.equals(this.qty, updateOrderRequest.qty) &&
        Objects.equals(this.timeInForce, updateOrderRequest.timeInForce) &&
        Objects.equals(this.limitPrice, updateOrderRequest.limitPrice) &&
        Objects.equals(this.stopPrice, updateOrderRequest.stopPrice) &&
        Objects.equals(this.trail, updateOrderRequest.trail) &&
        Objects.equals(this.clientOrderId, updateOrderRequest.clientOrderId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(qty, timeInForce, limitPrice, stopPrice, trail, clientOrderId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateOrderRequest {\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    timeInForce: ").append(toIndentedString(timeInForce)).append("\n");
    sb.append("    limitPrice: ").append(toIndentedString(limitPrice)).append("\n");
    sb.append("    stopPrice: ").append(toIndentedString(stopPrice)).append("\n");
    sb.append("    trail: ").append(toIndentedString(trail)).append("\n");
    sb.append("    clientOrderId: ").append(toIndentedString(clientOrderId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("qty");
    openapiFields.add("time_in_force");
    openapiFields.add("limit_price");
    openapiFields.add("stop_price");
    openapiFields.add("trail");
    openapiFields.add("client_order_id");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!UpdateOrderRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in UpdateOrderRequest is not found in the empty JSON string", UpdateOrderRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!UpdateOrderRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UpdateOrderRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      // validate the optional field `time_in_force`
      if (jsonObj.get("time_in_force") != null && !jsonObj.get("time_in_force").isJsonNull()) {
        TimeInForce.validateJsonElement(jsonObj.get("time_in_force"));
      }
      if ((jsonObj.get("limit_price") != null && !jsonObj.get("limit_price").isJsonNull()) && !jsonObj.get("limit_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `limit_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("limit_price").toString()));
      }
      if ((jsonObj.get("stop_price") != null && !jsonObj.get("stop_price").isJsonNull()) && !jsonObj.get("stop_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `stop_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("stop_price").toString()));
      }
      if ((jsonObj.get("trail") != null && !jsonObj.get("trail").isJsonNull()) && !jsonObj.get("trail").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trail` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trail").toString()));
      }
      if ((jsonObj.get("client_order_id") != null && !jsonObj.get("client_order_id").isJsonNull()) && !jsonObj.get("client_order_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_order_id").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!UpdateOrderRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'UpdateOrderRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<UpdateOrderRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(UpdateOrderRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<UpdateOrderRequest>() {
           @Override
           public void write(JsonWriter out, UpdateOrderRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public UpdateOrderRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of UpdateOrderRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of UpdateOrderRequest
  * @throws IOException if the JSON string is invalid with respect to UpdateOrderRequest
  */
  public static UpdateOrderRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, UpdateOrderRequest.class);
  }

 /**
  * Convert an instance of UpdateOrderRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

