/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Position values in USD. This is returned for LCT (non-USD) accounts only.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class USDPosition {
  public static final String SERIALIZED_NAME_AVG_ENTRY_PRICE = "avg_entry_price";
  @SerializedName(SERIALIZED_NAME_AVG_ENTRY_PRICE)
  private BigDecimal avgEntryPrice;

  public static final String SERIALIZED_NAME_MARKET_VALUE = "market_value";
  @SerializedName(SERIALIZED_NAME_MARKET_VALUE)
  private BigDecimal marketValue;

  public static final String SERIALIZED_NAME_COST_BASIS = "cost_basis";
  @SerializedName(SERIALIZED_NAME_COST_BASIS)
  private BigDecimal costBasis;

  public static final String SERIALIZED_NAME_UNREALIZED_PL = "unrealized_pl";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_PL)
  private BigDecimal unrealizedPl;

  public static final String SERIALIZED_NAME_UNREALIZED_PLPC = "unrealized_plpc";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_PLPC)
  private BigDecimal unrealizedPlpc;

  public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PL = "unrealized_intraday_pl";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_INTRADAY_PL)
  private BigDecimal unrealizedIntradayPl;

  public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC = "unrealized_intraday_plpc";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC)
  private BigDecimal unrealizedIntradayPlpc;

  public static final String SERIALIZED_NAME_CURRENT_PRICE = "current_price";
  @SerializedName(SERIALIZED_NAME_CURRENT_PRICE)
  private BigDecimal currentPrice;

  public static final String SERIALIZED_NAME_LASTDAY_PRICE = "lastday_price";
  @SerializedName(SERIALIZED_NAME_LASTDAY_PRICE)
  private BigDecimal lastdayPrice;

  public static final String SERIALIZED_NAME_CHANGE_TODAY = "change_today";
  @SerializedName(SERIALIZED_NAME_CHANGE_TODAY)
  private BigDecimal changeToday;

  public USDPosition() {
  }

  public USDPosition avgEntryPrice(BigDecimal avgEntryPrice) {
    this.avgEntryPrice = avgEntryPrice;
    return this;
  }

   /**
   * Average entry price of the position in USD
   * @return avgEntryPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getAvgEntryPrice() {
    return avgEntryPrice;
  }

  public void setAvgEntryPrice(BigDecimal avgEntryPrice) {
    this.avgEntryPrice = avgEntryPrice;
  }


  public USDPosition marketValue(BigDecimal marketValue) {
    this.marketValue = marketValue;
    return this;
  }

   /**
   * Total market value of the position in USD
   * @return marketValue
  **/
  @javax.annotation.Nullable
  public BigDecimal getMarketValue() {
    return marketValue;
  }

  public void setMarketValue(BigDecimal marketValue) {
    this.marketValue = marketValue;
  }


  public USDPosition costBasis(BigDecimal costBasis) {
    this.costBasis = costBasis;
    return this;
  }

   /**
   * Total cost basis in USD
   * @return costBasis
  **/
  @javax.annotation.Nullable
  public BigDecimal getCostBasis() {
    return costBasis;
  }

  public void setCostBasis(BigDecimal costBasis) {
    this.costBasis = costBasis;
  }


  public USDPosition unrealizedPl(BigDecimal unrealizedPl) {
    this.unrealizedPl = unrealizedPl;
    return this;
  }

   /**
   * Unrealized profit/loss in USD
   * @return unrealizedPl
  **/
  @javax.annotation.Nullable
  public BigDecimal getUnrealizedPl() {
    return unrealizedPl;
  }

  public void setUnrealizedPl(BigDecimal unrealizedPl) {
    this.unrealizedPl = unrealizedPl;
  }


  public USDPosition unrealizedPlpc(BigDecimal unrealizedPlpc) {
    this.unrealizedPlpc = unrealizedPlpc;
    return this;
  }

   /**
   * Unrealized profit/loss percent (by a factor of 1)
   * @return unrealizedPlpc
  **/
  @javax.annotation.Nullable
  public BigDecimal getUnrealizedPlpc() {
    return unrealizedPlpc;
  }

  public void setUnrealizedPlpc(BigDecimal unrealizedPlpc) {
    this.unrealizedPlpc = unrealizedPlpc;
  }


  public USDPosition unrealizedIntradayPl(BigDecimal unrealizedIntradayPl) {
    this.unrealizedIntradayPl = unrealizedIntradayPl;
    return this;
  }

   /**
   * Unrealized profit/loss in USD for the day
   * @return unrealizedIntradayPl
  **/
  @javax.annotation.Nullable
  public BigDecimal getUnrealizedIntradayPl() {
    return unrealizedIntradayPl;
  }

  public void setUnrealizedIntradayPl(BigDecimal unrealizedIntradayPl) {
    this.unrealizedIntradayPl = unrealizedIntradayPl;
  }


  public USDPosition unrealizedIntradayPlpc(BigDecimal unrealizedIntradayPlpc) {
    this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
    return this;
  }

   /**
   * Unrealized interday profit/loss percent (by a factor of 1)
   * @return unrealizedIntradayPlpc
  **/
  @javax.annotation.Nullable
  public BigDecimal getUnrealizedIntradayPlpc() {
    return unrealizedIntradayPlpc;
  }

  public void setUnrealizedIntradayPlpc(BigDecimal unrealizedIntradayPlpc) {
    this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
  }


  public USDPosition currentPrice(BigDecimal currentPrice) {
    this.currentPrice = currentPrice;
    return this;
  }

   /**
   * Current asset price per share in USD
   * @return currentPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getCurrentPrice() {
    return currentPrice;
  }

  public void setCurrentPrice(BigDecimal currentPrice) {
    this.currentPrice = currentPrice;
  }


  public USDPosition lastdayPrice(BigDecimal lastdayPrice) {
    this.lastdayPrice = lastdayPrice;
    return this;
  }

   /**
   * Last day’s asset price per share based on the closing value of the last trading day in USD
   * @return lastdayPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getLastdayPrice() {
    return lastdayPrice;
  }

  public void setLastdayPrice(BigDecimal lastdayPrice) {
    this.lastdayPrice = lastdayPrice;
  }


  public USDPosition changeToday(BigDecimal changeToday) {
    this.changeToday = changeToday;
    return this;
  }

   /**
   * Percent change from last day price (by a factor of 1)
   * @return changeToday
  **/
  @javax.annotation.Nullable
  public BigDecimal getChangeToday() {
    return changeToday;
  }

  public void setChangeToday(BigDecimal changeToday) {
    this.changeToday = changeToday;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    USDPosition usDPosition = (USDPosition) o;
    return Objects.equals(this.avgEntryPrice, usDPosition.avgEntryPrice) &&
        Objects.equals(this.marketValue, usDPosition.marketValue) &&
        Objects.equals(this.costBasis, usDPosition.costBasis) &&
        Objects.equals(this.unrealizedPl, usDPosition.unrealizedPl) &&
        Objects.equals(this.unrealizedPlpc, usDPosition.unrealizedPlpc) &&
        Objects.equals(this.unrealizedIntradayPl, usDPosition.unrealizedIntradayPl) &&
        Objects.equals(this.unrealizedIntradayPlpc, usDPosition.unrealizedIntradayPlpc) &&
        Objects.equals(this.currentPrice, usDPosition.currentPrice) &&
        Objects.equals(this.lastdayPrice, usDPosition.lastdayPrice) &&
        Objects.equals(this.changeToday, usDPosition.changeToday);
  }

  @Override
  public int hashCode() {
    return Objects.hash(avgEntryPrice, marketValue, costBasis, unrealizedPl, unrealizedPlpc, unrealizedIntradayPl, unrealizedIntradayPlpc, currentPrice, lastdayPrice, changeToday);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class USDPosition {\n");
    sb.append("    avgEntryPrice: ").append(toIndentedString(avgEntryPrice)).append("\n");
    sb.append("    marketValue: ").append(toIndentedString(marketValue)).append("\n");
    sb.append("    costBasis: ").append(toIndentedString(costBasis)).append("\n");
    sb.append("    unrealizedPl: ").append(toIndentedString(unrealizedPl)).append("\n");
    sb.append("    unrealizedPlpc: ").append(toIndentedString(unrealizedPlpc)).append("\n");
    sb.append("    unrealizedIntradayPl: ").append(toIndentedString(unrealizedIntradayPl)).append("\n");
    sb.append("    unrealizedIntradayPlpc: ").append(toIndentedString(unrealizedIntradayPlpc)).append("\n");
    sb.append("    currentPrice: ").append(toIndentedString(currentPrice)).append("\n");
    sb.append("    lastdayPrice: ").append(toIndentedString(lastdayPrice)).append("\n");
    sb.append("    changeToday: ").append(toIndentedString(changeToday)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("avg_entry_price");
    openapiFields.add("market_value");
    openapiFields.add("cost_basis");
    openapiFields.add("unrealized_pl");
    openapiFields.add("unrealized_plpc");
    openapiFields.add("unrealized_intraday_pl");
    openapiFields.add("unrealized_intraday_plpc");
    openapiFields.add("current_price");
    openapiFields.add("lastday_price");
    openapiFields.add("change_today");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!USDPosition.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in USDPosition is not found in the empty JSON string", USDPosition.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!USDPosition.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `USDPosition` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("avg_entry_price") != null && !jsonObj.get("avg_entry_price").isJsonNull()) && !jsonObj.get("avg_entry_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `avg_entry_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("avg_entry_price").toString()));
      }
      if ((jsonObj.get("market_value") != null && !jsonObj.get("market_value").isJsonNull()) && !jsonObj.get("market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("market_value").toString()));
      }
      if ((jsonObj.get("cost_basis") != null && !jsonObj.get("cost_basis").isJsonNull()) && !jsonObj.get("cost_basis").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cost_basis` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cost_basis").toString()));
      }
      if ((jsonObj.get("unrealized_pl") != null && !jsonObj.get("unrealized_pl").isJsonNull()) && !jsonObj.get("unrealized_pl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_pl").toString()));
      }
      if ((jsonObj.get("unrealized_plpc") != null && !jsonObj.get("unrealized_plpc").isJsonNull()) && !jsonObj.get("unrealized_plpc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_plpc").toString()));
      }
      if ((jsonObj.get("unrealized_intraday_pl") != null && !jsonObj.get("unrealized_intraday_pl").isJsonNull()) && !jsonObj.get("unrealized_intraday_pl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_intraday_pl").toString()));
      }
      if ((jsonObj.get("unrealized_intraday_plpc") != null && !jsonObj.get("unrealized_intraday_plpc").isJsonNull()) && !jsonObj.get("unrealized_intraday_plpc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_intraday_plpc").toString()));
      }
      if ((jsonObj.get("current_price") != null && !jsonObj.get("current_price").isJsonNull()) && !jsonObj.get("current_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `current_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("current_price").toString()));
      }
      if ((jsonObj.get("lastday_price") != null && !jsonObj.get("lastday_price").isJsonNull()) && !jsonObj.get("lastday_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lastday_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lastday_price").toString()));
      }
      if ((jsonObj.get("change_today") != null && !jsonObj.get("change_today").isJsonNull()) && !jsonObj.get("change_today").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `change_today` to be a primitive type in the JSON string but got `%s`", jsonObj.get("change_today").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!USDPosition.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'USDPosition' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<USDPosition> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(USDPosition.class));

       return (TypeAdapter<T>) new TypeAdapter<USDPosition>() {
           @Override
           public void write(JsonWriter out, USDPosition value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public USDPosition read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of USDPosition given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of USDPosition
  * @throws IOException if the JSON string is invalid with respect to USDPosition
  */
  public static USDPosition fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, USDPosition.class);
  }

 /**
  * Convert an instance of USDPosition to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

