/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents a change in a Transfer&#39;s status, sent over the events streaming api.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class TransferStatusEvent {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private UUID accountId;

  public static final String SERIALIZED_NAME_AT = "at";
  @SerializedName(SERIALIZED_NAME_AT)
  private OffsetDateTime at;

  public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
  @SerializedName(SERIALIZED_NAME_EVENT_ID)
  private Integer eventId;

  public static final String SERIALIZED_NAME_EVENT_ULID = "event_ulid";
  @SerializedName(SERIALIZED_NAME_EVENT_ULID)
  private String eventUlid;

  public static final String SERIALIZED_NAME_STATUS_FROM = "status_from";
  @SerializedName(SERIALIZED_NAME_STATUS_FROM)
  private TransferStatus statusFrom;

  public static final String SERIALIZED_NAME_STATUS_TO = "status_to";
  @SerializedName(SERIALIZED_NAME_STATUS_TO)
  private TransferStatus statusTo;

  public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
  @SerializedName(SERIALIZED_NAME_TRANSFER_ID)
  private UUID transferId;

  public TransferStatusEvent() {
  }

  public TransferStatusEvent accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account UUID
   * @return accountId
  **/
  @javax.annotation.Nonnull
  public UUID getAccountId() {
    return accountId;
  }

  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }


  public TransferStatusEvent at(OffsetDateTime at) {
    this.at = at;
    return this;
  }

   /**
   * Timedate of when the transfer status changed
   * @return at
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getAt() {
    return at;
  }

  public void setAt(OffsetDateTime at) {
    this.at = at;
  }


  public TransferStatusEvent eventId(Integer eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * Monotonically increasing 64bit integer
   * @return eventId
  **/
  @javax.annotation.Nonnull
  public Integer getEventId() {
    return eventId;
  }

  public void setEventId(Integer eventId) {
    this.eventId = eventId;
  }


  public TransferStatusEvent eventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
    return this;
  }

   /**
   * lexically sortable, monotonically increasing character array
   * @return eventUlid
  **/
  @javax.annotation.Nonnull
  public String getEventUlid() {
    return eventUlid;
  }

  public void setEventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
  }


  public TransferStatusEvent statusFrom(TransferStatus statusFrom) {
    this.statusFrom = statusFrom;
    return this;
  }

   /**
   * Get statusFrom
   * @return statusFrom
  **/
  @javax.annotation.Nonnull
  public TransferStatus getStatusFrom() {
    return statusFrom;
  }

  public void setStatusFrom(TransferStatus statusFrom) {
    this.statusFrom = statusFrom;
  }


  public TransferStatusEvent statusTo(TransferStatus statusTo) {
    this.statusTo = statusTo;
    return this;
  }

   /**
   * Get statusTo
   * @return statusTo
  **/
  @javax.annotation.Nonnull
  public TransferStatus getStatusTo() {
    return statusTo;
  }

  public void setStatusTo(TransferStatus statusTo) {
    this.statusTo = statusTo;
  }


  public TransferStatusEvent transferId(UUID transferId) {
    this.transferId = transferId;
    return this;
  }

   /**
   * Transfer UUID
   * @return transferId
  **/
  @javax.annotation.Nonnull
  public UUID getTransferId() {
    return transferId;
  }

  public void setTransferId(UUID transferId) {
    this.transferId = transferId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferStatusEvent transferStatusEvent = (TransferStatusEvent) o;
    return Objects.equals(this.accountId, transferStatusEvent.accountId) &&
        Objects.equals(this.at, transferStatusEvent.at) &&
        Objects.equals(this.eventId, transferStatusEvent.eventId) &&
        Objects.equals(this.eventUlid, transferStatusEvent.eventUlid) &&
        Objects.equals(this.statusFrom, transferStatusEvent.statusFrom) &&
        Objects.equals(this.statusTo, transferStatusEvent.statusTo) &&
        Objects.equals(this.transferId, transferStatusEvent.transferId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, at, eventId, eventUlid, statusFrom, statusTo, transferId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferStatusEvent {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    at: ").append(toIndentedString(at)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    eventUlid: ").append(toIndentedString(eventUlid)).append("\n");
    sb.append("    statusFrom: ").append(toIndentedString(statusFrom)).append("\n");
    sb.append("    statusTo: ").append(toIndentedString(statusTo)).append("\n");
    sb.append("    transferId: ").append(toIndentedString(transferId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_id");
    openapiFields.add("at");
    openapiFields.add("event_id");
    openapiFields.add("event_ulid");
    openapiFields.add("status_from");
    openapiFields.add("status_to");
    openapiFields.add("transfer_id");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("account_id");
    openapiRequiredFields.add("at");
    openapiRequiredFields.add("event_id");
    openapiRequiredFields.add("event_ulid");
    openapiRequiredFields.add("status_from");
    openapiRequiredFields.add("status_to");
    openapiRequiredFields.add("transfer_id");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!TransferStatusEvent.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in TransferStatusEvent is not found in the empty JSON string", TransferStatusEvent.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!TransferStatusEvent.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransferStatusEvent` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : TransferStatusEvent.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      if (!jsonObj.get("event_ulid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `event_ulid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("event_ulid").toString()));
      }
      // validate the required field `status_from`
      TransferStatus.validateJsonElement(jsonObj.get("status_from"));
      // validate the required field `status_to`
      TransferStatus.validateJsonElement(jsonObj.get("status_to"));
      if (!jsonObj.get("transfer_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transfer_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transfer_id").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TransferStatusEvent.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TransferStatusEvent' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TransferStatusEvent> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TransferStatusEvent.class));

       return (TypeAdapter<T>) new TypeAdapter<TransferStatusEvent>() {
           @Override
           public void write(JsonWriter out, TransferStatusEvent value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TransferStatusEvent read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TransferStatusEvent given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TransferStatusEvent
  * @throws IOException if the JSON string is invalid with respect to TransferStatusEvent
  */
  public static TransferStatusEvent fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TransferStatusEvent.class);
  }

 /**
  * Convert an instance of TransferStatusEvent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

