/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * - **QUEUED** Transfer is in queue to be processed. - **APPROVAL_PENDING** Transfer is pending approval. - **PENDING** Transfer is pending processing. - **SENT_TO_CLEARING** Transfer is being processed by the clearing firm. - **REJECTED** Transfer is rejected. - **CANCELED** Client initiated transfer cancellation. - **APPROVED** Transfer is approved. - **COMPLETE** Transfer is completed. - **RETURNED** The bank issued an ACH return for the transfer. 
 */
@JsonAdapter(TransferStatus.Adapter.class)
public enum TransferStatus {
  
  QUEUED("QUEUED"),
  
  APPROVAL_PENDING("APPROVAL_PENDING"),
  
  PENDING("PENDING"),
  
  SENT_TO_CLEARING("SENT_TO_CLEARING"),
  
  REJECTED("REJECTED"),
  
  CANCELED("CANCELED"),
  
  APPROVED("APPROVED"),
  
  COMPLETE("COMPLETE"),
  
  RETURNED("RETURNED");

  private String value;

  TransferStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static TransferStatus fromValue(String value) {
    for (TransferStatus b : TransferStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<TransferStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final TransferStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public TransferStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return TransferStatus.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    TransferStatus.fromValue(value);
  }
}

