/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * - **INCOMING** Funds incoming to user’s account (deposit). - **OUTGOING** Funds outgoing from user’s account (withdrawal). 
 */
@JsonAdapter(TransferDirection.Adapter.class)
public enum TransferDirection {
  
  INCOMING("INCOMING"),
  
  OUTGOING("OUTGOING");

  private String value;

  TransferDirection(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static TransferDirection fromValue(String value) {
    for (TransferDirection b : TransferDirection.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<TransferDirection> {
    @Override
    public void write(final JsonWriter jsonWriter, final TransferDirection enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public TransferDirection read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return TransferDirection.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    TransferDirection.fromValue(value);
  }
}

