/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferDirection;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferType;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Transfers allow you to transfer money/balance into your end customers&#39; account (deposits) or out (withdrawal).  [Main docs here](https://alpaca.markets/docs/api-references/broker-api/funding/transfers/#the-transfer-object)
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Transfer {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_RELATIONSHIP_ID = "relationship_id";
  @SerializedName(SERIALIZED_NAME_RELATIONSHIP_ID)
  private UUID relationshipId;

  public static final String SERIALIZED_NAME_BANK_ID = "bank_id";
  @SerializedName(SERIALIZED_NAME_BANK_ID)
  private UUID bankId;

  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private UUID accountId;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TransferType type;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private TransferStatus status;

  public static final String SERIALIZED_NAME_REASON = "reason";
  @SerializedName(SERIALIZED_NAME_REASON)
  private String reason;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_DIRECTION = "direction";
  @SerializedName(SERIALIZED_NAME_DIRECTION)
  private TransferDirection direction;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
  @SerializedName(SERIALIZED_NAME_EXPIRES_AT)
  private OffsetDateTime expiresAt;

  public static final String SERIALIZED_NAME_ADDITIONAL_INFORMATION = "additional_information";
  @SerializedName(SERIALIZED_NAME_ADDITIONAL_INFORMATION)
  private String additionalInformation;

  public static final String SERIALIZED_NAME_HOLD_UNTIL = "hold_until";
  @SerializedName(SERIALIZED_NAME_HOLD_UNTIL)
  private OffsetDateTime holdUntil;

  public static final String SERIALIZED_NAME_INSTANT_AMOUNT = "instant_amount";
  @SerializedName(SERIALIZED_NAME_INSTANT_AMOUNT)
  private String instantAmount;

  public static final String SERIALIZED_NAME_REQUESTED_AMOUNT = "requested_amount";
  @SerializedName(SERIALIZED_NAME_REQUESTED_AMOUNT)
  private BigDecimal requestedAmount;

  public static final String SERIALIZED_NAME_FEE = "fee";
  @SerializedName(SERIALIZED_NAME_FEE)
  private BigDecimal fee;

  public static final String SERIALIZED_NAME_FEE_PAYMENT_METHOD = "fee_payment_method";
  @SerializedName(SERIALIZED_NAME_FEE_PAYMENT_METHOD)
  private String feePaymentMethod;

  public Transfer() {
  }

  public Transfer id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * The transfer ID
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public Transfer relationshipId(UUID relationshipId) {
    this.relationshipId = relationshipId;
    return this;
  }

   /**
   * The ACH relationship ID only present if type &#x3D; \&quot;ach\&quot;
   * @return relationshipId
  **/
  @javax.annotation.Nullable
  public UUID getRelationshipId() {
    return relationshipId;
  }

  public void setRelationshipId(UUID relationshipId) {
    this.relationshipId = relationshipId;
  }


  public Transfer bankId(UUID bankId) {
    this.bankId = bankId;
    return this;
  }

   /**
   * The ID of the Bank, only present if type &#x3D; \&quot;wire\&quot;
   * @return bankId
  **/
  @javax.annotation.Nullable
  public UUID getBankId() {
    return bankId;
  }

  public void setBankId(UUID bankId) {
    this.bankId = bankId;
  }


  public Transfer accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * The account ID
   * @return accountId
  **/
  @javax.annotation.Nonnull
  public UUID getAccountId() {
    return accountId;
  }

  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }


  public Transfer type(TransferType type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nonnull
  public TransferType getType() {
    return type;
  }

  public void setType(TransferType type) {
    this.type = type;
  }


  public Transfer status(TransferStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nonnull
  public TransferStatus getStatus() {
    return status;
  }

  public void setStatus(TransferStatus status) {
    this.status = status;
  }


  public Transfer reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Cause of the status
   * @return reason
  **/
  @javax.annotation.Nullable
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }


  public Transfer amount(BigDecimal amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Must be &gt; 0.00
   * @return amount
  **/
  @javax.annotation.Nonnull
  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public Transfer direction(TransferDirection direction) {
    this.direction = direction;
    return this;
  }

   /**
   * Get direction
   * @return direction
  **/
  @javax.annotation.Nonnull
  public TransferDirection getDirection() {
    return direction;
  }

  public void setDirection(TransferDirection direction) {
    this.direction = direction;
  }


  public Transfer createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Timedate when transfer was created
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Transfer updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Timedate when transfer was updated
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public Transfer expiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * Timedate when transfer was expired
   * @return expiresAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }

  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public Transfer additionalInformation(String additionalInformation) {
    this.additionalInformation = additionalInformation;
    return this;
  }

   /**
   * Additional information. Only applies when type &#x3D; \&quot;wire\&quot;.
   * @return additionalInformation
  **/
  @javax.annotation.Nullable
  public String getAdditionalInformation() {
    return additionalInformation;
  }

  public void setAdditionalInformation(String additionalInformation) {
    this.additionalInformation = additionalInformation;
  }


  public Transfer holdUntil(OffsetDateTime holdUntil) {
    this.holdUntil = holdUntil;
    return this;
  }

   /**
   * Get holdUntil
   * @return holdUntil
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getHoldUntil() {
    return holdUntil;
  }

  public void setHoldUntil(OffsetDateTime holdUntil) {
    this.holdUntil = holdUntil;
  }


  public Transfer instantAmount(String instantAmount) {
    this.instantAmount = instantAmount;
    return this;
  }

   /**
   * Get instantAmount
   * @return instantAmount
  **/
  @javax.annotation.Nullable
  public String getInstantAmount() {
    return instantAmount;
  }

  public void setInstantAmount(String instantAmount) {
    this.instantAmount = instantAmount;
  }


  public Transfer requestedAmount(BigDecimal requestedAmount) {
    this.requestedAmount = requestedAmount;
    return this;
  }

   /**
   * Must be &gt; 0.00. Only applies when type &#x3D; \&quot;wire\&quot;.
   * @return requestedAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getRequestedAmount() {
    return requestedAmount;
  }

  public void setRequestedAmount(BigDecimal requestedAmount) {
    this.requestedAmount = requestedAmount;
  }


  public Transfer fee(BigDecimal fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Fee amount to be collected. Only applies when type &#x3D; \&quot;wire\&quot;.
   * @return fee
  **/
  @javax.annotation.Nullable
  public BigDecimal getFee() {
    return fee;
  }

  public void setFee(BigDecimal fee) {
    this.fee = fee;
  }


  public Transfer feePaymentMethod(String feePaymentMethod) {
    this.feePaymentMethod = feePaymentMethod;
    return this;
  }

   /**
   * Either \&quot;user\&quot; or \&quot;invoice\&quot;. Only applies when type &#x3D; \&quot;wire\&quot;.
   * @return feePaymentMethod
  **/
  @javax.annotation.Nullable
  public String getFeePaymentMethod() {
    return feePaymentMethod;
  }

  public void setFeePaymentMethod(String feePaymentMethod) {
    this.feePaymentMethod = feePaymentMethod;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Transfer transfer = (Transfer) o;
    return Objects.equals(this.id, transfer.id) &&
        Objects.equals(this.relationshipId, transfer.relationshipId) &&
        Objects.equals(this.bankId, transfer.bankId) &&
        Objects.equals(this.accountId, transfer.accountId) &&
        Objects.equals(this.type, transfer.type) &&
        Objects.equals(this.status, transfer.status) &&
        Objects.equals(this.reason, transfer.reason) &&
        Objects.equals(this.amount, transfer.amount) &&
        Objects.equals(this.direction, transfer.direction) &&
        Objects.equals(this.createdAt, transfer.createdAt) &&
        Objects.equals(this.updatedAt, transfer.updatedAt) &&
        Objects.equals(this.expiresAt, transfer.expiresAt) &&
        Objects.equals(this.additionalInformation, transfer.additionalInformation) &&
        Objects.equals(this.holdUntil, transfer.holdUntil) &&
        Objects.equals(this.instantAmount, transfer.instantAmount) &&
        Objects.equals(this.requestedAmount, transfer.requestedAmount) &&
        Objects.equals(this.fee, transfer.fee) &&
        Objects.equals(this.feePaymentMethod, transfer.feePaymentMethod);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, relationshipId, bankId, accountId, type, status, reason, amount, direction, createdAt, updatedAt, expiresAt, additionalInformation, holdUntil, instantAmount, requestedAmount, fee, feePaymentMethod);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Transfer {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    relationshipId: ").append(toIndentedString(relationshipId)).append("\n");
    sb.append("    bankId: ").append(toIndentedString(bankId)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    additionalInformation: ").append(toIndentedString(additionalInformation)).append("\n");
    sb.append("    holdUntil: ").append(toIndentedString(holdUntil)).append("\n");
    sb.append("    instantAmount: ").append(toIndentedString(instantAmount)).append("\n");
    sb.append("    requestedAmount: ").append(toIndentedString(requestedAmount)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    feePaymentMethod: ").append(toIndentedString(feePaymentMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("relationship_id");
    openapiFields.add("bank_id");
    openapiFields.add("account_id");
    openapiFields.add("type");
    openapiFields.add("status");
    openapiFields.add("reason");
    openapiFields.add("amount");
    openapiFields.add("direction");
    openapiFields.add("created_at");
    openapiFields.add("updated_at");
    openapiFields.add("expires_at");
    openapiFields.add("additional_information");
    openapiFields.add("hold_until");
    openapiFields.add("instant_amount");
    openapiFields.add("requested_amount");
    openapiFields.add("fee");
    openapiFields.add("fee_payment_method");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("account_id");
    openapiRequiredFields.add("type");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("direction");
    openapiRequiredFields.add("created_at");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Transfer.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Transfer is not found in the empty JSON string", Transfer.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Transfer.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Transfer` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Transfer.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("relationship_id") != null && !jsonObj.get("relationship_id").isJsonNull()) && !jsonObj.get("relationship_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `relationship_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("relationship_id").toString()));
      }
      if ((jsonObj.get("bank_id") != null && !jsonObj.get("bank_id").isJsonNull()) && !jsonObj.get("bank_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_id").toString()));
      }
      if (!jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      // validate the required field `type`
      TransferType.validateJsonElement(jsonObj.get("type"));
      // validate the required field `status`
      TransferStatus.validateJsonElement(jsonObj.get("status"));
      if ((jsonObj.get("reason") != null && !jsonObj.get("reason").isJsonNull()) && !jsonObj.get("reason").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reason").toString()));
      }
      if (!jsonObj.get("amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("amount").toString()));
      }
      // validate the required field `direction`
      TransferDirection.validateJsonElement(jsonObj.get("direction"));
      if ((jsonObj.get("additional_information") != null && !jsonObj.get("additional_information").isJsonNull()) && !jsonObj.get("additional_information").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `additional_information` to be a primitive type in the JSON string but got `%s`", jsonObj.get("additional_information").toString()));
      }
      if ((jsonObj.get("instant_amount") != null && !jsonObj.get("instant_amount").isJsonNull()) && !jsonObj.get("instant_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `instant_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("instant_amount").toString()));
      }
      if ((jsonObj.get("requested_amount") != null && !jsonObj.get("requested_amount").isJsonNull()) && !jsonObj.get("requested_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `requested_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("requested_amount").toString()));
      }
      if ((jsonObj.get("fee") != null && !jsonObj.get("fee").isJsonNull()) && !jsonObj.get("fee").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `fee` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fee").toString()));
      }
      if ((jsonObj.get("fee_payment_method") != null && !jsonObj.get("fee_payment_method").isJsonNull()) && !jsonObj.get("fee_payment_method").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `fee_payment_method` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fee_payment_method").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Transfer.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Transfer' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Transfer> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Transfer.class));

       return (TypeAdapter<T>) new TypeAdapter<Transfer>() {
           @Override
           public void write(JsonWriter out, Transfer value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Transfer read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Transfer given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Transfer
  * @throws IOException if the JSON string is invalid with respect to Transfer
  */
  public static Transfer fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Transfer.class);
  }

 /**
  * Convert an instance of Transfer to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

