/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Transaction
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Transaction {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private String accountId;

  public static final String SERIALIZED_NAME_ACCOUNT_NO = "account_no";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NAME)
  private String accountName;

  public static final String SERIALIZED_NAME_SYSTEM_DATE = "system_date";
  @SerializedName(SERIALIZED_NAME_SYSTEM_DATE)
  private String systemDate;

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private String entryType;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_CONTRA_ACCOUNT_NAME = "contra_account_name";
  @SerializedName(SERIALIZED_NAME_CONTRA_ACCOUNT_NAME)
  private String contraAccountName;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private String amount;

  public static final String SERIALIZED_NAME_BALANCE = "balance";
  @SerializedName(SERIALIZED_NAME_BALANCE)
  private String balance;

  public Transaction() {
  }

  public Transaction accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * The ledger ID
   * @return accountId
  **/
  @javax.annotation.Nullable
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }


  public Transaction accountNo(String accountNo) {
    this.accountNo = accountNo;
    return this;
  }

   /**
   * The ledger account number
   * @return accountNo
  **/
  @javax.annotation.Nullable
  public String getAccountNo() {
    return accountNo;
  }

  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }


  public Transaction accountName(String accountName) {
    this.accountName = accountName;
    return this;
  }

   /**
   * The ledger name
   * @return accountName
  **/
  @javax.annotation.Nullable
  public String getAccountName() {
    return accountName;
  }

  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public Transaction systemDate(String systemDate) {
    this.systemDate = systemDate;
    return this;
  }

   /**
   * Date of transaction
   * @return systemDate
  **/
  @javax.annotation.Nullable
  public String getSystemDate() {
    return systemDate;
  }

  public void setSystemDate(String systemDate) {
    this.systemDate = systemDate;
  }


  public Transaction entryType(String entryType) {
    this.entryType = entryType;
    return this;
  }

   /**
   * Type of transaction
   * @return entryType
  **/
  @javax.annotation.Nullable
  public String getEntryType() {
    return entryType;
  }

  public void setEntryType(String entryType) {
    this.entryType = entryType;
  }


  public Transaction description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Plain text overview of the transaction
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public Transaction contraAccountName(String contraAccountName) {
    this.contraAccountName = contraAccountName;
    return this;
  }

   /**
   * Contra account of transaction
   * @return contraAccountName
  **/
  @javax.annotation.Nullable
  public String getContraAccountName() {
    return contraAccountName;
  }

  public void setContraAccountName(String contraAccountName) {
    this.contraAccountName = contraAccountName;
  }


  public Transaction amount(String amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Total amount of the transaction
   * @return amount
  **/
  @javax.annotation.Nullable
  public String getAmount() {
    return amount;
  }

  public void setAmount(String amount) {
    this.amount = amount;
  }


  public Transaction balance(String balance) {
    this.balance = balance;
    return this;
  }

   /**
   * Ending balance after thetransaction has been applied
   * @return balance
  **/
  @javax.annotation.Nullable
  public String getBalance() {
    return balance;
  }

  public void setBalance(String balance) {
    this.balance = balance;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Transaction transaction = (Transaction) o;
    return Objects.equals(this.accountId, transaction.accountId) &&
        Objects.equals(this.accountNo, transaction.accountNo) &&
        Objects.equals(this.accountName, transaction.accountName) &&
        Objects.equals(this.systemDate, transaction.systemDate) &&
        Objects.equals(this.entryType, transaction.entryType) &&
        Objects.equals(this.description, transaction.description) &&
        Objects.equals(this.contraAccountName, transaction.contraAccountName) &&
        Objects.equals(this.amount, transaction.amount) &&
        Objects.equals(this.balance, transaction.balance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountNo, accountName, systemDate, entryType, description, contraAccountName, amount, balance);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Transaction {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    systemDate: ").append(toIndentedString(systemDate)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    contraAccountName: ").append(toIndentedString(contraAccountName)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_id");
    openapiFields.add("account_no");
    openapiFields.add("account_name");
    openapiFields.add("system_date");
    openapiFields.add("entry_type");
    openapiFields.add("description");
    openapiFields.add("contra_account_name");
    openapiFields.add("amount");
    openapiFields.add("balance");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Transaction.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Transaction is not found in the empty JSON string", Transaction.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Transaction.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Transaction` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("account_id") != null && !jsonObj.get("account_id").isJsonNull()) && !jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      if ((jsonObj.get("account_no") != null && !jsonObj.get("account_no").isJsonNull()) && !jsonObj.get("account_no").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_no").toString()));
      }
      if ((jsonObj.get("account_name") != null && !jsonObj.get("account_name").isJsonNull()) && !jsonObj.get("account_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_name").toString()));
      }
      if ((jsonObj.get("system_date") != null && !jsonObj.get("system_date").isJsonNull()) && !jsonObj.get("system_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `system_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("system_date").toString()));
      }
      if ((jsonObj.get("entry_type") != null && !jsonObj.get("entry_type").isJsonNull()) && !jsonObj.get("entry_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `entry_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("entry_type").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("contra_account_name") != null && !jsonObj.get("contra_account_name").isJsonNull()) && !jsonObj.get("contra_account_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `contra_account_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("contra_account_name").toString()));
      }
      if ((jsonObj.get("amount") != null && !jsonObj.get("amount").isJsonNull()) && !jsonObj.get("amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("amount").toString()));
      }
      if ((jsonObj.get("balance") != null && !jsonObj.get("balance").isJsonNull()) && !jsonObj.get("balance").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `balance` to be a primitive type in the JSON string but got `%s`", jsonObj.get("balance").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Transaction.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Transaction' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Transaction> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Transaction.class));

       return (TypeAdapter<T>) new TypeAdapter<Transaction>() {
           @Override
           public void write(JsonWriter out, Transaction value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Transaction read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Transaction given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Transaction
  * @throws IOException if the JSON string is invalid with respect to Transaction
  */
  public static Transaction fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Transaction.class);
  }

 /**
  * Convert an instance of Transaction to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

