/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the &#x60;timestamp&#x60; field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;new&#x60;: Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60;: Sent when your order has been completely filled.   - &#x60;timestamp&#x60;: The time at which the order was filled. - &#x60;partial_fill&#x60;: Sent when a number of shares less than the total remaining quantity on your order has been filled.   - &#x60;timestamp&#x60;: The time at which the shares were filled. - &#x60;canceled&#x60;: Sent when your requested cancellation of an order is processed.   - &#x60;timestamp&#x60;: The time at which the order was canceled. - &#x60;expired&#x60;: Sent when an order has reached the end of its lifespan, as determined by the order’s time in force value.   - &#x60;timestamp&#x60;: The time at which the order expired. - &#x60;done_for_day&#x60;: Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60;: Sent when your requested replacement of an order is processed.   - &#x60;timestamp&#x60;: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60;: Sent when your order has been rejected.   - &#x60;timestamp&#x60;: The time at which the rejection occurred. - &#x60;pending_new&#x60;: Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;stopped&#x60;: Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60;: Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60;: Sent when the order is awaiting replacement. - &#x60;calculated&#x60;: Sent when the order has been completed for the day - it is either &#x60;filled&#x60; or &#x60;done_for_day&#x60; - but remaining settlement calculations are still pending. - &#x60;suspended&#x60;: Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60;: Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60;: Sent when the order cancel has been rejected. 
 */
@JsonAdapter(TradeUpdateEventType.Adapter.class)
public enum TradeUpdateEventType {
  
  NEW("new"),
  
  FILL("fill"),
  
  PARTIAL_FILL("partial_fill"),
  
  CANCELED("canceled"),
  
  EXPIRED("expired"),
  
  DONE_FOR_DAY("done_for_day"),
  
  REPLACED("replaced"),
  
  REJECTED("rejected"),
  
  PENDING_NEW("pending_new"),
  
  STOPPED("stopped"),
  
  PENDING_CANCEL("pending_cancel"),
  
  PENDING_REPLACE("pending_replace"),
  
  CALCULATED("calculated"),
  
  SUSPENDED("suspended"),
  
  ORDER_REPLACE_REJECTED("order_replace_rejected"),
  
  ORDER_CANCEL_REJECTED("order_cancel_rejected");

  private String value;

  TradeUpdateEventType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static TradeUpdateEventType fromValue(String value) {
    for (TradeUpdateEventType b : TradeUpdateEventType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<TradeUpdateEventType> {
    @Override
    public void write(final JsonWriter jsonWriter, final TradeUpdateEventType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public TradeUpdateEventType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return TradeUpdateEventType.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    TradeUpdateEventType.fromValue(value);
  }
}

