/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.Order;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEventType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents an update to an order/trade, sent over the events streaming api.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class TradeUpdateEvent {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private UUID accountId;

  public static final String SERIALIZED_NAME_AT = "at";
  @SerializedName(SERIALIZED_NAME_AT)
  private OffsetDateTime at;

  public static final String SERIALIZED_NAME_EVENT = "event";
  @SerializedName(SERIALIZED_NAME_EVENT)
  private TradeUpdateEventType event;

  public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
  @SerializedName(SERIALIZED_NAME_EVENT_ID)
  private Long eventId;

  public static final String SERIALIZED_NAME_EVENT_ULID = "event_ulid";
  @SerializedName(SERIALIZED_NAME_EVENT_ULID)
  private String eventUlid;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "execution_id";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private UUID executionId;

  public static final String SERIALIZED_NAME_ORDER = "order";
  @SerializedName(SERIALIZED_NAME_ORDER)
  private Order order;

  public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
  @SerializedName(SERIALIZED_NAME_TIMESTAMP)
  private OffsetDateTime timestamp;

  public static final String SERIALIZED_NAME_PRICE = "price";
  @SerializedName(SERIALIZED_NAME_PRICE)
  private String price;

  public static final String SERIALIZED_NAME_POSITION_QTY = "position_qty";
  @SerializedName(SERIALIZED_NAME_POSITION_QTY)
  private String positionQty;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public TradeUpdateEvent() {
  }

  public TradeUpdateEvent accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account UUID
   * @return accountId
  **/
  @javax.annotation.Nonnull
  public UUID getAccountId() {
    return accountId;
  }

  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }


  public TradeUpdateEvent at(OffsetDateTime at) {
    this.at = at;
    return this;
  }

   /**
   * Timestamp of event
   * @return at
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getAt() {
    return at;
  }

  public void setAt(OffsetDateTime at) {
    this.at = at;
  }


  public TradeUpdateEvent event(TradeUpdateEventType event) {
    this.event = event;
    return this;
  }

   /**
   * Get event
   * @return event
  **/
  @javax.annotation.Nonnull
  public TradeUpdateEventType getEvent() {
    return event;
  }

  public void setEvent(TradeUpdateEventType event) {
    this.event = event;
  }


  public TradeUpdateEvent eventId(Long eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * Monotonically increasing 64bit integer
   * @return eventId
  **/
  @javax.annotation.Nonnull
  public Long getEventId() {
    return eventId;
  }

  public void setEventId(Long eventId) {
    this.eventId = eventId;
  }


  public TradeUpdateEvent eventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
    return this;
  }

   /**
   * lexically sortable, monotonically increasing character array
   * @return eventUlid
  **/
  @javax.annotation.Nonnull
  public String getEventUlid() {
    return eventUlid;
  }

  public void setEventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
  }


  public TradeUpdateEvent executionId(UUID executionId) {
    this.executionId = executionId;
    return this;
  }

   /**
   * Corresponding execution of an order. If an order gets filled over two executions (a partial_fill for example), you will receive two events with different IDs.
   * @return executionId
  **/
  @javax.annotation.Nonnull
  public UUID getExecutionId() {
    return executionId;
  }

  public void setExecutionId(UUID executionId) {
    this.executionId = executionId;
  }


  public TradeUpdateEvent order(Order order) {
    this.order = order;
    return this;
  }

   /**
   * Get order
   * @return order
  **/
  @javax.annotation.Nonnull
  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }


  public TradeUpdateEvent timestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Has various different meanings depending on the value of &#x60;event&#x60;, please see the [Trading Events](https://alpaca.markets/docs/api-references/broker-api/events/#trade-events) Enum in the documentation or the TradeUpdateEventType model for more details on when it means different things. 
   * @return timestamp
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }


  public TradeUpdateEvent price(String price) {
    this.price = price;
    return this;
  }

   /**
   * Only present when event is either &#x60;fill&#x60; or &#x60;partial_fill&#x60;. The average price per share at which the order was filled.
   * @return price
  **/
  @javax.annotation.Nullable
  public String getPrice() {
    return price;
  }

  public void setPrice(String price) {
    this.price = price;
  }


  public TradeUpdateEvent positionQty(String positionQty) {
    this.positionQty = positionQty;
    return this;
  }

   /**
   * Only present when event is either &#x60;fill&#x60; or &#x60;partial_fill&#x60;. The size of your total position, after this fill event, in shares. Positive for long positions, negative for short positions.
   * @return positionQty
  **/
  @javax.annotation.Nullable
  public String getPositionQty() {
    return positionQty;
  }

  public void setPositionQty(String positionQty) {
    this.positionQty = positionQty;
  }


  public TradeUpdateEvent qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Only present when event is either &#x60;fill&#x60; or &#x60;partial_fill&#x60;. The amount of shares this Trade order was for
   * @return qty
  **/
  @javax.annotation.Nullable
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TradeUpdateEvent tradeUpdateEvent = (TradeUpdateEvent) o;
    return Objects.equals(this.accountId, tradeUpdateEvent.accountId) &&
        Objects.equals(this.at, tradeUpdateEvent.at) &&
        Objects.equals(this.event, tradeUpdateEvent.event) &&
        Objects.equals(this.eventId, tradeUpdateEvent.eventId) &&
        Objects.equals(this.eventUlid, tradeUpdateEvent.eventUlid) &&
        Objects.equals(this.executionId, tradeUpdateEvent.executionId) &&
        Objects.equals(this.order, tradeUpdateEvent.order) &&
        Objects.equals(this.timestamp, tradeUpdateEvent.timestamp) &&
        Objects.equals(this.price, tradeUpdateEvent.price) &&
        Objects.equals(this.positionQty, tradeUpdateEvent.positionQty) &&
        Objects.equals(this.qty, tradeUpdateEvent.qty);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, at, event, eventId, eventUlid, executionId, order, timestamp, price, positionQty, qty);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TradeUpdateEvent {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    at: ").append(toIndentedString(at)).append("\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    eventUlid: ").append(toIndentedString(eventUlid)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    positionQty: ").append(toIndentedString(positionQty)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_id");
    openapiFields.add("at");
    openapiFields.add("event");
    openapiFields.add("event_id");
    openapiFields.add("event_ulid");
    openapiFields.add("execution_id");
    openapiFields.add("order");
    openapiFields.add("timestamp");
    openapiFields.add("price");
    openapiFields.add("position_qty");
    openapiFields.add("qty");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("account_id");
    openapiRequiredFields.add("at");
    openapiRequiredFields.add("event");
    openapiRequiredFields.add("event_id");
    openapiRequiredFields.add("event_ulid");
    openapiRequiredFields.add("execution_id");
    openapiRequiredFields.add("order");
    openapiRequiredFields.add("timestamp");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!TradeUpdateEvent.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in TradeUpdateEvent is not found in the empty JSON string", TradeUpdateEvent.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!TradeUpdateEvent.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TradeUpdateEvent` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : TradeUpdateEvent.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      // validate the required field `event`
      TradeUpdateEventType.validateJsonElement(jsonObj.get("event"));
      if (!jsonObj.get("event_ulid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `event_ulid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("event_ulid").toString()));
      }
      if (!jsonObj.get("execution_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `execution_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("execution_id").toString()));
      }
      // validate the required field `order`
      Order.validateJsonElement(jsonObj.get("order"));
      if ((jsonObj.get("price") != null && !jsonObj.get("price").isJsonNull()) && !jsonObj.get("price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("price").toString()));
      }
      if ((jsonObj.get("position_qty") != null && !jsonObj.get("position_qty").isJsonNull()) && !jsonObj.get("position_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `position_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("position_qty").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TradeUpdateEvent.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TradeUpdateEvent' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TradeUpdateEvent> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TradeUpdateEvent.class));

       return (TypeAdapter<T>) new TypeAdapter<TradeUpdateEvent>() {
           @Override
           public void write(JsonWriter out, TradeUpdateEvent value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TradeUpdateEvent read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TradeUpdateEvent given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TradeUpdateEvent
  * @throws IOException if the JSON string is invalid with respect to TradeUpdateEvent
  */
  public static TradeUpdateEvent fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TradeUpdateEvent.class);
  }

 /**
  * Convert an instance of TradeUpdateEvent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

