/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * TradeActivity
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class TradeActivity {
  public static final String SERIALIZED_NAME_TRANSACTION_TIME = "transaction_time";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TIME)
  private OffsetDateTime transactionTime;

  /**
   * Valid only for trading activity types. Null for non-trading activites.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    FILL("fill"),
    
    PARTIAL_FILL("partial_fill");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      TypeEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_PRICE = "price";
  @SerializedName(SERIALIZED_NAME_PRICE)
  private BigDecimal price;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private BigDecimal qty;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private OrderSide side;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_LEAVES_QTY = "leaves_qty";
  @SerializedName(SERIALIZED_NAME_LEAVES_QTY)
  private BigDecimal leavesQty;

  public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
  @SerializedName(SERIALIZED_NAME_ORDER_ID)
  private UUID orderId;

  public static final String SERIALIZED_NAME_CUM_QTY = "cum_qty";
  @SerializedName(SERIALIZED_NAME_CUM_QTY)
  private BigDecimal cumQty;

  public static final String SERIALIZED_NAME_ORDER_STATUS = "order_status";
  @SerializedName(SERIALIZED_NAME_ORDER_STATUS)
  private OrderStatus orderStatus;

  public TradeActivity() {
  }

  public TradeActivity transactionTime(OffsetDateTime transactionTime) {
    this.transactionTime = transactionTime;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return transactionTime
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getTransactionTime() {
    return transactionTime;
  }

  public void setTransactionTime(OffsetDateTime transactionTime) {
    this.transactionTime = transactionTime;
  }


  public TradeActivity type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return type
  **/
  @javax.annotation.Nullable
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }


  public TradeActivity price(BigDecimal price) {
    this.price = price;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return price
  **/
  @javax.annotation.Nullable
  public BigDecimal getPrice() {
    return price;
  }

  public void setPrice(BigDecimal price) {
    this.price = price;
  }


  public TradeActivity qty(BigDecimal qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return qty
  **/
  @javax.annotation.Nullable
  public BigDecimal getQty() {
    return qty;
  }

  public void setQty(BigDecimal qty) {
    this.qty = qty;
  }


  public TradeActivity side(OrderSide side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @javax.annotation.Nullable
  public OrderSide getSide() {
    return side;
  }

  public void setSide(OrderSide side) {
    this.side = side;
  }


  public TradeActivity symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public TradeActivity leavesQty(BigDecimal leavesQty) {
    this.leavesQty = leavesQty;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return leavesQty
  **/
  @javax.annotation.Nullable
  public BigDecimal getLeavesQty() {
    return leavesQty;
  }

  public void setLeavesQty(BigDecimal leavesQty) {
    this.leavesQty = leavesQty;
  }


  public TradeActivity orderId(UUID orderId) {
    this.orderId = orderId;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return orderId
  **/
  @javax.annotation.Nullable
  public UUID getOrderId() {
    return orderId;
  }

  public void setOrderId(UUID orderId) {
    this.orderId = orderId;
  }


  public TradeActivity cumQty(BigDecimal cumQty) {
    this.cumQty = cumQty;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return cumQty
  **/
  @javax.annotation.Nullable
  public BigDecimal getCumQty() {
    return cumQty;
  }

  public void setCumQty(BigDecimal cumQty) {
    this.cumQty = cumQty;
  }


  public TradeActivity orderStatus(OrderStatus orderStatus) {
    this.orderStatus = orderStatus;
    return this;
  }

   /**
   * Get orderStatus
   * @return orderStatus
  **/
  @javax.annotation.Nullable
  public OrderStatus getOrderStatus() {
    return orderStatus;
  }

  public void setOrderStatus(OrderStatus orderStatus) {
    this.orderStatus = orderStatus;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TradeActivity tradeActivity = (TradeActivity) o;
    return Objects.equals(this.transactionTime, tradeActivity.transactionTime) &&
        Objects.equals(this.type, tradeActivity.type) &&
        Objects.equals(this.price, tradeActivity.price) &&
        Objects.equals(this.qty, tradeActivity.qty) &&
        Objects.equals(this.side, tradeActivity.side) &&
        Objects.equals(this.symbol, tradeActivity.symbol) &&
        Objects.equals(this.leavesQty, tradeActivity.leavesQty) &&
        Objects.equals(this.orderId, tradeActivity.orderId) &&
        Objects.equals(this.cumQty, tradeActivity.cumQty) &&
        Objects.equals(this.orderStatus, tradeActivity.orderStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transactionTime, type, price, qty, side, symbol, leavesQty, orderId, cumQty, orderStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TradeActivity {\n");
    sb.append("    transactionTime: ").append(toIndentedString(transactionTime)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    leavesQty: ").append(toIndentedString(leavesQty)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    cumQty: ").append(toIndentedString(cumQty)).append("\n");
    sb.append("    orderStatus: ").append(toIndentedString(orderStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("transaction_time");
    openapiFields.add("type");
    openapiFields.add("price");
    openapiFields.add("qty");
    openapiFields.add("side");
    openapiFields.add("symbol");
    openapiFields.add("leaves_qty");
    openapiFields.add("order_id");
    openapiFields.add("cum_qty");
    openapiFields.add("order_status");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!TradeActivity.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in TradeActivity is not found in the empty JSON string", TradeActivity.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!TradeActivity.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TradeActivity` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      // validate the optional field `type`
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) {
        TypeEnum.validateJsonElement(jsonObj.get("type"));
      }
      if ((jsonObj.get("price") != null && !jsonObj.get("price").isJsonNull()) && !jsonObj.get("price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("price").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      // validate the optional field `side`
      if (jsonObj.get("side") != null && !jsonObj.get("side").isJsonNull()) {
        OrderSide.validateJsonElement(jsonObj.get("side"));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("leaves_qty") != null && !jsonObj.get("leaves_qty").isJsonNull()) && !jsonObj.get("leaves_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `leaves_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("leaves_qty").toString()));
      }
      if ((jsonObj.get("order_id") != null && !jsonObj.get("order_id").isJsonNull()) && !jsonObj.get("order_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("order_id").toString()));
      }
      if ((jsonObj.get("cum_qty") != null && !jsonObj.get("cum_qty").isJsonNull()) && !jsonObj.get("cum_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cum_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cum_qty").toString()));
      }
      // validate the optional field `order_status`
      if (jsonObj.get("order_status") != null && !jsonObj.get("order_status").isJsonNull()) {
        OrderStatus.validateJsonElement(jsonObj.get("order_status"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TradeActivity.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TradeActivity' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TradeActivity> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TradeActivity.class));

       return (TypeAdapter<T>) new TypeAdapter<TradeActivity>() {
           @Override
           public void write(JsonWriter out, TradeActivity value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TradeActivity read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TradeActivity given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TradeActivity
  * @throws IOException if the JSON string is invalid with respect to TradeActivity
  */
  public static TradeActivity fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TradeActivity.class);
  }

 /**
  * Convert an instance of TradeActivity to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

