/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * This is an extended version of the Account model found [in the trading api](https://alpaca.markets/docs/api-references/trading-api/account/#account-entity).  Extra data has been added that would be useful for brokers.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class TradeAccount {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private AccountStatus status;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_BUYING_POWER = "buying_power";
  @SerializedName(SERIALIZED_NAME_BUYING_POWER)
  private BigDecimal buyingPower;

  public static final String SERIALIZED_NAME_REGT_BUYING_POWER = "regt_buying_power";
  @SerializedName(SERIALIZED_NAME_REGT_BUYING_POWER)
  private BigDecimal regtBuyingPower;

  public static final String SERIALIZED_NAME_DAYTRADING_BUYING_POWER = "daytrading_buying_power";
  @SerializedName(SERIALIZED_NAME_DAYTRADING_BUYING_POWER)
  private BigDecimal daytradingBuyingPower;

  public static final String SERIALIZED_NAME_OPTIONS_BUYING_POWER = "options_buying_power";
  @SerializedName(SERIALIZED_NAME_OPTIONS_BUYING_POWER)
  private BigDecimal optionsBuyingPower;

  public static final String SERIALIZED_NAME_CASH = "cash";
  @SerializedName(SERIALIZED_NAME_CASH)
  private BigDecimal cash;

  public static final String SERIALIZED_NAME_CASH_WITHDRAWABLE = "cash_withdrawable";
  @SerializedName(SERIALIZED_NAME_CASH_WITHDRAWABLE)
  private BigDecimal cashWithdrawable;

  public static final String SERIALIZED_NAME_CASH_TRANSFERABLE = "cash_transferable";
  @SerializedName(SERIALIZED_NAME_CASH_TRANSFERABLE)
  private String cashTransferable;

  public static final String SERIALIZED_NAME_PENDING_TRANSFER_OUT = "pending_transfer_out";
  @SerializedName(SERIALIZED_NAME_PENDING_TRANSFER_OUT)
  private String pendingTransferOut;

  public static final String SERIALIZED_NAME_PORTFOLIO_VALUE = "portfolio_value";
  @SerializedName(SERIALIZED_NAME_PORTFOLIO_VALUE)
  private BigDecimal portfolioValue;

  public static final String SERIALIZED_NAME_PATTERN_DAY_TRADER = "pattern_day_trader";
  @SerializedName(SERIALIZED_NAME_PATTERN_DAY_TRADER)
  private Boolean patternDayTrader;

  public static final String SERIALIZED_NAME_TRADING_BLOCKED = "trading_blocked";
  @SerializedName(SERIALIZED_NAME_TRADING_BLOCKED)
  private Boolean tradingBlocked;

  public static final String SERIALIZED_NAME_TRANSFERS_BLOCKED = "transfers_blocked";
  @SerializedName(SERIALIZED_NAME_TRANSFERS_BLOCKED)
  private Boolean transfersBlocked;

  public static final String SERIALIZED_NAME_ACCOUNT_BLOCKED = "account_blocked";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_BLOCKED)
  private Boolean accountBlocked;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private String createdAt;

  public static final String SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER = "trade_suspended_by_user";
  @SerializedName(SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER)
  private Boolean tradeSuspendedByUser;

  public static final String SERIALIZED_NAME_MULTIPLIER = "multiplier";
  @SerializedName(SERIALIZED_NAME_MULTIPLIER)
  private BigDecimal multiplier;

  public static final String SERIALIZED_NAME_SHORTING_ENABLED = "shorting_enabled";
  @SerializedName(SERIALIZED_NAME_SHORTING_ENABLED)
  private Boolean shortingEnabled;

  public static final String SERIALIZED_NAME_EQUITY = "equity";
  @SerializedName(SERIALIZED_NAME_EQUITY)
  private BigDecimal equity;

  public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
  @SerializedName(SERIALIZED_NAME_LAST_EQUITY)
  private BigDecimal lastEquity;

  public static final String SERIALIZED_NAME_LONG_MARKET_VALUE = "long_market_value";
  @SerializedName(SERIALIZED_NAME_LONG_MARKET_VALUE)
  private BigDecimal longMarketValue;

  public static final String SERIALIZED_NAME_SHORT_MARKET_VALUE = "short_market_value";
  @SerializedName(SERIALIZED_NAME_SHORT_MARKET_VALUE)
  private BigDecimal shortMarketValue;

  public static final String SERIALIZED_NAME_INITIAL_MARGIN = "initial_margin";
  @SerializedName(SERIALIZED_NAME_INITIAL_MARGIN)
  private BigDecimal initialMargin;

  public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN = "maintenance_margin";
  @SerializedName(SERIALIZED_NAME_MAINTENANCE_MARGIN)
  private BigDecimal maintenanceMargin;

  public static final String SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN = "last_maintenance_margin";
  @SerializedName(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN)
  private BigDecimal lastMaintenanceMargin;

  public static final String SERIALIZED_NAME_SMA = "sma";
  @SerializedName(SERIALIZED_NAME_SMA)
  private BigDecimal sma;

  public static final String SERIALIZED_NAME_DAYTRADE_COUNT = "daytrade_count";
  @SerializedName(SERIALIZED_NAME_DAYTRADE_COUNT)
  private Integer daytradeCount;

  public static final String SERIALIZED_NAME_PREVIOUS_CLOSE = "previous_close";
  @SerializedName(SERIALIZED_NAME_PREVIOUS_CLOSE)
  private String previousClose;

  public static final String SERIALIZED_NAME_LAST_LONG_MARKET_VALUE = "last_long_market_value";
  @SerializedName(SERIALIZED_NAME_LAST_LONG_MARKET_VALUE)
  private String lastLongMarketValue;

  public static final String SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE = "last_short_market_value";
  @SerializedName(SERIALIZED_NAME_LAST_SHORT_MARKET_VALUE)
  private String lastShortMarketValue;

  public static final String SERIALIZED_NAME_LAST_CASH = "last_cash";
  @SerializedName(SERIALIZED_NAME_LAST_CASH)
  private String lastCash;

  public static final String SERIALIZED_NAME_LAST_INITIAL_MARGIN = "last_initial_margin";
  @SerializedName(SERIALIZED_NAME_LAST_INITIAL_MARGIN)
  private String lastInitialMargin;

  public static final String SERIALIZED_NAME_LAST_REGT_BUYING_POWER = "last_regt_buying_power";
  @SerializedName(SERIALIZED_NAME_LAST_REGT_BUYING_POWER)
  private String lastRegtBuyingPower;

  public static final String SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER = "last_daytrading_buying_power";
  @SerializedName(SERIALIZED_NAME_LAST_DAYTRADING_BUYING_POWER)
  private String lastDaytradingBuyingPower;

  public static final String SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER = "last_options_buying_power";
  @SerializedName(SERIALIZED_NAME_LAST_OPTIONS_BUYING_POWER)
  private String lastOptionsBuyingPower;

  public static final String SERIALIZED_NAME_LAST_BUYING_POWER = "last_buying_power";
  @SerializedName(SERIALIZED_NAME_LAST_BUYING_POWER)
  private String lastBuyingPower;

  public static final String SERIALIZED_NAME_LAST_DAYTRADE_COUNT = "last_daytrade_count";
  @SerializedName(SERIALIZED_NAME_LAST_DAYTRADE_COUNT)
  private Integer lastDaytradeCount;

  public static final String SERIALIZED_NAME_CLEARING_BROKER = "clearing_broker";
  @SerializedName(SERIALIZED_NAME_CLEARING_BROKER)
  private String clearingBroker;

  /**
   * The option trading level that was approved for this account. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   */
  @JsonAdapter(OptionsApprovedLevelEnum.Adapter.class)
  public enum OptionsApprovedLevelEnum {
    NUMBER_0(0),
    
    NUMBER_1(1),
    
    NUMBER_2(2);

    private Integer value;

    OptionsApprovedLevelEnum(Integer value) {
      this.value = value;
    }

    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static OptionsApprovedLevelEnum fromValue(Integer value) {
      for (OptionsApprovedLevelEnum b : OptionsApprovedLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<OptionsApprovedLevelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OptionsApprovedLevelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public OptionsApprovedLevelEnum read(final JsonReader jsonReader) throws IOException {
        Integer value =  jsonReader.nextInt();
        return OptionsApprovedLevelEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      Integer value = jsonElement.getAsInt();
      OptionsApprovedLevelEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL = "options_approved_level";
  @SerializedName(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL)
  private OptionsApprovedLevelEnum optionsApprovedLevel;

  /**
   * The effective option trading level of the account. This is the minimum between account options_approved_level and account configurations max_options_trading_level. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   */
  @JsonAdapter(OptionsTradingLevelEnum.Adapter.class)
  public enum OptionsTradingLevelEnum {
    NUMBER_0(0),
    
    NUMBER_1(1),
    
    NUMBER_2(2);

    private Integer value;

    OptionsTradingLevelEnum(Integer value) {
      this.value = value;
    }

    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static OptionsTradingLevelEnum fromValue(Integer value) {
      for (OptionsTradingLevelEnum b : OptionsTradingLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<OptionsTradingLevelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OptionsTradingLevelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public OptionsTradingLevelEnum read(final JsonReader jsonReader) throws IOException {
        Integer value =  jsonReader.nextInt();
        return OptionsTradingLevelEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      Integer value = jsonElement.getAsInt();
      OptionsTradingLevelEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_OPTIONS_TRADING_LEVEL = "options_trading_level";
  @SerializedName(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL)
  private OptionsTradingLevelEnum optionsTradingLevel;

  public TradeAccount() {
  }

  public TradeAccount id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * The account ID
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public TradeAccount accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * The account number
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public TradeAccount status(AccountStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nonnull
  public AccountStatus getStatus() {
    return status;
  }

  public void setStatus(AccountStatus status) {
    this.status = status;
  }


  public TradeAccount currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Always USD
   * @return currency
  **/
  @javax.annotation.Nonnull
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public TradeAccount buyingPower(BigDecimal buyingPower) {
    this.buyingPower = buyingPower;
    return this;
  }

   /**
   * Current available cash buying power. If multiplier &#x3D; 2 then buying_power &#x3D; max(equity-initial_margin(0) * 2). If multiplier &#x3D; 1 then buying_power &#x3D; cash.
   * @return buyingPower
  **/
  @javax.annotation.Nonnull
  public BigDecimal getBuyingPower() {
    return buyingPower;
  }

  public void setBuyingPower(BigDecimal buyingPower) {
    this.buyingPower = buyingPower;
  }


  public TradeAccount regtBuyingPower(BigDecimal regtBuyingPower) {
    this.regtBuyingPower = regtBuyingPower;
    return this;
  }

   /**
   * User’s buying power under Regulation T (excess equity - (equity - margin value) - * margin multiplier)
   * @return regtBuyingPower
  **/
  @javax.annotation.Nullable
  public BigDecimal getRegtBuyingPower() {
    return regtBuyingPower;
  }

  public void setRegtBuyingPower(BigDecimal regtBuyingPower) {
    this.regtBuyingPower = regtBuyingPower;
  }


  public TradeAccount daytradingBuyingPower(BigDecimal daytradingBuyingPower) {
    this.daytradingBuyingPower = daytradingBuyingPower;
    return this;
  }

   /**
   * Your buying power for day trades (continuously updated value)
   * @return daytradingBuyingPower
  **/
  @javax.annotation.Nullable
  public BigDecimal getDaytradingBuyingPower() {
    return daytradingBuyingPower;
  }

  public void setDaytradingBuyingPower(BigDecimal daytradingBuyingPower) {
    this.daytradingBuyingPower = daytradingBuyingPower;
  }


  public TradeAccount optionsBuyingPower(BigDecimal optionsBuyingPower) {
    this.optionsBuyingPower = optionsBuyingPower;
    return this;
  }

   /**
   * Your buying power for options trading
   * @return optionsBuyingPower
  **/
  @javax.annotation.Nullable
  public BigDecimal getOptionsBuyingPower() {
    return optionsBuyingPower;
  }

  public void setOptionsBuyingPower(BigDecimal optionsBuyingPower) {
    this.optionsBuyingPower = optionsBuyingPower;
  }


  public TradeAccount cash(BigDecimal cash) {
    this.cash = cash;
    return this;
  }

   /**
   * Cash balance
   * @return cash
  **/
  @javax.annotation.Nonnull
  public BigDecimal getCash() {
    return cash;
  }

  public void setCash(BigDecimal cash) {
    this.cash = cash;
  }


  public TradeAccount cashWithdrawable(BigDecimal cashWithdrawable) {
    this.cashWithdrawable = cashWithdrawable;
    return this;
  }

   /**
   * Cash available for withdrawl
   * @return cashWithdrawable
  **/
  @javax.annotation.Nullable
  public BigDecimal getCashWithdrawable() {
    return cashWithdrawable;
  }

  public void setCashWithdrawable(BigDecimal cashWithdrawable) {
    this.cashWithdrawable = cashWithdrawable;
  }


  public TradeAccount cashTransferable(String cashTransferable) {
    this.cashTransferable = cashTransferable;
    return this;
  }

   /**
   * Cash available for transfer (JNLC)
   * @return cashTransferable
  **/
  @javax.annotation.Nullable
  public String getCashTransferable() {
    return cashTransferable;
  }

  public void setCashTransferable(String cashTransferable) {
    this.cashTransferable = cashTransferable;
  }


  public TradeAccount pendingTransferOut(String pendingTransferOut) {
    this.pendingTransferOut = pendingTransferOut;
    return this;
  }

   /**
   * Cash pending transfer out
   * @return pendingTransferOut
  **/
  @javax.annotation.Nullable
  public String getPendingTransferOut() {
    return pendingTransferOut;
  }

  public void setPendingTransferOut(String pendingTransferOut) {
    this.pendingTransferOut = pendingTransferOut;
  }


  public TradeAccount portfolioValue(BigDecimal portfolioValue) {
    this.portfolioValue = portfolioValue;
    return this;
  }

   /**
   * Total value of cash + holding positions. (This field is deprecated. It is equivalent to the equity field.)
   * @return portfolioValue
  **/
  @javax.annotation.Nullable
  public BigDecimal getPortfolioValue() {
    return portfolioValue;
  }

  public void setPortfolioValue(BigDecimal portfolioValue) {
    this.portfolioValue = portfolioValue;
  }


  public TradeAccount patternDayTrader(Boolean patternDayTrader) {
    this.patternDayTrader = patternDayTrader;
    return this;
  }

   /**
   * Whether account is flagged as pattern day trader or not
   * @return patternDayTrader
  **/
  @javax.annotation.Nullable
  public Boolean getPatternDayTrader() {
    return patternDayTrader;
  }

  public void setPatternDayTrader(Boolean patternDayTrader) {
    this.patternDayTrader = patternDayTrader;
  }


  public TradeAccount tradingBlocked(Boolean tradingBlocked) {
    this.tradingBlocked = tradingBlocked;
    return this;
  }

   /**
   * If true, the account is not allowed to place orders.
   * @return tradingBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getTradingBlocked() {
    return tradingBlocked;
  }

  public void setTradingBlocked(Boolean tradingBlocked) {
    this.tradingBlocked = tradingBlocked;
  }


  public TradeAccount transfersBlocked(Boolean transfersBlocked) {
    this.transfersBlocked = transfersBlocked;
    return this;
  }

   /**
   * If true, the account is not allowed to request money transfers.
   * @return transfersBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getTransfersBlocked() {
    return transfersBlocked;
  }

  public void setTransfersBlocked(Boolean transfersBlocked) {
    this.transfersBlocked = transfersBlocked;
  }


  public TradeAccount accountBlocked(Boolean accountBlocked) {
    this.accountBlocked = accountBlocked;
    return this;
  }

   /**
   * If true, the account activity by user is prohibited.
   * @return accountBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getAccountBlocked() {
    return accountBlocked;
  }

  public void setAccountBlocked(Boolean accountBlocked) {
    this.accountBlocked = accountBlocked;
  }


  public TradeAccount createdAt(String createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Timestamp this account was created at
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  public String getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }


  public TradeAccount tradeSuspendedByUser(Boolean tradeSuspendedByUser) {
    this.tradeSuspendedByUser = tradeSuspendedByUser;
    return this;
  }

   /**
   * If true, the account is not allowed to place orders.
   * @return tradeSuspendedByUser
  **/
  @javax.annotation.Nullable
  public Boolean getTradeSuspendedByUser() {
    return tradeSuspendedByUser;
  }

  public void setTradeSuspendedByUser(Boolean tradeSuspendedByUser) {
    this.tradeSuspendedByUser = tradeSuspendedByUser;
  }


  public TradeAccount multiplier(BigDecimal multiplier) {
    this.multiplier = multiplier;
    return this;
  }

   /**
   * “1”, “2”, \&quot;3\&quot;, or \&quot;4\&quot;
   * @return multiplier
  **/
  @javax.annotation.Nullable
  public BigDecimal getMultiplier() {
    return multiplier;
  }

  public void setMultiplier(BigDecimal multiplier) {
    this.multiplier = multiplier;
  }


  public TradeAccount shortingEnabled(Boolean shortingEnabled) {
    this.shortingEnabled = shortingEnabled;
    return this;
  }

   /**
   * Flag to denote whether or not the account is permitted to short
   * @return shortingEnabled
  **/
  @javax.annotation.Nullable
  public Boolean getShortingEnabled() {
    return shortingEnabled;
  }

  public void setShortingEnabled(Boolean shortingEnabled) {
    this.shortingEnabled = shortingEnabled;
  }


  public TradeAccount equity(BigDecimal equity) {
    this.equity = equity;
    return this;
  }

   /**
   * cash + long_market_value + short_market_value
   * @return equity
  **/
  @javax.annotation.Nonnull
  public BigDecimal getEquity() {
    return equity;
  }

  public void setEquity(BigDecimal equity) {
    this.equity = equity;
  }


  public TradeAccount lastEquity(BigDecimal lastEquity) {
    this.lastEquity = lastEquity;
    return this;
  }

   /**
   * Equity as of previous trading day at 16:00:00 ET
   * @return lastEquity
  **/
  @javax.annotation.Nonnull
  public BigDecimal getLastEquity() {
    return lastEquity;
  }

  public void setLastEquity(BigDecimal lastEquity) {
    this.lastEquity = lastEquity;
  }


  public TradeAccount longMarketValue(BigDecimal longMarketValue) {
    this.longMarketValue = longMarketValue;
    return this;
  }

   /**
   * Real-time MtM value of all long positions held in the account
   * @return longMarketValue
  **/
  @javax.annotation.Nullable
  public BigDecimal getLongMarketValue() {
    return longMarketValue;
  }

  public void setLongMarketValue(BigDecimal longMarketValue) {
    this.longMarketValue = longMarketValue;
  }


  public TradeAccount shortMarketValue(BigDecimal shortMarketValue) {
    this.shortMarketValue = shortMarketValue;
    return this;
  }

   /**
   * Real-time MtM value of all short positions held in the account
   * @return shortMarketValue
  **/
  @javax.annotation.Nullable
  public BigDecimal getShortMarketValue() {
    return shortMarketValue;
  }

  public void setShortMarketValue(BigDecimal shortMarketValue) {
    this.shortMarketValue = shortMarketValue;
  }


  public TradeAccount initialMargin(BigDecimal initialMargin) {
    this.initialMargin = initialMargin;
    return this;
  }

   /**
   * Reg T initial margin requirement (continuously updated value)
   * @return initialMargin
  **/
  @javax.annotation.Nullable
  public BigDecimal getInitialMargin() {
    return initialMargin;
  }

  public void setInitialMargin(BigDecimal initialMargin) {
    this.initialMargin = initialMargin;
  }


  public TradeAccount maintenanceMargin(BigDecimal maintenanceMargin) {
    this.maintenanceMargin = maintenanceMargin;
    return this;
  }

   /**
   * Maintenance margin requirement (continuously updated value)
   * @return maintenanceMargin
  **/
  @javax.annotation.Nullable
  public BigDecimal getMaintenanceMargin() {
    return maintenanceMargin;
  }

  public void setMaintenanceMargin(BigDecimal maintenanceMargin) {
    this.maintenanceMargin = maintenanceMargin;
  }


  public TradeAccount lastMaintenanceMargin(BigDecimal lastMaintenanceMargin) {
    this.lastMaintenanceMargin = lastMaintenanceMargin;
    return this;
  }

   /**
   * Maintenance margin requirement on the previous trading day
   * @return lastMaintenanceMargin
  **/
  @javax.annotation.Nullable
  public BigDecimal getLastMaintenanceMargin() {
    return lastMaintenanceMargin;
  }

  public void setLastMaintenanceMargin(BigDecimal lastMaintenanceMargin) {
    this.lastMaintenanceMargin = lastMaintenanceMargin;
  }


  public TradeAccount sma(BigDecimal sma) {
    this.sma = sma;
    return this;
  }

   /**
   * Value of Special Memorandum Account (will be used at a later date to provide additional buying_power)
   * @return sma
  **/
  @javax.annotation.Nullable
  public BigDecimal getSma() {
    return sma;
  }

  public void setSma(BigDecimal sma) {
    this.sma = sma;
  }


  public TradeAccount daytradeCount(Integer daytradeCount) {
    this.daytradeCount = daytradeCount;
    return this;
  }

   /**
   * The current number of daytrades that have been made in the last 5 trading days (inclusive of today)
   * @return daytradeCount
  **/
  @javax.annotation.Nullable
  public Integer getDaytradeCount() {
    return daytradeCount;
  }

  public void setDaytradeCount(Integer daytradeCount) {
    this.daytradeCount = daytradeCount;
  }


  public TradeAccount previousClose(String previousClose) {
    this.previousClose = previousClose;
    return this;
  }

   /**
   * Previous sessions close time
   * @return previousClose
  **/
  @javax.annotation.Nullable
  public String getPreviousClose() {
    return previousClose;
  }

  public void setPreviousClose(String previousClose) {
    this.previousClose = previousClose;
  }


  public TradeAccount lastLongMarketValue(String lastLongMarketValue) {
    this.lastLongMarketValue = lastLongMarketValue;
    return this;
  }

   /**
   * Value of all long positions as of previous trading day at 16:00:00 ET
   * @return lastLongMarketValue
  **/
  @javax.annotation.Nullable
  public String getLastLongMarketValue() {
    return lastLongMarketValue;
  }

  public void setLastLongMarketValue(String lastLongMarketValue) {
    this.lastLongMarketValue = lastLongMarketValue;
  }


  public TradeAccount lastShortMarketValue(String lastShortMarketValue) {
    this.lastShortMarketValue = lastShortMarketValue;
    return this;
  }

   /**
   * Value of all short positions as of previous trading day at 16:00:00 ET
   * @return lastShortMarketValue
  **/
  @javax.annotation.Nullable
  public String getLastShortMarketValue() {
    return lastShortMarketValue;
  }

  public void setLastShortMarketValue(String lastShortMarketValue) {
    this.lastShortMarketValue = lastShortMarketValue;
  }


  public TradeAccount lastCash(String lastCash) {
    this.lastCash = lastCash;
    return this;
  }

   /**
   * Value of all cash as of previous trading day at 16:00:00 ET
   * @return lastCash
  **/
  @javax.annotation.Nullable
  public String getLastCash() {
    return lastCash;
  }

  public void setLastCash(String lastCash) {
    this.lastCash = lastCash;
  }


  public TradeAccount lastInitialMargin(String lastInitialMargin) {
    this.lastInitialMargin = lastInitialMargin;
    return this;
  }

   /**
   * Value of Reg T margin as of previous trading day at 16:00:00 ET
   * @return lastInitialMargin
  **/
  @javax.annotation.Nullable
  public String getLastInitialMargin() {
    return lastInitialMargin;
  }

  public void setLastInitialMargin(String lastInitialMargin) {
    this.lastInitialMargin = lastInitialMargin;
  }


  public TradeAccount lastRegtBuyingPower(String lastRegtBuyingPower) {
    this.lastRegtBuyingPower = lastRegtBuyingPower;
    return this;
  }

   /**
   * Value of Reg T buying power as of previous trading day at 16:00:00 ET
   * @return lastRegtBuyingPower
  **/
  @javax.annotation.Nullable
  public String getLastRegtBuyingPower() {
    return lastRegtBuyingPower;
  }

  public void setLastRegtBuyingPower(String lastRegtBuyingPower) {
    this.lastRegtBuyingPower = lastRegtBuyingPower;
  }


  public TradeAccount lastDaytradingBuyingPower(String lastDaytradingBuyingPower) {
    this.lastDaytradingBuyingPower = lastDaytradingBuyingPower;
    return this;
  }

   /**
   * Value of daytrading buying power as of previous trading day at 16:00:00 ET
   * @return lastDaytradingBuyingPower
  **/
  @javax.annotation.Nullable
  public String getLastDaytradingBuyingPower() {
    return lastDaytradingBuyingPower;
  }

  public void setLastDaytradingBuyingPower(String lastDaytradingBuyingPower) {
    this.lastDaytradingBuyingPower = lastDaytradingBuyingPower;
  }


  public TradeAccount lastOptionsBuyingPower(String lastOptionsBuyingPower) {
    this.lastOptionsBuyingPower = lastOptionsBuyingPower;
    return this;
  }

   /**
   * Value of option buying power as of previous trading day at 16:00:00 ET
   * @return lastOptionsBuyingPower
  **/
  @javax.annotation.Nullable
  public String getLastOptionsBuyingPower() {
    return lastOptionsBuyingPower;
  }

  public void setLastOptionsBuyingPower(String lastOptionsBuyingPower) {
    this.lastOptionsBuyingPower = lastOptionsBuyingPower;
  }


  public TradeAccount lastBuyingPower(String lastBuyingPower) {
    this.lastBuyingPower = lastBuyingPower;
    return this;
  }

   /**
   * Value of buying_power as of previous trading day at 16:00:00 ET
   * @return lastBuyingPower
  **/
  @javax.annotation.Nullable
  public String getLastBuyingPower() {
    return lastBuyingPower;
  }

  public void setLastBuyingPower(String lastBuyingPower) {
    this.lastBuyingPower = lastBuyingPower;
  }


  public TradeAccount lastDaytradeCount(Integer lastDaytradeCount) {
    this.lastDaytradeCount = lastDaytradeCount;
    return this;
  }

   /**
   * Value of daytrade count as of previous trading day at 16:00:00 ET
   * @return lastDaytradeCount
  **/
  @javax.annotation.Nullable
  public Integer getLastDaytradeCount() {
    return lastDaytradeCount;
  }

  public void setLastDaytradeCount(Integer lastDaytradeCount) {
    this.lastDaytradeCount = lastDaytradeCount;
  }


  public TradeAccount clearingBroker(String clearingBroker) {
    this.clearingBroker = clearingBroker;
    return this;
  }

   /**
   * Clearing broker
   * @return clearingBroker
  **/
  @javax.annotation.Nullable
  public String getClearingBroker() {
    return clearingBroker;
  }

  public void setClearingBroker(String clearingBroker) {
    this.clearingBroker = clearingBroker;
  }


  public TradeAccount optionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
    this.optionsApprovedLevel = optionsApprovedLevel;
    return this;
  }

   /**
   * The option trading level that was approved for this account. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   * @return optionsApprovedLevel
  **/
  @javax.annotation.Nullable
  public OptionsApprovedLevelEnum getOptionsApprovedLevel() {
    return optionsApprovedLevel;
  }

  public void setOptionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
    this.optionsApprovedLevel = optionsApprovedLevel;
  }


  public TradeAccount optionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
    this.optionsTradingLevel = optionsTradingLevel;
    return this;
  }

   /**
   * The effective option trading level of the account. This is the minimum between account options_approved_level and account configurations max_options_trading_level. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   * @return optionsTradingLevel
  **/
  @javax.annotation.Nullable
  public OptionsTradingLevelEnum getOptionsTradingLevel() {
    return optionsTradingLevel;
  }

  public void setOptionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
    this.optionsTradingLevel = optionsTradingLevel;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TradeAccount tradeAccount = (TradeAccount) o;
    return Objects.equals(this.id, tradeAccount.id) &&
        Objects.equals(this.accountNumber, tradeAccount.accountNumber) &&
        Objects.equals(this.status, tradeAccount.status) &&
        Objects.equals(this.currency, tradeAccount.currency) &&
        Objects.equals(this.buyingPower, tradeAccount.buyingPower) &&
        Objects.equals(this.regtBuyingPower, tradeAccount.regtBuyingPower) &&
        Objects.equals(this.daytradingBuyingPower, tradeAccount.daytradingBuyingPower) &&
        Objects.equals(this.optionsBuyingPower, tradeAccount.optionsBuyingPower) &&
        Objects.equals(this.cash, tradeAccount.cash) &&
        Objects.equals(this.cashWithdrawable, tradeAccount.cashWithdrawable) &&
        Objects.equals(this.cashTransferable, tradeAccount.cashTransferable) &&
        Objects.equals(this.pendingTransferOut, tradeAccount.pendingTransferOut) &&
        Objects.equals(this.portfolioValue, tradeAccount.portfolioValue) &&
        Objects.equals(this.patternDayTrader, tradeAccount.patternDayTrader) &&
        Objects.equals(this.tradingBlocked, tradeAccount.tradingBlocked) &&
        Objects.equals(this.transfersBlocked, tradeAccount.transfersBlocked) &&
        Objects.equals(this.accountBlocked, tradeAccount.accountBlocked) &&
        Objects.equals(this.createdAt, tradeAccount.createdAt) &&
        Objects.equals(this.tradeSuspendedByUser, tradeAccount.tradeSuspendedByUser) &&
        Objects.equals(this.multiplier, tradeAccount.multiplier) &&
        Objects.equals(this.shortingEnabled, tradeAccount.shortingEnabled) &&
        Objects.equals(this.equity, tradeAccount.equity) &&
        Objects.equals(this.lastEquity, tradeAccount.lastEquity) &&
        Objects.equals(this.longMarketValue, tradeAccount.longMarketValue) &&
        Objects.equals(this.shortMarketValue, tradeAccount.shortMarketValue) &&
        Objects.equals(this.initialMargin, tradeAccount.initialMargin) &&
        Objects.equals(this.maintenanceMargin, tradeAccount.maintenanceMargin) &&
        Objects.equals(this.lastMaintenanceMargin, tradeAccount.lastMaintenanceMargin) &&
        Objects.equals(this.sma, tradeAccount.sma) &&
        Objects.equals(this.daytradeCount, tradeAccount.daytradeCount) &&
        Objects.equals(this.previousClose, tradeAccount.previousClose) &&
        Objects.equals(this.lastLongMarketValue, tradeAccount.lastLongMarketValue) &&
        Objects.equals(this.lastShortMarketValue, tradeAccount.lastShortMarketValue) &&
        Objects.equals(this.lastCash, tradeAccount.lastCash) &&
        Objects.equals(this.lastInitialMargin, tradeAccount.lastInitialMargin) &&
        Objects.equals(this.lastRegtBuyingPower, tradeAccount.lastRegtBuyingPower) &&
        Objects.equals(this.lastDaytradingBuyingPower, tradeAccount.lastDaytradingBuyingPower) &&
        Objects.equals(this.lastOptionsBuyingPower, tradeAccount.lastOptionsBuyingPower) &&
        Objects.equals(this.lastBuyingPower, tradeAccount.lastBuyingPower) &&
        Objects.equals(this.lastDaytradeCount, tradeAccount.lastDaytradeCount) &&
        Objects.equals(this.clearingBroker, tradeAccount.clearingBroker) &&
        Objects.equals(this.optionsApprovedLevel, tradeAccount.optionsApprovedLevel) &&
        Objects.equals(this.optionsTradingLevel, tradeAccount.optionsTradingLevel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountNumber, status, currency, buyingPower, regtBuyingPower, daytradingBuyingPower, optionsBuyingPower, cash, cashWithdrawable, cashTransferable, pendingTransferOut, portfolioValue, patternDayTrader, tradingBlocked, transfersBlocked, accountBlocked, createdAt, tradeSuspendedByUser, multiplier, shortingEnabled, equity, lastEquity, longMarketValue, shortMarketValue, initialMargin, maintenanceMargin, lastMaintenanceMargin, sma, daytradeCount, previousClose, lastLongMarketValue, lastShortMarketValue, lastCash, lastInitialMargin, lastRegtBuyingPower, lastDaytradingBuyingPower, lastOptionsBuyingPower, lastBuyingPower, lastDaytradeCount, clearingBroker, optionsApprovedLevel, optionsTradingLevel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TradeAccount {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    buyingPower: ").append(toIndentedString(buyingPower)).append("\n");
    sb.append("    regtBuyingPower: ").append(toIndentedString(regtBuyingPower)).append("\n");
    sb.append("    daytradingBuyingPower: ").append(toIndentedString(daytradingBuyingPower)).append("\n");
    sb.append("    optionsBuyingPower: ").append(toIndentedString(optionsBuyingPower)).append("\n");
    sb.append("    cash: ").append(toIndentedString(cash)).append("\n");
    sb.append("    cashWithdrawable: ").append(toIndentedString(cashWithdrawable)).append("\n");
    sb.append("    cashTransferable: ").append(toIndentedString(cashTransferable)).append("\n");
    sb.append("    pendingTransferOut: ").append(toIndentedString(pendingTransferOut)).append("\n");
    sb.append("    portfolioValue: ").append(toIndentedString(portfolioValue)).append("\n");
    sb.append("    patternDayTrader: ").append(toIndentedString(patternDayTrader)).append("\n");
    sb.append("    tradingBlocked: ").append(toIndentedString(tradingBlocked)).append("\n");
    sb.append("    transfersBlocked: ").append(toIndentedString(transfersBlocked)).append("\n");
    sb.append("    accountBlocked: ").append(toIndentedString(accountBlocked)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    tradeSuspendedByUser: ").append(toIndentedString(tradeSuspendedByUser)).append("\n");
    sb.append("    multiplier: ").append(toIndentedString(multiplier)).append("\n");
    sb.append("    shortingEnabled: ").append(toIndentedString(shortingEnabled)).append("\n");
    sb.append("    equity: ").append(toIndentedString(equity)).append("\n");
    sb.append("    lastEquity: ").append(toIndentedString(lastEquity)).append("\n");
    sb.append("    longMarketValue: ").append(toIndentedString(longMarketValue)).append("\n");
    sb.append("    shortMarketValue: ").append(toIndentedString(shortMarketValue)).append("\n");
    sb.append("    initialMargin: ").append(toIndentedString(initialMargin)).append("\n");
    sb.append("    maintenanceMargin: ").append(toIndentedString(maintenanceMargin)).append("\n");
    sb.append("    lastMaintenanceMargin: ").append(toIndentedString(lastMaintenanceMargin)).append("\n");
    sb.append("    sma: ").append(toIndentedString(sma)).append("\n");
    sb.append("    daytradeCount: ").append(toIndentedString(daytradeCount)).append("\n");
    sb.append("    previousClose: ").append(toIndentedString(previousClose)).append("\n");
    sb.append("    lastLongMarketValue: ").append(toIndentedString(lastLongMarketValue)).append("\n");
    sb.append("    lastShortMarketValue: ").append(toIndentedString(lastShortMarketValue)).append("\n");
    sb.append("    lastCash: ").append(toIndentedString(lastCash)).append("\n");
    sb.append("    lastInitialMargin: ").append(toIndentedString(lastInitialMargin)).append("\n");
    sb.append("    lastRegtBuyingPower: ").append(toIndentedString(lastRegtBuyingPower)).append("\n");
    sb.append("    lastDaytradingBuyingPower: ").append(toIndentedString(lastDaytradingBuyingPower)).append("\n");
    sb.append("    lastOptionsBuyingPower: ").append(toIndentedString(lastOptionsBuyingPower)).append("\n");
    sb.append("    lastBuyingPower: ").append(toIndentedString(lastBuyingPower)).append("\n");
    sb.append("    lastDaytradeCount: ").append(toIndentedString(lastDaytradeCount)).append("\n");
    sb.append("    clearingBroker: ").append(toIndentedString(clearingBroker)).append("\n");
    sb.append("    optionsApprovedLevel: ").append(toIndentedString(optionsApprovedLevel)).append("\n");
    sb.append("    optionsTradingLevel: ").append(toIndentedString(optionsTradingLevel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_number");
    openapiFields.add("status");
    openapiFields.add("currency");
    openapiFields.add("buying_power");
    openapiFields.add("regt_buying_power");
    openapiFields.add("daytrading_buying_power");
    openapiFields.add("options_buying_power");
    openapiFields.add("cash");
    openapiFields.add("cash_withdrawable");
    openapiFields.add("cash_transferable");
    openapiFields.add("pending_transfer_out");
    openapiFields.add("portfolio_value");
    openapiFields.add("pattern_day_trader");
    openapiFields.add("trading_blocked");
    openapiFields.add("transfers_blocked");
    openapiFields.add("account_blocked");
    openapiFields.add("created_at");
    openapiFields.add("trade_suspended_by_user");
    openapiFields.add("multiplier");
    openapiFields.add("shorting_enabled");
    openapiFields.add("equity");
    openapiFields.add("last_equity");
    openapiFields.add("long_market_value");
    openapiFields.add("short_market_value");
    openapiFields.add("initial_margin");
    openapiFields.add("maintenance_margin");
    openapiFields.add("last_maintenance_margin");
    openapiFields.add("sma");
    openapiFields.add("daytrade_count");
    openapiFields.add("previous_close");
    openapiFields.add("last_long_market_value");
    openapiFields.add("last_short_market_value");
    openapiFields.add("last_cash");
    openapiFields.add("last_initial_margin");
    openapiFields.add("last_regt_buying_power");
    openapiFields.add("last_daytrading_buying_power");
    openapiFields.add("last_options_buying_power");
    openapiFields.add("last_buying_power");
    openapiFields.add("last_daytrade_count");
    openapiFields.add("clearing_broker");
    openapiFields.add("options_approved_level");
    openapiFields.add("options_trading_level");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("account_number");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("currency");
    openapiRequiredFields.add("buying_power");
    openapiRequiredFields.add("cash");
    openapiRequiredFields.add("created_at");
    openapiRequiredFields.add("equity");
    openapiRequiredFields.add("last_equity");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!TradeAccount.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in TradeAccount is not found in the empty JSON string", TradeAccount.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!TradeAccount.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TradeAccount` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : TradeAccount.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_number") != null && !jsonObj.get("account_number").isJsonNull()) && !jsonObj.get("account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number").toString()));
      }
      // validate the required field `status`
      AccountStatus.validateJsonElement(jsonObj.get("status"));
      if (!jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if (!jsonObj.get("buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("buying_power").toString()));
      }
      if ((jsonObj.get("regt_buying_power") != null && !jsonObj.get("regt_buying_power").isJsonNull()) && !jsonObj.get("regt_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `regt_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("regt_buying_power").toString()));
      }
      if ((jsonObj.get("daytrading_buying_power") != null && !jsonObj.get("daytrading_buying_power").isJsonNull()) && !jsonObj.get("daytrading_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `daytrading_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("daytrading_buying_power").toString()));
      }
      if ((jsonObj.get("options_buying_power") != null && !jsonObj.get("options_buying_power").isJsonNull()) && !jsonObj.get("options_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `options_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("options_buying_power").toString()));
      }
      if (!jsonObj.get("cash").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cash` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cash").toString()));
      }
      if ((jsonObj.get("cash_withdrawable") != null && !jsonObj.get("cash_withdrawable").isJsonNull()) && !jsonObj.get("cash_withdrawable").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cash_withdrawable` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cash_withdrawable").toString()));
      }
      if ((jsonObj.get("cash_transferable") != null && !jsonObj.get("cash_transferable").isJsonNull()) && !jsonObj.get("cash_transferable").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cash_transferable` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cash_transferable").toString()));
      }
      if ((jsonObj.get("pending_transfer_out") != null && !jsonObj.get("pending_transfer_out").isJsonNull()) && !jsonObj.get("pending_transfer_out").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `pending_transfer_out` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pending_transfer_out").toString()));
      }
      if ((jsonObj.get("portfolio_value") != null && !jsonObj.get("portfolio_value").isJsonNull()) && !jsonObj.get("portfolio_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `portfolio_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("portfolio_value").toString()));
      }
      if (!jsonObj.get("created_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `created_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("created_at").toString()));
      }
      if ((jsonObj.get("multiplier") != null && !jsonObj.get("multiplier").isJsonNull()) && !jsonObj.get("multiplier").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `multiplier` to be a primitive type in the JSON string but got `%s`", jsonObj.get("multiplier").toString()));
      }
      if (!jsonObj.get("equity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("equity").toString()));
      }
      if (!jsonObj.get("last_equity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_equity").toString()));
      }
      if ((jsonObj.get("long_market_value") != null && !jsonObj.get("long_market_value").isJsonNull()) && !jsonObj.get("long_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `long_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("long_market_value").toString()));
      }
      if ((jsonObj.get("short_market_value") != null && !jsonObj.get("short_market_value").isJsonNull()) && !jsonObj.get("short_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `short_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("short_market_value").toString()));
      }
      if ((jsonObj.get("initial_margin") != null && !jsonObj.get("initial_margin").isJsonNull()) && !jsonObj.get("initial_margin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `initial_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("initial_margin").toString()));
      }
      if ((jsonObj.get("maintenance_margin") != null && !jsonObj.get("maintenance_margin").isJsonNull()) && !jsonObj.get("maintenance_margin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("maintenance_margin").toString()));
      }
      if ((jsonObj.get("last_maintenance_margin") != null && !jsonObj.get("last_maintenance_margin").isJsonNull()) && !jsonObj.get("last_maintenance_margin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_maintenance_margin").toString()));
      }
      if ((jsonObj.get("sma") != null && !jsonObj.get("sma").isJsonNull()) && !jsonObj.get("sma").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sma` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sma").toString()));
      }
      if ((jsonObj.get("previous_close") != null && !jsonObj.get("previous_close").isJsonNull()) && !jsonObj.get("previous_close").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `previous_close` to be a primitive type in the JSON string but got `%s`", jsonObj.get("previous_close").toString()));
      }
      if ((jsonObj.get("last_long_market_value") != null && !jsonObj.get("last_long_market_value").isJsonNull()) && !jsonObj.get("last_long_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_long_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_long_market_value").toString()));
      }
      if ((jsonObj.get("last_short_market_value") != null && !jsonObj.get("last_short_market_value").isJsonNull()) && !jsonObj.get("last_short_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_short_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_short_market_value").toString()));
      }
      if ((jsonObj.get("last_cash") != null && !jsonObj.get("last_cash").isJsonNull()) && !jsonObj.get("last_cash").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_cash` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_cash").toString()));
      }
      if ((jsonObj.get("last_initial_margin") != null && !jsonObj.get("last_initial_margin").isJsonNull()) && !jsonObj.get("last_initial_margin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_initial_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_initial_margin").toString()));
      }
      if ((jsonObj.get("last_regt_buying_power") != null && !jsonObj.get("last_regt_buying_power").isJsonNull()) && !jsonObj.get("last_regt_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_regt_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_regt_buying_power").toString()));
      }
      if ((jsonObj.get("last_daytrading_buying_power") != null && !jsonObj.get("last_daytrading_buying_power").isJsonNull()) && !jsonObj.get("last_daytrading_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_daytrading_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_daytrading_buying_power").toString()));
      }
      if ((jsonObj.get("last_options_buying_power") != null && !jsonObj.get("last_options_buying_power").isJsonNull()) && !jsonObj.get("last_options_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_options_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_options_buying_power").toString()));
      }
      if ((jsonObj.get("last_buying_power") != null && !jsonObj.get("last_buying_power").isJsonNull()) && !jsonObj.get("last_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_buying_power").toString()));
      }
      if ((jsonObj.get("clearing_broker") != null && !jsonObj.get("clearing_broker").isJsonNull()) && !jsonObj.get("clearing_broker").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `clearing_broker` to be a primitive type in the JSON string but got `%s`", jsonObj.get("clearing_broker").toString()));
      }
      // validate the optional field `options_approved_level`
      if (jsonObj.get("options_approved_level") != null && !jsonObj.get("options_approved_level").isJsonNull()) {
        OptionsApprovedLevelEnum.validateJsonElement(jsonObj.get("options_approved_level"));
      }
      // validate the optional field `options_trading_level`
      if (jsonObj.get("options_trading_level") != null && !jsonObj.get("options_trading_level").isJsonNull()) {
        OptionsTradingLevelEnum.validateJsonElement(jsonObj.get("options_trading_level"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TradeAccount.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TradeAccount' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TradeAccount> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TradeAccount.class));

       return (TypeAdapter<T>) new TypeAdapter<TradeAccount>() {
           @Override
           public void write(JsonWriter out, TradeAccount value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TradeAccount read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TradeAccount given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TradeAccount
  * @throws IOException if the JSON string is invalid with respect to TradeAccount
  */
  public static TradeAccount fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TradeAccount.class);
  }

 /**
  * Convert an instance of TradeAccount to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

