/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Required if &#x60;tax_id&#x60; is set.  An Enum of the various kinds of Tax ID formats Alpaca supports.  Possible Values are:   - **USA_SSN** USA Social Security Number  - **ARG_AR_CUIT** Argentina CUIT  - **AUS_TFN** Australian Tax File Number  - **AUS_ABN** Australian Business Number  - **BOL_NIT** Bolivia NIT  - **BRA_CPF** Brazil CPF  - **CHL_RUT** Chile RUT  - **COL_NIT** Colombia NIT  - **CRI_NITE** Costa Rica NITE  - **DEU_TAX_ID** Germany Tax ID (Identifikationsnummer)  - **DOM_RNC** Dominican Republic RNC  - **ECU_RUC** Ecuador RUC  - **FRA_SPI** France SPI (Reference Tax Number)  - **GBR_UTR** UK UTR (Unique Taxpayer Reference)  - **GBR_NINO** UK NINO (National Insurance Number)  - **GTM_NIT** Guatemala NIT  - **HND_RTN** Honduras RTN  - **HUN_TIN** Hungary TIN Number  - **IDN_KTP** Indonesia KTP  - **IND_PAN** India PAN Number  - **ISR_TAX_ID** Israel Tax ID (Teudat Zehut)  - **ITA_TAX_ID** Italy Tax ID (Codice Fiscale)  - **JPN_TAX_ID** Japan Tax ID (Koijin Bango)  - **MEX_RFC** Mexico RFC  - **NIC_RUC** Nicaragua RUC  - **NLD_TIN** Netherlands TIN Number  - **PAN_RUC** Panama RUC  - **PER_RUC** Peru RUC  - **PRY_RUC** Paraguay RUC  - **SGP_NRIC** Singapore NRIC  - **SGP_FIN** Singapore FIN  - **SGP_ASGD** Singapore ASGD  - **SGP_ITR** Singapore ITR  - **SLV_NIT** El Salvador NIT  - **SWE_TAX_ID** Sweden Tax ID (Personnummer)  - **URY_RUT** Uruguay RUT  - **VEN_RIF** Venezuela RIF  - **NATIONAL_ID** National ID number, if a tax ID number is not available  - **PASSPORT** Passport number, if a tax ID number is not available  - **PERMANENT_RESIDENT** Permanent resident number, if a tax ID number is not available  - **DRIVER_LICENSE** Drivers license number, if a tax ID number is not available  - **OTHER_GOV_ID** Other government issued identifier, if a tax ID number is not available  - **NOT_SPECIFIED** Other Tax IDs
 */
@JsonAdapter(TaxIdType.Adapter.class)
public enum TaxIdType {
  
  USA_SSN("USA_SSN"),
  
  ARG_AG_CUIT("ARG_AG_CUIT"),
  
  AUS_TFN("AUS_TFN"),
  
  AUS_ABN("AUS_ABN"),
  
  BOL_NIT("BOL_NIT"),
  
  BRA_CPF("BRA_CPF"),
  
  CHL_RUT("CHL_RUT"),
  
  COL_NIT("COL_NIT"),
  
  CRI_NITE("CRI_NITE"),
  
  DEU_TAX_ID("DEU_TAX_ID"),
  
  DOM_RNC("DOM_RNC"),
  
  ECU_RUC("ECU_RUC"),
  
  FRA_SPI("FRA_SPI"),
  
  GBR_UTR("GBR_UTR"),
  
  GBR_NINO("GBR_NINO"),
  
  GTM_NIT("GTM_NIT"),
  
  HND_RTN("HND_RTN"),
  
  HUN_TIN("HUN_TIN"),
  
  IDN_KTP("IDN_KTP"),
  
  IND_PAN("IND_PAN"),
  
  ISR_TAX_ID("ISR_TAX_ID"),
  
  ITA_TAX_ID("ITA_TAX_ID"),
  
  JPN_TAX_ID("JPN_TAX_ID"),
  
  MEX_RFC("MEX_RFC"),
  
  NIC_RUC("NIC_RUC"),
  
  NLD_TIN("NLD_TIN"),
  
  PAN_RUC("PAN_RUC"),
  
  PER_RUC("PER_RUC"),
  
  PRY_RUC("PRY_RUC"),
  
  SGP_NRIC("SGP_NRIC"),
  
  SGP_FIN("SGP_FIN"),
  
  SGP_ASGD("SGP_ASGD"),
  
  SGP_ITR("SGP_ITR"),
  
  SLV_NIT("SLV_NIT"),
  
  SWE_TAX_ID("SWE_TAX_ID"),
  
  URY_RUT("URY_RUT"),
  
  VEN_RIF("VEN_RIF"),
  
  NATIONAL_ID("NATIONAL_ID"),
  
  PASSPORT("PASSPORT"),
  
  PERMANENT_RESIDENT("PERMANENT_RESIDENT"),
  
  DRIVER_LICENSE("DRIVER_LICENSE"),
  
  OTHER_GOV_ID("OTHER_GOV_ID"),
  
  NOT_SPECIFIED("NOT_SPECIFIED");

  private String value;

  TaxIdType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static TaxIdType fromValue(String value) {
    for (TaxIdType b : TaxIdType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<TaxIdType> {
    @Override
    public void write(final JsonWriter jsonWriter, final TaxIdType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public TaxIdType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return TaxIdType.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    TaxIdType.fromValue(value);
  }
}

