/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionBelongsTo;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionCategory;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionContextTransactionCancelContext;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionCreatedBy;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionLegacyNote;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionLiquidation;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionTransactionCancel;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionType;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionVisibility;



import java.io.IOException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class SubscribeToAdminActionSSE200ResponseInner extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(SubscribeToAdminActionSSE200ResponseInner.class.getName());

    public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
        @SuppressWarnings("unchecked")
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SubscribeToAdminActionSSE200ResponseInner.class.isAssignableFrom(type.getRawType())) {
                return null; // this class only serializes 'SubscribeToAdminActionSSE200ResponseInner' and its subtypes
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<AdminActionLegacyNote> adapterAdminActionLegacyNote = gson.getDelegateAdapter(this, TypeToken.get(AdminActionLegacyNote.class));
            final TypeAdapter<AdminActionLiquidation> adapterAdminActionLiquidation = gson.getDelegateAdapter(this, TypeToken.get(AdminActionLiquidation.class));
            final TypeAdapter<AdminActionTransactionCancel> adapterAdminActionTransactionCancel = gson.getDelegateAdapter(this, TypeToken.get(AdminActionTransactionCancel.class));

            return (TypeAdapter<T>) new TypeAdapter<SubscribeToAdminActionSSE200ResponseInner>() {
                @Override
                public void write(JsonWriter out, SubscribeToAdminActionSSE200ResponseInner value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }

                    // check if the actual instance is of the type `AdminActionLegacyNote`
                    if (value.getActualInstance() instanceof AdminActionLegacyNote) {
                      JsonElement element = adapterAdminActionLegacyNote.toJsonTree((AdminActionLegacyNote)value.getActualInstance());
                      elementAdapter.write(out, element);
                      return;
                    }
                    // check if the actual instance is of the type `AdminActionLiquidation`
                    if (value.getActualInstance() instanceof AdminActionLiquidation) {
                      JsonElement element = adapterAdminActionLiquidation.toJsonTree((AdminActionLiquidation)value.getActualInstance());
                      elementAdapter.write(out, element);
                      return;
                    }
                    // check if the actual instance is of the type `AdminActionTransactionCancel`
                    if (value.getActualInstance() instanceof AdminActionTransactionCancel) {
                      JsonElement element = adapterAdminActionTransactionCancel.toJsonTree((AdminActionTransactionCancel)value.getActualInstance());
                      elementAdapter.write(out, element);
                      return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: AdminActionLegacyNote, AdminActionLiquidation, AdminActionTransactionCancel");
                }

                @Override
                public SubscribeToAdminActionSSE200ResponseInner read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = elementAdapter.read(in);

                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<>();
                    TypeAdapter actualAdapter = elementAdapter;

                    // deserialize AdminActionLegacyNote
                    try {
                      // validate the JSON object to see if any exception is thrown
                      AdminActionLegacyNote.validateJsonElement(jsonElement);
                      actualAdapter = adapterAdminActionLegacyNote;
                      match++;
                      log.log(Level.FINER, "Input data matches schema 'AdminActionLegacyNote'");
                    } catch (Exception e) {
                      // deserialization failed, continue
                      errorMessages.add(String.format("Deserialization for AdminActionLegacyNote failed with `%s`.", e.getMessage()));
                      log.log(Level.FINER, "Input data does not match schema 'AdminActionLegacyNote'", e);
                    }
                    // deserialize AdminActionLiquidation
                    try {
                      // validate the JSON object to see if any exception is thrown
                      AdminActionLiquidation.validateJsonElement(jsonElement);
                      actualAdapter = adapterAdminActionLiquidation;
                      match++;
                      log.log(Level.FINER, "Input data matches schema 'AdminActionLiquidation'");
                    } catch (Exception e) {
                      // deserialization failed, continue
                      errorMessages.add(String.format("Deserialization for AdminActionLiquidation failed with `%s`.", e.getMessage()));
                      log.log(Level.FINER, "Input data does not match schema 'AdminActionLiquidation'", e);
                    }
                    // deserialize AdminActionTransactionCancel
                    try {
                      // validate the JSON object to see if any exception is thrown
                      AdminActionTransactionCancel.validateJsonElement(jsonElement);
                      actualAdapter = adapterAdminActionTransactionCancel;
                      match++;
                      log.log(Level.FINER, "Input data matches schema 'AdminActionTransactionCancel'");
                    } catch (Exception e) {
                      // deserialization failed, continue
                      errorMessages.add(String.format("Deserialization for AdminActionTransactionCancel failed with `%s`.", e.getMessage()));
                      log.log(Level.FINER, "Input data does not match schema 'AdminActionTransactionCancel'", e);
                    }

                    if (match == 1) {
                        SubscribeToAdminActionSSE200ResponseInner ret = new SubscribeToAdminActionSSE200ResponseInner();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }

                    throw new IOException(String.format("Failed deserialization for SubscribeToAdminActionSSE200ResponseInner: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, Class<?>> schemas = new HashMap<String, Class<?>>();

    public SubscribeToAdminActionSSE200ResponseInner() {
        super("oneOf", Boolean.FALSE);
    }

    public SubscribeToAdminActionSSE200ResponseInner(AdminActionLegacyNote o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public SubscribeToAdminActionSSE200ResponseInner(AdminActionLiquidation o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public SubscribeToAdminActionSSE200ResponseInner(AdminActionTransactionCancel o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("AdminActionLegacyNote", AdminActionLegacyNote.class);
        schemas.put("AdminActionLiquidation", AdminActionLiquidation.class);
        schemas.put("AdminActionTransactionCancel", AdminActionTransactionCancel.class);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return SubscribeToAdminActionSSE200ResponseInner.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * AdminActionLegacyNote, AdminActionLiquidation, AdminActionTransactionCancel
     *
     * It could be an instance of the 'oneOf' schemas.
     */
    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof AdminActionLegacyNote) {
            super.setActualInstance(instance);
            return;
        }

        if (instance instanceof AdminActionLiquidation) {
            super.setActualInstance(instance);
            return;
        }

        if (instance instanceof AdminActionTransactionCancel) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be AdminActionLegacyNote, AdminActionLiquidation, AdminActionTransactionCancel");
    }

    /**
     * Get the actual instance, which can be the following:
     * AdminActionLegacyNote, AdminActionLiquidation, AdminActionTransactionCancel
     *
     * @return The actual instance (AdminActionLegacyNote, AdminActionLiquidation, AdminActionTransactionCancel)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `AdminActionLegacyNote`. If the actual instance is not `AdminActionLegacyNote`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `AdminActionLegacyNote`
     * @throws ClassCastException if the instance is not `AdminActionLegacyNote`
     */
    public AdminActionLegacyNote getAdminActionLegacyNote() throws ClassCastException {
        return (AdminActionLegacyNote)super.getActualInstance();
    }
    /**
     * Get the actual instance of `AdminActionLiquidation`. If the actual instance is not `AdminActionLiquidation`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `AdminActionLiquidation`
     * @throws ClassCastException if the instance is not `AdminActionLiquidation`
     */
    public AdminActionLiquidation getAdminActionLiquidation() throws ClassCastException {
        return (AdminActionLiquidation)super.getActualInstance();
    }
    /**
     * Get the actual instance of `AdminActionTransactionCancel`. If the actual instance is not `AdminActionTransactionCancel`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `AdminActionTransactionCancel`
     * @throws ClassCastException if the instance is not `AdminActionTransactionCancel`
     */
    public AdminActionTransactionCancel getAdminActionTransactionCancel() throws ClassCastException {
        return (AdminActionTransactionCancel)super.getActualInstance();
    }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    // validate oneOf schemas one by one
    int validCount = 0;
    ArrayList<String> errorMessages = new ArrayList<>();
    // validate the json string with AdminActionLegacyNote
    try {
      AdminActionLegacyNote.validateJsonElement(jsonElement);
      validCount++;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for AdminActionLegacyNote failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    // validate the json string with AdminActionLiquidation
    try {
      AdminActionLiquidation.validateJsonElement(jsonElement);
      validCount++;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for AdminActionLiquidation failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    // validate the json string with AdminActionTransactionCancel
    try {
      AdminActionTransactionCancel.validateJsonElement(jsonElement);
      validCount++;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for AdminActionTransactionCancel failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    if (validCount != 1) {
      throw new IOException(String.format("The JSON string is invalid for SubscribeToAdminActionSSE200ResponseInner with oneOf schemas: AdminActionLegacyNote, AdminActionLiquidation, AdminActionTransactionCancel. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
    }
  }

 /**
  * Create an instance of SubscribeToAdminActionSSE200ResponseInner given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of SubscribeToAdminActionSSE200ResponseInner
  * @throws IOException if the JSON string is invalid with respect to SubscribeToAdminActionSSE200ResponseInner
  */
  public static SubscribeToAdminActionSSE200ResponseInner fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SubscribeToAdminActionSSE200ResponseInner.class);
  }

 /**
  * Convert an instance of SubscribeToAdminActionSSE200ResponseInner to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

