/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Skipped orders model contains information for such orders that the rebalancing engine didn’t send to our order system due to some validation issues.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class SkippedOrder {
  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private String side;

  public static final String SERIALIZED_NAME_NOTIONAL = "notional";
  @SerializedName(SERIALIZED_NAME_NOTIONAL)
  private String notional;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_REASON = "reason";
  @SerializedName(SERIALIZED_NAME_REASON)
  private String reason;

  public static final String SERIALIZED_NAME_REASON_DETAILS = "reason_details";
  @SerializedName(SERIALIZED_NAME_REASON_DETAILS)
  private String reasonDetails;

  public SkippedOrder() {
  }

  public SkippedOrder symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Symbol for which the adjustment was skipped
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public SkippedOrder side(String side) {
    this.side = side;
    return this;
  }

   /**
   * Side of the order (buy, sell, sell_short)
   * @return side
  **/
  @javax.annotation.Nullable
  public String getSide() {
    return side;
  }

  public void setSide(String side) {
    this.side = side;
  }


  public SkippedOrder notional(String notional) {
    this.notional = notional;
    return this;
  }

   /**
   * Notional value of the order
   * @return notional
  **/
  @javax.annotation.Nullable
  public String getNotional() {
    return notional;
  }

  public void setNotional(String notional) {
    this.notional = notional;
  }


  public SkippedOrder currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Currency of the order
   * @return currency
  **/
  @javax.annotation.Nullable
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public SkippedOrder reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Reason for the order being skipped
   * @return reason
  **/
  @javax.annotation.Nonnull
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }


  public SkippedOrder reasonDetails(String reasonDetails) {
    this.reasonDetails = reasonDetails;
    return this;
  }

   /**
   * Formatted error message with the cause of the skip
   * @return reasonDetails
  **/
  @javax.annotation.Nonnull
  public String getReasonDetails() {
    return reasonDetails;
  }

  public void setReasonDetails(String reasonDetails) {
    this.reasonDetails = reasonDetails;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SkippedOrder skippedOrder = (SkippedOrder) o;
    return Objects.equals(this.symbol, skippedOrder.symbol) &&
        Objects.equals(this.side, skippedOrder.side) &&
        Objects.equals(this.notional, skippedOrder.notional) &&
        Objects.equals(this.currency, skippedOrder.currency) &&
        Objects.equals(this.reason, skippedOrder.reason) &&
        Objects.equals(this.reasonDetails, skippedOrder.reasonDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(symbol, side, notional, currency, reason, reasonDetails);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SkippedOrder {\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    notional: ").append(toIndentedString(notional)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    reasonDetails: ").append(toIndentedString(reasonDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("symbol");
    openapiFields.add("side");
    openapiFields.add("notional");
    openapiFields.add("currency");
    openapiFields.add("reason");
    openapiFields.add("reason_details");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("reason");
    openapiRequiredFields.add("reason_details");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!SkippedOrder.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in SkippedOrder is not found in the empty JSON string", SkippedOrder.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!SkippedOrder.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SkippedOrder` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : SkippedOrder.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("side") != null && !jsonObj.get("side").isJsonNull()) && !jsonObj.get("side").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `side` to be a primitive type in the JSON string but got `%s`", jsonObj.get("side").toString()));
      }
      if ((jsonObj.get("notional") != null && !jsonObj.get("notional").isJsonNull()) && !jsonObj.get("notional").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `notional` to be a primitive type in the JSON string but got `%s`", jsonObj.get("notional").toString()));
      }
      if ((jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonNull()) && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if (!jsonObj.get("reason").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reason").toString()));
      }
      if (!jsonObj.get("reason_details").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reason_details` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reason_details").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!SkippedOrder.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'SkippedOrder' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<SkippedOrder> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(SkippedOrder.class));

       return (TypeAdapter<T>) new TypeAdapter<SkippedOrder>() {
           @Override
           public void write(JsonWriter out, SkippedOrder value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public SkippedOrder read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of SkippedOrder given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of SkippedOrder
  * @throws IOException if the JSON string is invalid with respect to SkippedOrder
  */
  public static SkippedOrder fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SkippedOrder.class);
  }

 /**
  * Convert an instance of SkippedOrder to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

