/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class RetrieveJITReportRequest {
  public static final String SERIALIZED_NAME_REPORT_TYPE = "report_type";
  @SerializedName(SERIALIZED_NAME_REPORT_TYPE)
  private String reportType;

  public static final String SERIALIZED_NAME_SYSTEM_DATE = "system_date";
  @SerializedName(SERIALIZED_NAME_SYSTEM_DATE)
  private String systemDate;

  public static final String SERIALIZED_NAME_ASSET_CLASS = "asset_class";
  @SerializedName(SERIALIZED_NAME_ASSET_CLASS)
  private String assetClass;

  public RetrieveJITReportRequest() {
  }

  public RetrieveJITReportRequest reportType(String reportType) {
    this.reportType = reportType;
    return this;
  }

   /**
   * **detail** Detail report, content-type &#x3D; application/csv **net_summary** Net Summary report, content-type &#x3D; application/csv **net_payment** Net Payment report, content-type &#x3D; application/pdf **net_payment_final** Net Payment Final report, content-type &#x3D; application/pdf **gross_summary Gross** Summary report, content-type &#x3D; application/pdf **gross_payment Gross** Payment report, content-type &#x3D; application/pdf **gross_payment_final** Gross Payment Final report, content-type &#x3D; application/pdf
   * @return reportType
  **/
  @javax.annotation.Nonnull
  public String getReportType() {
    return reportType;
  }

  public void setReportType(String reportType) {
    this.reportType = reportType;
  }


  public RetrieveJITReportRequest systemDate(String systemDate) {
    this.systemDate = systemDate;
    return this;
  }

   /**
   * Date of file generation
   * @return systemDate
  **/
  @javax.annotation.Nonnull
  public String getSystemDate() {
    return systemDate;
  }

  public void setSystemDate(String systemDate) {
    this.systemDate = systemDate;
  }


  public RetrieveJITReportRequest assetClass(String assetClass) {
    this.assetClass = assetClass;
    return this;
  }

   /**
   * The asset class to retrieve for.
   * @return assetClass
  **/
  @javax.annotation.Nullable
  public String getAssetClass() {
    return assetClass;
  }

  public void setAssetClass(String assetClass) {
    this.assetClass = assetClass;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RetrieveJITReportRequest retrieveJITReportRequest = (RetrieveJITReportRequest) o;
    return Objects.equals(this.reportType, retrieveJITReportRequest.reportType) &&
        Objects.equals(this.systemDate, retrieveJITReportRequest.systemDate) &&
        Objects.equals(this.assetClass, retrieveJITReportRequest.assetClass);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reportType, systemDate, assetClass);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RetrieveJITReportRequest {\n");
    sb.append("    reportType: ").append(toIndentedString(reportType)).append("\n");
    sb.append("    systemDate: ").append(toIndentedString(systemDate)).append("\n");
    sb.append("    assetClass: ").append(toIndentedString(assetClass)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("report_type");
    openapiFields.add("system_date");
    openapiFields.add("asset_class");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("report_type");
    openapiRequiredFields.add("system_date");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!RetrieveJITReportRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in RetrieveJITReportRequest is not found in the empty JSON string", RetrieveJITReportRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!RetrieveJITReportRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RetrieveJITReportRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : RetrieveJITReportRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("report_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `report_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("report_type").toString()));
      }
      if (!jsonObj.get("system_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `system_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("system_date").toString()));
      }
      if ((jsonObj.get("asset_class") != null && !jsonObj.get("asset_class").isJsonNull()) && !jsonObj.get("asset_class").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `asset_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get("asset_class").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RetrieveJITReportRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RetrieveJITReportRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RetrieveJITReportRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RetrieveJITReportRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<RetrieveJITReportRequest>() {
           @Override
           public void write(JsonWriter out, RetrieveJITReportRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RetrieveJITReportRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RetrieveJITReportRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RetrieveJITReportRequest
  * @throws IOException if the JSON string is invalid with respect to RetrieveJITReportRequest
  */
  public static RetrieveJITReportRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RetrieveJITReportRequest.class);
  }

 /**
  * Convert an instance of RetrieveJITReportRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

