/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Reasons why the liquidation only flag was set
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class RestrictToLiquidationReasons {
  public static final String SERIALIZED_NAME_PATTERN_DAY_TRADING = "pattern_day_trading";
  @SerializedName(SERIALIZED_NAME_PATTERN_DAY_TRADING)
  private Boolean patternDayTrading;

  public static final String SERIALIZED_NAME_ACH_RETURN = "ach_return";
  @SerializedName(SERIALIZED_NAME_ACH_RETURN)
  private Boolean achReturn;

  public static final String SERIALIZED_NAME_POSITION_TO_EQUITY_RATIO = "position_to_equity_ratio";
  @SerializedName(SERIALIZED_NAME_POSITION_TO_EQUITY_RATIO)
  private Boolean positionToEquityRatio;

  public static final String SERIALIZED_NAME_UNSPECIFIED = "unspecified";
  @SerializedName(SERIALIZED_NAME_UNSPECIFIED)
  private Boolean unspecified;

  public RestrictToLiquidationReasons() {
  }

  public RestrictToLiquidationReasons patternDayTrading(Boolean patternDayTrading) {
    this.patternDayTrading = patternDayTrading;
    return this;
  }

   /**
   * Set when the trading account is marked as a PDT, but its equity falls below the $25k treshold
   * @return patternDayTrading
  **/
  @javax.annotation.Nullable
  public Boolean getPatternDayTrading() {
    return patternDayTrading;
  }

  public void setPatternDayTrading(Boolean patternDayTrading) {
    this.patternDayTrading = patternDayTrading;
  }


  public RestrictToLiquidationReasons achReturn(Boolean achReturn) {
    this.achReturn = achReturn;
    return this;
  }

   /**
   * Set when an incoming ACH transfer gets rejected
   * @return achReturn
  **/
  @javax.annotation.Nullable
  public Boolean getAchReturn() {
    return achReturn;
  }

  public void setAchReturn(Boolean achReturn) {
    this.achReturn = achReturn;
  }


  public RestrictToLiquidationReasons positionToEquityRatio(Boolean positionToEquityRatio) {
    this.positionToEquityRatio = positionToEquityRatio;
    return this;
  }

   /**
   * Set when the position to equity ration exceeds the maximum limit
   * @return positionToEquityRatio
  **/
  @javax.annotation.Nullable
  public Boolean getPositionToEquityRatio() {
    return positionToEquityRatio;
  }

  public void setPositionToEquityRatio(Boolean positionToEquityRatio) {
    this.positionToEquityRatio = positionToEquityRatio;
  }


  public RestrictToLiquidationReasons unspecified(Boolean unspecified) {
    this.unspecified = unspecified;
    return this;
  }

   /**
   * Default value for unknown reason
   * @return unspecified
  **/
  @javax.annotation.Nullable
  public Boolean getUnspecified() {
    return unspecified;
  }

  public void setUnspecified(Boolean unspecified) {
    this.unspecified = unspecified;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RestrictToLiquidationReasons restrictToLiquidationReasons = (RestrictToLiquidationReasons) o;
    return Objects.equals(this.patternDayTrading, restrictToLiquidationReasons.patternDayTrading) &&
        Objects.equals(this.achReturn, restrictToLiquidationReasons.achReturn) &&
        Objects.equals(this.positionToEquityRatio, restrictToLiquidationReasons.positionToEquityRatio) &&
        Objects.equals(this.unspecified, restrictToLiquidationReasons.unspecified);
  }

  @Override
  public int hashCode() {
    return Objects.hash(patternDayTrading, achReturn, positionToEquityRatio, unspecified);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RestrictToLiquidationReasons {\n");
    sb.append("    patternDayTrading: ").append(toIndentedString(patternDayTrading)).append("\n");
    sb.append("    achReturn: ").append(toIndentedString(achReturn)).append("\n");
    sb.append("    positionToEquityRatio: ").append(toIndentedString(positionToEquityRatio)).append("\n");
    sb.append("    unspecified: ").append(toIndentedString(unspecified)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("pattern_day_trading");
    openapiFields.add("ach_return");
    openapiFields.add("position_to_equity_ratio");
    openapiFields.add("unspecified");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!RestrictToLiquidationReasons.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in RestrictToLiquidationReasons is not found in the empty JSON string", RestrictToLiquidationReasons.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!RestrictToLiquidationReasons.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RestrictToLiquidationReasons` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RestrictToLiquidationReasons.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RestrictToLiquidationReasons' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RestrictToLiquidationReasons> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RestrictToLiquidationReasons.class));

       return (TypeAdapter<T>) new TypeAdapter<RestrictToLiquidationReasons>() {
           @Override
           public void write(JsonWriter out, RestrictToLiquidationReasons value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RestrictToLiquidationReasons read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RestrictToLiquidationReasons given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RestrictToLiquidationReasons
  * @throws IOException if the JSON string is invalid with respect to RestrictToLiquidationReasons
  */
  public static RestrictToLiquidationReasons fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RestrictToLiquidationReasons.class);
  }

 /**
  * Convert an instance of RestrictToLiquidationReasons to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

