/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioWeights;
import net.jacobpeterson.alpaca.openapi.broker.model.RebalancingConditions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * PostV1RebalancingPortfoliosRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class PostV1RebalancingPortfoliosRequest {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_WEIGHTS = "weights";
  @SerializedName(SERIALIZED_NAME_WEIGHTS)
  private List<PortfolioWeights> weights;

  public static final String SERIALIZED_NAME_COOLDOWN_DAYS = "cooldown_days";
  @SerializedName(SERIALIZED_NAME_COOLDOWN_DAYS)
  private String cooldownDays;

  public static final String SERIALIZED_NAME_REBALANCE_CONDITIONS = "rebalance_conditions";
  @SerializedName(SERIALIZED_NAME_REBALANCE_CONDITIONS)
  private List<RebalancingConditions> rebalanceConditions;

  public PostV1RebalancingPortfoliosRequest() {
  }

  public PostV1RebalancingPortfoliosRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name of portfolio
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public PostV1RebalancingPortfoliosRequest description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Text to describe portfolio
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public PostV1RebalancingPortfoliosRequest weights(List<PortfolioWeights> weights) {
    this.weights = weights;
    return this;
  }

  public PostV1RebalancingPortfoliosRequest addWeightsItem(PortfolioWeights weightsItem) {
    if (this.weights == null) {
      this.weights = new ArrayList<>();
    }
    this.weights.add(weightsItem);
    return this;
  }

   /**
   * Weight configuration to portfolio. Sum of “percent” values in the weights array must be 100.00
   * @return weights
  **/
  @javax.annotation.Nullable
  public List<PortfolioWeights> getWeights() {
    return weights;
  }

  public void setWeights(List<PortfolioWeights> weights) {
    this.weights = weights;
  }


  public PostV1RebalancingPortfoliosRequest cooldownDays(String cooldownDays) {
    this.cooldownDays = cooldownDays;
    return this;
  }

   /**
   * Count of calendar days following a rebalance before a subscription is eligible to trigger another rebalance
   * @return cooldownDays
  **/
  @javax.annotation.Nullable
  public String getCooldownDays() {
    return cooldownDays;
  }

  public void setCooldownDays(String cooldownDays) {
    this.cooldownDays = cooldownDays;
  }


  public PostV1RebalancingPortfoliosRequest rebalanceConditions(List<RebalancingConditions> rebalanceConditions) {
    this.rebalanceConditions = rebalanceConditions;
    return this;
  }

  public PostV1RebalancingPortfoliosRequest addRebalanceConditionsItem(RebalancingConditions rebalanceConditionsItem) {
    if (this.rebalanceConditions == null) {
      this.rebalanceConditions = new ArrayList<>();
    }
    this.rebalanceConditions.add(rebalanceConditionsItem);
    return this;
  }

   /**
   * Rebalancing conditions for portfolio
   * @return rebalanceConditions
  **/
  @javax.annotation.Nullable
  public List<RebalancingConditions> getRebalanceConditions() {
    return rebalanceConditions;
  }

  public void setRebalanceConditions(List<RebalancingConditions> rebalanceConditions) {
    this.rebalanceConditions = rebalanceConditions;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PostV1RebalancingPortfoliosRequest postV1RebalancingPortfoliosRequest = (PostV1RebalancingPortfoliosRequest) o;
    return Objects.equals(this.name, postV1RebalancingPortfoliosRequest.name) &&
        Objects.equals(this.description, postV1RebalancingPortfoliosRequest.description) &&
        Objects.equals(this.weights, postV1RebalancingPortfoliosRequest.weights) &&
        Objects.equals(this.cooldownDays, postV1RebalancingPortfoliosRequest.cooldownDays) &&
        Objects.equals(this.rebalanceConditions, postV1RebalancingPortfoliosRequest.rebalanceConditions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, weights, cooldownDays, rebalanceConditions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PostV1RebalancingPortfoliosRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    weights: ").append(toIndentedString(weights)).append("\n");
    sb.append("    cooldownDays: ").append(toIndentedString(cooldownDays)).append("\n");
    sb.append("    rebalanceConditions: ").append(toIndentedString(rebalanceConditions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("weights");
    openapiFields.add("cooldown_days");
    openapiFields.add("rebalance_conditions");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!PostV1RebalancingPortfoliosRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PostV1RebalancingPortfoliosRequest is not found in the empty JSON string", PostV1RebalancingPortfoliosRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PostV1RebalancingPortfoliosRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PostV1RebalancingPortfoliosRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("weights") != null && !jsonObj.get("weights").isJsonNull()) {
        JsonArray jsonArrayweights = jsonObj.getAsJsonArray("weights");
        if (jsonArrayweights != null) {
          // ensure the json data is an array
          if (!jsonObj.get("weights").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `weights` to be an array in the JSON string but got `%s`", jsonObj.get("weights").toString()));
          }

          // validate the optional field `weights` (array)
          for (int i = 0; i < jsonArrayweights.size(); i++) {
            PortfolioWeights.validateJsonElement(jsonArrayweights.get(i));
          };
        }
      }
      if ((jsonObj.get("cooldown_days") != null && !jsonObj.get("cooldown_days").isJsonNull()) && !jsonObj.get("cooldown_days").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cooldown_days` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cooldown_days").toString()));
      }
      if (jsonObj.get("rebalance_conditions") != null && !jsonObj.get("rebalance_conditions").isJsonNull()) {
        JsonArray jsonArrayrebalanceConditions = jsonObj.getAsJsonArray("rebalance_conditions");
        if (jsonArrayrebalanceConditions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("rebalance_conditions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `rebalance_conditions` to be an array in the JSON string but got `%s`", jsonObj.get("rebalance_conditions").toString()));
          }

          // validate the optional field `rebalance_conditions` (array)
          for (int i = 0; i < jsonArrayrebalanceConditions.size(); i++) {
            RebalancingConditions.validateJsonElement(jsonArrayrebalanceConditions.get(i));
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PostV1RebalancingPortfoliosRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PostV1RebalancingPortfoliosRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PostV1RebalancingPortfoliosRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PostV1RebalancingPortfoliosRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<PostV1RebalancingPortfoliosRequest>() {
           @Override
           public void write(JsonWriter out, PostV1RebalancingPortfoliosRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PostV1RebalancingPortfoliosRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PostV1RebalancingPortfoliosRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PostV1RebalancingPortfoliosRequest
  * @throws IOException if the JSON string is invalid with respect to PostV1RebalancingPortfoliosRequest
  */
  public static PostV1RebalancingPortfoliosRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PostV1RebalancingPortfoliosRequest.class);
  }

 /**
  * Convert an instance of PostV1RebalancingPortfoliosRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

