/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.USDPosition;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Position
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Position {
  public static final String SERIALIZED_NAME_ASSET_ID = "asset_id";
  @SerializedName(SERIALIZED_NAME_ASSET_ID)
  private UUID assetId;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_EXCHANGE = "exchange";
  @SerializedName(SERIALIZED_NAME_EXCHANGE)
  private String exchange;

  public static final String SERIALIZED_NAME_ASSET_CLASS = "asset_class";
  @SerializedName(SERIALIZED_NAME_ASSET_CLASS)
  private AssetClass assetClass;

  public static final String SERIALIZED_NAME_ASSET_MARGINABLE = "asset_marginable";
  @SerializedName(SERIALIZED_NAME_ASSET_MARGINABLE)
  private Boolean assetMarginable;

  public static final String SERIALIZED_NAME_AVG_ENTRY_PRICE = "avg_entry_price";
  @SerializedName(SERIALIZED_NAME_AVG_ENTRY_PRICE)
  private String avgEntryPrice;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  /**
   * Gets or Sets side
   */
  @JsonAdapter(SideEnum.Adapter.class)
  public enum SideEnum {
    LONG("long"),
    
    SHORT("short");

    private String value;

    SideEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static SideEnum fromValue(String value) {
      for (SideEnum b : SideEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<SideEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SideEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public SideEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return SideEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      SideEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private SideEnum side;

  public static final String SERIALIZED_NAME_MARKET_VALUE = "market_value";
  @SerializedName(SERIALIZED_NAME_MARKET_VALUE)
  private BigDecimal marketValue;

  public static final String SERIALIZED_NAME_COST_BASIS = "cost_basis";
  @SerializedName(SERIALIZED_NAME_COST_BASIS)
  private BigDecimal costBasis;

  public static final String SERIALIZED_NAME_UNREALIZED_PL = "unrealized_pl";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_PL)
  private BigDecimal unrealizedPl;

  public static final String SERIALIZED_NAME_UNREALIZED_PLPC = "unrealized_plpc";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_PLPC)
  private BigDecimal unrealizedPlpc;

  public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PL = "unrealized_intraday_pl";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_INTRADAY_PL)
  private BigDecimal unrealizedIntradayPl;

  public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC = "unrealized_intraday_plpc";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC)
  private BigDecimal unrealizedIntradayPlpc;

  public static final String SERIALIZED_NAME_CURRENT_PRICE = "current_price";
  @SerializedName(SERIALIZED_NAME_CURRENT_PRICE)
  private BigDecimal currentPrice;

  public static final String SERIALIZED_NAME_LASTDAY_PRICE = "lastday_price";
  @SerializedName(SERIALIZED_NAME_LASTDAY_PRICE)
  private BigDecimal lastdayPrice;

  public static final String SERIALIZED_NAME_CHANGE_TODAY = "change_today";
  @SerializedName(SERIALIZED_NAME_CHANGE_TODAY)
  private BigDecimal changeToday;

  public static final String SERIALIZED_NAME_SWAP_RATE = "swap_rate";
  @SerializedName(SERIALIZED_NAME_SWAP_RATE)
  private BigDecimal swapRate;

  public static final String SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE = "avg_entry_swap_rate";
  @SerializedName(SERIALIZED_NAME_AVG_ENTRY_SWAP_RATE)
  private BigDecimal avgEntrySwapRate;

  public static final String SERIALIZED_NAME_USD = "usd";
  @SerializedName(SERIALIZED_NAME_USD)
  private USDPosition usd;

  public Position() {
  }

  public Position assetId(UUID assetId) {
    this.assetId = assetId;
    return this;
  }

   /**
   * Asset ID (For options this represents the option contract ID)
   * @return assetId
  **/
  @javax.annotation.Nonnull
  public UUID getAssetId() {
    return assetId;
  }

  public void setAssetId(UUID assetId) {
    this.assetId = assetId;
  }


  public Position symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Asset symbol
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public Position exchange(String exchange) {
    this.exchange = exchange;
    return this;
  }

   /**
   * Exchange name of the asset
   * @return exchange
  **/
  @javax.annotation.Nonnull
  public String getExchange() {
    return exchange;
  }

  public void setExchange(String exchange) {
    this.exchange = exchange;
  }


  public Position assetClass(AssetClass assetClass) {
    this.assetClass = assetClass;
    return this;
  }

   /**
   * Get assetClass
   * @return assetClass
  **/
  @javax.annotation.Nonnull
  public AssetClass getAssetClass() {
    return assetClass;
  }

  public void setAssetClass(AssetClass assetClass) {
    this.assetClass = assetClass;
  }


  public Position assetMarginable(Boolean assetMarginable) {
    this.assetMarginable = assetMarginable;
    return this;
  }

   /**
   * Indicates if this asset is marginable
   * @return assetMarginable
  **/
  @javax.annotation.Nullable
  public Boolean getAssetMarginable() {
    return assetMarginable;
  }

  public void setAssetMarginable(Boolean assetMarginable) {
    this.assetMarginable = assetMarginable;
  }


  public Position avgEntryPrice(String avgEntryPrice) {
    this.avgEntryPrice = avgEntryPrice;
    return this;
  }

   /**
   * Average entry price of the position
   * @return avgEntryPrice
  **/
  @javax.annotation.Nonnull
  public String getAvgEntryPrice() {
    return avgEntryPrice;
  }

  public void setAvgEntryPrice(String avgEntryPrice) {
    this.avgEntryPrice = avgEntryPrice;
  }


  public Position qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * The number of shares
   * @return qty
  **/
  @javax.annotation.Nonnull
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public Position side(SideEnum side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @javax.annotation.Nonnull
  public SideEnum getSide() {
    return side;
  }

  public void setSide(SideEnum side) {
    this.side = side;
  }


  public Position marketValue(BigDecimal marketValue) {
    this.marketValue = marketValue;
    return this;
  }

   /**
   * Total market value of the position
   * @return marketValue
  **/
  @javax.annotation.Nonnull
  public BigDecimal getMarketValue() {
    return marketValue;
  }

  public void setMarketValue(BigDecimal marketValue) {
    this.marketValue = marketValue;
  }


  public Position costBasis(BigDecimal costBasis) {
    this.costBasis = costBasis;
    return this;
  }

   /**
   * Total cost basis
   * @return costBasis
  **/
  @javax.annotation.Nonnull
  public BigDecimal getCostBasis() {
    return costBasis;
  }

  public void setCostBasis(BigDecimal costBasis) {
    this.costBasis = costBasis;
  }


  public Position unrealizedPl(BigDecimal unrealizedPl) {
    this.unrealizedPl = unrealizedPl;
    return this;
  }

   /**
   * Unrealized profit/loss
   * @return unrealizedPl
  **/
  @javax.annotation.Nonnull
  public BigDecimal getUnrealizedPl() {
    return unrealizedPl;
  }

  public void setUnrealizedPl(BigDecimal unrealizedPl) {
    this.unrealizedPl = unrealizedPl;
  }


  public Position unrealizedPlpc(BigDecimal unrealizedPlpc) {
    this.unrealizedPlpc = unrealizedPlpc;
    return this;
  }

   /**
   * Unrealized profit/loss percent (by a factor of 1)
   * @return unrealizedPlpc
  **/
  @javax.annotation.Nonnull
  public BigDecimal getUnrealizedPlpc() {
    return unrealizedPlpc;
  }

  public void setUnrealizedPlpc(BigDecimal unrealizedPlpc) {
    this.unrealizedPlpc = unrealizedPlpc;
  }


  public Position unrealizedIntradayPl(BigDecimal unrealizedIntradayPl) {
    this.unrealizedIntradayPl = unrealizedIntradayPl;
    return this;
  }

   /**
   * Unrealized profit/loss for the day
   * @return unrealizedIntradayPl
  **/
  @javax.annotation.Nonnull
  public BigDecimal getUnrealizedIntradayPl() {
    return unrealizedIntradayPl;
  }

  public void setUnrealizedIntradayPl(BigDecimal unrealizedIntradayPl) {
    this.unrealizedIntradayPl = unrealizedIntradayPl;
  }


  public Position unrealizedIntradayPlpc(BigDecimal unrealizedIntradayPlpc) {
    this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
    return this;
  }

   /**
   * Unrealized interday profit/loss percent (by a factor of 1)
   * @return unrealizedIntradayPlpc
  **/
  @javax.annotation.Nonnull
  public BigDecimal getUnrealizedIntradayPlpc() {
    return unrealizedIntradayPlpc;
  }

  public void setUnrealizedIntradayPlpc(BigDecimal unrealizedIntradayPlpc) {
    this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
  }


  public Position currentPrice(BigDecimal currentPrice) {
    this.currentPrice = currentPrice;
    return this;
  }

   /**
   * Current asset price per share
   * @return currentPrice
  **/
  @javax.annotation.Nonnull
  public BigDecimal getCurrentPrice() {
    return currentPrice;
  }

  public void setCurrentPrice(BigDecimal currentPrice) {
    this.currentPrice = currentPrice;
  }


  public Position lastdayPrice(BigDecimal lastdayPrice) {
    this.lastdayPrice = lastdayPrice;
    return this;
  }

   /**
   * Last day’s asset price per share based on the closing value of the last trading day
   * @return lastdayPrice
  **/
  @javax.annotation.Nonnull
  public BigDecimal getLastdayPrice() {
    return lastdayPrice;
  }

  public void setLastdayPrice(BigDecimal lastdayPrice) {
    this.lastdayPrice = lastdayPrice;
  }


  public Position changeToday(BigDecimal changeToday) {
    this.changeToday = changeToday;
    return this;
  }

   /**
   * Percent change from last day price (by a factor of 1)
   * @return changeToday
  **/
  @javax.annotation.Nonnull
  public BigDecimal getChangeToday() {
    return changeToday;
  }

  public void setChangeToday(BigDecimal changeToday) {
    this.changeToday = changeToday;
  }


  public Position swapRate(BigDecimal swapRate) {
    this.swapRate = swapRate;
    return this;
  }

   /**
   * The latest swap rate. This is only returned for LCT accounts.
   * @return swapRate
  **/
  @javax.annotation.Nullable
  public BigDecimal getSwapRate() {
    return swapRate;
  }

  public void setSwapRate(BigDecimal swapRate) {
    this.swapRate = swapRate;
  }


  public Position avgEntrySwapRate(BigDecimal avgEntrySwapRate) {
    this.avgEntrySwapRate = avgEntrySwapRate;
    return this;
  }

   /**
   * The average swap rate of the position. This is only returned for LCT accounts.
   * @return avgEntrySwapRate
  **/
  @javax.annotation.Nullable
  public BigDecimal getAvgEntrySwapRate() {
    return avgEntrySwapRate;
  }

  public void setAvgEntrySwapRate(BigDecimal avgEntrySwapRate) {
    this.avgEntrySwapRate = avgEntrySwapRate;
  }


  public Position usd(USDPosition usd) {
    this.usd = usd;
    return this;
  }

   /**
   * Get usd
   * @return usd
  **/
  @javax.annotation.Nullable
  public USDPosition getUsd() {
    return usd;
  }

  public void setUsd(USDPosition usd) {
    this.usd = usd;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Position position = (Position) o;
    return Objects.equals(this.assetId, position.assetId) &&
        Objects.equals(this.symbol, position.symbol) &&
        Objects.equals(this.exchange, position.exchange) &&
        Objects.equals(this.assetClass, position.assetClass) &&
        Objects.equals(this.assetMarginable, position.assetMarginable) &&
        Objects.equals(this.avgEntryPrice, position.avgEntryPrice) &&
        Objects.equals(this.qty, position.qty) &&
        Objects.equals(this.side, position.side) &&
        Objects.equals(this.marketValue, position.marketValue) &&
        Objects.equals(this.costBasis, position.costBasis) &&
        Objects.equals(this.unrealizedPl, position.unrealizedPl) &&
        Objects.equals(this.unrealizedPlpc, position.unrealizedPlpc) &&
        Objects.equals(this.unrealizedIntradayPl, position.unrealizedIntradayPl) &&
        Objects.equals(this.unrealizedIntradayPlpc, position.unrealizedIntradayPlpc) &&
        Objects.equals(this.currentPrice, position.currentPrice) &&
        Objects.equals(this.lastdayPrice, position.lastdayPrice) &&
        Objects.equals(this.changeToday, position.changeToday) &&
        Objects.equals(this.swapRate, position.swapRate) &&
        Objects.equals(this.avgEntrySwapRate, position.avgEntrySwapRate) &&
        Objects.equals(this.usd, position.usd);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assetId, symbol, exchange, assetClass, assetMarginable, avgEntryPrice, qty, side, marketValue, costBasis, unrealizedPl, unrealizedPlpc, unrealizedIntradayPl, unrealizedIntradayPlpc, currentPrice, lastdayPrice, changeToday, swapRate, avgEntrySwapRate, usd);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Position {\n");
    sb.append("    assetId: ").append(toIndentedString(assetId)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    exchange: ").append(toIndentedString(exchange)).append("\n");
    sb.append("    assetClass: ").append(toIndentedString(assetClass)).append("\n");
    sb.append("    assetMarginable: ").append(toIndentedString(assetMarginable)).append("\n");
    sb.append("    avgEntryPrice: ").append(toIndentedString(avgEntryPrice)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    marketValue: ").append(toIndentedString(marketValue)).append("\n");
    sb.append("    costBasis: ").append(toIndentedString(costBasis)).append("\n");
    sb.append("    unrealizedPl: ").append(toIndentedString(unrealizedPl)).append("\n");
    sb.append("    unrealizedPlpc: ").append(toIndentedString(unrealizedPlpc)).append("\n");
    sb.append("    unrealizedIntradayPl: ").append(toIndentedString(unrealizedIntradayPl)).append("\n");
    sb.append("    unrealizedIntradayPlpc: ").append(toIndentedString(unrealizedIntradayPlpc)).append("\n");
    sb.append("    currentPrice: ").append(toIndentedString(currentPrice)).append("\n");
    sb.append("    lastdayPrice: ").append(toIndentedString(lastdayPrice)).append("\n");
    sb.append("    changeToday: ").append(toIndentedString(changeToday)).append("\n");
    sb.append("    swapRate: ").append(toIndentedString(swapRate)).append("\n");
    sb.append("    avgEntrySwapRate: ").append(toIndentedString(avgEntrySwapRate)).append("\n");
    sb.append("    usd: ").append(toIndentedString(usd)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("asset_id");
    openapiFields.add("symbol");
    openapiFields.add("exchange");
    openapiFields.add("asset_class");
    openapiFields.add("asset_marginable");
    openapiFields.add("avg_entry_price");
    openapiFields.add("qty");
    openapiFields.add("side");
    openapiFields.add("market_value");
    openapiFields.add("cost_basis");
    openapiFields.add("unrealized_pl");
    openapiFields.add("unrealized_plpc");
    openapiFields.add("unrealized_intraday_pl");
    openapiFields.add("unrealized_intraday_plpc");
    openapiFields.add("current_price");
    openapiFields.add("lastday_price");
    openapiFields.add("change_today");
    openapiFields.add("swap_rate");
    openapiFields.add("avg_entry_swap_rate");
    openapiFields.add("usd");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("asset_id");
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("exchange");
    openapiRequiredFields.add("asset_class");
    openapiRequiredFields.add("avg_entry_price");
    openapiRequiredFields.add("qty");
    openapiRequiredFields.add("side");
    openapiRequiredFields.add("market_value");
    openapiRequiredFields.add("cost_basis");
    openapiRequiredFields.add("unrealized_pl");
    openapiRequiredFields.add("unrealized_plpc");
    openapiRequiredFields.add("unrealized_intraday_pl");
    openapiRequiredFields.add("unrealized_intraday_plpc");
    openapiRequiredFields.add("current_price");
    openapiRequiredFields.add("lastday_price");
    openapiRequiredFields.add("change_today");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Position.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Position is not found in the empty JSON string", Position.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Position.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Position` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Position.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("asset_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `asset_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("asset_id").toString()));
      }
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if (!jsonObj.get("exchange").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exchange` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exchange").toString()));
      }
      // validate the required field `asset_class`
      AssetClass.validateJsonElement(jsonObj.get("asset_class"));
      if (!jsonObj.get("avg_entry_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `avg_entry_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("avg_entry_price").toString()));
      }
      if (!jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if (!jsonObj.get("side").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `side` to be a primitive type in the JSON string but got `%s`", jsonObj.get("side").toString()));
      }
      // validate the required field `side`
      SideEnum.validateJsonElement(jsonObj.get("side"));
      if (!jsonObj.get("market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("market_value").toString()));
      }
      if (!jsonObj.get("cost_basis").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cost_basis` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cost_basis").toString()));
      }
      if (!jsonObj.get("unrealized_pl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_pl").toString()));
      }
      if (!jsonObj.get("unrealized_plpc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_plpc").toString()));
      }
      if (!jsonObj.get("unrealized_intraday_pl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_intraday_pl").toString()));
      }
      if (!jsonObj.get("unrealized_intraday_plpc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_intraday_plpc").toString()));
      }
      if (!jsonObj.get("current_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `current_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("current_price").toString()));
      }
      if (!jsonObj.get("lastday_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lastday_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lastday_price").toString()));
      }
      if (!jsonObj.get("change_today").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `change_today` to be a primitive type in the JSON string but got `%s`", jsonObj.get("change_today").toString()));
      }
      if ((jsonObj.get("swap_rate") != null && !jsonObj.get("swap_rate").isJsonNull()) && !jsonObj.get("swap_rate").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `swap_rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("swap_rate").toString()));
      }
      if ((jsonObj.get("avg_entry_swap_rate") != null && !jsonObj.get("avg_entry_swap_rate").isJsonNull()) && !jsonObj.get("avg_entry_swap_rate").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `avg_entry_swap_rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("avg_entry_swap_rate").toString()));
      }
      // validate the optional field `usd`
      if (jsonObj.get("usd") != null && !jsonObj.get("usd").isJsonNull()) {
        USDPosition.validateJsonElement(jsonObj.get("usd"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Position.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Position' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Position> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Position.class));

       return (TypeAdapter<T>) new TypeAdapter<Position>() {
           @Override
           public void write(JsonWriter out, Position value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Position read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Position given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Position
  * @throws IOException if the JSON string is invalid with respect to Position
  */
  public static Position fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Position.class);
  }

 /**
  * Convert an instance of Position to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

