/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * PortfolioSubscription
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class PortfolioSubscription {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private String accountId;

  public static final String SERIALIZED_NAME_PORTFOLIO_ID = "portfolio_id";
  @SerializedName(SERIALIZED_NAME_PORTFOLIO_ID)
  private String portfolioId;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_LAST_REBALANCED_AT = "last_rebalanced_at";
  @SerializedName(SERIALIZED_NAME_LAST_REBALANCED_AT)
  private String lastRebalancedAt;

  public PortfolioSubscription() {
  }

  public PortfolioSubscription id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Subscription ID
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public PortfolioSubscription accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account ID subscribing to portfolio
   * @return accountId
  **/
  @javax.annotation.Nullable
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }


  public PortfolioSubscription portfolioId(String portfolioId) {
    this.portfolioId = portfolioId;
    return this;
  }

   /**
   * Portfolio ID for subscription
   * @return portfolioId
  **/
  @javax.annotation.Nullable
  public String getPortfolioId() {
    return portfolioId;
  }

  public void setPortfolioId(String portfolioId) {
    this.portfolioId = portfolioId;
  }


  public PortfolioSubscription createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Subscription creation timestamp
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public PortfolioSubscription updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Subscription updated timestamp
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public PortfolioSubscription lastRebalancedAt(String lastRebalancedAt) {
    this.lastRebalancedAt = lastRebalancedAt;
    return this;
  }

   /**
   * Last rebalancing event for this subscription. Can be null.
   * @return lastRebalancedAt
  **/
  @javax.annotation.Nullable
  public String getLastRebalancedAt() {
    return lastRebalancedAt;
  }

  public void setLastRebalancedAt(String lastRebalancedAt) {
    this.lastRebalancedAt = lastRebalancedAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PortfolioSubscription portfolioSubscription = (PortfolioSubscription) o;
    return Objects.equals(this.id, portfolioSubscription.id) &&
        Objects.equals(this.accountId, portfolioSubscription.accountId) &&
        Objects.equals(this.portfolioId, portfolioSubscription.portfolioId) &&
        Objects.equals(this.createdAt, portfolioSubscription.createdAt) &&
        Objects.equals(this.updatedAt, portfolioSubscription.updatedAt) &&
        Objects.equals(this.lastRebalancedAt, portfolioSubscription.lastRebalancedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountId, portfolioId, createdAt, updatedAt, lastRebalancedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PortfolioSubscription {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    portfolioId: ").append(toIndentedString(portfolioId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    lastRebalancedAt: ").append(toIndentedString(lastRebalancedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_id");
    openapiFields.add("portfolio_id");
    openapiFields.add("created_at");
    openapiFields.add("updated_at");
    openapiFields.add("last_rebalanced_at");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!PortfolioSubscription.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PortfolioSubscription is not found in the empty JSON string", PortfolioSubscription.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PortfolioSubscription.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PortfolioSubscription` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_id") != null && !jsonObj.get("account_id").isJsonNull()) && !jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      if ((jsonObj.get("portfolio_id") != null && !jsonObj.get("portfolio_id").isJsonNull()) && !jsonObj.get("portfolio_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `portfolio_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("portfolio_id").toString()));
      }
      if ((jsonObj.get("last_rebalanced_at") != null && !jsonObj.get("last_rebalanced_at").isJsonNull()) && !jsonObj.get("last_rebalanced_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_rebalanced_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_rebalanced_at").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PortfolioSubscription.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PortfolioSubscription' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PortfolioSubscription> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PortfolioSubscription.class));

       return (TypeAdapter<T>) new TypeAdapter<PortfolioSubscription>() {
           @Override
           public void write(JsonWriter out, PortfolioSubscription value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PortfolioSubscription read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PortfolioSubscription given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PortfolioSubscription
  * @throws IOException if the JSON string is invalid with respect to PortfolioSubscription
  */
  public static PortfolioSubscription fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PortfolioSubscription.class);
  }

 /**
  * Convert an instance of PortfolioSubscription to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

