/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.Order;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioRunStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioWeights;
import net.jacobpeterson.alpaca.openapi.broker.model.SkippedOrder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * PortfolioRun
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class PortfolioRun {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private String accountId;

  public static final String SERIALIZED_NAME_PORTFOLIO_ID = "portfolio_id";
  @SerializedName(SERIALIZED_NAME_PORTFOLIO_ID)
  private String portfolioId;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_INITIATED_BY = "initiated_by";
  @SerializedName(SERIALIZED_NAME_INITIATED_BY)
  private String initiatedBy;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private String updatedAt;

  public static final String SERIALIZED_NAME_COMPLETED_AT = "completed_at";
  @SerializedName(SERIALIZED_NAME_COMPLETED_AT)
  private String completedAt;

  public static final String SERIALIZED_NAME_CANCELED_AT = "canceled_at";
  @SerializedName(SERIALIZED_NAME_CANCELED_AT)
  private String canceledAt;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private PortfolioRunStatus status;

  public static final String SERIALIZED_NAME_REASON = "reason";
  @SerializedName(SERIALIZED_NAME_REASON)
  private String reason;

  public static final String SERIALIZED_NAME_WEIGHTS = "weights";
  @SerializedName(SERIALIZED_NAME_WEIGHTS)
  private List<PortfolioWeights> weights;

  public static final String SERIALIZED_NAME_ORDERS = "orders";
  @SerializedName(SERIALIZED_NAME_ORDERS)
  private List<Order> orders;

  public static final String SERIALIZED_NAME_FAILED_ORDERS = "failed_orders";
  @SerializedName(SERIALIZED_NAME_FAILED_ORDERS)
  private List<Order> failedOrders;

  public static final String SERIALIZED_NAME_SKIPPED_ORDERS = "skipped_orders";
  @SerializedName(SERIALIZED_NAME_SKIPPED_ORDERS)
  private List<SkippedOrder> skippedOrders;

  public PortfolioRun() {
  }

  public PortfolioRun id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Run ID
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public PortfolioRun accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account ID for given run
   * @return accountId
  **/
  @javax.annotation.Nullable
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }


  public PortfolioRun portfolioId(String portfolioId) {
    this.portfolioId = portfolioId;
    return this;
  }

   /**
   * Portfolio ID for given run
   * @return portfolioId
  **/
  @javax.annotation.Nullable
  public String getPortfolioId() {
    return portfolioId;
  }

  public void setPortfolioId(String portfolioId) {
    this.portfolioId = portfolioId;
  }


  public PortfolioRun type(String type) {
    this.type = type;
    return this;
  }

   /**
   * full_rebalance or invest_cash
   * @return type
  **/
  @javax.annotation.Nullable
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }


  public PortfolioRun initiatedBy(String initiatedBy) {
    this.initiatedBy = initiatedBy;
    return this;
  }

   /**
   * system or api
   * @return initiatedBy
  **/
  @javax.annotation.Nullable
  public String getInitiatedBy() {
    return initiatedBy;
  }

  public void setInitiatedBy(String initiatedBy) {
    this.initiatedBy = initiatedBy;
  }


  public PortfolioRun updatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * RFC3339 format
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public String getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
  }


  public PortfolioRun completedAt(String completedAt) {
    this.completedAt = completedAt;
    return this;
  }

   /**
   * RFC3339 format
   * @return completedAt
  **/
  @javax.annotation.Nullable
  public String getCompletedAt() {
    return completedAt;
  }

  public void setCompletedAt(String completedAt) {
    this.completedAt = completedAt;
  }


  public PortfolioRun canceledAt(String canceledAt) {
    this.canceledAt = canceledAt;
    return this;
  }

   /**
   * RFC3339 format
   * @return canceledAt
  **/
  @javax.annotation.Nullable
  public String getCanceledAt() {
    return canceledAt;
  }

  public void setCanceledAt(String canceledAt) {
    this.canceledAt = canceledAt;
  }


  public PortfolioRun status(PortfolioRunStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  public PortfolioRunStatus getStatus() {
    return status;
  }

  public void setStatus(PortfolioRunStatus status) {
    this.status = status;
  }


  public PortfolioRun reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Explainer text in case of failed runs
   * @return reason
  **/
  @javax.annotation.Nullable
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }


  public PortfolioRun weights(List<PortfolioWeights> weights) {
    this.weights = weights;
    return this;
  }

  public PortfolioRun addWeightsItem(PortfolioWeights weightsItem) {
    if (this.weights == null) {
      this.weights = new ArrayList<>();
    }
    this.weights.add(weightsItem);
    return this;
  }

   /**
   * Considered weighting for this run
   * @return weights
  **/
  @javax.annotation.Nullable
  public List<PortfolioWeights> getWeights() {
    return weights;
  }

  public void setWeights(List<PortfolioWeights> weights) {
    this.weights = weights;
  }


  public PortfolioRun orders(List<Order> orders) {
    this.orders = orders;
    return this;
  }

  public PortfolioRun addOrdersItem(Order ordersItem) {
    if (this.orders == null) {
      this.orders = new ArrayList<>();
    }
    this.orders.add(ordersItem);
    return this;
  }

   /**
   * Array of executed orders for this run
   * @return orders
  **/
  @javax.annotation.Nullable
  public List<Order> getOrders() {
    return orders;
  }

  public void setOrders(List<Order> orders) {
    this.orders = orders;
  }


  public PortfolioRun failedOrders(List<Order> failedOrders) {
    this.failedOrders = failedOrders;
    return this;
  }

  public PortfolioRun addFailedOrdersItem(Order failedOrdersItem) {
    if (this.failedOrders == null) {
      this.failedOrders = new ArrayList<>();
    }
    this.failedOrders.add(failedOrdersItem);
    return this;
  }

   /**
   * Array of failed orders for this run
   * @return failedOrders
  **/
  @javax.annotation.Nullable
  public List<Order> getFailedOrders() {
    return failedOrders;
  }

  public void setFailedOrders(List<Order> failedOrders) {
    this.failedOrders = failedOrders;
  }


  public PortfolioRun skippedOrders(List<SkippedOrder> skippedOrders) {
    this.skippedOrders = skippedOrders;
    return this;
  }

  public PortfolioRun addSkippedOrdersItem(SkippedOrder skippedOrdersItem) {
    if (this.skippedOrders == null) {
      this.skippedOrders = new ArrayList<>();
    }
    this.skippedOrders.add(skippedOrdersItem);
    return this;
  }

   /**
   * Array of skipped order for this run
   * @return skippedOrders
  **/
  @javax.annotation.Nullable
  public List<SkippedOrder> getSkippedOrders() {
    return skippedOrders;
  }

  public void setSkippedOrders(List<SkippedOrder> skippedOrders) {
    this.skippedOrders = skippedOrders;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PortfolioRun portfolioRun = (PortfolioRun) o;
    return Objects.equals(this.id, portfolioRun.id) &&
        Objects.equals(this.accountId, portfolioRun.accountId) &&
        Objects.equals(this.portfolioId, portfolioRun.portfolioId) &&
        Objects.equals(this.type, portfolioRun.type) &&
        Objects.equals(this.initiatedBy, portfolioRun.initiatedBy) &&
        Objects.equals(this.updatedAt, portfolioRun.updatedAt) &&
        Objects.equals(this.completedAt, portfolioRun.completedAt) &&
        Objects.equals(this.canceledAt, portfolioRun.canceledAt) &&
        Objects.equals(this.status, portfolioRun.status) &&
        Objects.equals(this.reason, portfolioRun.reason) &&
        Objects.equals(this.weights, portfolioRun.weights) &&
        Objects.equals(this.orders, portfolioRun.orders) &&
        Objects.equals(this.failedOrders, portfolioRun.failedOrders) &&
        Objects.equals(this.skippedOrders, portfolioRun.skippedOrders);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountId, portfolioId, type, initiatedBy, updatedAt, completedAt, canceledAt, status, reason, weights, orders, failedOrders, skippedOrders);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PortfolioRun {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    portfolioId: ").append(toIndentedString(portfolioId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    initiatedBy: ").append(toIndentedString(initiatedBy)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    completedAt: ").append(toIndentedString(completedAt)).append("\n");
    sb.append("    canceledAt: ").append(toIndentedString(canceledAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    weights: ").append(toIndentedString(weights)).append("\n");
    sb.append("    orders: ").append(toIndentedString(orders)).append("\n");
    sb.append("    failedOrders: ").append(toIndentedString(failedOrders)).append("\n");
    sb.append("    skippedOrders: ").append(toIndentedString(skippedOrders)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_id");
    openapiFields.add("portfolio_id");
    openapiFields.add("type");
    openapiFields.add("initiated_by");
    openapiFields.add("updated_at");
    openapiFields.add("completed_at");
    openapiFields.add("canceled_at");
    openapiFields.add("status");
    openapiFields.add("reason");
    openapiFields.add("weights");
    openapiFields.add("orders");
    openapiFields.add("failed_orders");
    openapiFields.add("skipped_orders");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!PortfolioRun.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PortfolioRun is not found in the empty JSON string", PortfolioRun.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PortfolioRun.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PortfolioRun` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_id") != null && !jsonObj.get("account_id").isJsonNull()) && !jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      if ((jsonObj.get("portfolio_id") != null && !jsonObj.get("portfolio_id").isJsonNull()) && !jsonObj.get("portfolio_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `portfolio_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("portfolio_id").toString()));
      }
      if ((jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if ((jsonObj.get("initiated_by") != null && !jsonObj.get("initiated_by").isJsonNull()) && !jsonObj.get("initiated_by").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `initiated_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get("initiated_by").toString()));
      }
      if ((jsonObj.get("updated_at") != null && !jsonObj.get("updated_at").isJsonNull()) && !jsonObj.get("updated_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `updated_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("updated_at").toString()));
      }
      if ((jsonObj.get("completed_at") != null && !jsonObj.get("completed_at").isJsonNull()) && !jsonObj.get("completed_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `completed_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("completed_at").toString()));
      }
      if ((jsonObj.get("canceled_at") != null && !jsonObj.get("canceled_at").isJsonNull()) && !jsonObj.get("canceled_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `canceled_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("canceled_at").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        PortfolioRunStatus.validateJsonElement(jsonObj.get("status"));
      }
      if ((jsonObj.get("reason") != null && !jsonObj.get("reason").isJsonNull()) && !jsonObj.get("reason").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reason").toString()));
      }
      if (jsonObj.get("weights") != null && !jsonObj.get("weights").isJsonNull()) {
        JsonArray jsonArrayweights = jsonObj.getAsJsonArray("weights");
        if (jsonArrayweights != null) {
          // ensure the json data is an array
          if (!jsonObj.get("weights").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `weights` to be an array in the JSON string but got `%s`", jsonObj.get("weights").toString()));
          }

          // validate the optional field `weights` (array)
          for (int i = 0; i < jsonArrayweights.size(); i++) {
            PortfolioWeights.validateJsonElement(jsonArrayweights.get(i));
          };
        }
      }
      if (jsonObj.get("orders") != null && !jsonObj.get("orders").isJsonNull()) {
        JsonArray jsonArrayorders = jsonObj.getAsJsonArray("orders");
        if (jsonArrayorders != null) {
          // ensure the json data is an array
          if (!jsonObj.get("orders").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `orders` to be an array in the JSON string but got `%s`", jsonObj.get("orders").toString()));
          }

          // validate the optional field `orders` (array)
          for (int i = 0; i < jsonArrayorders.size(); i++) {
            Order.validateJsonElement(jsonArrayorders.get(i));
          };
        }
      }
      if (jsonObj.get("failed_orders") != null && !jsonObj.get("failed_orders").isJsonNull()) {
        JsonArray jsonArrayfailedOrders = jsonObj.getAsJsonArray("failed_orders");
        if (jsonArrayfailedOrders != null) {
          // ensure the json data is an array
          if (!jsonObj.get("failed_orders").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `failed_orders` to be an array in the JSON string but got `%s`", jsonObj.get("failed_orders").toString()));
          }

          // validate the optional field `failed_orders` (array)
          for (int i = 0; i < jsonArrayfailedOrders.size(); i++) {
            Order.validateJsonElement(jsonArrayfailedOrders.get(i));
          };
        }
      }
      if (jsonObj.get("skipped_orders") != null && !jsonObj.get("skipped_orders").isJsonNull()) {
        JsonArray jsonArrayskippedOrders = jsonObj.getAsJsonArray("skipped_orders");
        if (jsonArrayskippedOrders != null) {
          // ensure the json data is an array
          if (!jsonObj.get("skipped_orders").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `skipped_orders` to be an array in the JSON string but got `%s`", jsonObj.get("skipped_orders").toString()));
          }

          // validate the optional field `skipped_orders` (array)
          for (int i = 0; i < jsonArrayskippedOrders.size(); i++) {
            SkippedOrder.validateJsonElement(jsonArrayskippedOrders.get(i));
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PortfolioRun.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PortfolioRun' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PortfolioRun> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PortfolioRun.class));

       return (TypeAdapter<T>) new TypeAdapter<PortfolioRun>() {
           @Override
           public void write(JsonWriter out, PortfolioRun value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PortfolioRun read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PortfolioRun given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PortfolioRun
  * @throws IOException if the JSON string is invalid with respect to PortfolioRun
  */
  public static PortfolioRun fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PortfolioRun.class);
  }

 /**
  * Convert an instance of PortfolioRun to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

