/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Timeseries data for equity and profit loss information of the account.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class PortfolioHistory {
  public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
  @SerializedName(SERIALIZED_NAME_TIMESTAMP)
  private List<Integer> timestamp = new ArrayList<>();

  public static final String SERIALIZED_NAME_EQUITY = "equity";
  @SerializedName(SERIALIZED_NAME_EQUITY)
  private List<BigDecimal> equity = new ArrayList<>();

  public static final String SERIALIZED_NAME_PROFIT_LOSS = "profit_loss";
  @SerializedName(SERIALIZED_NAME_PROFIT_LOSS)
  private List<BigDecimal> profitLoss = new ArrayList<>();

  public static final String SERIALIZED_NAME_PROFIT_LOSS_PCT = "profit_loss_pct";
  @SerializedName(SERIALIZED_NAME_PROFIT_LOSS_PCT)
  private List<BigDecimal> profitLossPct = new ArrayList<>();

  public static final String SERIALIZED_NAME_BASE_VALUE = "base_value";
  @SerializedName(SERIALIZED_NAME_BASE_VALUE)
  private BigDecimal baseValue;

  public static final String SERIALIZED_NAME_BASE_VALUE_ASOF = "base_value_asof";
  @SerializedName(SERIALIZED_NAME_BASE_VALUE_ASOF)
  private LocalDate baseValueAsof;

  public static final String SERIALIZED_NAME_TIMEFRAME = "timeframe";
  @SerializedName(SERIALIZED_NAME_TIMEFRAME)
  private String timeframe;

  public PortfolioHistory() {
  }

  public PortfolioHistory timestamp(List<Integer> timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  public PortfolioHistory addTimestampItem(Integer timestampItem) {
    if (this.timestamp == null) {
      this.timestamp = new ArrayList<>();
    }
    this.timestamp.add(timestampItem);
    return this;
  }

   /**
   * Time of each data element, left-labeled (the beginning of time window).  The values returned are in [UNIX epoch format](https://en.wikipedia.org/wiki/Unix_time). 
   * @return timestamp
  **/
  @javax.annotation.Nonnull
  public List<Integer> getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(List<Integer> timestamp) {
    this.timestamp = timestamp;
  }


  public PortfolioHistory equity(List<BigDecimal> equity) {
    this.equity = equity;
    return this;
  }

  public PortfolioHistory addEquityItem(BigDecimal equityItem) {
    if (this.equity == null) {
      this.equity = new ArrayList<>();
    }
    this.equity.add(equityItem);
    return this;
  }

   /**
   * equity value of the account in dollar amount as of the end of each time window
   * @return equity
  **/
  @javax.annotation.Nonnull
  public List<BigDecimal> getEquity() {
    return equity;
  }

  public void setEquity(List<BigDecimal> equity) {
    this.equity = equity;
  }


  public PortfolioHistory profitLoss(List<BigDecimal> profitLoss) {
    this.profitLoss = profitLoss;
    return this;
  }

  public PortfolioHistory addProfitLossItem(BigDecimal profitLossItem) {
    if (this.profitLoss == null) {
      this.profitLoss = new ArrayList<>();
    }
    this.profitLoss.add(profitLossItem);
    return this;
  }

   /**
   * profit/loss in dollar from the base value
   * @return profitLoss
  **/
  @javax.annotation.Nonnull
  public List<BigDecimal> getProfitLoss() {
    return profitLoss;
  }

  public void setProfitLoss(List<BigDecimal> profitLoss) {
    this.profitLoss = profitLoss;
  }


  public PortfolioHistory profitLossPct(List<BigDecimal> profitLossPct) {
    this.profitLossPct = profitLossPct;
    return this;
  }

  public PortfolioHistory addProfitLossPctItem(BigDecimal profitLossPctItem) {
    if (this.profitLossPct == null) {
      this.profitLossPct = new ArrayList<>();
    }
    this.profitLossPct.add(profitLossPctItem);
    return this;
  }

   /**
   * profit/loss in percentage from the base value
   * @return profitLossPct
  **/
  @javax.annotation.Nonnull
  public List<BigDecimal> getProfitLossPct() {
    return profitLossPct;
  }

  public void setProfitLossPct(List<BigDecimal> profitLossPct) {
    this.profitLossPct = profitLossPct;
  }


  public PortfolioHistory baseValue(BigDecimal baseValue) {
    this.baseValue = baseValue;
    return this;
  }

   /**
   * basis in dollar of the profit loss calculation
   * @return baseValue
  **/
  @javax.annotation.Nonnull
  public BigDecimal getBaseValue() {
    return baseValue;
  }

  public void setBaseValue(BigDecimal baseValue) {
    this.baseValue = baseValue;
  }


  public PortfolioHistory baseValueAsof(LocalDate baseValueAsof) {
    this.baseValueAsof = baseValueAsof;
    return this;
  }

   /**
   * If included, then it indicates that the base_value is the account&#39;s closing  equity value at this trading date.  If not specified, then the baseline calculation is done against the earliest returned data item. This could happen for accounts without prior closing balances (e.g. new account) or for queries with 1D timeframes, where the first data point is used as a reference point. 
   * @return baseValueAsof
  **/
  @javax.annotation.Nullable
  public LocalDate getBaseValueAsof() {
    return baseValueAsof;
  }

  public void setBaseValueAsof(LocalDate baseValueAsof) {
    this.baseValueAsof = baseValueAsof;
  }


  public PortfolioHistory timeframe(String timeframe) {
    this.timeframe = timeframe;
    return this;
  }

   /**
   * time window size of each data element
   * @return timeframe
  **/
  @javax.annotation.Nonnull
  public String getTimeframe() {
    return timeframe;
  }

  public void setTimeframe(String timeframe) {
    this.timeframe = timeframe;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PortfolioHistory portfolioHistory = (PortfolioHistory) o;
    return Objects.equals(this.timestamp, portfolioHistory.timestamp) &&
        Objects.equals(this.equity, portfolioHistory.equity) &&
        Objects.equals(this.profitLoss, portfolioHistory.profitLoss) &&
        Objects.equals(this.profitLossPct, portfolioHistory.profitLossPct) &&
        Objects.equals(this.baseValue, portfolioHistory.baseValue) &&
        Objects.equals(this.baseValueAsof, portfolioHistory.baseValueAsof) &&
        Objects.equals(this.timeframe, portfolioHistory.timeframe);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timestamp, equity, profitLoss, profitLossPct, baseValue, baseValueAsof, timeframe);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PortfolioHistory {\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    equity: ").append(toIndentedString(equity)).append("\n");
    sb.append("    profitLoss: ").append(toIndentedString(profitLoss)).append("\n");
    sb.append("    profitLossPct: ").append(toIndentedString(profitLossPct)).append("\n");
    sb.append("    baseValue: ").append(toIndentedString(baseValue)).append("\n");
    sb.append("    baseValueAsof: ").append(toIndentedString(baseValueAsof)).append("\n");
    sb.append("    timeframe: ").append(toIndentedString(timeframe)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("timestamp");
    openapiFields.add("equity");
    openapiFields.add("profit_loss");
    openapiFields.add("profit_loss_pct");
    openapiFields.add("base_value");
    openapiFields.add("base_value_asof");
    openapiFields.add("timeframe");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("timestamp");
    openapiRequiredFields.add("equity");
    openapiRequiredFields.add("profit_loss");
    openapiRequiredFields.add("profit_loss_pct");
    openapiRequiredFields.add("base_value");
    openapiRequiredFields.add("timeframe");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!PortfolioHistory.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PortfolioHistory is not found in the empty JSON string", PortfolioHistory.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PortfolioHistory.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PortfolioHistory` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PortfolioHistory.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the required json array is present
      if (jsonObj.get("timestamp") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("timestamp").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `timestamp` to be an array in the JSON string but got `%s`", jsonObj.get("timestamp").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("equity") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("equity").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `equity` to be an array in the JSON string but got `%s`", jsonObj.get("equity").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("profit_loss") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("profit_loss").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `profit_loss` to be an array in the JSON string but got `%s`", jsonObj.get("profit_loss").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("profit_loss_pct") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("profit_loss_pct").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `profit_loss_pct` to be an array in the JSON string but got `%s`", jsonObj.get("profit_loss_pct").toString()));
      }
      if (!jsonObj.get("timeframe").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `timeframe` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timeframe").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PortfolioHistory.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PortfolioHistory' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PortfolioHistory> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PortfolioHistory.class));

       return (TypeAdapter<T>) new TypeAdapter<PortfolioHistory>() {
           @Override
           public void write(JsonWriter out, PortfolioHistory value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PortfolioHistory read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PortfolioHistory given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PortfolioHistory
  * @throws IOException if the JSON string is invalid with respect to PortfolioHistory
  */
  public static PortfolioHistory fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PortfolioHistory.class);
  }

 /**
  * Convert an instance of PortfolioHistory to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

