/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioWeights;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Portfolio
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Portfolio {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private String status;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_WEIGHTS = "weights";
  @SerializedName(SERIALIZED_NAME_WEIGHTS)
  private List<PortfolioWeights> weights;

  public static final String SERIALIZED_NAME_COOLDOWN_DAYS = "cooldown_days";
  @SerializedName(SERIALIZED_NAME_COOLDOWN_DAYS)
  private String cooldownDays;

  public static final String SERIALIZED_NAME_REBALANCING_CONDITIONS = "rebalancing_conditions";
  @SerializedName(SERIALIZED_NAME_REBALANCING_CONDITIONS)
  private String rebalancingConditions;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private String createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private String updatedAt;

  public Portfolio() {
  }

  public Portfolio id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Portfolio ID
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public Portfolio name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name of portfolio
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public Portfolio status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Current status of portfolio
   * @return status
  **/
  @javax.annotation.Nullable
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }


  public Portfolio description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Text to describe portfolio
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public Portfolio weights(List<PortfolioWeights> weights) {
    this.weights = weights;
    return this;
  }

  public Portfolio addWeightsItem(PortfolioWeights weightsItem) {
    if (this.weights == null) {
      this.weights = new ArrayList<>();
    }
    this.weights.add(weightsItem);
    return this;
  }

   /**
   * Weight configuration to portfolio. Sum of “percent” values in the weights array must be 100.00
   * @return weights
  **/
  @javax.annotation.Nullable
  public List<PortfolioWeights> getWeights() {
    return weights;
  }

  public void setWeights(List<PortfolioWeights> weights) {
    this.weights = weights;
  }


  public Portfolio cooldownDays(String cooldownDays) {
    this.cooldownDays = cooldownDays;
    return this;
  }

   /**
   * Count of calendar days following a rebalance before a subscription is eligible to trigger another rebalance
   * @return cooldownDays
  **/
  @javax.annotation.Nullable
  public String getCooldownDays() {
    return cooldownDays;
  }

  public void setCooldownDays(String cooldownDays) {
    this.cooldownDays = cooldownDays;
  }


  public Portfolio rebalancingConditions(String rebalancingConditions) {
    this.rebalancingConditions = rebalancingConditions;
    return this;
  }

   /**
   * Rebalancing conditions for portfolio
   * @return rebalancingConditions
  **/
  @javax.annotation.Nullable
  public String getRebalancingConditions() {
    return rebalancingConditions;
  }

  public void setRebalancingConditions(String rebalancingConditions) {
    this.rebalancingConditions = rebalancingConditions;
  }


  public Portfolio createdAt(String createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Portfolio creation timestamp
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public String getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }


  public Portfolio updatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Portfolio updated timestamp
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public String getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Portfolio portfolio = (Portfolio) o;
    return Objects.equals(this.id, portfolio.id) &&
        Objects.equals(this.name, portfolio.name) &&
        Objects.equals(this.status, portfolio.status) &&
        Objects.equals(this.description, portfolio.description) &&
        Objects.equals(this.weights, portfolio.weights) &&
        Objects.equals(this.cooldownDays, portfolio.cooldownDays) &&
        Objects.equals(this.rebalancingConditions, portfolio.rebalancingConditions) &&
        Objects.equals(this.createdAt, portfolio.createdAt) &&
        Objects.equals(this.updatedAt, portfolio.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, status, description, weights, cooldownDays, rebalancingConditions, createdAt, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Portfolio {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    weights: ").append(toIndentedString(weights)).append("\n");
    sb.append("    cooldownDays: ").append(toIndentedString(cooldownDays)).append("\n");
    sb.append("    rebalancingConditions: ").append(toIndentedString(rebalancingConditions)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("name");
    openapiFields.add("status");
    openapiFields.add("description");
    openapiFields.add("weights");
    openapiFields.add("cooldown_days");
    openapiFields.add("rebalancing_conditions");
    openapiFields.add("created_at");
    openapiFields.add("updated_at");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Portfolio.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Portfolio is not found in the empty JSON string", Portfolio.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Portfolio.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Portfolio` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) && !jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("weights") != null && !jsonObj.get("weights").isJsonNull()) {
        JsonArray jsonArrayweights = jsonObj.getAsJsonArray("weights");
        if (jsonArrayweights != null) {
          // ensure the json data is an array
          if (!jsonObj.get("weights").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `weights` to be an array in the JSON string but got `%s`", jsonObj.get("weights").toString()));
          }

          // validate the optional field `weights` (array)
          for (int i = 0; i < jsonArrayweights.size(); i++) {
            PortfolioWeights.validateJsonElement(jsonArrayweights.get(i));
          };
        }
      }
      if ((jsonObj.get("cooldown_days") != null && !jsonObj.get("cooldown_days").isJsonNull()) && !jsonObj.get("cooldown_days").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cooldown_days` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cooldown_days").toString()));
      }
      if ((jsonObj.get("rebalancing_conditions") != null && !jsonObj.get("rebalancing_conditions").isJsonNull()) && !jsonObj.get("rebalancing_conditions").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rebalancing_conditions` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rebalancing_conditions").toString()));
      }
      if ((jsonObj.get("created_at") != null && !jsonObj.get("created_at").isJsonNull()) && !jsonObj.get("created_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `created_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("created_at").toString()));
      }
      if ((jsonObj.get("updated_at") != null && !jsonObj.get("updated_at").isJsonNull()) && !jsonObj.get("updated_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `updated_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("updated_at").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Portfolio.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Portfolio' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Portfolio> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Portfolio.class));

       return (TypeAdapter<T>) new TypeAdapter<Portfolio>() {
           @Override
           public void write(JsonWriter out, Portfolio value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Portfolio read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Portfolio given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Portfolio
  * @throws IOException if the JSON string is invalid with respect to Portfolio
  */
  public static Portfolio fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Portfolio.class);
  }

 /**
  * Convert an instance of Portfolio to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

