/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioWeights;
import net.jacobpeterson.alpaca.openapi.broker.model.RebalancingConditions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * PatchV1RebalancingPortfoliosPortfolioIdRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class PatchV1RebalancingPortfoliosPortfolioIdRequest {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_WEIGHTS = "weights";
  @SerializedName(SERIALIZED_NAME_WEIGHTS)
  private List<PortfolioWeights> weights;

  public static final String SERIALIZED_NAME_REBALANCING_CONDITIONS = "rebalancing_conditions";
  @SerializedName(SERIALIZED_NAME_REBALANCING_CONDITIONS)
  private List<RebalancingConditions> rebalancingConditions;

  public static final String SERIALIZED_NAME_COOLDOWN_DAYS = "cooldown_days";
  @SerializedName(SERIALIZED_NAME_COOLDOWN_DAYS)
  private String cooldownDays;

  public PatchV1RebalancingPortfoliosPortfolioIdRequest() {
  }

  public PatchV1RebalancingPortfoliosPortfolioIdRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Used to update portfolio name.
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public PatchV1RebalancingPortfoliosPortfolioIdRequest description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Used to update portfolio description.
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public PatchV1RebalancingPortfoliosPortfolioIdRequest weights(List<PortfolioWeights> weights) {
    this.weights = weights;
    return this;
  }

  public PatchV1RebalancingPortfoliosPortfolioIdRequest addWeightsItem(PortfolioWeights weightsItem) {
    if (this.weights == null) {
      this.weights = new ArrayList<>();
    }
    this.weights.add(weightsItem);
    return this;
  }

   /**
   * Used to update portfolio weights.
   * @return weights
  **/
  @javax.annotation.Nullable
  public List<PortfolioWeights> getWeights() {
    return weights;
  }

  public void setWeights(List<PortfolioWeights> weights) {
    this.weights = weights;
  }


  public PatchV1RebalancingPortfoliosPortfolioIdRequest rebalancingConditions(List<RebalancingConditions> rebalancingConditions) {
    this.rebalancingConditions = rebalancingConditions;
    return this;
  }

  public PatchV1RebalancingPortfoliosPortfolioIdRequest addRebalancingConditionsItem(RebalancingConditions rebalancingConditionsItem) {
    if (this.rebalancingConditions == null) {
      this.rebalancingConditions = new ArrayList<>();
    }
    this.rebalancingConditions.add(rebalancingConditionsItem);
    return this;
  }

   /**
   * Used to update portfolio conditions.
   * @return rebalancingConditions
  **/
  @javax.annotation.Nullable
  public List<RebalancingConditions> getRebalancingConditions() {
    return rebalancingConditions;
  }

  public void setRebalancingConditions(List<RebalancingConditions> rebalancingConditions) {
    this.rebalancingConditions = rebalancingConditions;
  }


  public PatchV1RebalancingPortfoliosPortfolioIdRequest cooldownDays(String cooldownDays) {
    this.cooldownDays = cooldownDays;
    return this;
  }

   /**
   * Used to update portfolio cooldown days.
   * @return cooldownDays
  **/
  @javax.annotation.Nullable
  public String getCooldownDays() {
    return cooldownDays;
  }

  public void setCooldownDays(String cooldownDays) {
    this.cooldownDays = cooldownDays;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PatchV1RebalancingPortfoliosPortfolioIdRequest patchV1RebalancingPortfoliosPortfolioIdRequest = (PatchV1RebalancingPortfoliosPortfolioIdRequest) o;
    return Objects.equals(this.name, patchV1RebalancingPortfoliosPortfolioIdRequest.name) &&
        Objects.equals(this.description, patchV1RebalancingPortfoliosPortfolioIdRequest.description) &&
        Objects.equals(this.weights, patchV1RebalancingPortfoliosPortfolioIdRequest.weights) &&
        Objects.equals(this.rebalancingConditions, patchV1RebalancingPortfoliosPortfolioIdRequest.rebalancingConditions) &&
        Objects.equals(this.cooldownDays, patchV1RebalancingPortfoliosPortfolioIdRequest.cooldownDays);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, weights, rebalancingConditions, cooldownDays);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PatchV1RebalancingPortfoliosPortfolioIdRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    weights: ").append(toIndentedString(weights)).append("\n");
    sb.append("    rebalancingConditions: ").append(toIndentedString(rebalancingConditions)).append("\n");
    sb.append("    cooldownDays: ").append(toIndentedString(cooldownDays)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("weights");
    openapiFields.add("rebalancing_conditions");
    openapiFields.add("cooldown_days");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!PatchV1RebalancingPortfoliosPortfolioIdRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PatchV1RebalancingPortfoliosPortfolioIdRequest is not found in the empty JSON string", PatchV1RebalancingPortfoliosPortfolioIdRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PatchV1RebalancingPortfoliosPortfolioIdRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PatchV1RebalancingPortfoliosPortfolioIdRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("weights") != null && !jsonObj.get("weights").isJsonNull()) {
        JsonArray jsonArrayweights = jsonObj.getAsJsonArray("weights");
        if (jsonArrayweights != null) {
          // ensure the json data is an array
          if (!jsonObj.get("weights").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `weights` to be an array in the JSON string but got `%s`", jsonObj.get("weights").toString()));
          }

          // validate the optional field `weights` (array)
          for (int i = 0; i < jsonArrayweights.size(); i++) {
            PortfolioWeights.validateJsonElement(jsonArrayweights.get(i));
          };
        }
      }
      if (jsonObj.get("rebalancing_conditions") != null && !jsonObj.get("rebalancing_conditions").isJsonNull()) {
        JsonArray jsonArrayrebalancingConditions = jsonObj.getAsJsonArray("rebalancing_conditions");
        if (jsonArrayrebalancingConditions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("rebalancing_conditions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `rebalancing_conditions` to be an array in the JSON string but got `%s`", jsonObj.get("rebalancing_conditions").toString()));
          }

          // validate the optional field `rebalancing_conditions` (array)
          for (int i = 0; i < jsonArrayrebalancingConditions.size(); i++) {
            RebalancingConditions.validateJsonElement(jsonArrayrebalancingConditions.get(i));
          };
        }
      }
      if ((jsonObj.get("cooldown_days") != null && !jsonObj.get("cooldown_days").isJsonNull()) && !jsonObj.get("cooldown_days").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cooldown_days` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cooldown_days").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PatchV1RebalancingPortfoliosPortfolioIdRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PatchV1RebalancingPortfoliosPortfolioIdRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PatchV1RebalancingPortfoliosPortfolioIdRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PatchV1RebalancingPortfoliosPortfolioIdRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<PatchV1RebalancingPortfoliosPortfolioIdRequest>() {
           @Override
           public void write(JsonWriter out, PatchV1RebalancingPortfoliosPortfolioIdRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PatchV1RebalancingPortfoliosPortfolioIdRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PatchV1RebalancingPortfoliosPortfolioIdRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PatchV1RebalancingPortfoliosPortfolioIdRequest
  * @throws IOException if the JSON string is invalid with respect to PatchV1RebalancingPortfoliosPortfolioIdRequest
  */
  public static PatchV1RebalancingPortfoliosPortfolioIdRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PatchV1RebalancingPortfoliosPortfolioIdRequest.class);
  }

 /**
  * Convert an instance of PatchV1RebalancingPortfoliosPortfolioIdRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

