/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * The order types supported by Alpaca vary based on the order&#39;s security type. The following provides a comprehensive breakdown of the supported order types for each category:  - Equity trading: market, limit, stop, stop_limit, trailing_stop.  - Options trading: market, limit, stop, stop_limit.  - Crypto trading: market, limit, stop_limit.
 */
@JsonAdapter(OrderType.Adapter.class)
public enum OrderType {
  
  MARKET("market"),
  
  LIMIT("limit"),
  
  STOP("stop"),
  
  STOP_LIMIT("stop_limit"),
  
  TRAILING_STOP("trailing_stop");

  private String value;

  OrderType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static OrderType fromValue(String value) {
    for (OrderType b : OrderType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<OrderType> {
    @Override
    public void write(final JsonWriter jsonWriter, final OrderType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public OrderType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return OrderType.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    OrderType.fromValue(value);
  }
}

