/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets OrderStatus
 */
@JsonAdapter(OrderStatus.Adapter.class)
public enum OrderStatus {
  
  NEW("new"),
  
  PARTIALLY_FILLED("partially_filled"),
  
  FILLED("filled"),
  
  DONE_FOR_DAY("done_for_day"),
  
  CANCELED("canceled"),
  
  EXPIRED("expired"),
  
  REPLACED("replaced"),
  
  PENDING_CANCEL("pending_cancel"),
  
  PENDING_REPLACE("pending_replace"),
  
  ACCEPTED("accepted"),
  
  PENDING_NEW("pending_new"),
  
  ACCEPTED_FOR_BIDDING("accepted_for_bidding"),
  
  STOPPED("stopped"),
  
  REJECTED("rejected"),
  
  SUSPENDED("suspended"),
  
  CALCULATED("calculated");

  private String value;

  OrderStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static OrderStatus fromValue(String value) {
    for (OrderStatus b : OrderStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<OrderStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final OrderStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public OrderStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return OrderStatus.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    OrderStatus.fromValue(value);
  }
}

