/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * The order classes supported by Alpaca vary based on the order&#39;s security type. The following provides a comprehensive breakdown of the supported order classes for each category:  - Equity trading: simple (or \&quot;\&quot;), oco, oto, bracket.  - Options trading: simple (or \&quot;\&quot;).  - Crypto trading: simple (or \&quot;\&quot;).
 */
@JsonAdapter(OrderClass.Adapter.class)
public enum OrderClass {
  
  SIMPLE("simple"),
  
  BRACKET("bracket"),
  
  OCO("oco"),
  
  OTO("oto");

  private String value;

  OrderClass(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static OrderClass fromValue(String value) {
    for (OrderClass b : OrderClass.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<OrderClass> {
    @Override
    public void write(final JsonWriter jsonWriter, final OrderClass enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public OrderClass read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return OrderClass.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    OrderClass.fromValue(value);
  }
}

