/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderClass;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderType;
import net.jacobpeterson.alpaca.openapi.broker.model.TimeInForce;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Order
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Order {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_CLIENT_ORDER_ID = "client_order_id";
  @SerializedName(SERIALIZED_NAME_CLIENT_ORDER_ID)
  private String clientOrderId;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_SUBMITTED_AT = "submitted_at";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_AT)
  private OffsetDateTime submittedAt;

  public static final String SERIALIZED_NAME_FILLED_AT = "filled_at";
  @SerializedName(SERIALIZED_NAME_FILLED_AT)
  private OffsetDateTime filledAt;

  public static final String SERIALIZED_NAME_EXPIRED_AT = "expired_at";
  @SerializedName(SERIALIZED_NAME_EXPIRED_AT)
  private OffsetDateTime expiredAt;

  public static final String SERIALIZED_NAME_CANCELED_AT = "canceled_at";
  @SerializedName(SERIALIZED_NAME_CANCELED_AT)
  private OffsetDateTime canceledAt;

  public static final String SERIALIZED_NAME_FAILED_AT = "failed_at";
  @SerializedName(SERIALIZED_NAME_FAILED_AT)
  private OffsetDateTime failedAt;

  public static final String SERIALIZED_NAME_REPLACED_AT = "replaced_at";
  @SerializedName(SERIALIZED_NAME_REPLACED_AT)
  private OffsetDateTime replacedAt;

  public static final String SERIALIZED_NAME_REPLACED_BY = "replaced_by";
  @SerializedName(SERIALIZED_NAME_REPLACED_BY)
  private UUID replacedBy;

  public static final String SERIALIZED_NAME_REPLACES = "replaces";
  @SerializedName(SERIALIZED_NAME_REPLACES)
  private UUID replaces;

  public static final String SERIALIZED_NAME_ASSET_ID = "asset_id";
  @SerializedName(SERIALIZED_NAME_ASSET_ID)
  private UUID assetId;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_ASSET_CLASS = "asset_class";
  @SerializedName(SERIALIZED_NAME_ASSET_CLASS)
  private AssetClass assetClass;

  public static final String SERIALIZED_NAME_NOTIONAL = "notional";
  @SerializedName(SERIALIZED_NAME_NOTIONAL)
  private BigDecimal notional;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private BigDecimal qty;

  public static final String SERIALIZED_NAME_FILLED_QTY = "filled_qty";
  @SerializedName(SERIALIZED_NAME_FILLED_QTY)
  private BigDecimal filledQty;

  public static final String SERIALIZED_NAME_FILLED_AVG_PRICE = "filled_avg_price";
  @SerializedName(SERIALIZED_NAME_FILLED_AVG_PRICE)
  private BigDecimal filledAvgPrice;

  public static final String SERIALIZED_NAME_ORDER_CLASS = "order_class";
  @SerializedName(SERIALIZED_NAME_ORDER_CLASS)
  private OrderClass orderClass;

  public static final String SERIALIZED_NAME_ORDER_TYPE = "order_type";
  @SerializedName(SERIALIZED_NAME_ORDER_TYPE)
  private OrderType orderType;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private OrderType type;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private OrderSide side;

  public static final String SERIALIZED_NAME_TIME_IN_FORCE = "time_in_force";
  @SerializedName(SERIALIZED_NAME_TIME_IN_FORCE)
  private TimeInForce timeInForce;

  public static final String SERIALIZED_NAME_LIMIT_PRICE = "limit_price";
  @SerializedName(SERIALIZED_NAME_LIMIT_PRICE)
  private BigDecimal limitPrice;

  public static final String SERIALIZED_NAME_STOP_PRICE = "stop_price";
  @SerializedName(SERIALIZED_NAME_STOP_PRICE)
  private BigDecimal stopPrice;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private OrderStatus status;

  public static final String SERIALIZED_NAME_EXTENDED_HOURS = "extended_hours";
  @SerializedName(SERIALIZED_NAME_EXTENDED_HOURS)
  private Boolean extendedHours;

  public static final String SERIALIZED_NAME_LEGS = "legs";
  @SerializedName(SERIALIZED_NAME_LEGS)
  private List<Order> legs;

  public static final String SERIALIZED_NAME_TRAIL_PRICE = "trail_price";
  @SerializedName(SERIALIZED_NAME_TRAIL_PRICE)
  private BigDecimal trailPrice;

  public static final String SERIALIZED_NAME_TRAIL_PERCENT = "trail_percent";
  @SerializedName(SERIALIZED_NAME_TRAIL_PERCENT)
  private BigDecimal trailPercent;

  public static final String SERIALIZED_NAME_HWM = "hwm";
  @SerializedName(SERIALIZED_NAME_HWM)
  private BigDecimal hwm;

  public static final String SERIALIZED_NAME_COMMISSION = "commission";
  @SerializedName(SERIALIZED_NAME_COMMISSION)
  private BigDecimal commission;

  public static final String SERIALIZED_NAME_COMMISSION_BPS = "commission_bps";
  @SerializedName(SERIALIZED_NAME_COMMISSION_BPS)
  private BigDecimal commissionBps;

  public static final String SERIALIZED_NAME_SWAP_RATE = "swap_rate";
  @SerializedName(SERIALIZED_NAME_SWAP_RATE)
  private String swapRate;

  public static final String SERIALIZED_NAME_SWAP_FEE_BPS = "swap_fee_bps";
  @SerializedName(SERIALIZED_NAME_SWAP_FEE_BPS)
  private String swapFeeBps;

  public static final String SERIALIZED_NAME_USD = "usd";
  @SerializedName(SERIALIZED_NAME_USD)
  private Object usd;

  public Order() {
  }

  public Order id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Order ID generated by Alpaca
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public Order clientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
    return this;
  }

   /**
   * Client unique order ID
   * @return clientOrderId
  **/
  @javax.annotation.Nullable
  public String getClientOrderId() {
    return clientOrderId;
  }

  public void setClientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
  }


  public Order createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Time when order was entered
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Order updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Time of most recent change to the order
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public Order submittedAt(OffsetDateTime submittedAt) {
    this.submittedAt = submittedAt;
    return this;
  }

   /**
   * Time the order was submitted for execution or, if not yet submitted the created_at time. Because orders are submitted for execution asynchronous to database updates, at times this may be before the created_at time.
   * @return submittedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getSubmittedAt() {
    return submittedAt;
  }

  public void setSubmittedAt(OffsetDateTime submittedAt) {
    this.submittedAt = submittedAt;
  }


  public Order filledAt(OffsetDateTime filledAt) {
    this.filledAt = filledAt;
    return this;
  }

   /**
   * Time the order was filled. Can be null if not filled
   * @return filledAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getFilledAt() {
    return filledAt;
  }

  public void setFilledAt(OffsetDateTime filledAt) {
    this.filledAt = filledAt;
  }


  public Order expiredAt(OffsetDateTime expiredAt) {
    this.expiredAt = expiredAt;
    return this;
  }

   /**
   * Can be null
   * @return expiredAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getExpiredAt() {
    return expiredAt;
  }

  public void setExpiredAt(OffsetDateTime expiredAt) {
    this.expiredAt = expiredAt;
  }


  public Order canceledAt(OffsetDateTime canceledAt) {
    this.canceledAt = canceledAt;
    return this;
  }

   /**
   * Can be null
   * @return canceledAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCanceledAt() {
    return canceledAt;
  }

  public void setCanceledAt(OffsetDateTime canceledAt) {
    this.canceledAt = canceledAt;
  }


  public Order failedAt(OffsetDateTime failedAt) {
    this.failedAt = failedAt;
    return this;
  }

   /**
   * Can be null
   * @return failedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getFailedAt() {
    return failedAt;
  }

  public void setFailedAt(OffsetDateTime failedAt) {
    this.failedAt = failedAt;
  }


  public Order replacedAt(OffsetDateTime replacedAt) {
    this.replacedAt = replacedAt;
    return this;
  }

   /**
   * Can be null
   * @return replacedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getReplacedAt() {
    return replacedAt;
  }

  public void setReplacedAt(OffsetDateTime replacedAt) {
    this.replacedAt = replacedAt;
  }


  public Order replacedBy(UUID replacedBy) {
    this.replacedBy = replacedBy;
    return this;
  }

   /**
   * The order ID that this order was replaced by. (Can be null)
   * @return replacedBy
  **/
  @javax.annotation.Nullable
  public UUID getReplacedBy() {
    return replacedBy;
  }

  public void setReplacedBy(UUID replacedBy) {
    this.replacedBy = replacedBy;
  }


  public Order replaces(UUID replaces) {
    this.replaces = replaces;
    return this;
  }

   /**
   * The order ID that this order replaces. (Can be null)
   * @return replaces
  **/
  @javax.annotation.Nullable
  public UUID getReplaces() {
    return replaces;
  }

  public void setReplaces(UUID replaces) {
    this.replaces = replaces;
  }


  public Order assetId(UUID assetId) {
    this.assetId = assetId;
    return this;
  }

   /**
   * The asset ID (For options this represents the option contract ID)
   * @return assetId
  **/
  @javax.annotation.Nullable
  public UUID getAssetId() {
    return assetId;
  }

  public void setAssetId(UUID assetId) {
    this.assetId = assetId;
  }


  public Order symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The asset symbol
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public Order assetClass(AssetClass assetClass) {
    this.assetClass = assetClass;
    return this;
  }

   /**
   * Get assetClass
   * @return assetClass
  **/
  @javax.annotation.Nullable
  public AssetClass getAssetClass() {
    return assetClass;
  }

  public void setAssetClass(AssetClass assetClass) {
    this.assetClass = assetClass;
  }


  public Order notional(BigDecimal notional) {
    this.notional = notional;
    return this;
  }

   /**
   * Ordered notional amount. If entered, qty will be null. Can take up to 2 decimal points.
   * @return notional
  **/
  @javax.annotation.Nullable
  public BigDecimal getNotional() {
    return notional;
  }

  public void setNotional(BigDecimal notional) {
    this.notional = notional;
  }


  public Order qty(BigDecimal qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Ordered quantity. If entered, notional will be null. Can take up to 2 decimal points.
   * @return qty
  **/
  @javax.annotation.Nullable
  public BigDecimal getQty() {
    return qty;
  }

  public void setQty(BigDecimal qty) {
    this.qty = qty;
  }


  public Order filledQty(BigDecimal filledQty) {
    this.filledQty = filledQty;
    return this;
  }

   /**
   * Filled quantity
   * @return filledQty
  **/
  @javax.annotation.Nullable
  public BigDecimal getFilledQty() {
    return filledQty;
  }

  public void setFilledQty(BigDecimal filledQty) {
    this.filledQty = filledQty;
  }


  public Order filledAvgPrice(BigDecimal filledAvgPrice) {
    this.filledAvgPrice = filledAvgPrice;
    return this;
  }

   /**
   * Filled average price. Can be 0 until order is processed in case order is passed outside of market hours
   * @return filledAvgPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getFilledAvgPrice() {
    return filledAvgPrice;
  }

  public void setFilledAvgPrice(BigDecimal filledAvgPrice) {
    this.filledAvgPrice = filledAvgPrice;
  }


  public Order orderClass(OrderClass orderClass) {
    this.orderClass = orderClass;
    return this;
  }

   /**
   * Get orderClass
   * @return orderClass
  **/
  @javax.annotation.Nullable
  public OrderClass getOrderClass() {
    return orderClass;
  }

  public void setOrderClass(OrderClass orderClass) {
    this.orderClass = orderClass;
  }


  public Order orderType(OrderType orderType) {
    this.orderType = orderType;
    return this;
  }

   /**
   * Get orderType
   * @return orderType
  **/
  @javax.annotation.Nullable
  public OrderType getOrderType() {
    return orderType;
  }

  public void setOrderType(OrderType orderType) {
    this.orderType = orderType;
  }


  public Order type(OrderType type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  public OrderType getType() {
    return type;
  }

  public void setType(OrderType type) {
    this.type = type;
  }


  public Order side(OrderSide side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @javax.annotation.Nullable
  public OrderSide getSide() {
    return side;
  }

  public void setSide(OrderSide side) {
    this.side = side;
  }


  public Order timeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
    return this;
  }

   /**
   * Get timeInForce
   * @return timeInForce
  **/
  @javax.annotation.Nullable
  public TimeInForce getTimeInForce() {
    return timeInForce;
  }

  public void setTimeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
  }


  public Order limitPrice(BigDecimal limitPrice) {
    this.limitPrice = limitPrice;
    return this;
  }

   /**
   * Limit price
   * @return limitPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getLimitPrice() {
    return limitPrice;
  }

  public void setLimitPrice(BigDecimal limitPrice) {
    this.limitPrice = limitPrice;
  }


  public Order stopPrice(BigDecimal stopPrice) {
    this.stopPrice = stopPrice;
    return this;
  }

   /**
   * Stop price
   * @return stopPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getStopPrice() {
    return stopPrice;
  }

  public void setStopPrice(BigDecimal stopPrice) {
    this.stopPrice = stopPrice;
  }


  public Order status(OrderStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  public OrderStatus getStatus() {
    return status;
  }

  public void setStatus(OrderStatus status) {
    this.status = status;
  }


  public Order extendedHours(Boolean extendedHours) {
    this.extendedHours = extendedHours;
    return this;
  }

   /**
   * Get extendedHours
   * @return extendedHours
  **/
  @javax.annotation.Nullable
  public Boolean getExtendedHours() {
    return extendedHours;
  }

  public void setExtendedHours(Boolean extendedHours) {
    this.extendedHours = extendedHours;
  }


  public Order legs(List<Order> legs) {
    this.legs = legs;
    return this;
  }

  public Order addLegsItem(Order legsItem) {
    if (this.legs == null) {
      this.legs = new ArrayList<>();
    }
    this.legs.add(legsItem);
    return this;
  }

   /**
   * When querying non-simple order_class orders in a nested style, an array of Order entities associated with this order. Otherwise, null.
   * @return legs
  **/
  @javax.annotation.Nullable
  public List<Order> getLegs() {
    return legs;
  }

  public void setLegs(List<Order> legs) {
    this.legs = legs;
  }


  public Order trailPrice(BigDecimal trailPrice) {
    this.trailPrice = trailPrice;
    return this;
  }

   /**
   * The dollar value away from the high water mark for trailing stop orders.
   * @return trailPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getTrailPrice() {
    return trailPrice;
  }

  public void setTrailPrice(BigDecimal trailPrice) {
    this.trailPrice = trailPrice;
  }


  public Order trailPercent(BigDecimal trailPercent) {
    this.trailPercent = trailPercent;
    return this;
  }

   /**
   * The percent value away from the high water mark for trailing stop orders.
   * @return trailPercent
  **/
  @javax.annotation.Nullable
  public BigDecimal getTrailPercent() {
    return trailPercent;
  }

  public void setTrailPercent(BigDecimal trailPercent) {
    this.trailPercent = trailPercent;
  }


  public Order hwm(BigDecimal hwm) {
    this.hwm = hwm;
    return this;
  }

   /**
   * The highest (lowest) market price seen since the trailing stop order was submitted.
   * @return hwm
  **/
  @javax.annotation.Nullable
  public BigDecimal getHwm() {
    return hwm;
  }

  public void setHwm(BigDecimal hwm) {
    this.hwm = hwm;
  }


  public Order commission(BigDecimal commission) {
    this.commission = commission;
    return this;
  }

   /**
   * The dollar value commission you want to charge the end user.
   * @return commission
  **/
  @javax.annotation.Nullable
  public BigDecimal getCommission() {
    return commission;
  }

  public void setCommission(BigDecimal commission) {
    this.commission = commission;
  }


  public Order commissionBps(BigDecimal commissionBps) {
    this.commissionBps = commissionBps;
    return this;
  }

   /**
   * The percent commission you want to charge the end user on the order (expressed in bps). Alpaca will convert the order to a notional amount for purposes of calculating commission
   * @return commissionBps
  **/
  @javax.annotation.Nullable
  public BigDecimal getCommissionBps() {
    return commissionBps;
  }

  public void setCommissionBps(BigDecimal commissionBps) {
    this.commissionBps = commissionBps;
  }


  public Order swapRate(String swapRate) {
    this.swapRate = swapRate;
    return this;
  }

   /**
   * Swap rate is the exchange rate (without mark-up) used to convert the price into local currency or crypto asset
   * @return swapRate
  **/
  @javax.annotation.Nullable
  public String getSwapRate() {
    return swapRate;
  }

  public void setSwapRate(String swapRate) {
    this.swapRate = swapRate;
  }


  public Order swapFeeBps(String swapFeeBps) {
    this.swapFeeBps = swapFeeBps;
    return this;
  }

   /**
   * Fee in basis points on top swap rate charged by the correspondent on every order
   * @return swapFeeBps
  **/
  @javax.annotation.Nullable
  public String getSwapFeeBps() {
    return swapFeeBps;
  }

  public void setSwapFeeBps(String swapFeeBps) {
    this.swapFeeBps = swapFeeBps;
  }


  public Order usd(Object usd) {
    this.usd = usd;
    return this;
  }

   /**
   * Nested object to encompass the USD equivalent fields for the local currency fields
   * @return usd
  **/
  @javax.annotation.Nullable
  public Object getUsd() {
    return usd;
  }

  public void setUsd(Object usd) {
    this.usd = usd;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Order order = (Order) o;
    return Objects.equals(this.id, order.id) &&
        Objects.equals(this.clientOrderId, order.clientOrderId) &&
        Objects.equals(this.createdAt, order.createdAt) &&
        Objects.equals(this.updatedAt, order.updatedAt) &&
        Objects.equals(this.submittedAt, order.submittedAt) &&
        Objects.equals(this.filledAt, order.filledAt) &&
        Objects.equals(this.expiredAt, order.expiredAt) &&
        Objects.equals(this.canceledAt, order.canceledAt) &&
        Objects.equals(this.failedAt, order.failedAt) &&
        Objects.equals(this.replacedAt, order.replacedAt) &&
        Objects.equals(this.replacedBy, order.replacedBy) &&
        Objects.equals(this.replaces, order.replaces) &&
        Objects.equals(this.assetId, order.assetId) &&
        Objects.equals(this.symbol, order.symbol) &&
        Objects.equals(this.assetClass, order.assetClass) &&
        Objects.equals(this.notional, order.notional) &&
        Objects.equals(this.qty, order.qty) &&
        Objects.equals(this.filledQty, order.filledQty) &&
        Objects.equals(this.filledAvgPrice, order.filledAvgPrice) &&
        Objects.equals(this.orderClass, order.orderClass) &&
        Objects.equals(this.orderType, order.orderType) &&
        Objects.equals(this.type, order.type) &&
        Objects.equals(this.side, order.side) &&
        Objects.equals(this.timeInForce, order.timeInForce) &&
        Objects.equals(this.limitPrice, order.limitPrice) &&
        Objects.equals(this.stopPrice, order.stopPrice) &&
        Objects.equals(this.status, order.status) &&
        Objects.equals(this.extendedHours, order.extendedHours) &&
        Objects.equals(this.legs, order.legs) &&
        Objects.equals(this.trailPrice, order.trailPrice) &&
        Objects.equals(this.trailPercent, order.trailPercent) &&
        Objects.equals(this.hwm, order.hwm) &&
        Objects.equals(this.commission, order.commission) &&
        Objects.equals(this.commissionBps, order.commissionBps) &&
        Objects.equals(this.swapRate, order.swapRate) &&
        Objects.equals(this.swapFeeBps, order.swapFeeBps) &&
        Objects.equals(this.usd, order.usd);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, clientOrderId, createdAt, updatedAt, submittedAt, filledAt, expiredAt, canceledAt, failedAt, replacedAt, replacedBy, replaces, assetId, symbol, assetClass, notional, qty, filledQty, filledAvgPrice, orderClass, orderType, type, side, timeInForce, limitPrice, stopPrice, status, extendedHours, legs, trailPrice, trailPercent, hwm, commission, commissionBps, swapRate, swapFeeBps, usd);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Order {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    clientOrderId: ").append(toIndentedString(clientOrderId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    submittedAt: ").append(toIndentedString(submittedAt)).append("\n");
    sb.append("    filledAt: ").append(toIndentedString(filledAt)).append("\n");
    sb.append("    expiredAt: ").append(toIndentedString(expiredAt)).append("\n");
    sb.append("    canceledAt: ").append(toIndentedString(canceledAt)).append("\n");
    sb.append("    failedAt: ").append(toIndentedString(failedAt)).append("\n");
    sb.append("    replacedAt: ").append(toIndentedString(replacedAt)).append("\n");
    sb.append("    replacedBy: ").append(toIndentedString(replacedBy)).append("\n");
    sb.append("    replaces: ").append(toIndentedString(replaces)).append("\n");
    sb.append("    assetId: ").append(toIndentedString(assetId)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    assetClass: ").append(toIndentedString(assetClass)).append("\n");
    sb.append("    notional: ").append(toIndentedString(notional)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    filledQty: ").append(toIndentedString(filledQty)).append("\n");
    sb.append("    filledAvgPrice: ").append(toIndentedString(filledAvgPrice)).append("\n");
    sb.append("    orderClass: ").append(toIndentedString(orderClass)).append("\n");
    sb.append("    orderType: ").append(toIndentedString(orderType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    timeInForce: ").append(toIndentedString(timeInForce)).append("\n");
    sb.append("    limitPrice: ").append(toIndentedString(limitPrice)).append("\n");
    sb.append("    stopPrice: ").append(toIndentedString(stopPrice)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    extendedHours: ").append(toIndentedString(extendedHours)).append("\n");
    sb.append("    legs: ").append(toIndentedString(legs)).append("\n");
    sb.append("    trailPrice: ").append(toIndentedString(trailPrice)).append("\n");
    sb.append("    trailPercent: ").append(toIndentedString(trailPercent)).append("\n");
    sb.append("    hwm: ").append(toIndentedString(hwm)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    commissionBps: ").append(toIndentedString(commissionBps)).append("\n");
    sb.append("    swapRate: ").append(toIndentedString(swapRate)).append("\n");
    sb.append("    swapFeeBps: ").append(toIndentedString(swapFeeBps)).append("\n");
    sb.append("    usd: ").append(toIndentedString(usd)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("client_order_id");
    openapiFields.add("created_at");
    openapiFields.add("updated_at");
    openapiFields.add("submitted_at");
    openapiFields.add("filled_at");
    openapiFields.add("expired_at");
    openapiFields.add("canceled_at");
    openapiFields.add("failed_at");
    openapiFields.add("replaced_at");
    openapiFields.add("replaced_by");
    openapiFields.add("replaces");
    openapiFields.add("asset_id");
    openapiFields.add("symbol");
    openapiFields.add("asset_class");
    openapiFields.add("notional");
    openapiFields.add("qty");
    openapiFields.add("filled_qty");
    openapiFields.add("filled_avg_price");
    openapiFields.add("order_class");
    openapiFields.add("order_type");
    openapiFields.add("type");
    openapiFields.add("side");
    openapiFields.add("time_in_force");
    openapiFields.add("limit_price");
    openapiFields.add("stop_price");
    openapiFields.add("status");
    openapiFields.add("extended_hours");
    openapiFields.add("legs");
    openapiFields.add("trail_price");
    openapiFields.add("trail_percent");
    openapiFields.add("hwm");
    openapiFields.add("commission");
    openapiFields.add("commission_bps");
    openapiFields.add("swap_rate");
    openapiFields.add("swap_fee_bps");
    openapiFields.add("usd");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("symbol");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Order.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Order is not found in the empty JSON string", Order.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Order.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Order` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Order.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("client_order_id") != null && !jsonObj.get("client_order_id").isJsonNull()) && !jsonObj.get("client_order_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_order_id").toString()));
      }
      if ((jsonObj.get("replaced_by") != null && !jsonObj.get("replaced_by").isJsonNull()) && !jsonObj.get("replaced_by").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `replaced_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get("replaced_by").toString()));
      }
      if ((jsonObj.get("replaces") != null && !jsonObj.get("replaces").isJsonNull()) && !jsonObj.get("replaces").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `replaces` to be a primitive type in the JSON string but got `%s`", jsonObj.get("replaces").toString()));
      }
      if ((jsonObj.get("asset_id") != null && !jsonObj.get("asset_id").isJsonNull()) && !jsonObj.get("asset_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `asset_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("asset_id").toString()));
      }
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      // validate the optional field `asset_class`
      if (jsonObj.get("asset_class") != null && !jsonObj.get("asset_class").isJsonNull()) {
        AssetClass.validateJsonElement(jsonObj.get("asset_class"));
      }
      if ((jsonObj.get("notional") != null && !jsonObj.get("notional").isJsonNull()) && !jsonObj.get("notional").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `notional` to be a primitive type in the JSON string but got `%s`", jsonObj.get("notional").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("filled_qty") != null && !jsonObj.get("filled_qty").isJsonNull()) && !jsonObj.get("filled_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `filled_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("filled_qty").toString()));
      }
      if ((jsonObj.get("filled_avg_price") != null && !jsonObj.get("filled_avg_price").isJsonNull()) && !jsonObj.get("filled_avg_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `filled_avg_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("filled_avg_price").toString()));
      }
      // validate the optional field `order_class`
      if (jsonObj.get("order_class") != null && !jsonObj.get("order_class").isJsonNull()) {
        OrderClass.validateJsonElement(jsonObj.get("order_class"));
      }
      // validate the optional field `order_type`
      if (jsonObj.get("order_type") != null && !jsonObj.get("order_type").isJsonNull()) {
        OrderType.validateJsonElement(jsonObj.get("order_type"));
      }
      // validate the optional field `type`
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) {
        OrderType.validateJsonElement(jsonObj.get("type"));
      }
      // validate the optional field `side`
      if (jsonObj.get("side") != null && !jsonObj.get("side").isJsonNull()) {
        OrderSide.validateJsonElement(jsonObj.get("side"));
      }
      // validate the optional field `time_in_force`
      if (jsonObj.get("time_in_force") != null && !jsonObj.get("time_in_force").isJsonNull()) {
        TimeInForce.validateJsonElement(jsonObj.get("time_in_force"));
      }
      if ((jsonObj.get("limit_price") != null && !jsonObj.get("limit_price").isJsonNull()) && !jsonObj.get("limit_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `limit_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("limit_price").toString()));
      }
      if ((jsonObj.get("stop_price") != null && !jsonObj.get("stop_price").isJsonNull()) && !jsonObj.get("stop_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `stop_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("stop_price").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        OrderStatus.validateJsonElement(jsonObj.get("status"));
      }
      if (jsonObj.get("legs") != null && !jsonObj.get("legs").isJsonNull()) {
        JsonArray jsonArraylegs = jsonObj.getAsJsonArray("legs");
        if (jsonArraylegs != null) {
          // ensure the json data is an array
          if (!jsonObj.get("legs").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `legs` to be an array in the JSON string but got `%s`", jsonObj.get("legs").toString()));
          }

          // validate the optional field `legs` (array)
          for (int i = 0; i < jsonArraylegs.size(); i++) {
            Order.validateJsonElement(jsonArraylegs.get(i));
          };
        }
      }
      if ((jsonObj.get("trail_price") != null && !jsonObj.get("trail_price").isJsonNull()) && !jsonObj.get("trail_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trail_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trail_price").toString()));
      }
      if ((jsonObj.get("trail_percent") != null && !jsonObj.get("trail_percent").isJsonNull()) && !jsonObj.get("trail_percent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trail_percent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trail_percent").toString()));
      }
      if ((jsonObj.get("hwm") != null && !jsonObj.get("hwm").isJsonNull()) && !jsonObj.get("hwm").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `hwm` to be a primitive type in the JSON string but got `%s`", jsonObj.get("hwm").toString()));
      }
      if ((jsonObj.get("commission") != null && !jsonObj.get("commission").isJsonNull()) && !jsonObj.get("commission").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `commission` to be a primitive type in the JSON string but got `%s`", jsonObj.get("commission").toString()));
      }
      if ((jsonObj.get("commission_bps") != null && !jsonObj.get("commission_bps").isJsonNull()) && !jsonObj.get("commission_bps").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `commission_bps` to be a primitive type in the JSON string but got `%s`", jsonObj.get("commission_bps").toString()));
      }
      if ((jsonObj.get("swap_rate") != null && !jsonObj.get("swap_rate").isJsonNull()) && !jsonObj.get("swap_rate").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `swap_rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("swap_rate").toString()));
      }
      if ((jsonObj.get("swap_fee_bps") != null && !jsonObj.get("swap_fee_bps").isJsonNull()) && !jsonObj.get("swap_fee_bps").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `swap_fee_bps` to be a primitive type in the JSON string but got `%s`", jsonObj.get("swap_fee_bps").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Order.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Order' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Order> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Order.class));

       return (TypeAdapter<T>) new TypeAdapter<Order>() {
           @Override
           public void write(JsonWriter out, Order value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Order read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Order given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Order
  * @throws IOException if the JSON string is invalid with respect to Order
  */
  public static Order fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Order.class);
  }

 /**
  * Convert an instance of Order to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

