/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * OptionContract
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class OptionContract {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * The status of the option contract.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    ACTIVE("active"),
    
    INACTIVE("inactive");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      StatusEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TRADABLE = "tradable";
  @SerializedName(SERIALIZED_NAME_TRADABLE)
  private Boolean tradable;

  public static final String SERIALIZED_NAME_EXPIRATION_DATE = "expiration_date";
  @SerializedName(SERIALIZED_NAME_EXPIRATION_DATE)
  private LocalDate expirationDate;

  public static final String SERIALIZED_NAME_ROOT_SYMBOL = "root_symbol";
  @SerializedName(SERIALIZED_NAME_ROOT_SYMBOL)
  private String rootSymbol;

  public static final String SERIALIZED_NAME_UNDERLYING_SYMBOL = "underlying_symbol";
  @SerializedName(SERIALIZED_NAME_UNDERLYING_SYMBOL)
  private String underlyingSymbol;

  public static final String SERIALIZED_NAME_UNDERLYING_ASSET_ID = "underlying_asset_id";
  @SerializedName(SERIALIZED_NAME_UNDERLYING_ASSET_ID)
  private String underlyingAssetId;

  /**
   * The type of the option contract.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    CALL("call"),
    
    PUT("put");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      TypeEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  /**
   * The style of the option contract.
   */
  @JsonAdapter(StyleEnum.Adapter.class)
  public enum StyleEnum {
    AMERICAN("american"),
    
    EUROPEAN("european");

    private String value;

    StyleEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StyleEnum fromValue(String value) {
      for (StyleEnum b : StyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StyleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StyleEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StyleEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StyleEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      StyleEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_STYLE = "style";
  @SerializedName(SERIALIZED_NAME_STYLE)
  private StyleEnum style;

  public static final String SERIALIZED_NAME_STRIKE_PRICE = "strike_price";
  @SerializedName(SERIALIZED_NAME_STRIKE_PRICE)
  private String strikePrice;

  public static final String SERIALIZED_NAME_SIZE = "size";
  @SerializedName(SERIALIZED_NAME_SIZE)
  private String size;

  public static final String SERIALIZED_NAME_OPEN_INTEREST = "open_interest";
  @SerializedName(SERIALIZED_NAME_OPEN_INTEREST)
  private String openInterest;

  public static final String SERIALIZED_NAME_OPEN_INTEREST_DATE = "open_interest_date";
  @SerializedName(SERIALIZED_NAME_OPEN_INTEREST_DATE)
  private LocalDate openInterestDate;

  public static final String SERIALIZED_NAME_CLOSE_PRICE = "close_price";
  @SerializedName(SERIALIZED_NAME_CLOSE_PRICE)
  private String closePrice;

  public static final String SERIALIZED_NAME_CLOSE_PRICE_DATE = "close_price_date";
  @SerializedName(SERIALIZED_NAME_CLOSE_PRICE_DATE)
  private LocalDate closePriceDate;

  public OptionContract() {
  }

  public OptionContract id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the option contract.
   * @return id
  **/
  @javax.annotation.Nonnull
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public OptionContract symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The symbol representing the option contract.
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public OptionContract name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the option contract.
   * @return name
  **/
  @javax.annotation.Nonnull
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public OptionContract status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * The status of the option contract.
   * @return status
  **/
  @javax.annotation.Nonnull
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public OptionContract tradable(Boolean tradable) {
    this.tradable = tradable;
    return this;
  }

   /**
   * Indicates whether the option contract is tradable.
   * @return tradable
  **/
  @javax.annotation.Nonnull
  public Boolean getTradable() {
    return tradable;
  }

  public void setTradable(Boolean tradable) {
    this.tradable = tradable;
  }


  public OptionContract expirationDate(LocalDate expirationDate) {
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * The expiration date of the option contract.
   * @return expirationDate
  **/
  @javax.annotation.Nonnull
  public LocalDate getExpirationDate() {
    return expirationDate;
  }

  public void setExpirationDate(LocalDate expirationDate) {
    this.expirationDate = expirationDate;
  }


  public OptionContract rootSymbol(String rootSymbol) {
    this.rootSymbol = rootSymbol;
    return this;
  }

   /**
   * The root symbol of the option contract.
   * @return rootSymbol
  **/
  @javax.annotation.Nullable
  public String getRootSymbol() {
    return rootSymbol;
  }

  public void setRootSymbol(String rootSymbol) {
    this.rootSymbol = rootSymbol;
  }


  public OptionContract underlyingSymbol(String underlyingSymbol) {
    this.underlyingSymbol = underlyingSymbol;
    return this;
  }

   /**
   * The underlying symbol of the option contract.
   * @return underlyingSymbol
  **/
  @javax.annotation.Nonnull
  public String getUnderlyingSymbol() {
    return underlyingSymbol;
  }

  public void setUnderlyingSymbol(String underlyingSymbol) {
    this.underlyingSymbol = underlyingSymbol;
  }


  public OptionContract underlyingAssetId(String underlyingAssetId) {
    this.underlyingAssetId = underlyingAssetId;
    return this;
  }

   /**
   * The unique identifier of the underlying asset.
   * @return underlyingAssetId
  **/
  @javax.annotation.Nonnull
  public String getUnderlyingAssetId() {
    return underlyingAssetId;
  }

  public void setUnderlyingAssetId(String underlyingAssetId) {
    this.underlyingAssetId = underlyingAssetId;
  }


  public OptionContract type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of the option contract.
   * @return type
  **/
  @javax.annotation.Nonnull
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }


  public OptionContract style(StyleEnum style) {
    this.style = style;
    return this;
  }

   /**
   * The style of the option contract.
   * @return style
  **/
  @javax.annotation.Nonnull
  public StyleEnum getStyle() {
    return style;
  }

  public void setStyle(StyleEnum style) {
    this.style = style;
  }


  public OptionContract strikePrice(String strikePrice) {
    this.strikePrice = strikePrice;
    return this;
  }

   /**
   * The strike price of the option contract.
   * @return strikePrice
  **/
  @javax.annotation.Nonnull
  public String getStrikePrice() {
    return strikePrice;
  }

  public void setStrikePrice(String strikePrice) {
    this.strikePrice = strikePrice;
  }


  public OptionContract size(String size) {
    this.size = size;
    return this;
  }

   /**
   * The size of the option contract. Usually contracts have size&#x3D;100.
   * @return size
  **/
  @javax.annotation.Nonnull
  public String getSize() {
    return size;
  }

  public void setSize(String size) {
    this.size = size;
  }


  public OptionContract openInterest(String openInterest) {
    this.openInterest = openInterest;
    return this;
  }

   /**
   * The open interest of the option contract.
   * @return openInterest
  **/
  @javax.annotation.Nullable
  public String getOpenInterest() {
    return openInterest;
  }

  public void setOpenInterest(String openInterest) {
    this.openInterest = openInterest;
  }


  public OptionContract openInterestDate(LocalDate openInterestDate) {
    this.openInterestDate = openInterestDate;
    return this;
  }

   /**
   * The date of the open interest data.
   * @return openInterestDate
  **/
  @javax.annotation.Nullable
  public LocalDate getOpenInterestDate() {
    return openInterestDate;
  }

  public void setOpenInterestDate(LocalDate openInterestDate) {
    this.openInterestDate = openInterestDate;
  }


  public OptionContract closePrice(String closePrice) {
    this.closePrice = closePrice;
    return this;
  }

   /**
   * The close price of the option contract.
   * @return closePrice
  **/
  @javax.annotation.Nullable
  public String getClosePrice() {
    return closePrice;
  }

  public void setClosePrice(String closePrice) {
    this.closePrice = closePrice;
  }


  public OptionContract closePriceDate(LocalDate closePriceDate) {
    this.closePriceDate = closePriceDate;
    return this;
  }

   /**
   * The date of the close price data.
   * @return closePriceDate
  **/
  @javax.annotation.Nullable
  public LocalDate getClosePriceDate() {
    return closePriceDate;
  }

  public void setClosePriceDate(LocalDate closePriceDate) {
    this.closePriceDate = closePriceDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OptionContract optionContract = (OptionContract) o;
    return Objects.equals(this.id, optionContract.id) &&
        Objects.equals(this.symbol, optionContract.symbol) &&
        Objects.equals(this.name, optionContract.name) &&
        Objects.equals(this.status, optionContract.status) &&
        Objects.equals(this.tradable, optionContract.tradable) &&
        Objects.equals(this.expirationDate, optionContract.expirationDate) &&
        Objects.equals(this.rootSymbol, optionContract.rootSymbol) &&
        Objects.equals(this.underlyingSymbol, optionContract.underlyingSymbol) &&
        Objects.equals(this.underlyingAssetId, optionContract.underlyingAssetId) &&
        Objects.equals(this.type, optionContract.type) &&
        Objects.equals(this.style, optionContract.style) &&
        Objects.equals(this.strikePrice, optionContract.strikePrice) &&
        Objects.equals(this.size, optionContract.size) &&
        Objects.equals(this.openInterest, optionContract.openInterest) &&
        Objects.equals(this.openInterestDate, optionContract.openInterestDate) &&
        Objects.equals(this.closePrice, optionContract.closePrice) &&
        Objects.equals(this.closePriceDate, optionContract.closePriceDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, symbol, name, status, tradable, expirationDate, rootSymbol, underlyingSymbol, underlyingAssetId, type, style, strikePrice, size, openInterest, openInterestDate, closePrice, closePriceDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OptionContract {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tradable: ").append(toIndentedString(tradable)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("    rootSymbol: ").append(toIndentedString(rootSymbol)).append("\n");
    sb.append("    underlyingSymbol: ").append(toIndentedString(underlyingSymbol)).append("\n");
    sb.append("    underlyingAssetId: ").append(toIndentedString(underlyingAssetId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    strikePrice: ").append(toIndentedString(strikePrice)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    openInterest: ").append(toIndentedString(openInterest)).append("\n");
    sb.append("    openInterestDate: ").append(toIndentedString(openInterestDate)).append("\n");
    sb.append("    closePrice: ").append(toIndentedString(closePrice)).append("\n");
    sb.append("    closePriceDate: ").append(toIndentedString(closePriceDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("symbol");
    openapiFields.add("name");
    openapiFields.add("status");
    openapiFields.add("tradable");
    openapiFields.add("expiration_date");
    openapiFields.add("root_symbol");
    openapiFields.add("underlying_symbol");
    openapiFields.add("underlying_asset_id");
    openapiFields.add("type");
    openapiFields.add("style");
    openapiFields.add("strike_price");
    openapiFields.add("size");
    openapiFields.add("open_interest");
    openapiFields.add("open_interest_date");
    openapiFields.add("close_price");
    openapiFields.add("close_price_date");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("name");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("tradable");
    openapiRequiredFields.add("expiration_date");
    openapiRequiredFields.add("underlying_symbol");
    openapiRequiredFields.add("underlying_asset_id");
    openapiRequiredFields.add("type");
    openapiRequiredFields.add("style");
    openapiRequiredFields.add("strike_price");
    openapiRequiredFields.add("size");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!OptionContract.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in OptionContract is not found in the empty JSON string", OptionContract.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!OptionContract.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OptionContract` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : OptionContract.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if (!jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (!jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // validate the required field `status`
      StatusEnum.validateJsonElement(jsonObj.get("status"));
      if ((jsonObj.get("root_symbol") != null && !jsonObj.get("root_symbol").isJsonNull()) && !jsonObj.get("root_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `root_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("root_symbol").toString()));
      }
      if (!jsonObj.get("underlying_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `underlying_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("underlying_symbol").toString()));
      }
      if (!jsonObj.get("underlying_asset_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `underlying_asset_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("underlying_asset_id").toString()));
      }
      if (!jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      // validate the required field `type`
      TypeEnum.validateJsonElement(jsonObj.get("type"));
      if (!jsonObj.get("style").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `style` to be a primitive type in the JSON string but got `%s`", jsonObj.get("style").toString()));
      }
      // validate the required field `style`
      StyleEnum.validateJsonElement(jsonObj.get("style"));
      if (!jsonObj.get("strike_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `strike_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("strike_price").toString()));
      }
      if (!jsonObj.get("size").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `size` to be a primitive type in the JSON string but got `%s`", jsonObj.get("size").toString()));
      }
      if ((jsonObj.get("open_interest") != null && !jsonObj.get("open_interest").isJsonNull()) && !jsonObj.get("open_interest").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `open_interest` to be a primitive type in the JSON string but got `%s`", jsonObj.get("open_interest").toString()));
      }
      if ((jsonObj.get("close_price") != null && !jsonObj.get("close_price").isJsonNull()) && !jsonObj.get("close_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `close_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("close_price").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!OptionContract.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'OptionContract' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<OptionContract> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(OptionContract.class));

       return (TypeAdapter<T>) new TypeAdapter<OptionContract>() {
           @Override
           public void write(JsonWriter out, OptionContract value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public OptionContract read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of OptionContract given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of OptionContract
  * @throws IOException if the JSON string is invalid with respect to OptionContract
  */
  public static OptionContract fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, OptionContract.class);
  }

 /**
  * Convert an instance of OptionContract to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

