/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * OathClientResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class OathClientResponse {
  public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private String clientId;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_URL = "url";
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public static final String SERIALIZED_NAME_TERMS_OF_USE = "terms_of_use";
  @SerializedName(SERIALIZED_NAME_TERMS_OF_USE)
  private String termsOfUse;

  public static final String SERIALIZED_NAME_PRIVACY_POLICY = "privacy_policy";
  @SerializedName(SERIALIZED_NAME_PRIVACY_POLICY)
  private String privacyPolicy;

  /**
   * ACTIVE or DISABLED
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    DISABLED("DISABLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      StatusEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_REDIRECT_URI = "redirect_uri";
  @SerializedName(SERIALIZED_NAME_REDIRECT_URI)
  private List<String> redirectUri;

  public static final String SERIALIZED_NAME_LIVE_TRADING_APPROVED = "live_trading_approved";
  @SerializedName(SERIALIZED_NAME_LIVE_TRADING_APPROVED)
  private Boolean liveTradingApproved;

  public OathClientResponse() {
  }

  public OathClientResponse clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

   /**
   * OAuth client id
   * @return clientId
  **/
  @javax.annotation.Nullable
  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }


  public OathClientResponse name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Broker name (your name)
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public OathClientResponse description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public OathClientResponse url(String url) {
    this.url = url;
    return this;
  }

   /**
   * Get url
   * @return url
  **/
  @javax.annotation.Nullable
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }


  public OathClientResponse termsOfUse(String termsOfUse) {
    this.termsOfUse = termsOfUse;
    return this;
  }

   /**
   * URL of Terms of Use
   * @return termsOfUse
  **/
  @javax.annotation.Nullable
  public String getTermsOfUse() {
    return termsOfUse;
  }

  public void setTermsOfUse(String termsOfUse) {
    this.termsOfUse = termsOfUse;
  }


  public OathClientResponse privacyPolicy(String privacyPolicy) {
    this.privacyPolicy = privacyPolicy;
    return this;
  }

   /**
   * URL of Privacy Policy
   * @return privacyPolicy
  **/
  @javax.annotation.Nullable
  public String getPrivacyPolicy() {
    return privacyPolicy;
  }

  public void setPrivacyPolicy(String privacyPolicy) {
    this.privacyPolicy = privacyPolicy;
  }


  public OathClientResponse status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * ACTIVE or DISABLED
   * @return status
  **/
  @javax.annotation.Nullable
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public OathClientResponse redirectUri(List<String> redirectUri) {
    this.redirectUri = redirectUri;
    return this;
  }

  public OathClientResponse addRedirectUriItem(String redirectUriItem) {
    if (this.redirectUri == null) {
      this.redirectUri = new ArrayList<>();
    }
    this.redirectUri.add(redirectUriItem);
    return this;
  }

   /**
   * Get redirectUri
   * @return redirectUri
  **/
  @javax.annotation.Nullable
  public List<String> getRedirectUri() {
    return redirectUri;
  }

  public void setRedirectUri(List<String> redirectUri) {
    this.redirectUri = redirectUri;
  }


  public OathClientResponse liveTradingApproved(Boolean liveTradingApproved) {
    this.liveTradingApproved = liveTradingApproved;
    return this;
  }

   /**
   * Get liveTradingApproved
   * @return liveTradingApproved
  **/
  @javax.annotation.Nullable
  public Boolean getLiveTradingApproved() {
    return liveTradingApproved;
  }

  public void setLiveTradingApproved(Boolean liveTradingApproved) {
    this.liveTradingApproved = liveTradingApproved;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OathClientResponse oathClientResponse = (OathClientResponse) o;
    return Objects.equals(this.clientId, oathClientResponse.clientId) &&
        Objects.equals(this.name, oathClientResponse.name) &&
        Objects.equals(this.description, oathClientResponse.description) &&
        Objects.equals(this.url, oathClientResponse.url) &&
        Objects.equals(this.termsOfUse, oathClientResponse.termsOfUse) &&
        Objects.equals(this.privacyPolicy, oathClientResponse.privacyPolicy) &&
        Objects.equals(this.status, oathClientResponse.status) &&
        Objects.equals(this.redirectUri, oathClientResponse.redirectUri) &&
        Objects.equals(this.liveTradingApproved, oathClientResponse.liveTradingApproved);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, name, description, url, termsOfUse, privacyPolicy, status, redirectUri, liveTradingApproved);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OathClientResponse {\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    termsOfUse: ").append(toIndentedString(termsOfUse)).append("\n");
    sb.append("    privacyPolicy: ").append(toIndentedString(privacyPolicy)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    redirectUri: ").append(toIndentedString(redirectUri)).append("\n");
    sb.append("    liveTradingApproved: ").append(toIndentedString(liveTradingApproved)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("client_id");
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("url");
    openapiFields.add("terms_of_use");
    openapiFields.add("privacy_policy");
    openapiFields.add("status");
    openapiFields.add("redirect_uri");
    openapiFields.add("live_trading_approved");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!OathClientResponse.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in OathClientResponse is not found in the empty JSON string", OathClientResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!OathClientResponse.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OathClientResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("client_id") != null && !jsonObj.get("client_id").isJsonNull()) && !jsonObj.get("client_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_id").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("url") != null && !jsonObj.get("url").isJsonNull()) && !jsonObj.get("url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
      if ((jsonObj.get("terms_of_use") != null && !jsonObj.get("terms_of_use").isJsonNull()) && !jsonObj.get("terms_of_use").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `terms_of_use` to be a primitive type in the JSON string but got `%s`", jsonObj.get("terms_of_use").toString()));
      }
      if ((jsonObj.get("privacy_policy") != null && !jsonObj.get("privacy_policy").isJsonNull()) && !jsonObj.get("privacy_policy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `privacy_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("privacy_policy").toString()));
      }
      if ((jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) && !jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        StatusEnum.validateJsonElement(jsonObj.get("status"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("redirect_uri") != null && !jsonObj.get("redirect_uri").isJsonNull() && !jsonObj.get("redirect_uri").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `redirect_uri` to be an array in the JSON string but got `%s`", jsonObj.get("redirect_uri").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!OathClientResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'OathClientResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<OathClientResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(OathClientResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<OathClientResponse>() {
           @Override
           public void write(JsonWriter out, OathClientResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public OathClientResponse read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of OathClientResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of OathClientResponse
  * @throws IOException if the JSON string is invalid with respect to OathClientResponse
  */
  public static OathClientResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, OathClientResponse.class);
  }

 /**
  * Convert an instance of OathClientResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

