/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * NonTradeActivity
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class NonTradeActivity {
  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  public static final String SERIALIZED_NAME_NET_AMOUNT = "net_amount";
  @SerializedName(SERIALIZED_NAME_NET_AMOUNT)
  private BigDecimal netAmount;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  /**
   * Valid only for non-trading activity types. Null for trading activites.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    EXECUTED("executed"),
    
    CORRECT("correct"),
    
    CANCELED("canceled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      StatusEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private BigDecimal qty;

  public static final String SERIALIZED_NAME_PER_SHARE_AMOUNT = "per_share_amount";
  @SerializedName(SERIALIZED_NAME_PER_SHARE_AMOUNT)
  private BigDecimal perShareAmount;

  public NonTradeActivity() {
  }

  public NonTradeActivity date(LocalDate date) {
    this.date = date;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return date
  **/
  @javax.annotation.Nullable
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }


  public NonTradeActivity netAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return netAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getNetAmount() {
    return netAmount;
  }

  public void setNetAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
  }


  public NonTradeActivity description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public NonTradeActivity status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return status
  **/
  @javax.annotation.Nullable
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public NonTradeActivity symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public NonTradeActivity qty(BigDecimal qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return qty
  **/
  @javax.annotation.Nullable
  public BigDecimal getQty() {
    return qty;
  }

  public void setQty(BigDecimal qty) {
    this.qty = qty;
  }


  public NonTradeActivity perShareAmount(BigDecimal perShareAmount) {
    this.perShareAmount = perShareAmount;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return perShareAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getPerShareAmount() {
    return perShareAmount;
  }

  public void setPerShareAmount(BigDecimal perShareAmount) {
    this.perShareAmount = perShareAmount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NonTradeActivity nonTradeActivity = (NonTradeActivity) o;
    return Objects.equals(this.date, nonTradeActivity.date) &&
        Objects.equals(this.netAmount, nonTradeActivity.netAmount) &&
        Objects.equals(this.description, nonTradeActivity.description) &&
        Objects.equals(this.status, nonTradeActivity.status) &&
        Objects.equals(this.symbol, nonTradeActivity.symbol) &&
        Objects.equals(this.qty, nonTradeActivity.qty) &&
        Objects.equals(this.perShareAmount, nonTradeActivity.perShareAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, netAmount, description, status, symbol, qty, perShareAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NonTradeActivity {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    perShareAmount: ").append(toIndentedString(perShareAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("date");
    openapiFields.add("net_amount");
    openapiFields.add("description");
    openapiFields.add("status");
    openapiFields.add("symbol");
    openapiFields.add("qty");
    openapiFields.add("per_share_amount");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!NonTradeActivity.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in NonTradeActivity is not found in the empty JSON string", NonTradeActivity.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!NonTradeActivity.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NonTradeActivity` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("net_amount") != null && !jsonObj.get("net_amount").isJsonNull()) && !jsonObj.get("net_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_amount").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) && !jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        StatusEnum.validateJsonElement(jsonObj.get("status"));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("per_share_amount") != null && !jsonObj.get("per_share_amount").isJsonNull()) && !jsonObj.get("per_share_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `per_share_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("per_share_amount").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!NonTradeActivity.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'NonTradeActivity' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<NonTradeActivity> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(NonTradeActivity.class));

       return (TypeAdapter<T>) new TypeAdapter<NonTradeActivity>() {
           @Override
           public void write(JsonWriter out, NonTradeActivity value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public NonTradeActivity read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of NonTradeActivity given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of NonTradeActivity
  * @throws IOException if the JSON string is invalid with respect to NonTradeActivity
  */
  public static NonTradeActivity fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, NonTradeActivity.class);
  }

 /**
  * Convert an instance of NonTradeActivity to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

