/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Hold information about the result of KYC. Please see the documentation [here](https://alpaca.markets/docs/api-references/broker-api/events/#kyc-results) for more indepth details
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class KYCResult {
  public static final String SERIALIZED_NAME_REJECT = "reject";
  @SerializedName(SERIALIZED_NAME_REJECT)
  private String reject;

  public static final String SERIALIZED_NAME_ACCEPT = "accept";
  @SerializedName(SERIALIZED_NAME_ACCEPT)
  private String accept;

  public static final String SERIALIZED_NAME_INDETERMINATE = "indeterminate";
  @SerializedName(SERIALIZED_NAME_INDETERMINATE)
  private String indeterminate;

  public static final String SERIALIZED_NAME_ADDIDIONAL_INFORMATION = "addidional_information";
  @SerializedName(SERIALIZED_NAME_ADDIDIONAL_INFORMATION)
  private String addidionalInformation;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private String summary;

  public KYCResult() {
  }

  public KYCResult reject(String reject) {
    this.reject = reject;
    return this;
  }

   /**
   * IDENTITY_VERIFICATION Identity needs to be verified  TAX_IDENTIFICATION Tax ID number needs to be verified  ADDRESS_VERIFICATION Address needs to be verified  DATE_OF_BIRTH Date of birth needs to be verified  INVALID_IDENTITY_PASSPORT Identity needs to be verified via a  government issued ID. This is commonly used in conjuction with OTHER to describe the exact document needed.  SELFIE_VERIFICATION Identity needs to be verified via a live selfie of the account owner  PEP Further information needs to be submitted if account owner is politically exposed person  FAMILY_MEMBER_PEP Further information needs to be submitted if family member is a politically exposed person  CONTROL_PERSON Further information needs to be submitted if account owner is a control person  AFFILIATED Further information needs to be submitted if account owner is affiliated to finra or an exchange  VISA_TYPE_OTHER Further information needs to be submitted about account owner’s visa  W8BEN_CORRECTION Idenfitying information submitted by the user was incorrect so a new, corrected, W8BEN needs to be submitted COUNTRY_NOT_SUPPORTED The account owner’s country of tax residence is not supported by our KYC providers. In this case, we’ll manully perform KYC on the user  WATCHLIST_HIT Results from the watchlist screening need further investigation before account opening. No action is needed from the user  OTHER A custom message will be sent to describe exactly what is needed from the account owner. The message will be displayed in the additional_information attribute.  OTHER_PARTNER A custom message will be sent to relay information relevant only to the partner. The message will be displayed in the additional_information attribute.
   * @return reject
  **/
  @javax.annotation.Nullable
  public String getReject() {
    return reject;
  }

  public void setReject(String reject) {
    this.reject = reject;
  }


  public KYCResult accept(String accept) {
    this.accept = accept;
    return this;
  }

   /**
   * IDENTITY_VERIFICATION Identity needs to be verified  TAX_IDENTIFICATION Tax ID number needs to be verified  ADDRESS_VERIFICATION Address needs to be verified  DATE_OF_BIRTH Date of birth needs to be verified  INVALID_IDENTITY_PASSPORT Identity needs to be verified via a  government issued ID. This is commonly used in conjuction with OTHER to describe the exact document needed.  SELFIE_VERIFICATION Identity needs to be verified via a live selfie of the account owner  PEP Further information needs to be submitted if account owner is politically exposed person  FAMILY_MEMBER_PEP Further information needs to be submitted if family member is a politically exposed person  CONTROL_PERSON Further information needs to be submitted if account owner is a control person  AFFILIATED Further information needs to be submitted if account owner is affiliated to finra or an exchange  VISA_TYPE_OTHER Further information needs to be submitted about account owner’s visa  W8BEN_CORRECTION Idenfitying information submitted by the user was incorrect so a new, corrected, W8BEN needs to be submitted COUNTRY_NOT_SUPPORTED The account owner’s country of tax residence is not supported by our KYC providers. In this case, we’ll manully perform KYC on the user  WATCHLIST_HIT Results from the watchlist screening need further investigation before account opening. No action is needed from the user  OTHER A custom message will be sent to describe exactly what is needed from the account owner. The message will be displayed in the additional_information attribute.  OTHER_PARTNER A custom message will be sent to relay information relevant only to the partner. The message will be displayed in the additional_information attribute.
   * @return accept
  **/
  @javax.annotation.Nullable
  public String getAccept() {
    return accept;
  }

  public void setAccept(String accept) {
    this.accept = accept;
  }


  public KYCResult indeterminate(String indeterminate) {
    this.indeterminate = indeterminate;
    return this;
  }

   /**
   * IDENTITY_VERIFICATION Identity needs to be verified  TAX_IDENTIFICATION Tax ID number needs to be verified  ADDRESS_VERIFICATION Address needs to be verified  DATE_OF_BIRTH Date of birth needs to be verified  INVALID_IDENTITY_PASSPORT Identity needs to be verified via a  government issued ID. This is commonly used in conjuction with OTHER to describe the exact document needed.  SELFIE_VERIFICATION Identity needs to be verified via a live selfie of the account owner  PEP Further information needs to be submitted if account owner is politically exposed person  FAMILY_MEMBER_PEP Further information needs to be submitted if family member is a politically exposed person  CONTROL_PERSON Further information needs to be submitted if account owner is a control person  AFFILIATED Further information needs to be submitted if account owner is affiliated to finra or an exchange  VISA_TYPE_OTHER Further information needs to be submitted about account owner’s visa  W8BEN_CORRECTION Idenfitying information submitted by the user was incorrect so a new, corrected, W8BEN needs to be submitted COUNTRY_NOT_SUPPORTED The account owner’s country of tax residence is not supported by our KYC providers. In this case, we’ll manully perform KYC on the user  WATCHLIST_HIT Results from the watchlist screening need further investigation before account opening. No action is needed from the user  OTHER A custom message will be sent to describe exactly what is needed from the account owner. The message will be displayed in the additional_information attribute.  OTHER_PARTNER A custom message will be sent to relay information relevant only to the partner. The message will be displayed in the additional_information attribute.
   * @return indeterminate
  **/
  @javax.annotation.Nullable
  public String getIndeterminate() {
    return indeterminate;
  }

  public void setIndeterminate(String indeterminate) {
    this.indeterminate = indeterminate;
  }


  public KYCResult addidionalInformation(String addidionalInformation) {
    this.addidionalInformation = addidionalInformation;
    return this;
  }

   /**
   * Used to display a custom message.
   * @return addidionalInformation
  **/
  @javax.annotation.Nullable
  public String getAddidionalInformation() {
    return addidionalInformation;
  }

  public void setAddidionalInformation(String addidionalInformation) {
    this.addidionalInformation = addidionalInformation;
  }


  public KYCResult summary(String summary) {
    this.summary = summary;
    return this;
  }

   /**
   * Either &#x60;pass&#x60; or &#x60;fail&#x60;. Used to indicate if KYC has completed and passed or not. This field is used for internal purposes only.
   * @return summary
  **/
  @javax.annotation.Nullable
  public String getSummary() {
    return summary;
  }

  public void setSummary(String summary) {
    this.summary = summary;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KYCResult kyCResult = (KYCResult) o;
    return Objects.equals(this.reject, kyCResult.reject) &&
        Objects.equals(this.accept, kyCResult.accept) &&
        Objects.equals(this.indeterminate, kyCResult.indeterminate) &&
        Objects.equals(this.addidionalInformation, kyCResult.addidionalInformation) &&
        Objects.equals(this.summary, kyCResult.summary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reject, accept, indeterminate, addidionalInformation, summary);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KYCResult {\n");
    sb.append("    reject: ").append(toIndentedString(reject)).append("\n");
    sb.append("    accept: ").append(toIndentedString(accept)).append("\n");
    sb.append("    indeterminate: ").append(toIndentedString(indeterminate)).append("\n");
    sb.append("    addidionalInformation: ").append(toIndentedString(addidionalInformation)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("reject");
    openapiFields.add("accept");
    openapiFields.add("indeterminate");
    openapiFields.add("addidional_information");
    openapiFields.add("summary");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!KYCResult.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in KYCResult is not found in the empty JSON string", KYCResult.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!KYCResult.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `KYCResult` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("reject") != null && !jsonObj.get("reject").isJsonNull()) && !jsonObj.get("reject").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reject` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reject").toString()));
      }
      if ((jsonObj.get("accept") != null && !jsonObj.get("accept").isJsonNull()) && !jsonObj.get("accept").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `accept` to be a primitive type in the JSON string but got `%s`", jsonObj.get("accept").toString()));
      }
      if ((jsonObj.get("indeterminate") != null && !jsonObj.get("indeterminate").isJsonNull()) && !jsonObj.get("indeterminate").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `indeterminate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("indeterminate").toString()));
      }
      if ((jsonObj.get("addidional_information") != null && !jsonObj.get("addidional_information").isJsonNull()) && !jsonObj.get("addidional_information").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `addidional_information` to be a primitive type in the JSON string but got `%s`", jsonObj.get("addidional_information").toString()));
      }
      if ((jsonObj.get("summary") != null && !jsonObj.get("summary").isJsonNull()) && !jsonObj.get("summary").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get("summary").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!KYCResult.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'KYCResult' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<KYCResult> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(KYCResult.class));

       return (TypeAdapter<T>) new TypeAdapter<KYCResult>() {
           @Override
           public void write(JsonWriter out, KYCResult value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public KYCResult read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of KYCResult given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of KYCResult
  * @throws IOException if the JSON string is invalid with respect to KYCResult
  */
  public static KYCResult fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, KYCResult.class);
  }

 /**
  * Convert an instance of KYCResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

