/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalEntryType;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents a change in a Journal&#39;s status, sent over the events streaming api. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class JournalStatusEvent {
  public static final String SERIALIZED_NAME_AT = "at";
  @SerializedName(SERIALIZED_NAME_AT)
  private OffsetDateTime at;

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private JournalEntryType entryType;

  public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
  @SerializedName(SERIALIZED_NAME_EVENT_ID)
  private Integer eventId;

  public static final String SERIALIZED_NAME_EVENT_ULID = "event_ulid";
  @SerializedName(SERIALIZED_NAME_EVENT_ULID)
  private String eventUlid;

  public static final String SERIALIZED_NAME_JOURNAL_ID = "journal_id";
  @SerializedName(SERIALIZED_NAME_JOURNAL_ID)
  private UUID journalId;

  public static final String SERIALIZED_NAME_STATUS_FROM = "status_from";
  @SerializedName(SERIALIZED_NAME_STATUS_FROM)
  private JournalStatus statusFrom;

  public static final String SERIALIZED_NAME_STATUS_TO = "status_to";
  @SerializedName(SERIALIZED_NAME_STATUS_TO)
  private JournalStatus statusTo;

  public JournalStatusEvent() {
  }

  public JournalStatusEvent at(OffsetDateTime at) {
    this.at = at;
    return this;
  }

   /**
   * Timestamp of event
   * @return at
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getAt() {
    return at;
  }

  public void setAt(OffsetDateTime at) {
    this.at = at;
  }


  public JournalStatusEvent entryType(JournalEntryType entryType) {
    this.entryType = entryType;
    return this;
  }

   /**
   * Get entryType
   * @return entryType
  **/
  @javax.annotation.Nonnull
  public JournalEntryType getEntryType() {
    return entryType;
  }

  public void setEntryType(JournalEntryType entryType) {
    this.entryType = entryType;
  }


  public JournalStatusEvent eventId(Integer eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * Monotonically increasing 64bit integer
   * @return eventId
  **/
  @javax.annotation.Nonnull
  public Integer getEventId() {
    return eventId;
  }

  public void setEventId(Integer eventId) {
    this.eventId = eventId;
  }


  public JournalStatusEvent eventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
    return this;
  }

   /**
   * lexically sortable, monotonically increasing character array
   * @return eventUlid
  **/
  @javax.annotation.Nonnull
  public String getEventUlid() {
    return eventUlid;
  }

  public void setEventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
  }


  public JournalStatusEvent journalId(UUID journalId) {
    this.journalId = journalId;
    return this;
  }

   /**
   * The UUID of the related Journal
   * @return journalId
  **/
  @javax.annotation.Nonnull
  public UUID getJournalId() {
    return journalId;
  }

  public void setJournalId(UUID journalId) {
    this.journalId = journalId;
  }


  public JournalStatusEvent statusFrom(JournalStatus statusFrom) {
    this.statusFrom = statusFrom;
    return this;
  }

   /**
   * Get statusFrom
   * @return statusFrom
  **/
  @javax.annotation.Nonnull
  public JournalStatus getStatusFrom() {
    return statusFrom;
  }

  public void setStatusFrom(JournalStatus statusFrom) {
    this.statusFrom = statusFrom;
  }


  public JournalStatusEvent statusTo(JournalStatus statusTo) {
    this.statusTo = statusTo;
    return this;
  }

   /**
   * Get statusTo
   * @return statusTo
  **/
  @javax.annotation.Nonnull
  public JournalStatus getStatusTo() {
    return statusTo;
  }

  public void setStatusTo(JournalStatus statusTo) {
    this.statusTo = statusTo;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JournalStatusEvent journalStatusEvent = (JournalStatusEvent) o;
    return Objects.equals(this.at, journalStatusEvent.at) &&
        Objects.equals(this.entryType, journalStatusEvent.entryType) &&
        Objects.equals(this.eventId, journalStatusEvent.eventId) &&
        Objects.equals(this.eventUlid, journalStatusEvent.eventUlid) &&
        Objects.equals(this.journalId, journalStatusEvent.journalId) &&
        Objects.equals(this.statusFrom, journalStatusEvent.statusFrom) &&
        Objects.equals(this.statusTo, journalStatusEvent.statusTo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(at, entryType, eventId, eventUlid, journalId, statusFrom, statusTo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JournalStatusEvent {\n");
    sb.append("    at: ").append(toIndentedString(at)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    eventUlid: ").append(toIndentedString(eventUlid)).append("\n");
    sb.append("    journalId: ").append(toIndentedString(journalId)).append("\n");
    sb.append("    statusFrom: ").append(toIndentedString(statusFrom)).append("\n");
    sb.append("    statusTo: ").append(toIndentedString(statusTo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("at");
    openapiFields.add("entry_type");
    openapiFields.add("event_id");
    openapiFields.add("event_ulid");
    openapiFields.add("journal_id");
    openapiFields.add("status_from");
    openapiFields.add("status_to");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("at");
    openapiRequiredFields.add("entry_type");
    openapiRequiredFields.add("event_id");
    openapiRequiredFields.add("event_ulid");
    openapiRequiredFields.add("journal_id");
    openapiRequiredFields.add("status_from");
    openapiRequiredFields.add("status_to");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!JournalStatusEvent.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in JournalStatusEvent is not found in the empty JSON string", JournalStatusEvent.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!JournalStatusEvent.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `JournalStatusEvent` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : JournalStatusEvent.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the required field `entry_type`
      JournalEntryType.validateJsonElement(jsonObj.get("entry_type"));
      if (!jsonObj.get("event_ulid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `event_ulid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("event_ulid").toString()));
      }
      if (!jsonObj.get("journal_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `journal_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("journal_id").toString()));
      }
      // validate the required field `status_from`
      JournalStatus.validateJsonElement(jsonObj.get("status_from"));
      // validate the required field `status_to`
      JournalStatus.validateJsonElement(jsonObj.get("status_to"));
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!JournalStatusEvent.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'JournalStatusEvent' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<JournalStatusEvent> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(JournalStatusEvent.class));

       return (TypeAdapter<T>) new TypeAdapter<JournalStatusEvent>() {
           @Override
           public void write(JsonWriter out, JournalStatusEvent value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public JournalStatusEvent read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of JournalStatusEvent given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of JournalStatusEvent
  * @throws IOException if the JSON string is invalid with respect to JournalStatusEvent
  */
  public static JournalStatusEvent fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, JournalStatusEvent.class);
  }

 /**
  * Convert an instance of JournalStatusEvent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

