/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Represents the status that a Journal instance can be in.  **Current Values**  queued Journal in queue to be processed. Journal is not processed yet.  sent_to_clearing Journal sent to be processed by Alpaca’s booking system. The journal is not processed yet.  pending     Journal pending to be processed as it requires manual approval from Alpaca operations (for example due to hitting JNLC daily limits).  executed Journal executed and balances updated for both sides of  the journal transaction. This is not a final status, journals can be reversed if there is an error.  rejected Journal rejected. Please try again.  canceled Journal canceled. This is a **FINAL** status.  refused Journal refused. Please try again.  deleted Journal deleted. This is a **FINAL** status.  correct Journal is corrected. Previously executed journal is cancelled and a new journal is corrected amount is created. This is a **FINAL** status.
 */
@JsonAdapter(JournalStatus.Adapter.class)
public enum JournalStatus {
  
  PENDING("pending"),
  
  CANCELED("canceled"),
  
  EXECUTED("executed"),
  
  QUEUED("queued"),
  
  REJECTED("rejected"),
  
  DELETED("deleted");

  private String value;

  JournalStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static JournalStatus fromValue(String value) {
    for (JournalStatus b : JournalStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<JournalStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final JournalStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public JournalStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return JournalStatus.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    JournalStatus.fromValue(value);
  }
}

