/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.JNLC;
import net.jacobpeterson.alpaca.openapi.broker.model.JNLS;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalStatus;



import java.io.IOException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class JournalResource extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(JournalResource.class.getName());

    public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
        @SuppressWarnings("unchecked")
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!JournalResource.class.isAssignableFrom(type.getRawType())) {
                return null; // this class only serializes 'JournalResource' and its subtypes
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<JNLC> adapterJNLC = gson.getDelegateAdapter(this, TypeToken.get(JNLC.class));
            final TypeAdapter<JNLS> adapterJNLS = gson.getDelegateAdapter(this, TypeToken.get(JNLS.class));

            return (TypeAdapter<T>) new TypeAdapter<JournalResource>() {
                @Override
                public void write(JsonWriter out, JournalResource value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }

                    // check if the actual instance is of the type `JNLC`
                    if (value.getActualInstance() instanceof JNLC) {
                      JsonElement element = adapterJNLC.toJsonTree((JNLC)value.getActualInstance());
                      elementAdapter.write(out, element);
                      return;
                    }
                    // check if the actual instance is of the type `JNLS`
                    if (value.getActualInstance() instanceof JNLS) {
                      JsonElement element = adapterJNLS.toJsonTree((JNLS)value.getActualInstance());
                      elementAdapter.write(out, element);
                      return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: JNLC, JNLS");
                }

                @Override
                public JournalResource read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = elementAdapter.read(in);

                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<>();
                    TypeAdapter actualAdapter = elementAdapter;

                    // deserialize JNLC
                    try {
                      // validate the JSON object to see if any exception is thrown
                      JNLC.validateJsonElement(jsonElement);
                      actualAdapter = adapterJNLC;
                      match++;
                      log.log(Level.FINER, "Input data matches schema 'JNLC'");
                    } catch (Exception e) {
                      // deserialization failed, continue
                      errorMessages.add(String.format("Deserialization for JNLC failed with `%s`.", e.getMessage()));
                      log.log(Level.FINER, "Input data does not match schema 'JNLC'", e);
                    }
                    // deserialize JNLS
                    try {
                      // validate the JSON object to see if any exception is thrown
                      JNLS.validateJsonElement(jsonElement);
                      actualAdapter = adapterJNLS;
                      match++;
                      log.log(Level.FINER, "Input data matches schema 'JNLS'");
                    } catch (Exception e) {
                      // deserialization failed, continue
                      errorMessages.add(String.format("Deserialization for JNLS failed with `%s`.", e.getMessage()));
                      log.log(Level.FINER, "Input data does not match schema 'JNLS'", e);
                    }

                    if (match == 1) {
                        JournalResource ret = new JournalResource();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }

                    throw new IOException(String.format("Failed deserialization for JournalResource: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, Class<?>> schemas = new HashMap<String, Class<?>>();

    public JournalResource() {
        super("oneOf", Boolean.FALSE);
    }

    public JournalResource(JNLC o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public JournalResource(JNLS o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("JNLC", JNLC.class);
        schemas.put("JNLS", JNLS.class);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return JournalResource.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * JNLC, JNLS
     *
     * It could be an instance of the 'oneOf' schemas.
     */
    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof JNLC) {
            super.setActualInstance(instance);
            return;
        }

        if (instance instanceof JNLS) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be JNLC, JNLS");
    }

    /**
     * Get the actual instance, which can be the following:
     * JNLC, JNLS
     *
     * @return The actual instance (JNLC, JNLS)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `JNLC`. If the actual instance is not `JNLC`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `JNLC`
     * @throws ClassCastException if the instance is not `JNLC`
     */
    public JNLC getJNLC() throws ClassCastException {
        return (JNLC)super.getActualInstance();
    }
    /**
     * Get the actual instance of `JNLS`. If the actual instance is not `JNLS`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `JNLS`
     * @throws ClassCastException if the instance is not `JNLS`
     */
    public JNLS getJNLS() throws ClassCastException {
        return (JNLS)super.getActualInstance();
    }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    // validate oneOf schemas one by one
    int validCount = 0;
    ArrayList<String> errorMessages = new ArrayList<>();
    // validate the json string with JNLC
    try {
      JNLC.validateJsonElement(jsonElement);
      validCount++;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for JNLC failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    // validate the json string with JNLS
    try {
      JNLS.validateJsonElement(jsonElement);
      validCount++;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for JNLS failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    if (validCount != 1) {
      throw new IOException(String.format("The JSON string is invalid for JournalResource with oneOf schemas: JNLC, JNLS. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
    }
  }

 /**
  * Create an instance of JournalResource given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of JournalResource
  * @throws IOException if the JSON string is invalid with respect to JournalResource
  */
  public static JournalResource fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, JournalResource.class);
  }

 /**
  * Convert an instance of JournalResource to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

